package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;

/**
 * This sample demonstrates technique of disabling alerts, error and confirmation dialogs.
 *
 * @author Alexei Orischenko
 */
public class DisableDialogsSample extends BasicSample
{
    private static final String HTML_CONTENT = "<html><body>" +
            "<button id='alertDiv' onclick='alert(\"alert shown\")'>Show alert</button><br />" +
            "<button id='errorDiv' onclick='document.all.unexistElement.innerHTML = \"some text\"'>Show error dialog</button>" +
            "</body></html>";

    public DisableDialogsSample()
    {
        super("Disable Alerts and Error Dialogs");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // disable error, alert and confirmation dialogs
        browser.setSilent(true);

        browser.setContent(HTML_CONTENT);
        browser.waitReady();

        HTMLElement alertDiv = (HTMLElement)browser.getDocument().getElementById("alertDiv");
        HTMLElement errorDiv = (HTMLElement)browser.getDocument().getElementById("errorDiv");

        alertDiv.click();
        errorDiv.click();

        showMessage("Alert and error dialogs are disabled.\r\nPlease press on buttons that produce these dialogs.");
    }

    public static void main(String[] args) throws Exception
    {
        new DisableDialogsSample().run();
    }
}
