package core;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.KeyFilter;
import com.jniwrapper.win32.ie.WebBrowser;

/**
 * This sample demonstrates how to disable Find and Print shortcuts.
 *
 * @author Alexei Orischenko
 */
public class DisableShortcutsSample extends BasicSample
{
    public DisableShortcutsSample()
    {
        super("Disable Shortcuts");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        browser.setKeyFilter(new GenuitecKeyFilter());

        browser.navigate("http://google.com");
        browser.waitReady();
    }

    public static void main(String[] args) throws Exception
    {
        new DisableShortcutsSample().run();
    }
}

class GenuitecKeyFilter implements KeyFilter
{
    public boolean isFilter(KeyEvent evt)
    {
        return (evt.getKeyCode() == 'F' && evt.isControlPressed()) ||
                (evt.getKeyCode() == 'P' && evt.isControlPressed());
    }
}