package core;

import com.jniwrapper.win32.ie.Browser;
import com.jniwrapper.win32.ie.proxy.ProcessProxySettings;
import com.jniwrapper.win32.ie.proxy.ProxySettings;
import com.jniwrapper.win32.winhttp.WinHttpException;
import com.jniwrapper.win32.winhttp.DefaultProxySettings;

import javax.swing.*;

/**
 * @author Ikryanov Vladimir
 */
public class ProcessProxySample extends JFrame
{
    private Browser _browser;

    public ProcessProxySample()
    {
        createGUI();
    }

    private void createGUI()
    {
        _browser = new Browser();

        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setContentPane(_browser);
        setSize(400, 400);
        setVisible(true);
        setLocationRelativeTo(null);
    }

    public void navigate(String url)
    {
        _browser.navigate(url);
        _browser.waitReady();
    }

    public static void main(String[] args) throws WinHttpException
    {
        // You need to call this code before creating browser instance
        ProxySettings proxySettings = new ProcessProxySettings();
        proxySettings.setProxy("http://127.0.0.1:808");
        proxySettings.setUserName("username");
        proxySettings.setPassword("password");
        proxySettings.commit();

        // Creating the browser instance and navigate to some resource
        new ProcessProxySample().navigate("http://www.google.com");

        // Sets the default proxy settings
        com.jniwrapper.win32.winhttp.ProxySettings settings = new DefaultProxySettings();
        new ProcessProxySettings(settings.getURL() + ":" + settings.getPort(), null, null).commit();

        // Creating the browser instance and navigate to some resource
        new ProcessProxySample().navigate("http://www.google.com");
    }
}

