package core.event;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.event.DefaultWebBrowserEventsHandler;
import com.jniwrapper.win32.ie.event.NavigationEventAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import core.BasicSample;

/**
 * This sample adds navigation listener.
 *
 * @author Alexei Orischenko
 */
public class NavigationListenerSample extends BasicSample
{
    public NavigationListenerSample()
    {
        super("Navigation Listener");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.navigate("google.com");
        browser.waitReady();

        setupNavigationListeners(browser);

        Element textInput = getTextInput(browser.getDocument());

        textInput.setAttribute("value", "JExplorer");

        HTMLElement searchButton = getSearchButton(browser.getDocument());
        showMessage("Submit form");
        searchButton.click();
    }

    private void setupNavigationListeners(WebBrowser browser)
    {
        browser.setEventHandler(new DefaultWebBrowserEventsHandler()
        {
            public boolean beforeNavigate(WebBrowser webBrowser, String url, String targetFrameName, String postData, String headers)
            {
                clearLog();

                info("url = " + url);
                info("postData = " + postData);
                info("headers = " + headers);

                showLogSwingLoop("Navigation Data");

                // proceed
                return false;
            }
        });

        browser.addNavigationListener(new NavigationEventAdapter()
        {
            public void documentCompleted(WebBrowser webBrowser, String url)
            {
                showMessageSwingLoop("Document completed: " + url);
            }
        });
    }

    private static Element getTextInput(Document document)
    {
        NodeList inputs = document.getElementsByTagName("input");

        for (int i = 0; i < inputs.getLength(); i++)
        {
            Element input = (Element) inputs.item(i);
            String type = input.getAttribute("type").toLowerCase();

            if ("text".equals(type))
            {
                return input;
            }
        }

        return null;
    }

    private static HTMLElement getSearchButton(Document document)
    {
        NodeList inputs = document.getElementsByTagName("input");
        for (int i = 0; i < inputs.getLength(); i++)
        {
            HTMLElement input = (HTMLElement) inputs.item(i);
            String name = input.getAttribute("name");

            if ("btnG".equals(name))
            {
                return input;
            }
        }

        return null;
    }

    public static void main(String[] args) throws Exception
    {
        new NavigationListenerSample().run();
    }
}
