package core.event;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.event.DefaultWebBrowserEventsHandler;
import core.BasicSample;

/**
 * This sample adds navigation post data listener.
 *
 * <p>postdata.asp test page:
 * <%@ Language="JScript"%>
 *
 * Post Data Length:
 * <%
 *      var len = Request.TotalBytes;
 *      Response.Write(len);
 * %>
 *
 * @author Alexei Orischenko
 */
public class NavigationPostDataSample extends BasicSample
{
    public NavigationPostDataSample()
    {
        super("Navigation Post Data");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        
        browser.setEventHandler(new DefaultWebBrowserEventsHandler() {
            public boolean beforeNavigate(WebBrowser webBrowser, String url, String targetFrameName, String postData, String headers)
            {
                showMessageSwingLoop("postData: " + postData);
                return false;
            }
        });

        showMessage("Navigation with post data");
        browser.navigate("http://localhost/jexplorer/postdata.asp", "name=Alex&product=Pizza");
    }

    public static void main(String[] args) throws Exception
    {
        new NavigationPostDataSample().run();
    }
}
