package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import core.BasicSample;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;

/**
 * This sample demonstrates technique of modifying content of the document. 
 *
 * @author Alexei Orischenko
 */
public class InnerHTMLSample extends BasicSample
{
    public InnerHTMLSample()
    {
        super("Inner HTML");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        browser.setContent("<html><body><h1>Simple document</h1><div id='theDiv'></div></body></html>");
        browser.waitReady();

        HTMLElement div = (HTMLElement) browser.getDocument().getElementById("theDiv");
        div.setHTML("<b>new text in div</b>");
    }

    public static void main(String[] args) throws Exception
    {
        new InnerHTMLSample().run();
    }
}
