package dom;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import org.w3c.dom.NodeList;
import org.w3c.dom.Element;
import core.BasicSample;

/**
 * This sample demonstrates technique of working with frames.
 *
 * @author Alexei Orischenko
 */
public class ScrollFrameSample extends BasicSample
{
    private static final String HTML = "<frameset cols='50%,50%'>" +
            "<frame id='frame1' src='' />" +
            "<frame id='frame2' src='http://google.com' />" +
            "</body></html>";

    public ScrollFrameSample()
    {
        super("Scroll Frame");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();
        browser.setContent(HTML);
        browser.waitReady();

        NodeList frames = browser.getDocument().getElementsByTagName("frame");

        Element googleFrame = (Element) frames.item(1);

        WebBrowser frameBrowser = (WebBrowser) googleFrame;
        int scrollWidth = frameBrowser.getDocument().getScrollWidth();

        showMessage("Scroll frame...");

        frameBrowser.getDocument().scrollHorisontal(scrollWidth);
    }

    public static void main(String[] args) throws Exception
    {
        new ScrollFrameSample().run();
    }
}
