package dom.event;

/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */

import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MouseEvent;
import core.BasicSample;

/**
 * This sample demonstrates the technique of installing a click listener for buttons, links.
 *
 * @author Serge Piletsky
 */
public class ClickListenerSample extends BasicSample
{
    private static final String ON_CLICK = "onclick";

    private static final String HTML_CONTENT = "<HTML>" +
            "<HEAD>" +
            "<TITLE>Click Test Sample</TITLE>\n" +
            "</HEAD>" +
            "<BODY>" +
            "<button name=\"btn1\">Button1</button>" +
            "<br>" +
            "<button name=\"btn2\">Button2</button>" +
            "<br>" +
            "<a href=\"JavaScript://\" id=\"link1\">Link 1</a>" +
            "<br>" +
            "<a href=\"JavaScript://\" id=\"link2\">Link 2</a>" +
            "</BODY>" +
            "</HTML>";

    public ClickListenerSample()
    {
        super("Click Listener");
    }

    protected void execute()
    {
        WebBrowser browser = getBrowser();

        // wait when the browser will be ready to work
        browser.waitReady();

        browser.setContent(HTML_CONTENT);
        browser.waitReady();

        Document document = browser.getDocument();

        ClickListener clickListener = new ClickListener();

        addLinksListener(document, clickListener);
        addButtonsListener(document, clickListener);

        showMessage("Please click on buttons and links.");
    }

    private void addLinksListener(Document document, EventListener listener)
    {
        final NodeList links = document.getElementsByTagName("a");
        for (int i = 0; i < links.getLength(); i++)
        {
            HTMLElement link = (HTMLElement)links.item(i);
            link.addEventListener(ON_CLICK, listener, false);
        }
    }

    private void addButtonsListener(Document document, EventListener listener)
    {
        final NodeList buttons = document.getElementsByTagName("button");
        for (int i = 0; i < buttons.getLength(); i++)
        {
            HTMLElement button = (HTMLElement) buttons.item(i);
            button.addEventListener(ON_CLICK, listener, false);
        }
    }

    private class ClickListener implements EventListener
    {
        public void handleEvent(Event evt)
        {
            MouseEvent event = (MouseEvent)evt;
            dumpEvent(event, (Element)event.getTarget());
        }

        void dumpEvent(MouseEvent event, Element target)
        {
            StringBuffer result = new StringBuffer();

            result.append("Type: " + event.getType() + "\r\n");
            result.append("Target UID: " + ((Element)event.getTarget()).getAttribute("uniqueID") + "\r\n");
            result.append("Client coords: (" + event.getClientX() + ", " + event.getClientY() + ")\r\n");
            result.append("Screen coords: (" + event.getScreenX() + ", " + event.getScreenY() + ")\r\n");
            result.append("Ctrl pressed: " + event.getCtrlKey() + "\r\n");
            result.append("Alt pressed: " + event.getAltKey() + "\r\n");
            result.append("Shift pressed: " + event.getShiftKey() + "\r\n");

            if (target.getTagName().equalsIgnoreCase("a"))
            {
                String href = target.getAttribute("href");
                result.append("href = " + href);
            }

            showMessageSwingLoop("Event Data", result.toString());
        }
    }

    public static void main(String[] args) throws Exception
    {
        new ClickListenerSample().run();
    }
}
