unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DB, DBTables, Grids, DBGrids, ExtCtrls, xsdedit, strs,
  xmls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Table1: TTable;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function GenerateXSD(Dataset: TDataSet): string;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TForm1 }

function TForm1.GenerateXSD(Dataset: TDataSet): string;
var i: Integer; SN, XN: TXMLNode; F: TField;
begin
   // Create a scheme to edit a table record as XML object
   SN := TXMLNode.Create('<xsd:element name="A"></xsd:element>');
   try
    for i := 0 to Dataset.FieldCount - 1 do begin
     F := Dataset.Fields[i];
     if not F.ReadOnly then begin
      XN := SN.Nodes.AddNode('xsd:attribute');
      XN.Attr['name'] := '_' + AnsiLowerCase(F.FieldName);
      XN.Node['xsd:annotation/xsd:documentation'] := F.DisplayName;
      if F.DataType = ftInteger then XN.Attr['type'] := 'xsd:integer'
      else XN.Attr['type'] := 'xsd:string';
      if F.Required then XN.Attr['use'] := 'required';
     end;
    end;
    Result := '<xsd:schema>' + SN.Code + '</xsd:schema>';
    StrtoFile(Result, ExtractFilePath(ParamStr(0)) + 'record.xsd');
   finally
    SN.Free;
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var XE: TXSDEditor; SN: TXMLNode;
begin
 // Create an editor with XMLInspector
 SN := nil;
 XE := TXSDEditor.Create(Self);
 try
  // Generate XSD scheme for editing a table record
  SN := TXMLNode.Create(GenerateXSD(Table1));

  // Add a new record to a table or edit the current record
  if Sender = Button2 then begin
    Table1.Append;
    XE.Caption := 'New Employee';
  end
  else begin
    Table1.Edit;
    XE.Caption := 'Edit Employee';
  end;

  // Run a dialog form with XMLInspector and store (or cancel) changes
  try
    XE.Run(SN[0], CreateXMLTemplate(SN[0], True), Table1);
    if XE.ModalResult = mrOk then Table1.Post else Table1.Cancel;
  except
    Table1.Cancel;
    raise;
  end;
 finally
  XE.Free;
  SN.Free;
 end;
end;

end.
