unit langwiz;

interface

uses
  Windows, Messages, Controls, SysUtils, Classes, Graphics, Forms, Dialogs,
  xsdins, ExtCtrls, StdCtrls, xmls, typinfo, strs;

type
  TLWizard = class(TForm)
    Props: TXMLInspector;
    procedure PropsChange(Sender: TXMLInspector; Prop: TXMLPropEditor);
  private
    { Private declarations }
  public
    Schema: TXMLNode;
    CurrFrame: TWinControl;
    procedure BuildSchema(F: TWinControl);
    procedure Execute(F: TWinControl);
  end;

var
  LWizard: TLWizard;

procedure SetProp(Frame: TComponent; Prop, Value: string);

implementation

{$R *.DFM}

uses lnframe;

procedure SetProp(Frame: TComponent; Prop, Value: string);
var C: TObject; s: string; PI: PPropInfo;
begin
 if Frame.ClassType=TLnForm then s:=Frame.Name else s:=Frame.ClassName;
 if StartsWith(Prop, s+'.') then begin
  s:=Q_StrTok(Prop, '.');
  C:=Frame
 end else begin
  s:=Q_StrTok(Prop, '.');
  C:=Frame.FindComponent(s);
 end;
 while Assigned(C) and (pos('.', Prop)>0) do begin
  s:=Q_StrTok(Prop, '.');
  if C is TCollection then begin
   C:=TCollection(C).Items[StrtoInt(s)];
   continue
  end else begin
   PI:=GetPropInfo(C, s);
   if PI=nil then exit;
   if Prop='' then begin
    if PI.PropType^^.Kind=tkClass then begin
     C:=GetObjectProp(C, PI);
     if C is TStrings then TStrings(C).Text:=Q_ReplaceStr(Value, '|', #13#10);
    end else SetStrProp(C, PI, Value);
   end else C:=GetObjectProp(C, PI);
  end;
 end;
end;

procedure SetXMLProp(Frame: TComponent; Prop, Value: string);
var XN: TXMLNode; s: string; n: integer;
begin
 if LangNode=nil then Exit;
 if Frame.ClassType=TLnForm then s:=Frame.Name else s:=Frame.ClassName;
 if StartsWith(Prop, s+'.') then XN:=LangNode else XN:=LangNode.Nodes.GetCreateNode(s);
 s:=Q_ReplaceStr(Prop, '.', '/');
 n:=length(s);
 while (n>0) and (s[n]<>'/') do dec(n);
 if n>0 then s:=copy(s, 1, n)+'@'+copy(s, n+1, maxInt);
 XN.Node[s]:=Value;
end;


{ TLWizard }

procedure AddObject(SN, PN: TXMLNode; C: TObject; prefix: string);
var k, m, Count: Integer; PL: PPropList; C1: TObject; XN: TXMLNode; s: string;
begin
 GetMem(PL, SizeOf(PPropInfo)*100);
 try
  Count:=GetPropList(C.ClassInfo, [tkString, tkLString, tkWString, tkClass], PL);
  for k:=0 to Count-1 do begin
   if PL^[k].PropType^^.Kind=tkClass then begin
    C1:=GetObjectProp(C, PL^[k]);
    if Assigned(C1) and not (C1 is TComponent) then begin
     if C1 is TCollection then begin
      for m:=0 to TCollection(C1).Count-1 do
      AddObject(SN, PN, TCollection(C1).Items[m], prefix+PL^[k].Name+'.'+IntToStr(m)+'.')
     end else if C1 is TStrings then begin
      XN:=SN.Nodes.AddNode('xsd:element');
      XN.Attr['name']:=prefix+PL^[k].Name;
      XN.Attr['type']:='xsd:string';
      s:=TStrings(C1).Text;
      s:=Q_ReplaceStr(s, #13#10, '|');
      PN.Node[XN.Attr['name']]:=s;
     end else AddObject(SN, PN, C1, prefix+PL^[k].Name+'.');
    end;
   end else
   if (PL^[k].Name<>'Name') and (PL^[k].Name<>'ImeName') and (PL^[k].Name<>'FieldName'){and (GetStrProp(C, PL^[k])<>'')} then begin
    XN:=SN.Nodes.AddNode('xsd:element');
    XN.Attr['name']:=prefix+PL^[k].Name;
    XN.Attr['type']:='xsd:string';
    s:=GetStrProp(C, PL^[k]);
    PN.Node[XN.Attr['name']]:=s;
   end;
  end;
 finally FreeMem(PL) end;
end;

procedure TLWizard.BuildSchema(F: TWinControl);
var i: Integer; SN, PN: TXMLNode;
begin
 if Assigned(Schema) then FreeAndNil(Schema);
 Schema:=TXMLNode.Create('<xsd:schema><xsd:element name="FORM"><xsd:complexType><xsd:sequence></xsd:sequence></xsd:complexType></xsd:element></xsd:schema>');
 SN:=Schema[0][0][0];
 PN:=TXMLNode.Create('<control/>');
 AddObject(SN, PN, F, F.Name+'.');
 for i:=0 to F.ComponentCount-1 do
  if GetPropInfo(F.Components[i], 'Visible')<>nil then AddObject(SN, PN, F.Components[i], F.Components[i].Name+'.');
 Props.Schema:=Schema[0];
 Props.CurNode:=PN;
end;

procedure TLWizard.Execute(F: TWinControl);
begin
 CurrFrame:=F;
 BuildSchema(F);
 Caption:='Lang Wizard: '+F.Name;
 ShowModal;
end;

procedure TLWizard.PropsChange(Sender: TXMLInspector;  Prop: TXMLPropEditor);
begin
 SetProp(CurrFrame, Prop.GetName, Prop.GetValue);
 SetXMLProp(CurrFrame, Prop.GetName, Prop.GetValue);
 if Assigned(LangNode) then StrtoFile(LangNode.FormattedCode(' '), RootPath+LangFile);
end;

end.
