unit lnframe;

interface

uses Windows, Classes, Controls, Forms, SysUtils, typinfo, xmls, langwiz;

type
 TLnFrame=class(TFrame)
 protected
   procedure KeyDown(var Key: Word; Shift: TShiftState); override;
 public
   constructor Create(AOwner: TComponent); override;
   procedure   Translate;
 end;

 TLnForm=class(TForm)
 protected
   procedure KeyDown(var Key: Word; Shift: TShiftState); override;
 public
   constructor Create(AOwner: TComponent); override;
   procedure   Translate;
 end;

 procedure TranslateComponent(F: TComponent);
 function Trans(const s: string): string;


const
 LangNode: TXMLNode=nil;
 LangFile: string='';

implementation

{$R *.DFM}

{ TLnFrame }

function Trans(const s: string): string;
var C, XN: TXMLNode;
begin
 Result:=s;
 if Assigned(LangNode) then begin
  C:=LangNode.NodebyName('Common');
  if Assigned(C) then begin
   XN:=C.NodebyAttr('a', s);
   if Assigned(XN) then Result:=XN.Attr['b'];
  end;
 end;
end;

constructor TLnFrame.Create(AOwner: TComponent);
begin
 inherited;
 Translate;
end;

procedure TLnFrame.KeyDown(var Key: Word; Shift: TShiftState);
var LW: TLWizard;
begin
 inherited;
 if (Key=ord('K')) and (GetKeyState(VK_LMENU)<0) then begin
  Key:=0;
  LW:=TLWizard.Create(nil);
  LW.Execute(Self);
  LW.Free;
 end;
end;

procedure TLnFrame.Translate;
begin
 TranslateComponent(Self)
end;

{ TLnForm }

constructor TLnForm.Create(AOwner: TComponent);
begin
 inherited;
 KeyPreview:=True;
 Translate;
end;

procedure TLnForm.KeyDown(var Key: Word; Shift: TShiftState);
var LW: TLWizard; A: TWinControl;
begin
 inherited;
 if (Key=ord('L')) and (GetKeyState(VK_LMENU)<0) then begin
  Key:=0;
  LW:=TLWizard.Create(nil);
  A:=ActiveControl;
  while (A<>nil) and not (A is TFrame) do A:=A.Parent;
  if Assigned(A) then LW.Execute(A) else LW.Execute(Self);
  LW.Free;
 end else if (Key=VK_F1) and (ssCtrl in Shift) then Application.MessageBox(pchar(Name), 'Help ID', ID_OK);
end;


procedure TLnForm.Translate;
begin
 TranslateComponent(Self)
end;

procedure TranslateComponent(F: TComponent);
var XN: TXMLNode; i: integer; s: string;

procedure Trans(XN: TXMLNode; path: string);
var i: integer; 
begin
 for i:=0 to XN.Attributes.Count-1 do SetProp(F, path+'.'+XN.Attributes[i].Name, XN.Attributes[i].Value);
 for i:=0 to XN.Count-1 do Trans(XN[i], path+'.'+XN[i].Name);
end;

begin
 if Assigned(LangNode) then begin
  if F.ClassType=TLnForm then s:=F.Name else s:=F.ClassName;
  XN:=LangNode.NodebyName(s);
  if Assigned(XN) then begin
   for i:=0 to XN.Attributes.Count-1 do SetProp(F, s+'.'+XN.Attributes[i].Name, XN.Attributes[i].Value);
   for i:=0 to XN.Count-1 do Trans(XN[i], XN[i].Name);
  end;
 end;
end;


end.
