{***************************************************************}
{ XMLInspector - a component for automatic generation of dialog }
{ forms based on XML                                            }
{                                                               }
{    Copyright (c) 2001-2004 Alexander Sviridenkov              }
{    Contact: asv@devrace.com                                   }
{                                                               }
{ ------------------------------------------------------------- }
{    XMLInspector home page : http://www.xmlinspector.com/      }
{    Support page :  http://www.devrace.com/en/support/         }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}

unit xsdedit;

interface

{$I xmlinspector.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  xmls, xsdins, strs, Menus, StdCtrls, ExtCtrls, db;

type
  TXSDEditor = class(TForm)
    PopupMenu1: TPopupMenu;
    AddShort: TMenuItem;
    AddFull: TMenuItem;
    N1: TMenuItem;
    DelItem: TMenuItem;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    XP: TXMLInspector;
    procedure PopupMenu1Popup(Sender: TObject);
    procedure AA1Click(Sender: TObject);
    procedure DelItemClick(Sender: TObject);
  private
   Schema, Node: TXMLNode;
  public
   // BCB does not love Create with non-default parameters :)
   constructor CreateWithCaption(AOwner: TComponent; const ACaption: string = '');
   function  Run(ASchema, ANode: TXMLNode; DS: TDataSet=nil): boolean;
  end;


implementation

{$R *.DFM}

procedure LinkDataset(Schema, Res: TXMLNode; DS: TDataSet; Get: boolean);
var Element: TXMLNode; ns: string;

procedure IndexNode(Node, SchemaNode: TXMLNode; level: integer);
var XN, SI, Schema1: TXMLNode; i: integer; element, datatype: string; processed: boolean;
begin
 if level>10 then exit;
 processed:=false;
 for i:=0 to SchemaNode.Count-1 do begin
  if processed and (SchemaNode.name=ns+'choice') then break;
  SI:=SchemaNode[i];
  if SI.Name=ns+'attribute' then begin
   if StartsWith(SI.Attr['name'], '_') and (DS.FindField(Copy(SI.Attr['name'], 2, Maxint))<>nil)
    then begin
     if Get then Node.Attr[SI.Attr['name']]:=DS.FieldByName(Copy(SI.Attr['name'], 2, Maxint)).AsString
      else DS.FieldByName(Copy(SI.Attr['name'], 2, Maxint)).AsString:=Node.Attr[SI.Attr['name']];
    end;
  end else
  if SI.Name=ns+'sequence' then begin
//   if (not Optional) and (StrIn(SI.Attr['minOccurs'], ['0'])) then continue;
   IndexNode(Node, SI, level+1); processed:=true
  end else
  if SI.Name=ns+'element' then begin
    processed:=true;
    if SI.Attr['ref']<>'' then begin
      XN:=Node.Nodes.GetCreateNode(SI.Attr['ref']);
      Schema1:=Schema.Nodes.NodebyNameAttr(ns+'element', 'name', SI.Attr['ref']);
      if Assigned(Schema1) then IndexNode(XN, Schema1, level+1);
      continue
    end;
    datatype:=SI.Attr['type'];
    element:=SI.Attr['name'];
    if (datatype<>'') and StartsWith(datatype, ns) then begin
     XN:=Node.Nodes.GetCreateNode(element);
     if StartsWith(SI.Attr['name'], '_') and (DS.FindField(Copy(SI.Attr['name'], 2, Maxint))<>nil)
      then begin
       if Get then XN.Value:=DS.FieldByName(Copy(SI.Attr['name'], 2, Maxint)).AsString
        else DS.FieldByName(Copy(SI.Attr['name'], 2, Maxint)).AsString:=XN.Value;
      end
    end else begin
     if datatype<>'' then begin
      XN:=Node.Nodes.GetCreateNode(element);
      Schema1:=Schema.Nodes.NodebyNameAttr(ns+'complexType', 'name', datatype);
      if Assigned(Schema1) then IndexNode(XN, Schema1, level+1);
     end else begin
      XN:=Node.Nodes.GetCreateNode(SI.Attr['name']);
      if StartsWith(SI.Attr['name'], '_') and (DS.FindField(Copy(SI.Attr['name'], 2, Maxint))<>nil)
       then begin
        if Get then XN.Value:=DS.FieldByName(Copy(SI.Attr['name'], 2, Maxint)).AsString
         else DS.FieldByName(Copy(SI.Attr['name'], 2, Maxint)).AsString:=XN.Value;
       end;
      IndexNode(XN, SI, level+1);
     end;
    end
  end else
  if SI.Name=ns+'extension' then begin
  end else
  if SI.Name=ns+'complexType' then begin IndexNode(Node, SI, level+1); processed:=true end else
  if SI.Name=ns+'choice' then begin IndexNode(Node, SI, level+1); processed:=true end else
  if SI.Name=ns+'simpleContent' then begin IndexNode(Node, SI, level+1); processed:=true end
 end;
end;

begin
 Element:=Schema;
 Schema:=Schema.Root;
 ns:=Schema.NameSpace;
 if (Element.Attr['type']<>'') and not StartsWith(Element.Attr['type'], ns)
  then Element:=Schema.Nodes.NodebyNameAttr(ns+'complexType', 'name', Element.Attr['type']);
 IndexNode(Res, Element, 1);
end;

function TXSDEditor.Run(ASchema, ANode: TXMLNode; DS: TDataSet=nil): boolean;
begin
 Schema:=ASchema;
 Node:=ANode;
 if Assigned(DS) then LinkDataset(Schema, Node, DS, true);
 XP.Schema:=ASchema;
 XP.CurNode:=ANode;
 XP.NodeClicked;
 ShowModal;
 Result:=ModalResult=mrOk;
 if Result and Assigned(DS) and (DS.State in [dsEdit, dsInsert]) then LinkDataset(Schema, Node, DS, False);
end;

function Title(XN: TXMLNode): string;
begin
 if XN.Attr['ref']<>'' then XN:=XN.Root.NodebyAttr('name', XN.Attr['ref']);
 Result:=XN.Node[XN.NameSpace+'annotation/'+XN.NameSpace+'documentation'];
 if Result='' then Result:=XN.Attr['name'];
end;

procedure InsertNode(SchemaNode, Node, NewNode: TXMLNode);
var k: integer; ns: string;

procedure ProcessNode(SchemaNode, Node: TXMLNode; var Start:integer);
var i, k,{minoccurs,} maxoccurs: integer; SN: TXMLNode; ElementName: string;
begin
 {---typed elements---}
 if SchemaNode.Attr['type']<>'' then SchemaNode:=SchemaNode.Root.NodebyAttr('name', SchemaNode.Attr['type']) else
 {---type by ref---}
 if SchemaNode.Attr['ref']<>'' then SchemaNode:=SchemaNode.Root.NodebyAttr('name', SchemaNode.Attr['ref']);
 if SchemaNode=nil then exit;
 for i:=0 to SchemaNode.Count-1 do begin
  if NewNode=nil then exit;
  SN:=SchemaNode[i];
  {---attribute---}
  if SN.Name=ns+'attribute' then else
  {---element---}
  if SN.Name=ns+'element' then begin
   //minOccurs:=0;
   maxOccurs:=1;
   //if SN.Attr['minOccurs']<>'' then minOccurs:=strtoint(SN.Attr['minOccurs']);
   if SN.Attr['maxOccurs']<>'' then begin
    if SN.Attr['maxOccurs']='unbounded' then maxOccurs:=10000
     else maxOccurs:=strtoint(SN.Attr['maxOccurs']);
   end;
   k:=0;
   ElementName:=SN.Attr['name'];
   if ElementName='' then ElementName:=SN.Attr['ref'];
   while (Start<Node.Count) and (Node[Start].Name=ElementName) do begin
    inc(Start);
    inc(k);
   end;
   if Assigned(SN.Parent) and (SN.Parent.Name=ns+'choice') then begin
    if (k<maxOccurs) and ((k>0) or (Node.Count=0)) and (NewNode.Name=ElementName)
      then begin Node.Nodes.Insert(Start, NewNode); NewNode.Parent:=Node; NewNode:=nil; exit end;
   end else begin
    if (k<maxOccurs) and (NewNode.Name=ElementName) then begin
     Node.Nodes.Insert(Start, NewNode);
     NewNode.Parent:=Node;
     NewNode:=nil;
     exit
    end;
   end;
  end else
  {---complexType---}
  if SN.Name=ns+'complexType' then begin
   if SN.Attr['name']<>'' then begin
    Node.Nodes.Insert(Start,NewNode); NewNode.Parent:=Node; NewNode:=nil; exit
   end else ProcessNode(SN, Node, Start);
  end else
  {---simpleContent extension restriction sequence choice---}
  if StrIn(SN.Name, [ns+'simpleContent', ns+'extension', ns+'restriction', ns+'sequence', ns+'choice'])
   then ProcessNode(SN, Node, Start)
 end;
end;

begin
 k:=0;
 ns:=SchemaNode.NameSpace;
 ProcessNode(SchemaNode, Node, k)
end;


procedure GetChildList(SchemaNode, Node: TXMLNode; L: TStringList);
var k: integer; ElementName, ns: string;

procedure ProcessNode(SchemaNode, Node: TXMLNode; var Start: integer);
var i, k, minoccurs, maxoccurs: integer; XN, SN: TXMLNode;
begin
 {---typed elements---}
 if SchemaNode.Attr['type']<>'' then SchemaNode:=SchemaNode.Root.NodebyAttr('name', SchemaNode.Attr['type']) else
 {---type by ref---}
 if SchemaNode.Attr['ref']<>'' then SchemaNode:=SchemaNode.Root.NodebyAttr('name', SchemaNode.Attr['ref']);
 if SchemaNode=nil then exit;
 for i:=0 to SchemaNode.Count-1 do begin
  SN:=SchemaNode[i];
  {---attribute---}
  if SN.Name=ns+'attribute' then else
  {---element---}
  if SN.Name=ns+'element' then begin
   if SN.Attr['minOccurs']='' then minOccurs:=1 else
    minOccurs:=strtoint(SN.Attr['minOccurs']);
   if SN.Attr['maxOccurs']<>'' then begin
    if SN.Attr['maxOccurs']='unbounded' then maxOccurs:=10000
     else maxOccurs:=strtoint(SN.Attr['maxOccurs']);
   end else maxOccurs:=1;
   ElementName:=SN.Attr['name'];
   if ElementName='' then ElementName:=SN.Attr['ref'];
   k:=0;
   {---add required elements---}
   if (Start<Node.Count) and (minOccurs>0) and (Node[Start].Name<>ElementName) then begin
     XN:=CreateXMLTemplate(SN, false);
     XN.Name:=ElementName;
     InsertNode(SchemaNode, Node, XN);
   end;
   while (Start<Node.Count) and (Node[Start].Name=ElementName) do begin
    inc(Start);
    inc(k);
   end;
   if Assigned(SN.Parent) and (SN.Parent.Name=ns+'choice') then begin
    if (k<maxOccurs) and ((k>0) or (Node.Count=0))
      then L.AddObject(Title(SN), SN) else L.AddObject('*'+Title(SN), SN);
   end else begin
    if k<maxOccurs then L.AddObject(Title(SN), SN) else L.AddObject('*'+Title(SN), SN);
   end;
  end else
  {---complexType---}
  if SN.Name=ns+'complexType' then begin
   if SN.Attr['name']<>'' then L.AddObject(Title(SN), SN)
    else ProcessNode(SN, Node, Start);
  end else
  {---simpleContent extension restriction sequence choice---}
  if StrIn(SN.Name, [ns+'simpleContent', ns+'extension', ns+'restriction', ns+'sequence', ns+'choice'])
   then ProcessNode(SN, Node, Start)
 end;
end;

begin
 k:=0;
 ns:=SchemaNode.NameSpace;
 ProcessNode(SchemaNode, Node, k)
end;

procedure TXSDEditor.PopupMenu1Popup(Sender: TObject);
var L: TStringList; MI: TMenuItem; i: integer; SN: TXMLNode;
begin
 while AddShort.Count>0 do AddShort.Delete(0);
 while AddFull.Count>0 do AddFull.Delete(0);
 L:=TStringList.Create;
 GetChildList(TXSDSchemaEditor(XP.Editor).Schema, TXSDSchemaEditor(XP.Editor).Node, L);
 for i:=0 to L.COunt-1 do begin
  MI:=TMenuItem.Create(self);
  MI.Tag:=integer(L.Objects[i]);
  if StartsWith(L[i], '*') then begin
   MI.Caption:=copy(L[i], 2, MaxInt);
   MI.Enabled:=false;
  end else MI.Caption:=L[i];
  MI.OnClick:=AA1Click;
  AddShort.Add(MI);
  MI:=TMenuItem.Create(self);
  MI.Tag:=integer(L.Objects[i]);
  if StartsWith(L[i], '*') then begin
   MI.Caption:=copy(L[i], 2, MaxInt);
   MI.Enabled:=false;
  end else MI.Caption:=L[i];
  MI.OnClick:=AA1Click;
  AddFull.Add(MI);
 end;
 SN:=TXSDSchemaEditor(XP.Editor).Schema;
 if (SN.Attr['maxOccurs']='1') or (SN.Attr['maxOccurs']='') then DelItem.Enabled:=false
  else DelItem.Enabled:=true;
 L.Free;
 AddShort.Visible:=AddShort.Count>0;
 AddFull.Visible:=AddFull.Count>0;
end;

procedure TXSDEditor.AA1Click(Sender: TObject);
var SN, XN, Curr: TXMLNode; ElementName: string;
begin
 SN:=TXMLNode((Sender as TMenuItem).Tag);
 if SN.Attr['name']<>'' then ElementName:=SN.Attr['name'] else ElementName:=SN.Attr['ref'];
 Curr:=TXSDSchemaEditor(XP.Editor).Node;
 if (SN.Attr['type']<>'') and (not StartsWith(SN.Attr['type'], SN.NameSpace))
   then SN:=SN.Root.NodebyAttr('name', SN.Attr['type']) else
  {---type by ref---}
    if SN.Attr['ref']<>'' then SN:=SN.Root.NodebyAttr('name', SN.Attr['ref']);
 if SN=nil then exit;
 XN:=CreateXMLTemplate(SN, TMenuItem(Sender).Parent=AddFull);
 XN.Name:=ElementName;
 InsertNode(TXSDSchemaEditor(XP.Editor).Schema, Curr, XN);
 XP.NodeClicked;
 XP.NodeClicked;
end;

procedure TXSDEditor.DelItemClick(Sender: TObject);
var SN, Cur: TXMLNode;
begin
 Cur:=XP.CurNode;
 SN:=TXSDSchemaEditor(XP.Editor).Node;
 if Assigned(SN.Parent) and (SN.NodeType=ntNode) then begin
  SN.Parent.Nodes.DeleteNode(SN);
  XP.CurNode:=nil;
  XP.CurNode:=Cur;
 end;
end;

constructor TXSDEditor.CreateWithCaption(AOwner: TComponent; const ACaption: string);
begin
 inherited Create(AOwner);
 if ACaption<>'' then Caption:=ACaption;
end;

end.
