/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.common;

import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.components.Block;
import org.apache.tapestry.components.BlockRenderer;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.contrib.table.model.ITableRendererListener;
import org.apache.tapestry.contrib.table.model.ITableRendererSource;
import org.apache.tapestry.util.ComponentAddress;

public class BlockTableRendererSource
implements ITableRendererSource {
    private ComponentAddress m_objBlockAddress;
    private ComponentAddress m_objListenerAddress;

    public BlockTableRendererSource(Block objBlock) {
        this(new ComponentAddress((IComponent)objBlock));
    }

    public BlockTableRendererSource(Block objBlock, ITableRendererListener objListener) {
        this(new ComponentAddress((IComponent)objBlock), new ComponentAddress((IComponent)objListener));
    }

    public BlockTableRendererSource(ComponentAddress objBlockAddress) {
        this(objBlockAddress, null);
    }

    public BlockTableRendererSource(ComponentAddress objBlockAddress, ComponentAddress objListenerAddress) {
        this.setBlockAddress(objBlockAddress);
        this.setListenerAddress(objListenerAddress);
    }

    public IRender getRenderer(IRequestCycle objCycle, ITableModelSource objSource, ITableColumn objColumn, Object objRow) {
        ComponentAddress objListenerAddress = this.getListenerAddress();
        if (objListenerAddress != null) {
            ITableRendererListener objListener = (ITableRendererListener)objListenerAddress.findComponent(objCycle);
            objListener.initializeRenderer(objCycle, objSource, objColumn, objRow);
        }
        Block objBlock = (Block)this.getBlockAddress().findComponent(objCycle);
        return new BlockRenderer(objBlock);
    }

    public ComponentAddress getBlockAddress() {
        return this.m_objBlockAddress;
    }

    public void setBlockAddress(ComponentAddress blockAddress) {
        this.m_objBlockAddress = blockAddress;
    }

    public ComponentAddress getListenerAddress() {
        return this.m_objListenerAddress;
    }

    public void setListenerAddress(ComponentAddress listenerAddress) {
        this.m_objListenerAddress = listenerAddress;
    }
}

