/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.Date;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class MonthlyCalendar
extends BaseCalendar
implements Calendar,
Serializable {
    private boolean[] excludeDays = new boolean[31];
    private boolean excludeAll = false;

    public MonthlyCalendar() {
        this.init();
    }

    public MonthlyCalendar(Calendar baseCalendar) {
        super(baseCalendar);
        this.init();
    }

    private void init() {
        this.excludeAll = this.areAllDaysExcluded();
    }

    public boolean[] getDaysExcluded() {
        return this.excludeDays;
    }

    public boolean isDayExcluded(int day) {
        return this.excludeDays[day - 1];
    }

    public void setDaysExcluded(boolean[] days) {
        if (days == null) {
            return;
        }
        this.excludeDays = days;
        this.excludeAll = this.areAllDaysExcluded();
    }

    public void setDayExcluded(int day, boolean exclude) {
        this.excludeDays[day] = exclude;
        this.excludeAll = this.areAllDaysExcluded();
    }

    public boolean areAllDaysExcluded() {
        int i = 1;
        while (i <= 31) {
            if (!this.isDayExcluded(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isTimeIncluded(long timeStamp) {
        if (this.excludeAll) {
            return false;
        }
        if (!super.isTimeIncluded(timeStamp)) {
            return false;
        }
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(new Date(timeStamp));
        int day = cl.get(5);
        return !this.isDayExcluded(day);
    }

    /*
     * Unable to fully structure code
     */
    public long getNextIncludedTime(long timeStamp) {
        if (this.excludeAll) {
            return 0L;
        }
        baseTime = super.getNextIncludedTime(timeStamp);
        if (baseTime > 0L && baseTime > timeStamp) {
            timeStamp = baseTime;
        }
        if (this.isDayExcluded(day = (cl = BaseCalendar.getJavaCalendar(newTimeStamp = BaseCalendar.buildHoliday(timeStamp))).get(5))) ** GOTO lbl10
        return timeStamp;
lbl-1000:
        // 1 sources

        {
            cl.add(5, 1);
            day = cl.get(7);
lbl10:
            // 2 sources

            ** while (this.isDayExcluded((int)day))
        }
lbl11:
        // 1 sources

        return cl.getTime().getTime();
    }
}

