/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.simpl.JobWrapper;
import org.quartz.simpl.TriggerComparator;
import org.quartz.simpl.TriggerWrapper;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;

public class RAMJobStore
implements JobStore {
    protected HashMap jobsByFQN = new HashMap(1000);
    protected HashMap triggersByFQN = new HashMap(1000);
    protected HashMap jobsByGroup = new HashMap(25);
    protected HashMap triggersByGroup = new HashMap(25);
    protected TreeSet timeTriggers = new TreeSet(new TriggerComparator());
    protected HashMap calendarsByName = new HashMap(25);
    protected ArrayList triggers = new ArrayList(1000);
    protected Object jobLock = new Object();
    protected Object triggerLock = new Object();
    protected HashSet pausedTriggerGroups = new HashSet();
    protected HashSet blockedJobs = new HashSet();
    protected long misfireThreshold = 5000L;
    protected SchedulerSignaler signaler;
    private static long ftrCtr = System.currentTimeMillis();
    static /* synthetic */ Class class$org$quartz$simpl$RAMJobStore;

    protected Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$simpl$RAMJobStore == null ? (class$org$quartz$simpl$RAMJobStore = RAMJobStore.class$("org.quartz.simpl.RAMJobStore")) : class$org$quartz$simpl$RAMJobStore));
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) {
        this.signaler = signaler;
        this.getLog().info((Object)"RAMJobStore initialized.");
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        if (misfireThreshold < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = misfireThreshold;
    }

    public void shutdown() {
    }

    public boolean supportsPersistence() {
        return false;
    }

    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws JobPersistenceException {
        this.storeJob(ctxt, newJob, false);
        this.storeTrigger(ctxt, newTrigger, false);
    }

    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException {
        JobWrapper jw = new JobWrapper(newJob);
        boolean repl = false;
        if (this.jobsByFQN.get(jw.key) != null) {
            if (!replaceExisting) {
                throw new ObjectAlreadyExistsException(newJob);
            }
            repl = true;
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (!repl) {
                HashMap<String, JobWrapper> grpMap = (HashMap<String, JobWrapper>)this.jobsByGroup.get(newJob.getGroup());
                if (grpMap == null) {
                    grpMap = new HashMap<String, JobWrapper>(100);
                    this.jobsByGroup.put(newJob.getGroup(), grpMap);
                }
                grpMap.put(newJob.getName(), jw);
                this.jobsByFQN.put(jw.key, jw);
            } else {
                JobWrapper orig = (JobWrapper)this.jobsByFQN.get(jw.key);
                orig.jobDetail = newJob;
            }
        }
    }

    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) {
        String key = JobWrapper.getJobNameKey(jobName, groupName);
        boolean found = false;
        Trigger[] trigger = this.getTriggersForJob(ctxt, jobName, groupName);
        int i = 0;
        while (i < trigger.length) {
            Trigger trig = trigger[i];
            this.removeTrigger(ctxt, trig.getName(), trig.getGroup());
            found = true;
            ++i;
        }
        Object object = this.jobLock;
        synchronized (object) {
            HashMap grpMap;
            found = this.jobsByFQN.remove(key) != null | found;
            if (found && (grpMap = (HashMap)this.jobsByGroup.get(groupName)) != null) {
                grpMap.remove(jobName);
                if (grpMap.size() == 0) {
                    this.jobsByGroup.remove(groupName);
                }
            }
        }
        return found;
    }

    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws JobPersistenceException {
        TriggerWrapper tw = new TriggerWrapper(newTrigger);
        if (this.triggersByFQN.get(tw.key) != null) {
            if (!replaceExisting) {
                throw new ObjectAlreadyExistsException(newTrigger);
            }
            this.removeTrigger(ctxt, newTrigger.getName(), newTrigger.getGroup());
        }
        if (this.retrieveJob(ctxt, newTrigger.getJobName(), newTrigger.getJobGroup()) == null) {
            throw new JobPersistenceException("The job (" + newTrigger.getFullJobName() + ") referenced by the trigger does not exist.");
        }
        Object object = this.triggerLock;
        synchronized (object) {
            this.triggers.add(tw);
            HashMap<String, TriggerWrapper> grpMap = (HashMap<String, TriggerWrapper>)this.triggersByGroup.get(newTrigger.getGroup());
            if (grpMap == null) {
                grpMap = new HashMap<String, TriggerWrapper>(100);
                this.triggersByGroup.put(newTrigger.getGroup(), grpMap);
            }
            grpMap.put(newTrigger.getName(), tw);
            this.triggersByFQN.put(tw.key, tw);
            HashSet hashSet = this.pausedTriggerGroups;
            synchronized (hashSet) {
                if (this.pausedTriggerGroups.contains(newTrigger.getGroup())) {
                    tw.state = 4;
                } else if (this.blockedJobs.contains(tw.jobKey)) {
                    tw.state = 5;
                } else {
                    this.timeTriggers.add(tw);
                }
            }
        }
    }

    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
        boolean found = false;
        Object object = this.triggerLock;
        synchronized (object) {
            boolean bl = found = this.triggersByFQN.remove(key) != null;
            if (found) {
                TriggerWrapper tw = null;
                HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
                if (grpMap != null) {
                    grpMap.remove(triggerName);
                    if (grpMap.size() == 0) {
                        this.triggersByGroup.remove(groupName);
                    }
                }
                Iterator tgs = ((AbstractList)this.triggers).iterator();
                while (tgs.hasNext()) {
                    tw = (TriggerWrapper)tgs.next();
                    if (!key.equals(tw.key)) continue;
                    tgs.remove();
                    break;
                }
                this.timeTriggers.remove(tw);
                JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(tw.trigger.getJobName(), tw.trigger.getJobGroup()));
                Trigger[] trigs = this.getTriggersForJob(ctxt, tw.trigger.getJobName(), tw.trigger.getJobGroup());
                if (!(trigs != null && trigs.length != 0 || jw.jobDetail.isDurable())) {
                    this.removeJob(ctxt, tw.trigger.getJobName(), tw.trigger.getJobGroup());
                }
            }
        }
        return found;
    }

    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        String key = TriggerWrapper.getTriggerNameKey(triggerName, groupName);
        boolean found = false;
        Object object = this.triggerLock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.remove(key);
            boolean bl = found = tw != null;
            if (found) {
                if (!tw.getTrigger().getJobName().equals(newTrigger.getJobName()) || !tw.getTrigger().getJobGroup().equals(newTrigger.getJobGroup())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                tw = null;
                HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
                if (grpMap != null) {
                    grpMap.remove(triggerName);
                    if (grpMap.size() == 0) {
                        this.triggersByGroup.remove(groupName);
                    }
                }
                Iterator tgs = ((AbstractList)this.triggers).iterator();
                while (tgs.hasNext()) {
                    tw = (TriggerWrapper)tgs.next();
                    if (!key.equals(tw.key)) continue;
                    tgs.remove();
                    break;
                }
                this.timeTriggers.remove(tw);
                try {
                    this.storeTrigger(ctxt, newTrigger, false);
                }
                catch (JobPersistenceException jpe) {
                    this.storeTrigger(ctxt, tw.getTrigger(), false);
                    throw jpe;
                }
            }
        }
        return found;
    }

    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) {
        JobWrapper jw = (JobWrapper)this.jobsByFQN.get(JobWrapper.getJobNameKey(jobName, groupName));
        if (jw != null) {
            return jw.jobDetail;
        }
        return null;
    }

    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        if (tw != null) {
            return tw.getTrigger();
        }
        return null;
    }

    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        if (tw == null) {
            return -1;
        }
        if (tw.state == 3) {
            return 2;
        }
        if (tw.state == 4) {
            return 1;
        }
        if (tw.state == 5) {
            return 4;
        }
        return 0;
    }

    public void storeCalendar(SchedulingContext ctxt, String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException {
        Object obj = this.calendarsByName.get(name);
        if (obj != null && !replaceExisting) {
            throw new ObjectAlreadyExistsException("Calendar with name '" + name + "' already exists.");
        }
        if (obj != null) {
            this.calendarsByName.remove(name);
        }
        this.calendarsByName.put(name, calendar);
        if (obj != null && updateTriggers) {
            Object object = this.triggerLock;
            synchronized (object) {
                Iterator trigs = ((AbstractList)this.getTriggerWrappersForCalendar(name)).iterator();
                while (trigs.hasNext()) {
                    TriggerWrapper tw = (TriggerWrapper)trigs.next();
                    Trigger trig = tw.getTrigger();
                    boolean removed = this.timeTriggers.remove(tw);
                    trig.updateWithNewCalendar(calendar, this.getMisfireThreshold());
                    if (!removed) continue;
                    this.timeTriggers.add(tw);
                }
            }
        }
    }

    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        int numRefs = 0;
        Object object = this.triggerLock;
        synchronized (object) {
            Iterator itr = ((AbstractList)this.triggers).iterator();
            while (itr.hasNext()) {
                Trigger trigg = ((TriggerWrapper)itr.next()).trigger;
                if (trigg.getCalendarName() == null || !trigg.getCalendarName().equals(calName)) continue;
                ++numRefs;
            }
        }
        if (numRefs > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.calendarsByName.remove(calName) != null;
    }

    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) {
        return (Calendar)this.calendarsByName.get(calName);
    }

    public int getNumberOfJobs(SchedulingContext ctxt) {
        return this.jobsByFQN.size();
    }

    public int getNumberOfTriggers(SchedulingContext ctxt) {
        return this.triggers.size();
    }

    public int getNumberOfCalendars(SchedulingContext ctxt) {
        return this.calendarsByName.size();
    }

    public String[] getJobNames(SchedulingContext ctxt, String groupName) {
        String[] outList = null;
        HashMap grpMap = (HashMap)this.jobsByGroup.get(groupName);
        if (grpMap != null) {
            Object object = this.jobLock;
            synchronized (object) {
                outList = new String[grpMap.size()];
                int outListPos = 0;
                Iterator keys = grpMap.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JobWrapper jw = (JobWrapper)grpMap.get(key);
                    if (jw == null) continue;
                    outList[outListPos++] = jw.jobDetail.getName();
                }
            }
        } else {
            outList = new String[]{};
        }
        return outList;
    }

    public String[] getCalendarNames(SchedulingContext ctxt) {
        Set names = this.calendarsByName.keySet();
        return names.toArray(new String[names.size()]);
    }

    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) {
        String[] outList = null;
        HashMap grpMap = (HashMap)this.triggersByGroup.get(groupName);
        if (grpMap != null) {
            Object object = this.triggerLock;
            synchronized (object) {
                outList = new String[grpMap.size()];
                int outListPos = 0;
                Iterator keys = grpMap.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    TriggerWrapper tw = (TriggerWrapper)grpMap.get(key);
                    if (tw == null) continue;
                    outList[outListPos++] = tw.trigger.getName();
                }
            }
        } else {
            outList = new String[]{};
        }
        return outList;
    }

    public String[] getJobGroupNames(SchedulingContext ctxt) {
        String[] outList = null;
        Object object = this.jobLock;
        synchronized (object) {
            outList = new String[this.jobsByGroup.size()];
            int outListPos = 0;
            Iterator keys = this.jobsByGroup.keySet().iterator();
            while (keys.hasNext()) {
                outList[outListPos++] = (String)keys.next();
            }
        }
        return outList;
    }

    public String[] getTriggerGroupNames(SchedulingContext ctxt) {
        String[] outList = null;
        Object object = this.triggerLock;
        synchronized (object) {
            outList = new String[this.triggersByGroup.size()];
            int outListPos = 0;
            Iterator keys = this.triggersByGroup.keySet().iterator();
            while (keys.hasNext()) {
                outList[outListPos++] = (String)keys.next();
            }
        }
        return outList;
    }

    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) {
        ArrayList<Object> trigList = new ArrayList<Object>();
        String jobKey = JobWrapper.getJobNameKey(jobName, groupName);
        Object object = this.triggerLock;
        synchronized (object) {
            int i = 0;
            while (i < this.triggers.size()) {
                TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
                if (tw.jobKey.equals(jobKey)) {
                    trigList.add(tw.trigger.clone());
                }
                ++i;
            }
        }
        return trigList.toArray(new Trigger[trigList.size()]);
    }

    protected ArrayList getTriggerWrappersForJob(String jobName, String groupName) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        String jobKey = JobWrapper.getJobNameKey(jobName, groupName);
        Object object = this.triggerLock;
        synchronized (object) {
            int i = 0;
            while (i < this.triggers.size()) {
                TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
                if (tw.jobKey.equals(jobKey)) {
                    trigList.add(tw);
                }
                ++i;
            }
        }
        return trigList;
    }

    protected ArrayList getTriggerWrappersForCalendar(String calName) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        Object object = this.triggerLock;
        synchronized (object) {
            int i = 0;
            while (i < this.triggers.size()) {
                TriggerWrapper tw = (TriggerWrapper)this.triggers.get(i);
                String tcalName = tw.getTrigger().getCalendarName();
                if (tcalName != null && tcalName.equals(calName)) {
                    trigList.add(tw);
                }
                ++i;
            }
        }
        return trigList;
    }

    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        if (tw == null || tw.trigger == null) {
            return;
        }
        if (tw.state == 3) {
            return;
        }
        Object object = this.triggerLock;
        synchronized (object) {
            tw.state = 4;
            this.timeTriggers.remove(tw);
        }
    }

    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            if (this.pausedTriggerGroups.contains(groupName)) {
                return;
            }
            this.pausedTriggerGroups.add(groupName);
            String[] names = this.getTriggerNames(ctxt, groupName);
            int i = 0;
            while (i < names.length) {
                this.pauseTrigger(ctxt, names[i], groupName);
                ++i;
            }
        }
    }

    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            Trigger[] triggers = this.getTriggersForJob(ctxt, jobName, groupName);
            int j = 0;
            while (j < triggers.length) {
                this.pauseTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
                ++j;
            }
        }
    }

    public void pauseJobGroup(SchedulingContext ctxt, String groupName) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] jobNames = this.getJobNames(ctxt, groupName);
            int i = 0;
            while (i < jobNames.length) {
                Trigger[] triggers = this.getTriggersForJob(ctxt, jobNames[i], groupName);
                int j = 0;
                while (j < triggers.length) {
                    this.pauseTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
                    ++j;
                }
                ++i;
            }
        }
    }

    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) {
        TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(triggerName, groupName));
        Trigger trig = tw.getTrigger();
        if (tw == null || tw.trigger == null) {
            return;
        }
        if (tw.state != 4) {
            return;
        }
        Object object = this.triggerLock;
        synchronized (object) {
            tw.state = this.blockedJobs.contains(JobWrapper.getJobNameKey(trig.getJobName(), trig.getJobGroup())) ? 5 : 0;
            this.applyMisfire(tw);
            if (tw.state == 0) {
                this.timeTriggers.add(tw);
            }
        }
    }

    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] names = this.getTriggerNames(ctxt, groupName);
            int i = 0;
            while (i < names.length) {
                this.resumeTrigger(ctxt, names[i], groupName);
                ++i;
            }
            this.pausedTriggerGroups.remove(groupName);
        }
    }

    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            Trigger[] triggers = this.getTriggersForJob(ctxt, jobName, groupName);
            int j = 0;
            while (j < triggers.length) {
                this.resumeTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
                ++j;
            }
        }
    }

    public void resumeJobGroup(SchedulingContext ctxt, String groupName) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] jobNames = this.getJobNames(ctxt, groupName);
            int i = 0;
            while (i < jobNames.length) {
                Trigger[] triggers = this.getTriggersForJob(ctxt, jobNames[i], groupName);
                int j = 0;
                while (j < triggers.length) {
                    this.resumeTrigger(ctxt, triggers[j].getName(), triggers[j].getGroup());
                    ++j;
                }
                ++i;
            }
        }
    }

    public void pauseAll(SchedulingContext ctxt) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] names = this.getTriggerGroupNames(ctxt);
            int i = 0;
            while (i < names.length) {
                this.pauseTriggerGroup(ctxt, names[i]);
                ++i;
            }
        }
    }

    public void resumeAll(SchedulingContext ctxt) {
        HashSet hashSet = this.pausedTriggerGroups;
        synchronized (hashSet) {
            String[] names = this.getTriggerGroupNames(ctxt);
            int i = 0;
            while (i < names.length) {
                this.resumeTriggerGroup(ctxt, names[i]);
                ++i;
            }
        }
    }

    protected boolean applyMisfire(TriggerWrapper tw) {
        Date tnft;
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        if ((tnft = tw.trigger.getNextFireTime()).getTime() > misfireTime) {
            return false;
        }
        Calendar cal = null;
        if (tw.trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(null, tw.trigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired(tw.trigger);
        tw.trigger.updateAfterMisfire(cal);
        if (tw.trigger.getNextFireTime() == null) {
            tw.state = 3;
            Object object = this.triggerLock;
            synchronized (object) {
                this.timeTriggers.remove(tw);
            }
        } else if (tnft.equals(tw.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected synchronized String getFiredTriggerRecordId() {
        return String.valueOf(ftrCtr++);
    }

    public Trigger acquireNextTrigger(SchedulingContext ctxt) {
        TriggerWrapper tw = null;
        Object object = this.triggerLock;
        synchronized (object) {
            while (tw == null) {
                Trigger trig;
                try {
                    tw = (TriggerWrapper)this.timeTriggers.first();
                }
                catch (NoSuchElementException nsee) {
                    Trigger trigger = null;
                    return trigger;
                }
                if (tw == null) {
                    Trigger trigger = null;
                    return trigger;
                }
                if (tw.trigger.getNextFireTime() == null) {
                    this.timeTriggers.remove(tw);
                    tw = null;
                    continue;
                }
                this.timeTriggers.remove(tw);
                if (this.applyMisfire(tw)) {
                    if (tw.trigger.getNextFireTime() != null) {
                        this.timeTriggers.add(tw);
                    }
                    tw = null;
                    continue;
                }
                tw.state = 1;
                tw.trigger.setFireInstanceId(this.getFiredTriggerRecordId());
                Trigger trigger = trig = (Trigger)tw.trigger.clone();
                return trigger;
            }
        }
        return null;
    }

    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) {
        Object object = this.triggerLock;
        synchronized (object) {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
            if (tw != null && tw.state != 3 && tw.state != 4) {
                tw.state = 0;
                this.timeTriggers.add(tw);
            }
        }
    }

    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) {
        Object object = this.triggerLock;
        synchronized (object) {
            Object object2;
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
            if (tw == null || tw.trigger == null) {
                TriggerFiredBundle triggerFiredBundle = null;
                return triggerFiredBundle;
            }
            if (tw.state == 3) {
                TriggerFiredBundle triggerFiredBundle = null;
                return triggerFiredBundle;
            }
            if (tw.state == 4) {
                TriggerFiredBundle triggerFiredBundle = null;
                return triggerFiredBundle;
            }
            if (tw.state == 5) {
                TriggerFiredBundle triggerFiredBundle = null;
                return triggerFiredBundle;
            }
            Calendar cal = null;
            if (tw.trigger.getCalendarName() != null) {
                cal = this.retrieveCalendar(ctxt, tw.trigger.getCalendarName());
            }
            Date prevFireTime = trigger.getPreviousFireTime();
            tw.trigger.triggered(cal);
            trigger.triggered(cal);
            tw.state = 0;
            TriggerFiredBundle bndle = new TriggerFiredBundle(this.retrieveJob(ctxt, trigger.getJobName(), trigger.getJobGroup()), trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
            JobDetail job = bndle.getJobDetail();
            if (job.isStateful()) {
                ArrayList trigs = this.getTriggerWrappersForJob(job.getName(), job.getGroup());
                Iterator itr = ((AbstractList)trigs).iterator();
                while (itr.hasNext()) {
                    TriggerWrapper ttw = (TriggerWrapper)itr.next();
                    if (ttw.state == 0) {
                        ttw.state = 5;
                    }
                    this.timeTriggers.remove(ttw);
                }
                this.blockedJobs.add(JobWrapper.getJobNameKey(job));
            } else if (tw.trigger.getNextFireTime() != null) {
                object2 = this.triggerLock;
                synchronized (object2) {
                    this.timeTriggers.add(tw);
                }
            }
            object2 = bndle;
            return object2;
        }
    }

    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) {
        Object object = this.triggerLock;
        synchronized (object) {
            String jobKey = JobWrapper.getJobNameKey(jobDetail.getName(), jobDetail.getGroup());
            JobWrapper jw = (JobWrapper)this.jobsByFQN.get(jobKey);
            TriggerWrapper tw = (TriggerWrapper)this.triggersByFQN.get(TriggerWrapper.getTriggerNameKey(trigger));
            if (jw != null) {
                JobDetail jd = jw.jobDetail;
                if (jobDetail.isStateful()) {
                    JobDataMap newData = jobDetail.getJobDataMap();
                    if (newData != null) {
                        newData.clearDirtyFlag();
                    }
                    jd.setJobDataMap(newData);
                    this.blockedJobs.remove(JobWrapper.getJobNameKey(jd));
                    ArrayList trigs = this.getTriggerWrappersForJob(jd.getName(), jd.getGroup());
                    Iterator itr = ((AbstractList)trigs).iterator();
                    while (itr.hasNext()) {
                        TriggerWrapper ttw = (TriggerWrapper)itr.next();
                        if (ttw.state != 5) continue;
                        ttw.state = 0;
                        this.timeTriggers.add(ttw);
                    }
                }
            } else {
                this.blockedJobs.remove(JobWrapper.getJobNameKey(jobDetail));
            }
            if (tw != null) {
                if (triggerInstCode == 3) {
                    if (trigger.getNextFireTime() == null) {
                        if (tw.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(ctxt, trigger.getName(), trigger.getGroup());
                        }
                    } else {
                        this.removeTrigger(ctxt, trigger.getName(), trigger.getGroup());
                    }
                } else if (triggerInstCode == 2) {
                    tw.state = 3;
                    this.timeTriggers.remove(tw);
                } else if (triggerInstCode == 4) {
                    ArrayList tws = this.getTriggerWrappersForJob(trigger.getJobName(), trigger.getJobGroup());
                    Iterator itr = ((AbstractList)tws).iterator();
                    while (itr.hasNext()) {
                        tw = (TriggerWrapper)itr.next();
                        tw.state = 3;
                        this.timeTriggers.remove(tw);
                    }
                }
            }
        }
    }

    protected String peekTriggers() {
        StringBuffer str = new StringBuffer();
        TriggerWrapper tw = null;
        Object object = this.triggerLock;
        synchronized (object) {
            Iterator itr = this.triggersByFQN.keySet().iterator();
            while (itr.hasNext()) {
                tw = (TriggerWrapper)this.triggersByFQN.get(itr.next());
                str.append(tw.trigger.getName());
                str.append("/");
            }
        }
        str.append(" | ");
        Object object2 = this.triggerLock;
        synchronized (object2) {
            Iterator itr = this.timeTriggers.iterator();
            while (itr.hasNext()) {
                tw = (TriggerWrapper)itr.next();
                str.append(tw.trigger.getName());
                str.append("->");
            }
        }
        return str.toString();
    }

    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws JobPersistenceException {
        HashSet set = new HashSet();
        set.addAll(this.pausedTriggerGroups);
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

