/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.net.InetAddress;
import java.util.Properties;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.MembershipService;
import org.apache.catalina.cluster.mcast.McastMember;
import org.apache.catalina.cluster.mcast.McastServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class McastService
implements MembershipService,
MembershipListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$mcast$McastService == null ? (class$org$apache$catalina$cluster$mcast$McastService = McastService.class$("org.apache.catalina.cluster.mcast.McastService")) : class$org$apache$catalina$cluster$mcast$McastService));
    protected Properties properties = new Properties();
    protected McastServiceImpl impl;
    protected MembershipListener listener;
    protected McastMember localMember;
    private int mcastSoTimeout;
    private int mcastTTL;
    static /* synthetic */ Class class$org$apache$catalina$cluster$mcast$McastService;

    public void setProperties(Properties properties) {
        this.hasProperty(properties, "mcastPort");
        this.hasProperty(properties, "mcastAddress");
        this.hasProperty(properties, "memberDropTime");
        this.hasProperty(properties, "msgFrequency");
        this.hasProperty(properties, "tcpListenPort");
        this.hasProperty(properties, "tcpListenHost");
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Member getLocalMember() {
        this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.impl.getServiceStartTime());
        return this.localMember;
    }

    public void setLocalMemberProperties(String listenHost, int listenPort) {
        this.properties.setProperty("tcpListenHost", listenHost);
        this.properties.setProperty("tcpListenPort", String.valueOf(listenPort));
    }

    public void setMcastAddr(String addr) {
        this.properties.setProperty("mcastAddress", addr);
    }

    public void setMcastBindAddress(String bindaddr) {
        this.properties.setProperty("mcastBindAddress", bindaddr);
    }

    public void setMcastPort(int port) {
        this.properties.setProperty("mcastPort", String.valueOf(port));
    }

    public void setMcastFrequency(long time) {
        this.properties.setProperty("msgFrequency", String.valueOf(time));
    }

    public void setMcastDropTime(long time) {
        this.properties.setProperty("memberDropTime", String.valueOf(time));
    }

    protected void hasProperty(Properties properties, String name) {
        if (properties.getProperty(name) == null) {
            throw new IllegalArgumentException("Required property \"" + name + "\" is missing.");
        }
    }

    public void start() throws Exception {
        this.start(1);
        this.start(2);
    }

    public void start(int level) throws Exception {
        if (this.impl != null) {
            this.impl.start(level);
            return;
        }
        String host = this.getProperties().getProperty("tcpListenHost");
        int port = Integer.parseInt(this.getProperties().getProperty("tcpListenPort"));
        String name = "tcp://" + host + ":" + port;
        if (this.localMember == null) {
            this.localMember = new McastMember(name, host, port, 100L);
        } else {
            this.localMember.setName(name);
            this.localMember.setHost(host);
            this.localMember.setPort(port);
            this.localMember.setMemberAliveTime(100L);
        }
        InetAddress bind = null;
        if (this.properties.getProperty("mcastBindAddress") != null) {
            bind = InetAddress.getByName(this.properties.getProperty("mcastBindAddress"));
        }
        int ttl = -1;
        int soTimeout = -1;
        if (this.properties.getProperty("mcastTTL") != null) {
            try {
                ttl = Integer.parseInt(this.properties.getProperty("mcastTTL"));
            }
            catch (Exception x) {
                log.error((Object)("Unable to parse mcastTTL=" + this.properties.getProperty("mcastTTL")), (Throwable)x);
            }
        }
        if (this.properties.getProperty("mcastSoTimeout") != null) {
            try {
                soTimeout = Integer.parseInt(this.properties.getProperty("mcastSoTimeout"));
            }
            catch (Exception x) {
                log.error((Object)("Unable to parse mcastSoTimeout=" + this.properties.getProperty("mcastSoTimeout")), (Throwable)x);
            }
        }
        this.impl = new McastServiceImpl(this.localMember, Long.parseLong(this.properties.getProperty("msgFrequency")), Long.parseLong(this.properties.getProperty("memberDropTime")), Integer.parseInt(this.properties.getProperty("mcastPort")), bind, InetAddress.getByName(this.properties.getProperty("mcastAddress")), ttl, soTimeout, this);
        this.impl.start(level);
        log.info((Object)("Sleeping for " + Long.parseLong(this.properties.getProperty("msgFrequency")) * 4L + " secs to establish cluster membership"));
        Thread.currentThread();
        Thread.sleep(Long.parseLong(this.properties.getProperty("msgFrequency")) * 4L);
    }

    public void stop() {
        try {
            if (this.impl != null) {
                this.impl.stop();
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop the mcast service.", (Throwable)x);
        }
        this.impl = null;
    }

    public Member[] getMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return null;
        }
        return this.impl.membership.getMembers();
    }

    public void addMembershipListener(MembershipListener listener) {
        this.listener = listener;
    }

    public void removeMembershipListener() {
        this.listener = null;
    }

    public void memberAdded(Member member) {
        if (this.listener != null) {
            this.listener.memberAdded(member);
        }
    }

    public void memberDisappeared(Member member) {
        if (this.listener != null) {
            this.listener.memberDisappeared(member);
        }
    }

    public static void main(String[] args) throws Exception {
        log.info((Object)"Usage McastService hostname tcpport");
        McastService service = new McastService();
        Properties p = new Properties();
        p.setProperty("mcastPort", "5555");
        p.setProperty("mcastAddress", "224.10.10.10");
        p.setProperty("bindAddress", "localhost");
        p.setProperty("memberDropTime", "3000");
        p.setProperty("msgFrequency", "500");
        p.setProperty("tcpListenPort", args[1]);
        p.setProperty("tcpListenHost", args[0]);
        service.setProperties(p);
        service.start();
        Thread.currentThread();
        Thread.sleep(3600000L);
    }

    public int getMcastSoTimeout() {
        return this.mcastSoTimeout;
    }

    public void setMcastSoTimeout(int mcastSoTimeout) {
        this.mcastSoTimeout = mcastSoTimeout;
        this.properties.setProperty("mcastSoTimeout", String.valueOf(mcastSoTimeout));
    }

    public int getMcastTTL() {
        return this.mcastTTL;
    }

    public void setMcastTTL(int mcastTTL) {
        this.mcastTTL = mcastTTL;
        this.properties.setProperty("mcastTTL", String.valueOf(mcastTTL));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

