/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.intercept.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.AuthenticationTrustResolver;
import net.sf.acegisecurity.AuthenticationTrustResolverImpl;
import net.sf.acegisecurity.InsufficientAuthenticationException;
import net.sf.acegisecurity.context.security.SecureContextUtils;
import net.sf.acegisecurity.intercept.web.AuthenticationEntryPoint;
import net.sf.acegisecurity.intercept.web.FilterInvocation;
import net.sf.acegisecurity.intercept.web.FilterSecurityInterceptor;
import net.sf.acegisecurity.util.PortResolver;
import net.sf.acegisecurity.util.PortResolverImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SecurityEnforcementFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter == null ? (class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter = SecurityEnforcementFilter.class$("net.sf.acegisecurity.intercept.web.SecurityEnforcementFilter")) : class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter));
    public static final String ACEGI_SECURITY_ACCESS_DENIED_EXCEPTION_KEY = "ACEGI_SECURITY_403_EXCEPTION";
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private FilterSecurityInterceptor filterSecurityInterceptor;
    private PortResolver portResolver = new PortResolverImpl();
    static /* synthetic */ Class class$net$sf$acegisecurity$intercept$web$SecurityEnforcementFilter;

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    public AuthenticationTrustResolver getAuthenticationTrustResolver() {
        return this.authenticationTrustResolver;
    }

    public void setFilterSecurityInterceptor(FilterSecurityInterceptor filterSecurityInterceptor) {
        this.filterSecurityInterceptor = filterSecurityInterceptor;
    }

    public FilterSecurityInterceptor getFilterSecurityInterceptor() {
        return this.filterSecurityInterceptor;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"authenticationEntryPoint must be specified");
        Assert.notNull((Object)this.filterSecurityInterceptor, (String)"filterSecurityInterceptor must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
        Assert.notNull((Object)this.authenticationTrustResolver, (String)"authenticationTrustResolver must be specified");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("HttpServletRequest required");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpServletResponse required");
        }
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        try {
            this.filterSecurityInterceptor.invoke(fi);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Chain processed normally");
            }
        }
        catch (AuthenticationException authentication) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication exception occurred; redirecting to authentication entry point", (Throwable)((Object)authentication));
            }
            this.sendStartAuthentication(fi, authentication);
        }
        catch (AccessDeniedException accessDenied) {
            if (this.authenticationTrustResolver.isAnonymous(SecureContextUtils.getSecureContext().getAuthentication())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Access is denied (user is anonymous); redirecting to authentication entry point", (Throwable)((Object)accessDenied));
                }
                this.sendStartAuthentication(fi, new InsufficientAuthenticationException("Full authentication is required to access this resource"));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Access is denied (user is not anonymous); sending back forbidden response", (Throwable)((Object)accessDenied));
                }
                this.sendAccessDeniedError(fi, accessDenied);
            }
        }
        catch (Throwable otherException) {
            throw new ServletException(otherException);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    protected void sendAccessDeniedError(FilterInvocation fi, AccessDeniedException accessDenied) throws ServletException, IOException {
        ((HttpServletRequest)fi.getRequest()).getSession().setAttribute(ACEGI_SECURITY_ACCESS_DENIED_EXCEPTION_KEY, (Object)accessDenied);
        ((HttpServletResponse)fi.getResponse()).sendError(403, accessDenied.getMessage());
    }

    protected void sendStartAuthentication(FilterInvocation fi, AuthenticationException reason) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)fi.getRequest();
        int port = this.portResolver.getServerPort((ServletRequest)request);
        boolean includePort = true;
        if ("http".equals(request.getScheme().toLowerCase()) && port == 80) {
            includePort = false;
        }
        if ("https".equals(request.getScheme().toLowerCase()) && port == 443) {
            includePort = false;
        }
        String targetUrl = request.getScheme() + "://" + request.getServerName() + (includePort ? ":" + port : "") + request.getContextPath() + fi.getRequestUrl();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication entry point being called; target URL added to Session: " + targetUrl));
        }
        request.getSession().setAttribute("ACEGI_SECURITY_TARGET_URL", (Object)targetUrl);
        this.authenticationEntryPoint.commence((ServletRequest)request, (ServletResponse)((HttpServletResponse)fi.getResponse()), reason);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

