/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.rememberme;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextUtils;
import net.sf.acegisecurity.ui.rememberme.NullRememberMeServices;
import net.sf.acegisecurity.ui.rememberme.RememberMeServices;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RememberMeProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$ui$rememberme$RememberMeProcessingFilter == null ? (class$net$sf$acegisecurity$ui$rememberme$RememberMeProcessingFilter = RememberMeProcessingFilter.class$("net.sf.acegisecurity.ui.rememberme.RememberMeProcessingFilter")) : class$net$sf$acegisecurity$ui$rememberme$RememberMeProcessingFilter));
    private RememberMeServices rememberMeServices = new NullRememberMeServices();
    static /* synthetic */ Class class$net$sf$acegisecurity$ui$rememberme$RememberMeProcessingFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.rememberMeServices);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        SecureContext sc = SecureContextUtils.getSecureContext();
        if (sc.getAuthentication() == null) {
            sc.setAuthentication(this.rememberMeServices.autoLogin(httpRequest, httpResponse));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Replaced ContextHolder with remember-me token: '" + sc.getAuthentication() + "'"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("ContextHolder not replaced with remember-me token, as ContextHolder already contained: '" + sc.getAuthentication() + "'"));
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

