/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.CollectionUtils;
import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EchoProperties
extends Task {
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private File inFile = null;
    private File destfile = null;
    private boolean failonerror = true;
    private Vector propertySets = new Vector();
    private String format = "text";

    public void setSrcfile(File file) {
        this.inFile = file;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setPrefix(String prefix) {
        PropertySet ps = new PropertySet();
        ps.setProject(this.getProject());
        ps.appendPrefix(prefix);
        this.addPropertyset(ps);
    }

    public void addPropertyset(PropertySet ps) {
        this.propertySets.addElement(ps);
    }

    public void setFormat(FormatAttribute ea) {
        this.format = ea.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        block36: {
            block38: {
                block37: {
                    block40: {
                        block39: {
                            allProps = new Hashtable<K, V>();
                            if (this.inFile != null || this.propertySets.size() != 0) break block39;
                            CollectionUtils.putAll(allProps, (Dictionary)this.getProject().getProperties());
                            break block40;
                        }
                        if (this.inFile != null) {
                            if (this.inFile.exists() && this.inFile.isDirectory()) {
                                message = "srcfile is a directory!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                return;
                            }
                            if (this.inFile.exists() && !this.inFile.canRead()) {
                                message = "Can not read from the specified srcfile!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                return;
                            }
                            in = null;
                            try {
                                try {
                                    in = new FileInputStream(this.inFile);
                                    props = new Properties();
                                    props.load(in);
                                    CollectionUtils.putAll(allProps, (Dictionary)props);
                                }
                                catch (FileNotFoundException fnfe) {
                                    message = "Could not find file " + this.inFile.getAbsolutePath();
                                    if (this.failonerror) {
                                        throw new BuildException(message, (Throwable)fnfe, this.getLocation());
                                    }
                                    this.log(message, 1);
                                    var6_9 = null;
                                    try {
                                        if (null == in) return;
                                        in.close();
                                        return;
                                    }
                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                catch (IOException ioe) {
                                    message = "Could not read file " + this.inFile.getAbsolutePath();
                                    if (this.failonerror) {
                                        throw new BuildException(message, (Throwable)ioe, this.getLocation());
                                    }
                                    this.log(message, 1);
                                    var6_10 = null;
                                    ** try [egrp 2[TRYBLOCK] [6 : 316->328)] { 
lbl49:
                                    // 1 sources

                                    if (null == in) return;
                                    in.close();
                                    return;
lbl52:
                                    // 1 sources

                                    catch (IOException ioe) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                var6_8 = null;
                                {
                                }
                            }
                            catch (Throwable var5_21) {
                                var6_11 = null;
                                ** try [egrp 2[TRYBLOCK] [6 : 316->328)] { 
lbl61:
                                // 1 sources

                                if (null == in) throw var5_21;
                                in.close();
                                throw var5_21;
lbl64:
                                // 1 sources

                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                throw var5_21;
                            }
                            try {}
                            catch (IOException ioe) {}
                            if (null != in) {
                                in.close();
                            }
                        }
                    }
                    e = this.propertySets.elements();
                    while (e.hasMoreElements()) {
                        ps = (PropertySet)e.nextElement();
                        CollectionUtils.putAll(allProps, (Dictionary)ps.getProperties());
                    }
                    os = null;
                    try {
                        try {
                            if (this.destfile == null) {
                                os = new ByteArrayOutputStream();
                                this.saveProperties(allProps, os);
                                this.log(os.toString(), 2);
                                break block36;
                            }
                            if (this.destfile.exists() && this.destfile.isDirectory()) {
                                message = "destfile is a directory!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                var9_22 = null;
                                if (os == null) return;
                                break block37;
                            }
                            if (this.destfile.exists() && !this.destfile.canWrite()) {
                                message = "Can not write to the specified destfile!";
                                if (this.failonerror) {
                                    throw new BuildException(message, this.getLocation());
                                }
                                this.log(message, 0);
                                break block38;
                            }
                            os = new FileOutputStream(this.destfile);
                            this.saveProperties(allProps, os);
                            break block36;
                        }
                        catch (IOException ioe) {
                            if (this.failonerror) {
                                throw new BuildException((Throwable)ioe, this.getLocation());
                            }
                            this.log(ioe.getMessage(), 2);
                            var9_25 = null;
                            if (os == null) return;
                            try {
                                os.close();
                                return;
                            }
                            catch (IOException ex) {
                                return;
                            }
                        }
                    }
                    catch (Throwable var8_32) {
                        var9_26 = null;
                        if (os == null) throw var8_32;
                        ** try [egrp 5[TRYBLOCK] [15 : 594->601)] { 
lbl123:
                        // 1 sources

                        os.close();
                        throw var8_32;
lbl125:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                        throw var8_32;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [15 : 594->601)] { 
lbl130:
                // 1 sources

                os.close();
                return;
lbl132:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
                return;
            }
            var9_23 = null;
            if (os == null) return;
            ** try [egrp 5[TRYBLOCK] [15 : 594->601)] { 
lbl139:
            // 1 sources

            os.close();
            return;
lbl141:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return;
        }
        var9_24 = null;
        if (os == null) return;
        try {}
        catch (IOException ex) {}
        os.close();
        return;
    }

    protected void saveProperties(Hashtable allProps, OutputStream os) throws IOException, BuildException {
        Properties props = new Properties();
        Enumeration e = allProps.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            String value = allProps.get(name).toString();
            ((Hashtable)props).put(name, value);
        }
        if ("text".equals(this.format)) {
            this.jdkSaveProperties(props, os, "Ant properties");
        } else if ("xml".equals(this.format)) {
            this.xmlSaveProperties(props, os);
        }
    }

    protected void xmlSaveProperties(Properties props, OutputStream os) throws IOException {
        Document doc = EchoProperties.getDocumentBuilder().newDocument();
        Element rootElement = doc.createElement(PROPERTIES);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Element propElement = doc.createElement(PROPERTY);
            propElement.setAttribute(ATTR_NAME, name);
            propElement.setAttribute(ATTR_VALUE, props.getProperty(name));
            rootElement.appendChild(propElement);
        }
        OutputStreamWriter wri = null;
        try {
            wri = new OutputStreamWriter(os, "UTF8");
            wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            new DOMElementWriter().write(rootElement, (Writer)wri, 0, "\t");
            ((Writer)wri).flush();
        }
        catch (IOException ioe) {
            throw new BuildException("Unable to write XML file", (Throwable)ioe);
        }
        finally {
            if (wri != null) {
                ((Writer)wri).close();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void jdkSaveProperties(Properties props, OutputStream os, String header) throws IOException {
        props.store(os, header);
        Object var6_4 = null;
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException ioex) {
            this.log("Failed to close output stream");
        }
        return;
        {
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException ioex) {
                this.log("Failed to close output stream");
            }
            throw throwable;
        }
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class FormatAttribute
    extends EnumeratedAttribute {
        private String[] formats = new String[]{"xml", "text"};

        public String[] getValues() {
            return this.formats;
        }
    }
}

