/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class Rpm
extends Task {
    private String specFile;
    private File topDir;
    private String command = "-bb";
    private String rpmBuildCommand = null;
    private boolean cleanBuildDir = false;
    private boolean removeSpec = false;
    private boolean removeSource = false;
    private File output;
    private File error;

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        block29: {
            IOException e42;
            Object errorstream;
            Object outputstream;
            block28: {
                Commandline toExecute = new Commandline();
                toExecute.setExecutable(this.rpmBuildCommand == null ? this.guessRpmBuildCommand() : this.rpmBuildCommand);
                if (this.topDir != null) {
                    toExecute.createArgument().setValue("--define");
                    toExecute.createArgument().setValue("_topdir" + this.topDir);
                }
                toExecute.createArgument().setLine(this.command);
                if (this.cleanBuildDir) {
                    toExecute.createArgument().setValue("--clean");
                }
                if (this.removeSpec) {
                    toExecute.createArgument().setValue("--rmspec");
                }
                if (this.removeSource) {
                    toExecute.createArgument().setValue("--rmsource");
                }
                toExecute.createArgument().setValue("SPECS/" + this.specFile);
                LogStreamHandler streamhandler = null;
                outputstream = null;
                errorstream = null;
                if (this.error == null && this.output == null) {
                    streamhandler = new LogStreamHandler((Task)this, 2, 1);
                } else {
                    BufferedOutputStream bos;
                    if (this.output != null) {
                        try {
                            bos = new BufferedOutputStream(new FileOutputStream(this.output));
                            outputstream = new PrintStream(bos);
                        }
                        catch (IOException e2) {
                            throw new BuildException((Throwable)e2, this.getLocation());
                        }
                    } else {
                        outputstream = new LogOutputStream((Task)this, 2);
                    }
                    if (this.error != null) {
                        try {
                            bos = new BufferedOutputStream(new FileOutputStream(this.error));
                            errorstream = new PrintStream(bos);
                        }
                        catch (IOException e3) {
                            throw new BuildException((Throwable)e3, this.getLocation());
                        }
                    } else {
                        errorstream = new LogOutputStream((Task)this, 1);
                    }
                    streamhandler = new PumpStreamHandler((OutputStream)outputstream, (OutputStream)errorstream);
                }
                Execute exe = new Execute((ExecuteStreamHandler)streamhandler, null);
                exe.setAntRun(this.getProject());
                if (this.topDir == null) {
                    this.topDir = this.getProject().getBaseDir();
                }
                exe.setWorkingDirectory(this.topDir);
                exe.setCommandline(toExecute.getCommandline());
                exe.execute();
                this.log("Building the RPM based on the " + this.specFile + " file");
                Object var8_8 = null;
                if (this.output == null) break block28;
                try {
                    ((OutputStream)outputstream).close();
                }
                catch (IOException e42) {
                    // empty catch block
                }
            }
            if (this.error != null) {
                try {
                    ((OutputStream)errorstream).close();
                }
                catch (IOException e42) {}
            }
            break block29;
            {
                catch (IOException e5) {
                    throw new BuildException((Throwable)e5, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                IOException e42;
                Object var8_9 = null;
                if (this.output != null) {
                    try {
                        ((OutputStream)outputstream).close();
                    }
                    catch (IOException e42) {
                        // empty catch block
                    }
                }
                if (this.error != null) {
                    try {
                        ((OutputStream)errorstream).close();
                    }
                    catch (IOException e42) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void setTopDir(File td) {
        this.topDir = td;
    }

    public void setCommand(String c) {
        this.command = c;
    }

    public void setSpecFile(String sf) {
        if (sf == null || sf.trim().equals("")) {
            throw new BuildException("You must specify a spec file", this.getLocation());
        }
        this.specFile = sf;
    }

    public void setCleanBuildDir(boolean cbd) {
        this.cleanBuildDir = cbd;
    }

    public void setRemoveSpec(boolean rs) {
        this.removeSpec = rs;
    }

    public void setRemoveSource(boolean rs) {
        this.removeSource = rs;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setError(File error) {
        this.error = error;
    }

    public void setRpmBuildCommand(String c) {
        this.rpmBuildCommand = c;
    }

    protected String guessRpmBuildCommand() {
        Vector env = Execute.getProcEnvironment();
        String path = null;
        Enumeration e = env.elements();
        while (e.hasMoreElements()) {
            String var = (String)e.nextElement();
            if (!var.startsWith("PATH=") && !var.startsWith("Path=")) continue;
            path = var.substring(6);
            break;
        }
        if (path != null) {
            Path p = new Path(this.getProject(), path);
            String[] pElements = p.list();
            for (int i = 0; i < pElements.length; ++i) {
                File f = new File(pElements[i], "rpmbuild" + (Os.isFamily((String)"dos") ? ".exe" : ""));
                if (!f.canRead()) continue;
                return f.getAbsolutePath();
            }
        }
        return "rpm";
    }
}

