/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import org.springframework.jms.support.destination.DestinationResolver;

public class DynamicDestinationResolver
implements DestinationResolver {
    public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        if (pubSubDomain) {
            if (session instanceof TopicSession) {
                return ((TopicSession)session).createTopic(destinationName);
            }
            return session.createTopic(destinationName);
        }
        if (session instanceof QueueSession) {
            return ((QueueSession)session).createQueue(destinationName);
        }
        return session.createQueue(destinationName);
    }
}

