/*
 * Decompiled with CFR 0.152.
 */
package com.borland.starteam.xml;

import com.borland.starteam.xml.Builder;
import com.borland.starteam.xml.Writer;
import com.borland.starteam.xml.XMLElement;
import com.borland.starteam.xml.XMLException;
import com.starbase.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class XMLDocument {
    private XMLElement m_root = null;
    private Object m_impl = null;

    public static XMLDocument build(File file) throws FileNotFoundException, IOException, XMLException {
        XMLDocument xMLDocument = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        xMLDocument = Builder.build(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        return xMLDocument;
    }

    public static XMLDocument build(byte[] byArray) throws IOException, XMLException {
        XMLDocument xMLDocument = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        xMLDocument = Builder.build(byteArrayInputStream);
        ((InputStream)byteArrayInputStream).close();
        return xMLDocument;
    }

    public static XMLDocument build(InputStream inputStream) throws IOException, XMLException {
        return Builder.build(inputStream);
    }

    public void write(File file) throws FileNotFoundException, IOException, XMLException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Writer.write(this, bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
    }

    public void write(OutputStream outputStream) throws IOException, XMLException {
        Writer.write(this, outputStream);
    }

    public XMLElement getRootElement() {
        return this.m_root;
    }

    Object getImplementation() {
        return this.m_impl;
    }

    XMLDocument(Object object, XMLElement xMLElement) {
        if (xMLElement == null) {
            Assert.nullArgument("Element");
        }
        this.m_root = xMLElement;
        this.m_impl = object;
    }
}

