/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.ColumnMask;

public class BasicColumnMask
implements ColumnMask {
    private int m_first = 0;
    private int m_last = 0;
    private boolean m_numeric = false;

    public int skipBy(int n, CharSequence charSequence) {
        if (n >= this.m_first && n <= this.m_last) {
            if (this.m_numeric) {
                int n2 = this.m_first - 1;
                if (n2 < 0 || n2 >= charSequence.length()) {
                    return 0;
                }
                if (!Character.isDigit(charSequence.charAt(n2))) {
                    return 0;
                }
            }
            return this.m_last - n + 1;
        }
        return 0;
    }

    public String debugDump() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(": first=" + this.m_first);
        stringBuffer.append("; last=" + this.m_last);
        stringBuffer.append("; numeric=" + this.m_numeric);
        return stringBuffer.toString();
    }

    public BasicColumnMask(int n, int n2, boolean bl) {
        this.m_first = n;
        this.m_last = n2;
        this.m_numeric = bl;
    }
}

