/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.ColumnMask;

public class LineIterator {
    private static final int WHITE_SPACE = 255;
    private static final int TRAILING_WS = 48;
    private static final int LEADING_WS = 3;
    private static final int INTERIOR_WS = 12;
    private int m_current = -1;
    private CharSequence m_sequence;
    private char m_nextChar = '\u0000';
    private int m_nextCharPos = -1;
    private int m_firstInterior = 0;
    private int m_lastInterior = 0;
    private int m_lastSkip = 0;
    private int m_flags;
    private ColumnMask[] m_mask = null;
    private boolean m_ignore_any_white = false;
    private boolean m_bCompareEOLs = false;

    private boolean isEOL(char c) {
        return c == '\r' || c == '\n';
    }

    private void findEnds() {
        this.m_firstInterior = -1;
        this.m_lastInterior = -1;
        if (this.m_ignore_any_white) {
            int n = this.m_sequence.length();
            int n2 = 0;
            while (n2 < n) {
                char c = this.m_sequence.charAt(n2);
                if (Character.isWhitespace(c)) {
                    if (this.m_bCompareEOLs && this.isEOL(c)) {
                        this.m_lastInterior = n2;
                    }
                } else {
                    if (this.m_firstInterior == -1) {
                        this.m_firstInterior = n2;
                    }
                    this.m_lastInterior = n2;
                }
                ++n2;
            }
        }
    }

    public boolean hasNext() {
        return this.m_current < this.m_sequence.length();
    }

    public char nextChar() {
        char c = this.m_nextChar;
        this.advance();
        return c;
    }

    public int index() {
        return this.m_nextCharPos;
    }

    private void setNextChar(char c, int n) {
        this.m_nextCharPos = n;
        this.m_nextChar = (this.m_flags & 0x100) != 0 ? Character.toLowerCase(c) : c;
    }

    private void inc() {
        ++this.m_current;
        int n = this.skipMaskedAmount();
        this.m_current += n;
        this.m_lastSkip = n + 1;
    }

    private void backup() {
        this.m_current -= this.m_lastSkip;
    }

    private int currentColumn() {
        return this.m_current + 1;
    }

    private int skipMaskedAmount() {
        int n = this.currentColumn();
        int n2 = 0;
        if (this.m_mask != null) {
            int n3 = 0;
            while (n3 < this.m_mask.length) {
                int n4 = this.m_mask[n3].skipBy(n, this.m_sequence);
                if (n4 > n2) {
                    n2 = n4;
                }
                ++n3;
            }
        }
        return n2;
    }

    private void advance() {
        this.inc();
        if (!this.hasNext()) {
            return;
        }
        this.setNextChar(this.m_sequence.charAt(this.m_current), this.m_current);
        if (this.m_ignore_any_white && Character.isWhitespace(this.m_nextChar) && this.skipHere()) {
            boolean bl = this.equivHere();
            while (Character.isWhitespace(this.m_nextChar) && this.hasNext()) {
                this.inc();
                if (!this.hasNext()) continue;
                this.setNextChar(this.m_sequence.charAt(this.m_current), this.m_current);
            }
            if (bl) {
                this.setNextChar(' ', this.m_current);
                this.backup();
            }
        }
    }

    private boolean equivHere() {
        if (this.m_lastInterior <= this.m_current) {
            return (this.m_flags & 0x20) != 0;
        }
        if (this.m_firstInterior <= this.m_current) {
            return (this.m_flags & 8) != 0;
        }
        return (this.m_flags & 2) != 0;
    }

    private boolean skipHere() {
        if (this.m_lastInterior <= this.m_current) {
            return (this.m_flags & 0x30) != 0;
        }
        if (this.m_firstInterior <= this.m_current) {
            return (this.m_flags & 0xC) != 0;
        }
        return (this.m_flags & 3) != 0;
    }

    public LineIterator(CharSequence charSequence, int n, ColumnMask[] columnMaskArray) {
        this.m_flags = n;
        this.m_sequence = charSequence;
        this.m_ignore_any_white = (0xFF & this.m_flags) != 0;
        this.m_bCompareEOLs = (0x80 & this.m_flags) != 0;
        this.m_mask = columnMaskArray;
        this.findEnds();
        this.advance();
    }
}

