/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.diff;

import com.starbase.diff.CharSequence;
import com.starbase.diff.DiffCompare;
import com.starbase.diff.DiffException;
import com.starbase.diff.Differ;
import com.starbase.diff.Edit;
import com.starbase.diff.EditList;
import com.starbase.diff.ParsedCharSequence;
import com.starbase.diff.Sequence;
import com.starbase.diff.StarTeamDiff;
import com.starbase.util.Assert;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class StarTeamMerge {
    private static final String PREFIX_OUT = "<<<<<<<";
    private static final String PREFIX_DIV = "=======";
    private static final String PREFIX_IN = ">>>>>>>";
    private static final String PREFIX_FLAG = "|||||||";
    private static final String ENCODING = "8859_1";
    static final int MINE = 0;
    static final int COMMON = 1;
    static final int YOURS = 2;
    static final int START = 0;
    static final int END = 1;

    static MergeEdit merge(Sequence sequence, Sequence sequence2, Sequence sequence3, DiffCompare diffCompare) throws DiffException {
        StarTeamDiff starTeamDiff = new StarTeamDiff();
        DiffEdit diffEdit = StarTeamMerge.getDiff(sequence2, sequence3, starTeamDiff, diffCompare);
        DiffEdit diffEdit2 = StarTeamMerge.getDiff(sequence, sequence3, starTeamDiff, diffCompare);
        DiffEdit[] diffEditArray = new DiffEdit[2];
        DiffEdit[] diffEditArray2 = new DiffEdit[2];
        DiffEdit[] diffEditArray3 = new DiffEdit[2];
        DiffEdit diffEdit3 = null;
        DiffEdit diffEdit4 = null;
        MergeEdit mergeEdit = null;
        MergeEdit mergeEdit2 = null;
        MergeEdit mergeEdit3 = null;
        mergeEdit = null;
        diffEditArray3[0] = diffEdit2;
        diffEditArray3[1] = diffEdit;
        while (diffEditArray3[0] != null || diffEditArray3[1] != null) {
            diffEditArray[0] = null;
            diffEditArray[1] = null;
            diffEditArray2[0] = null;
            diffEditArray2[1] = null;
            int n = diffEditArray3[0] == null ? 1 : (diffEditArray3[1] == null ? 0 : (diffEditArray3[0].targetStart > diffEditArray3[1].targetStart ? 1 : 0));
            int n2 = n;
            diffEdit3 = diffEditArray3[n2];
            int n3 = diffEdit3.targetEnd;
            diffEditArray[n2] = diffEditArray2[n2] = diffEdit3;
            diffEditArray3[n2] = diffEdit3.next;
            diffEditArray2[n2].next = null;
            int n4 = n2 ^ 1;
            diffEdit4 = diffEditArray3[n4];
            while (diffEdit4 != null && diffEdit4.targetStart <= n3 + 1) {
                if (diffEditArray[n4] != null) {
                    diffEditArray2[n4].next = diffEdit4;
                } else {
                    diffEditArray[n4] = diffEdit4;
                }
                diffEditArray2[n4] = diffEdit4;
                diffEditArray3[n4] = diffEditArray3[n4].next;
                diffEdit4.next = null;
                if (n3 < diffEdit4.targetEnd) {
                    n2 ^= 1;
                    diffEdit3 = diffEdit4;
                    n3 = diffEdit4.targetEnd;
                }
                n4 = n2 ^ 1;
                diffEdit4 = diffEditArray3[n4];
            }
            mergeEdit2 = StarTeamMerge.convertToMergeEdit(diffCompare, diffEditArray, diffEditArray2, n, n2, mergeEdit3);
            if (mergeEdit == null) {
                mergeEdit = mergeEdit2;
            }
            if (mergeEdit3 != null) {
                mergeEdit3.next = mergeEdit2;
            }
            mergeEdit3 = mergeEdit2;
        }
        return mergeEdit;
    }

    private static MergeEdit convertToMergeEdit(DiffCompare diffCompare, DiffEdit[] diffEditArray, DiffEdit[] diffEditArray2, int n, int n2, MergeEdit mergeEdit) {
        int n3;
        int n4;
        DiffEdit diffEdit;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n5 = diffEditArray[n].targetStart;
        int n6 = diffEditArray2[n2].targetEnd;
        int n7 = 0;
        while (n7 < 2) {
            if (diffEditArray[n7] != null) {
                nArray[n7] = n5 - diffEditArray[n7].targetStart + diffEditArray[n7].sourceStart;
                nArray2[n7] = n6 - diffEditArray2[n7].targetEnd + diffEditArray2[n7].sourceEnd;
            } else if (mergeEdit == null) {
                nArray[n7] = n5;
                nArray2[n7] = n6;
            } else {
                nArray[n7] = mergeEdit.highMapLine(2, n7, n5);
                nArray2[n7] = mergeEdit.highMapLine(2, n7, n6);
            }
            ++n7;
        }
        MergeEdit mergeEdit2 = new MergeEdit(nArray[0], nArray2[0], nArray[1], nArray2[1], n5, n6);
        n7 = 0;
        while (n7 < 2) {
            diffEdit = diffEditArray[n7];
            while (diffEdit != null) {
                n4 = diffEdit.targetStart - n5;
                StarTeamMerge.copyLines(diffEdit.targetLines, mergeEdit2.lines[2], n4, diffEdit.numTargetLines());
                diffEdit = diffEdit.next;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < 2) {
            DiffEdit diffEdit2 = diffEditArray[n7];
            n3 = nArray[n7];
            int n8 = nArray2[n7];
            int n9 = 0;
            while (n9 + n3 < (diffEdit2 != null ? diffEdit2.sourceStart : n8 + 1)) {
                mergeEdit2.lines[n7][n9] = mergeEdit2.lines[2][n9];
                ++n9;
            }
            diffEdit = diffEdit2;
            while (diffEdit != null) {
                int n10 = diffEdit.sourceStart - n3;
                StarTeamMerge.copyLines(diffEdit.sourceLines, mergeEdit2.lines[n7], n10, diffEdit.numSourceLines());
                int n11 = diffEdit.targetEnd + 1 - n5;
                n9 = diffEdit.sourceEnd + 1 - n3;
                while (n9 < (diffEdit.next != null ? diffEdit.next.sourceStart : n8 + 1) - n3) {
                    mergeEdit2.lines[n7][n9] = mergeEdit2.lines[2][n11];
                    ++n11;
                    ++n9;
                }
                diffEdit = diffEdit.next;
            }
            ++n7;
        }
        mergeEdit2.correspond = diffEditArray[0] == null ? 6 : (diffEditArray[1] == null ? 5 : ((n4 = mergeEdit2.numLines(0)) != (n3 = mergeEdit2.numLines(1)) || !StarTeamMerge.sameLines(diffCompare, mergeEdit2.lines[0], mergeEdit2.lines[1]) ? 4 : 7));
        return mergeEdit2;
    }

    private static boolean sameLines(DiffCompare diffCompare, Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!diffCompare.equalObjects(objectArray[n], objectArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static void copyLines(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n + n3;
            if (objectArray2[n4] != null) {
                if (objectArray2[n4] != objectArray[n3]) {
                    String string = "StarTeamMerge.copyLines()";
                    Assert.internalError(string);
                }
            } else {
                objectArray2[n4] = objectArray[n3];
            }
            ++n3;
        }
    }

    private static DiffEdit getDiff(Sequence sequence, Sequence sequence2, Differ differ, DiffCompare diffCompare) throws DiffException {
        EditList editList = differ.diff(sequence, sequence2, diffCompare);
        DiffEdit diffEdit = null;
        DiffEdit diffEdit2 = null;
        Edit[] editArray = editList.getChanges();
        int n = 0;
        while (n < editArray.length) {
            DiffEdit diffEdit3 = new DiffEdit();
            Edit edit = editArray[n];
            diffEdit3.sourceStart = edit.startSource();
            diffEdit3.sourceEnd = edit.endSource();
            diffEdit3.targetStart = edit.startTarget();
            diffEdit3.targetEnd = edit.endTarget();
            if (edit.getAction() == 1) {
                ++diffEdit3.sourceStart;
            } else if (edit.getAction() == 2) {
                ++diffEdit3.targetStart;
            }
            int n2 = diffEdit3.numSourceLines();
            diffEdit3.sourceLines = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                diffEdit3.sourceLines[n3] = sequence.get(diffEdit3.sourceStart + n3 - 1);
                ++n3;
            }
            n2 = diffEdit3.numTargetLines();
            diffEdit3.targetLines = new Object[n2];
            n3 = 0;
            while (n3 < n2) {
                diffEdit3.targetLines[n3] = sequence2.get(diffEdit3.targetStart + n3 - 1);
                ++n3;
            }
            if (diffEdit2 == null) {
                diffEdit2 = diffEdit3;
            }
            if (diffEdit != null) {
                diffEdit.next = diffEdit3;
            }
            diffEdit = diffEdit3;
            ++n;
        }
        return diffEdit2;
    }

    static boolean outputMergeEdits(BufferedWriter bufferedWriter, Sequence sequence, Sequence sequence2, Sequence sequence3, DiffCompare diffCompare, MergeEdit mergeEdit, String string, String string2, String string3, boolean bl, boolean bl2, String string4) throws IOException {
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        int n2 = 1;
        MergeEdit mergeEdit2 = mergeEdit;
        while (mergeEdit2 != null) {
            block22: {
                String string5;
                int n3 = mergeEdit2.correspond;
                String string6 = PREFIX_OUT;
                switch (n3) {
                    default: {
                        break block22;
                    }
                    case 6: {
                        if (bl) {
                            bl6 = true;
                            break;
                        }
                        break block22;
                    }
                    case 7: {
                        if (!bl2) {
                            bl6 = false;
                            break;
                        }
                        break block22;
                    }
                    case 4: {
                        if (!bl4) {
                            bl6 = bl3;
                            string6 = PREFIX_FLAG;
                            break;
                        }
                        break block22;
                    }
                }
                int n4 = mergeEdit2.ranges[0][0] - n - 1;
                n += n4;
                int n5 = 0;
                while (--n4 >= 0) {
                    ++n5;
                }
                StarTeamMerge.writeLines(bufferedWriter, sequence, n2, n5, string4);
                n2 += n5;
                if (bl6) {
                    bl5 = true;
                    if (n3 == 4) {
                        bufferedWriter.write("<<<<<<< " + string);
                        bufferedWriter.write(string4);
                        n4 = 0;
                        while (n4 < mergeEdit2.numLines(0)) {
                            if (!diffCompare.equalObjects(mergeEdit2.lines[0][n4], sequence.get(mergeEdit2.ranges[0][0] + n4 - 1))) {
                                string5 = "StarTeamMerge.outputMergeEdits(), MINE";
                                Assert.internalError(string5);
                            }
                            ++n4;
                        }
                        StarTeamMerge.writeLines(bufferedWriter, sequence, mergeEdit2.ranges[0][0], mergeEdit2.numLines(0), string4);
                    }
                    if (bl) {
                        bufferedWriter.write(string6 + " " + string2);
                        bufferedWriter.write(string4);
                        n4 = 0;
                        while (n4 < mergeEdit2.numLines(1)) {
                            if (!diffCompare.equalObjects(mergeEdit2.lines[1][n4], sequence2.get(mergeEdit2.ranges[1][0] + n4 - 1))) {
                                string5 = "StarTeamMerge.outputMergeEdits(), COMMON";
                                Assert.internalError(string5);
                            }
                            ++n4;
                        }
                        StarTeamMerge.writeLines(bufferedWriter, sequence2, mergeEdit2.ranges[1][0], mergeEdit2.numLines(1), string4);
                    }
                    bufferedWriter.write(PREFIX_DIV);
                    bufferedWriter.write(string4);
                }
                n4 = 0;
                while (n4 < mergeEdit2.numLines(2)) {
                    if (!diffCompare.equalObjects(mergeEdit2.lines[2][n4], sequence3.get(mergeEdit2.ranges[2][0] + n4 - 1))) {
                        string5 = "StarTeamMerge.outputMergeEdits(), YOURS";
                        Assert.internalError(string5);
                    }
                    ++n4;
                }
                StarTeamMerge.writeLines(bufferedWriter, sequence3, mergeEdit2.ranges[2][0], mergeEdit2.numLines(2), string4);
                if (bl6) {
                    bufferedWriter.write(">>>>>>> " + string3);
                    bufferedWriter.write(string4);
                }
                n4 = mergeEdit2.numLines(0);
                n += n4;
                while (--n4 >= 0) {
                    ++n2;
                }
            }
            mergeEdit2 = mergeEdit2.next;
        }
        if (n2 <= sequence.size()) {
            StarTeamMerge.writeLines(bufferedWriter, sequence, n2, sequence.size() - n2 + 1, string4);
        }
        return bl5;
    }

    private static void writeLines(BufferedWriter bufferedWriter, Sequence sequence, int n, int n2, String string) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            Object object = sequence.get(n + n3 - 1);
            CharSequence charSequence = (CharSequence)object;
            int n4 = charSequence.length();
            int n5 = 0;
            while (n5 < n4) {
                bufferedWriter.write(charSequence.charAt(n5));
                ++n5;
            }
            bufferedWriter.write(string);
            ++n3;
        }
    }

    public static boolean merge(File file, File file2, File file3, DiffCompare diffCompare, File file4, String string, String string2, String string3, boolean bl, boolean bl2) throws IOException, DiffException {
        return StarTeamMerge.mergeToFile(file, file2, file3, diffCompare, file4, string, string2, string3, bl, bl2, System.getProperty("line.separator"));
    }

    public static boolean mergeToFile(File file, File file2, File file3, DiffCompare diffCompare, File file4, String string, String string2, String string3, boolean bl, boolean bl2, String string4) throws IOException, DiffException {
        String string5 = ENCODING;
        return StarTeamMerge.mergeToFile(file, string5, file2, string5, file3, string5, diffCompare, file4, string5, string, string2, string3, bl, bl2, string4);
    }

    public static boolean mergeToFile(File file, String string, File file2, String string2, File file3, String string3, DiffCompare diffCompare, File file4, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, String string8) throws IOException, DiffException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file4));
        boolean bl3 = StarTeamMerge.merge(file, string, file2, string2, file3, string3, diffCompare, bufferedOutputStream, string4, string5, string6, string7, bl, bl2, string8);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        return bl3;
    }

    public static boolean merge(File file, File file2, File file3, DiffCompare diffCompare, OutputStream outputStream, String string, String string2, String string3, boolean bl, boolean bl2) throws IOException, DiffException {
        return StarTeamMerge.merge(file, file2, file3, diffCompare, outputStream, string, string2, string3, bl, bl2, System.getProperty("line.separator"));
    }

    public static boolean merge(File file, File file2, File file3, DiffCompare diffCompare, OutputStream outputStream, String string, String string2, String string3, boolean bl, boolean bl2, String string4) throws IOException, DiffException {
        String string5 = ENCODING;
        return StarTeamMerge.merge(file, string5, file2, string5, file3, string5, diffCompare, outputStream, string5, string, string2, string3, bl, bl2, string4);
    }

    public static boolean merge(File file, String string, File file2, String string2, File file3, String string3, DiffCompare diffCompare, OutputStream outputStream, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, String string8) throws IOException, DiffException {
        ParsedCharSequence parsedCharSequence = new ParsedCharSequence(file, string);
        ParsedCharSequence parsedCharSequence2 = new ParsedCharSequence(file2, string2);
        ParsedCharSequence parsedCharSequence3 = new ParsedCharSequence(file3, string3);
        MergeEdit mergeEdit = StarTeamMerge.merge(parsedCharSequence, parsedCharSequence2, parsedCharSequence3, diffCompare);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string4));
        boolean bl3 = StarTeamMerge.outputMergeEdits(bufferedWriter, parsedCharSequence, parsedCharSequence2, parsedCharSequence3, diffCompare, mergeEdit, string5, string6, string7, bl, bl2, string8);
        bufferedWriter.flush();
        return bl3;
    }

    private StarTeamMerge() {
    }

    static class DiffEdit {
        int sourceStart = 0;
        int sourceEnd = 0;
        int targetStart = 0;
        int targetEnd = 0;
        Object[] sourceLines = null;
        Object[] targetLines = null;
        DiffEdit next = null;

        int numSourceLines() {
            return this.sourceEnd - this.sourceStart + 1;
        }

        int numTargetLines() {
            return this.targetEnd - this.targetStart + 1;
        }

        public String toString() {
            return super.toString() + ": source: [" + this.sourceStart + ", " + this.sourceEnd + "]; target: [" + this.targetStart + ", " + this.targetEnd + "]";
        }

        DiffEdit() {
        }
    }

    static class MergeEdit {
        public static final int ERROR = 0;
        public static final int DIFF_ALL = 4;
        public static final int DIFF_1ST = 5;
        public static final int DIFF_2ND = 6;
        public static final int DIFF_3RD = 7;
        int correspond = 0;
        int[][] ranges;
        Object[][] lines = new Object[3][];
        MergeEdit next = null;

        private int highMapLine(int n, int n2, int n3) {
            return n3 - this.ranges[n][1] + this.ranges[n2][1];
        }

        private int numLines(int n) {
            return this.ranges[n][1] - this.ranges[n][0] + 1;
        }

        public String toString() {
            String string = null;
            switch (this.correspond) {
                case 0: {
                    string = "ERROR";
                    break;
                }
                case 4: {
                    string = "DIFF_ALL";
                    break;
                }
                case 5: {
                    string = "DIFF_1ST";
                    break;
                }
                case 6: {
                    string = "DIFF_2ND";
                    break;
                }
                case 7: {
                    string = "DIFF_3RD";
                    break;
                }
                default: {
                    string = "ERROR!!!!";
                }
            }
            return string + " [" + this.ranges[0][0] + ", " + this.ranges[0][1] + "] [" + this.ranges[1][0] + ", " + this.ranges[1][1] + "] [" + this.ranges[2][0] + ", " + this.ranges[2][1] + "]";
        }

        MergeEdit(int n, int n2, int n3, int n4, int n5, int n6) {
            this.ranges = new int[3][];
            int n7 = 0;
            while (n7 < 3) {
                this.ranges[n7] = new int[2];
                ++n7;
            }
            this.correspond = 0;
            this.next = null;
            this.ranges[0][0] = n;
            this.ranges[0][1] = n2;
            this.ranges[1][0] = n3;
            this.ranges[1][1] = n4;
            this.ranges[2][0] = n5;
            this.ranges[2][1] = n6;
            this.lines[0] = new Object[this.numLines(0)];
            this.lines[1] = new Object[this.numLines(1)];
            this.lines[2] = new Object[this.numLines(2)];
        }
    }
}

