/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Cache;
import com.starbase.starteam.EventHandlerProfile;
import com.starbase.starteam.MPXClient;
import com.starbase.starteam.MPXException;
import com.starbase.starteam.Server;
import com.starbase.util.Assert;

abstract class CacheManager {
    private int m_referenceCount = 0;
    private long m_lastReferenced = 0L;
    private long m_timestamp = 0L;
    private Object m_timestampLock = new Object();
    protected MPXClient m_MPXClient = null;

    public abstract void setAllDirty();

    protected abstract MPXClient newMPXClient(Server var1, EventHandlerProfile var2) throws MPXException;

    public boolean useMPX(Cache cache) {
        return this.isMPXRunning();
    }

    public boolean useMPX(long l) {
        return this.isMPXRunning();
    }

    public long getTimestamp() {
        Object object = this.m_timestampLock;
        synchronized (object) {
            long l = ++this.m_timestamp;
            Object var2_3 = null;
            return l;
        }
    }

    public int addRef() {
        return ++this.m_referenceCount;
    }

    public int release() {
        --this.m_referenceCount;
        if (this.m_referenceCount < 0) {
            Assert.internalError("CacheManager.release()");
        }
        return this.m_referenceCount;
    }

    public int getReferenceCount() {
        return this.m_referenceCount;
    }

    public void setLastReferenced(long l) {
        this.m_lastReferenced = l;
    }

    public long getLastReferenced() {
        return this.m_lastReferenced;
    }

    public void discard() {
        this.disableMPX();
    }

    public void enableMPX(Server server, EventHandlerProfile eventHandlerProfile) throws MPXException {
        if (!this.isMPXEnabled()) {
            if (this.m_MPXClient == null) {
                CacheManager cacheManager = this;
                synchronized (cacheManager) {
                    if (this.m_MPXClient == null) {
                        this.m_MPXClient = this.newMPXClient(server, eventHandlerProfile);
                    }
                }
            }
            this.m_MPXClient.start();
            this.setAllDirty();
        }
    }

    public boolean isMPXEnabled() {
        MPXClient mPXClient = this.m_MPXClient;
        if (mPXClient != null) {
            return mPXClient.isStarted();
        }
        return false;
    }

    public boolean isMPXRunning() {
        MPXClient mPXClient = this.m_MPXClient;
        if (mPXClient != null) {
            return mPXClient.isRunning();
        }
        return false;
    }

    public void pingMPXServer() throws MPXException {
        MPXClient mPXClient = this.m_MPXClient;
        if (mPXClient != null) {
            mPXClient.ping();
        } else {
            MPXException.throwNotConnectedException();
        }
    }

    public void disableMPX() {
        MPXClient mPXClient = this.m_MPXClient;
        if (mPXClient != null) {
            try {
                mPXClient.stop();
            }
            catch (MPXException mPXException) {
                // empty catch block
            }
            this.m_MPXClient = null;
        }
    }

    public CacheManager(Server server) {
    }
}

