/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.ConfigFiles;
import com.starbase.starteam.Folder;
import com.starbase.starteam.OverrideMap;
import com.starbase.starteam.OverrideProperties;
import com.starbase.starteam.Server;
import com.starbase.starteam.View;
import com.starbase.starteam.XMLConfigParser;
import com.starbase.util.GUID;
import com.starbase.util.XMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DirectoryOverrides {
    private static String PROJECT_COMPONENT = "Project Component";
    private static String VIEW_PREFIX = "ViewWorkingFolderOverrides\\";
    private static String FOLDER_PREFIX = "WorkingFolderOverrides\\";
    private static String FOLDER_EOL_PREFIX = "FolderEOLOverrides\\";
    private static String FOLDER_CASE_PREFIX = "FolderCaseOverrides\\";
    private static String FOLDER_VISIBLE_PREFIX = "FolderVisibleOverrides\\";
    private static String VIEWKEY = PROJECT_COMPONENT + "::" + VIEW_PREFIX;
    private static String FOLDERKEY = PROJECT_COMPONENT + "::" + FOLDER_PREFIX;
    private static String FOLDEREOLKEY = PROJECT_COMPONENT + "::" + FOLDER_EOL_PREFIX;
    private static String FOLDERCASEKEY = PROJECT_COMPONENT + "::" + FOLDER_CASE_PREFIX;
    private static String FOLDERVISIBLEKEY = PROJECT_COMPONENT + "::" + FOLDER_VISIBLE_PREFIX;
    private static Object CATEGORY_PATH = new Object();
    private static Object CATEGORY_EOL = new Object();
    private static Object CATEGORY_CASE = new Object();
    private static Object CATEGORY_VISIBLE = new Object();
    private Hashtable m_serverToViewMap = new Hashtable(100, 0.75f);
    private Hashtable m_serverToFolderMap = new Hashtable(100, 0.75f);
    private File m_sourceFile = null;
    private long m_lastModified = 0L;

    public File getSourceFile() {
        return this.m_sourceFile;
    }

    public void loadDefault() throws IOException {
        this.load(ConfigFiles.getStarTeamINI());
    }

    public void load(File file) throws IOException {
        if (XMLUtils.isXML(file)) {
            this.loadXML(file);
        } else {
            this.loadINI(file);
        }
    }

    void loadXML(File file) throws IOException {
        this.m_sourceFile = file;
        this.m_lastModified = 0L;
        if (this.m_sourceFile != null && this.m_sourceFile.exists()) {
            this.reset();
            this.m_sourceFile = file;
            this.m_lastModified = file.lastModified();
            DirectoryOverrides directoryOverrides = this;
            if (directoryOverrides == null) {
                throw null;
            }
            XMLConfigParser xMLConfigParser = new XMLConfigParser(directoryOverrides){
                private final /* synthetic */ DirectoryOverrides this$0;

                public void handleOption(String string, String string2, String string3) {
                    DirectoryOverrides.access$0(this.this$0, string, string2, string3);
                }
                {
                    this.this$0 = directoryOverrides;
                    this.constructor$0(directoryOverrides);
                }

                private final void constructor$0(DirectoryOverrides directoryOverrides) {
                }
            };
            xMLConfigParser.load(file);
        }
    }

    void loadINI(File file) throws IOException {
        BufferedReader bufferedReader;
        block5: {
            bufferedReader = null;
            try {
                this.m_sourceFile = file;
                this.m_lastModified = 0L;
                if (this.m_sourceFile == null || !this.m_sourceFile.exists()) break block5;
                this.reset();
                this.m_sourceFile = file;
                this.m_lastModified = file.lastModified();
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.processLine(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                throw throwable;
            }
        }
        Object var4_4 = null;
        if (bufferedReader != null) {
            bufferedReader.close();
        }
    }

    public void reload() throws IOException {
        if (this.m_sourceFile != null) {
            this.load(this.m_sourceFile);
        }
    }

    public void reloadIfNeeded() throws IOException {
        long l;
        if (this.m_sourceFile != null && this.m_sourceFile.exists() && (l = this.m_sourceFile.lastModified()) != this.m_lastModified) {
            this.reload();
        }
    }

    OverrideProperties getFolderOverrideProperties(Folder folder) {
        OverrideProperties overrideProperties = null;
        if (folder != null && folder.getServer() != null) {
            GUID gUID = folder.getServer().getRepositoryID();
            int n = folder.getItemID();
            overrideProperties = this.getFolderOverrideProperties(gUID, n);
        }
        return overrideProperties;
    }

    OverrideProperties getFolderOverrideProperties(GUID gUID, int n) {
        OverrideMap overrideMap = this.getFolderOverrideMap(gUID);
        if (overrideMap != null) {
            return overrideMap.getOverrideProperties(n);
        }
        return null;
    }

    OverrideProperties getViewOverrideProperties(View view) {
        Server server;
        OverrideProperties overrideProperties = null;
        if (view != null && (server = view.getServer()) != null) {
            overrideProperties = this.getViewOverrideProperties(server.getRepositoryID(), view.getViewID());
        }
        return overrideProperties;
    }

    OverrideProperties getViewOverrideProperties(GUID gUID, int n) {
        OverrideMap overrideMap = this.getViewOverrideMap(gUID);
        if (overrideMap != null) {
            return overrideMap.getOverrideProperties(n);
        }
        return null;
    }

    private void processLine(String string) {
        if (string.startsWith(VIEWKEY)) {
            this.processType(CATEGORY_PATH, VIEWKEY, string, this.m_serverToViewMap);
        } else if (string.startsWith(FOLDERKEY)) {
            this.processType(CATEGORY_PATH, FOLDERKEY, string, this.m_serverToFolderMap);
        } else if (string.startsWith(FOLDEREOLKEY)) {
            this.processType(CATEGORY_EOL, FOLDEREOLKEY, string, this.m_serverToFolderMap);
        } else if (string.startsWith(FOLDERCASEKEY)) {
            this.processType(CATEGORY_CASE, FOLDERCASEKEY, string, this.m_serverToFolderMap);
        } else if (string.startsWith(FOLDERVISIBLEKEY)) {
            this.processType(CATEGORY_VISIBLE, FOLDERVISIBLEKEY, string, this.m_serverToFolderMap);
        }
    }

    private void processType(Object object, String string, String string2, Hashtable hashtable) {
        String string3;
        int n;
        if (string2.length() > string.length() && (n = (string3 = string2.substring(string.length())).indexOf("=")) >= 0) {
            String string4 = string3.substring(0, n);
            String string5 = "";
            if (n < string3.length() - 1) {
                string5 = string3.substring(n + 1);
            }
            this.addToCached(object, string4, string5, hashtable);
        }
    }

    private void handleConfigOption(String string, String string2, String string3) {
        if (string.equals(PROJECT_COMPONENT)) {
            if (string2.startsWith(VIEW_PREFIX)) {
                this.addToCached(CATEGORY_PATH, string2.substring(VIEW_PREFIX.length()), string3, this.m_serverToViewMap);
            } else if (string2.startsWith(FOLDER_PREFIX)) {
                this.addToCached(CATEGORY_PATH, string2.substring(FOLDER_PREFIX.length()), string3, this.m_serverToFolderMap);
            } else if (string2.startsWith(FOLDER_EOL_PREFIX)) {
                this.addToCached(CATEGORY_EOL, string2.substring(FOLDER_EOL_PREFIX.length()), string3, this.m_serverToFolderMap);
            } else if (string2.startsWith(FOLDER_CASE_PREFIX)) {
                this.addToCached(CATEGORY_CASE, string2.substring(FOLDER_CASE_PREFIX.length()), string3, this.m_serverToFolderMap);
            } else if (string2.startsWith(FOLDER_VISIBLE_PREFIX)) {
                this.addToCached(CATEGORY_VISIBLE, string2.substring(FOLDER_VISIBLE_PREFIX.length()), string3, this.m_serverToFolderMap);
            }
        }
    }

    OverrideMap getViewOverrideMap(GUID gUID) {
        return (OverrideMap)this.m_serverToViewMap.get(gUID.toString().toLowerCase());
    }

    OverrideMap getFolderOverrideMap(GUID gUID) {
        return (OverrideMap)this.m_serverToFolderMap.get(gUID.toString().toLowerCase());
    }

    private void addToCached(Object object, String string, String string2, Hashtable hashtable) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        if (stringTokenizer.countTokens() == 3) {
            String string3 = stringTokenizer.nextToken();
            string3 = string3.toLowerCase();
            String string4 = stringTokenizer.nextToken();
            try {
                int n = Integer.parseInt(string4);
                String string5 = stringTokenizer.nextToken().toLowerCase();
                OverrideMap overrideMap = (OverrideMap)hashtable.get(string3);
                if (overrideMap == null) {
                    overrideMap = new OverrideMap(200);
                    hashtable.put(string3, overrideMap);
                }
                if (object == CATEGORY_PATH) {
                    if (string5.equals("path")) {
                        String string6 = string2;
                        overrideMap.setPathOverride(n, string6);
                    } else if (string5.equals("enable")) {
                        boolean bl = this.ValueStringToBoolean(string2);
                        overrideMap.setPathOverrideEnabled(n, bl);
                    }
                } else if (object == CATEGORY_EOL) {
                    if (string5.equals("eol")) {
                        String string7 = this.ValueStringToEOL(string2);
                        overrideMap.setEOLOverride(n, string7);
                    } else if (string5.equals("enable")) {
                        boolean bl = this.ValueStringToBoolean(string2);
                        overrideMap.setEOLOverrideEnabled(n, bl);
                    }
                } else if (object == CATEGORY_CASE) {
                    if (string5.equals("preserve")) {
                        boolean bl = this.ValueStringToBoolean(string2);
                        overrideMap.setCaseSensitivityOverride(n, bl);
                    } else if (string5.equals("enable")) {
                        boolean bl = this.ValueStringToBoolean(string2);
                        overrideMap.setCaseSensitivityOverrideEnabled(n, bl);
                    }
                } else if (object == CATEGORY_VISIBLE && string5.equals("visible")) {
                    boolean bl = this.ValueStringToBoolean(string2);
                    overrideMap.setVisibleOverride(n, bl);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected boolean ValueStringToBoolean(String string) {
        return !string.trim().equals("0");
    }

    protected String ValueStringToEOL(String string) {
        String string2 = null;
        if ((string = string.trim()).equals("0")) {
            string2 = "\r\n";
        } else if (string.equals("1")) {
            string2 = "\n";
        } else if (string.equals("2")) {
            string2 = "\r";
        }
        return string2;
    }

    String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        String string = System.getProperty("line.separator");
        stringBuffer.append("DirectoryOverrides");
        stringBuffer.append("------------------");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void reset() {
        this.m_serverToViewMap.clear();
        this.m_serverToFolderMap.clear();
    }

    static /* synthetic */ void access$0(DirectoryOverrides directoryOverrides, String string, String string2, String string3) {
        directoryOverrides.handleConfigOption(string, string2, string3);
    }
}

