/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Cacheable;
import com.starbase.starteam.ColumnInfo;
import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.NamedCacheable;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import java.io.IOException;

class Filter_Data
extends NamedCacheable {
    private String m_name = "";
    private int m_id = -1;
    private int m_userID = -1;
    private int m_queryID = -1;
    private int m_context = 0;
    private GroupSortInfo[] m_groupSortInfo = new GroupSortInfo[0];
    private ColumnInfo[] m_columnInfo = new ColumnInfo[0];

    public Object copy() {
        Filter_Data filter_Data = (Filter_Data)super.copy();
        filter_Data.m_groupSortInfo = new GroupSortInfo[this.m_groupSortInfo.length];
        int n = 0;
        while (n < this.m_groupSortInfo.length) {
            filter_Data.m_groupSortInfo[n] = this.m_groupSortInfo[n].copy();
            ++n;
        }
        filter_Data.m_columnInfo = new ColumnInfo[this.m_columnInfo.length];
        n = 0;
        while (n < this.m_columnInfo.length) {
            filter_Data.m_columnInfo[n] = this.m_columnInfo[n].copy();
            ++n;
        }
        return filter_Data;
    }

    public boolean isPublic() {
        return this.m_userID == -1;
    }

    public int getID() {
        return this.m_id;
    }

    public int getUserID() {
        return this.m_userID;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public int getQueryID() {
        return this.m_queryID;
    }

    public void setQueryID(int n) {
        this.m_queryID = n;
    }

    public int getContext() {
        return this.m_context;
    }

    public void setContext(int n) {
        this.m_context = n;
    }

    public GroupSortInfo[] getGroupSortInfo() {
        return this.m_groupSortInfo;
    }

    public void setGroupSortInfo(GroupSortInfo[] groupSortInfoArray) {
        this.m_groupSortInfo = groupSortInfoArray;
    }

    public ColumnInfo[] getColumnInfo() {
        return this.m_columnInfo;
    }

    public void setColumnInfo(ColumnInfo[] columnInfoArray) {
        this.m_columnInfo = columnInfoArray;
    }

    public void clearColumns() {
        this.m_columnInfo = new ColumnInfo[0];
    }

    public void clearGroupSortInfo() {
        this.m_groupSortInfo = new GroupSortInfo[0];
    }

    public boolean isNew() {
        return this.m_id == -1;
    }

    public String toString() {
        return this.m_name;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("FilterName   : " + this.m_name + string);
        stringBuffer.append("ID     : " + this.m_id + string);
        stringBuffer.append("UserID : " + this.m_userID + string);
        stringBuffer.append("Context: ");
        switch (this.m_context) {
            case 1: {
                stringBuffer.append("server items only" + string);
                break;
            }
            case 2: {
                stringBuffer.append("local items only" + string);
                break;
            }
            case 3: {
                stringBuffer.append("server and local items" + string);
                break;
            }
            default: {
                stringBuffer.append("<invalid context: " + this.m_context + ">" + string);
            }
        }
        stringBuffer.append("QueryID: " + this.m_queryID + string);
        stringBuffer.append("Visible Columns:" + string);
        int n = 0;
        while (n < this.m_columnInfo.length) {
            stringBuffer.append("    " + this.m_columnInfo[n].toDebugString() + string);
            ++n;
        }
        stringBuffer.append("GroupSortInfo:" + string);
        n = 0;
        while (n < this.m_groupSortInfo.length) {
            stringBuffer.append("    " + this.m_groupSortInfo[n].toDebugString() + string);
            ++n;
        }
        return stringBuffer.toString();
    }

    static Filter_Data readFilter(Command command) throws IOException {
        Filter_Data filter_Data = new Filter_Data();
        filter_Data.readGuts(command);
        return filter_Data;
    }

    void setID(int n) {
        this.m_id = n;
    }

    public void makePublic() {
        this.m_userID = -1;
    }

    void readGuts(Command command) throws IOException {
        int n;
        this.m_name = command.readString();
        this.m_userID = command.readInt();
        this.m_id = command.readInt();
        int[] nArray = command.readIntArray();
        int[] nArray2 = command.readIntArray();
        this.m_columnInfo = new ColumnInfo[nArray2.length];
        int n2 = 0;
        while (n2 < nArray2.length) {
            n = 80;
            if (n2 < nArray.length) {
                n = nArray[n2];
            }
            this.m_columnInfo[n2] = new ColumnInfo(nArray2[n2], n);
            ++n2;
        }
        n2 = command.readInt();
        this.m_groupSortInfo = new GroupSortInfo[n2];
        n = 0;
        while (n < n2) {
            int n3 = command.readInt();
            int n4 = command.readInt();
            int n5 = command.readInt();
            this.m_groupSortInfo[n] = new GroupSortInfo(n3, n5, n4);
            ++n;
        }
        this.m_queryID = command.readInt();
        this.m_context = command.readInt();
    }

    void writeGuts(Command command) throws IOException {
        command.writeString(this.m_name);
        command.writeInt(this.m_userID);
        command.writeInt(this.m_id);
        int n = this.m_columnInfo.length;
        command.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            command.writeInt(this.m_columnInfo[n2].getPixelWidth());
            ++n2;
        }
        command.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            command.writeInt(this.m_columnInfo[n2].getPropertyID());
            ++n2;
        }
        n = this.m_groupSortInfo.length;
        command.writeInt(n);
        n2 = 0;
        while (n2 < n) {
            GroupSortInfo groupSortInfo = this.m_groupSortInfo[n2];
            command.writeInt(groupSortInfo.getTypeMask());
            command.writeInt(groupSortInfo.getCompareMask());
            command.writeInt(groupSortInfo.getPropertyID());
            ++n2;
        }
        command.writeInt(this.m_queryID);
        command.writeInt(this.m_context);
    }

    public boolean isEqualTo(Cacheable cacheable) {
        if (cacheable != null && cacheable instanceof Filter_Data) {
            Filter_Data filter_Data = (Filter_Data)cacheable;
            if (this.getID() == filter_Data.getID() && this.getName().equals(filter_Data.getName()) && this.getUserID() == filter_Data.getUserID() && this.getQueryID() == filter_Data.getQueryID() && this.getContext() == filter_Data.getContext() && this.isPublic() == filter_Data.isPublic()) {
                ColumnInfo[] columnInfoArray;
                GroupSortInfo[] groupSortInfoArray;
                GroupSortInfo[] groupSortInfoArray2 = this.getGroupSortInfo();
                if (groupSortInfoArray2.length != (groupSortInfoArray = filter_Data.getGroupSortInfo()).length) {
                    return false;
                }
                ColumnInfo[] columnInfoArray2 = this.getColumnInfo();
                if (columnInfoArray2.length != (columnInfoArray = filter_Data.getColumnInfo()).length) {
                    return false;
                }
                int n = groupSortInfoArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    if (!groupSortInfoArray2[n2].isEqualTo(groupSortInfoArray[n2])) {
                        return false;
                    }
                    ++n2;
                }
                n = columnInfoArray2.length;
                n2 = 0;
                while (n2 < n) {
                    if (!columnInfoArray2[n2].isEqualTo(columnInfoArray[n2])) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public Filter_Data(String string, int n, int n2) {
        if (string == null) {
            Assert.nullArgument("String");
        }
        this.m_name = string;
        this.m_context = n;
        this.m_userID = n2;
    }

    Filter_Data(Filter_Data filter_Data) {
        this.m_name = filter_Data.m_name;
        this.m_id = filter_Data.m_id;
        this.m_userID = filter_Data.m_userID;
        this.m_queryID = filter_Data.m_queryID;
        this.m_context = filter_Data.m_context;
        this.m_groupSortInfo = new GroupSortInfo[filter_Data.m_groupSortInfo.length];
        System.arraycopy(filter_Data.m_groupSortInfo, 0, this.m_groupSortInfo, 0, filter_Data.m_groupSortInfo.length);
        this.m_columnInfo = new ColumnInfo[filter_Data.m_columnInfo.length];
        System.arraycopy(filter_Data.m_columnInfo, 0, this.m_columnInfo, 0, filter_Data.m_columnInfo.length);
    }

    private Filter_Data() {
    }
}

