/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.CmdGetParentFolders;
import com.starbase.starteam.CmdMoveFolder;
import com.starbase.starteam.CmdShareFolder;
import com.starbase.starteam.File;
import com.starbase.starteam.FolderEventScope;
import com.starbase.starteam.IFolderListener;
import com.starbase.starteam.IItemListener;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemEventScope;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.Item_Cache;
import com.starbase.starteam.Item_CacheRefCollection;
import com.starbase.starteam.Item_Data;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.starteam.View_Cmd_GetFolders;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.Assert;
import com.starbase.util.FileUtils;
import com.starbase.util.Platform;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Folder
extends Item
implements ISecurableContainer {
    private static final String EMPTY = "";
    public static final int EXCLUDE_NONE = 0;
    public static final int EXCLUDE_LOCAL = 1;
    public static final int EXCLUDE_INHERIT = 2;
    public static final String EOL_CRLF = "\r\n";
    public static final String EOL_LF = "\n";
    public static final String EOL_CR = "\r";
    private Folder[] m_subFolders = new Folder[0];
    private boolean m_parentFolderCached = false;
    private String m_alternatePathFragment;
    private boolean m_syncAvailable = false;
    private boolean m_userVisible = true;
    private Hashtable m_unsavedNewProperties = new Hashtable();
    long m_timestampIDs = 0L;
    long m_timestampProperties = 0L;
    private String m_originalPathFragment = null;
    protected String m_eol = null;
    protected Boolean m_caseSensitive = null;
    private Hashtable m_itemCollections = new Hashtable();

    public Object put(String string, Object object) throws NoSuchPropertyException, ClassCastException {
        if (this.isNew() && !this.isSetOnCreate(string)) {
            this.m_unsavedNewProperties.put(string, object);
        }
        return super.put(string, object);
    }

    public Object putByPropertyID(int n, Object object) throws NoSuchPropertyException, ClassCastException {
        Property property = this.getType().propertyForPID(n);
        if (property == null) {
            throw new NoSuchPropertyException(this.getType().getName(), n);
        }
        return this.put(property.getName(), object);
    }

    protected Object setCachedValue(String string, Object object) {
        if (this.isNew() && !this.isSetOnCreate(string)) {
            this.m_unsavedNewProperties.put(string, object);
        }
        return super.setCachedValue(string, object);
    }

    public String getDotNotation() {
        if (this.getServer().getRevisionLevel() >= 63) {
            return super.getDotNotation();
        }
        return ((Item_Data)this.getData()).getDotNotation();
    }

    void setDotNotation(String string) {
        ((Item_Data)this.getData()).setDotNotation(string);
    }

    public Folder[] getSubFolders() {
        this.verifyNotDisembodied();
        int n = this.m_subFolders.length;
        Folder[] folderArray = new Folder[n];
        System.arraycopy(this.m_subFolders, 0, folderArray, 0, n);
        return folderArray;
    }

    public int getSubFolderCount() {
        this.verifyNotDisembodied();
        return this.m_subFolders.length;
    }

    public String getDescription() {
        return (String)this.getCachedValue(this.getPropertyNames().FOLDER_DESCRIPTION);
    }

    public void setDescription(String string) {
        this.setCachedValue(this.getPropertyNames().FOLDER_DESCRIPTION, (Object)string);
    }

    public String getDefaultPathFragment() {
        String string = this.getOriginalPathFragment();
        if (this.getParentFolder() != null || string == null) {
            string = (String)this.getCachedValue(this.getPropertyNames().FOLDER_WORKING_FOLDER);
        }
        int n = string.length();
        String string2 = this.getServer().getClientContext().getFilePathDelimiter();
        if (n > 1 && string.substring(n - 1, n).equals(string2)) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public void setDefaultPathFragment(String string) {
        this.setOriginalPathFragment(string);
        this.setCachedValue(this.getPropertyNames().FOLDER_WORKING_FOLDER, (Object)string);
    }

    public String getAlternatePathFragment() {
        return this.m_alternatePathFragment;
    }

    public void setAlternatePathFragment(String string) {
        this.m_alternatePathFragment = string;
    }

    public String getPathFragment() {
        return this.getAlternatePathFragment() != null ? this.getAlternatePathFragment() : this.getDefaultPathFragment();
    }

    void setOriginalPathFragment(String string) {
        this.m_originalPathFragment = string;
    }

    private String getOriginalPathFragment() {
        return this.m_originalPathFragment;
    }

    public String getPath() {
        return this.getPath(this.getServer().getClientContext().getFilePathDelimiter());
    }

    private String getPath(String string) {
        this.verifyNotDisembodied();
        StringBuffer stringBuffer = new StringBuffer(256);
        Folder folder = this;
        while (folder != null) {
            if (folder.getParentFolder() == null) {
                if (folder.getView() != null && folder.getView().getPath() != null) {
                    stringBuffer.insert(0, folder.getView().getPath());
                } else {
                    stringBuffer.insert(0, folder.getPathFragment());
                }
            } else {
                String string2 = folder.getPathFragment();
                if (string2.length() > 0) {
                    stringBuffer.insert(0, string2);
                    if (FileUtils.isAbsolute(string2)) break;
                    stringBuffer.insert(0, string);
                }
            }
            folder = folder.getParentFolder();
        }
        return FileUtils.fullyResolvedPath(stringBuffer.toString(), string);
    }

    public int getExcludeFlags() {
        return (Integer)this.getCachedValue(this.getPropertyNames().FOLDER_EXCLUDE_FLAGS);
    }

    public void setExcludeFlags(int n) {
        this.setCachedValue(this.getPropertyNames().FOLDER_EXCLUDE_FLAGS, (Object)new Integer(n));
    }

    public String getExcludeList() {
        return (String)this.getCachedValue(this.getPropertyNames().FOLDER_EXCLUDE_SPEC);
    }

    public void setExcludeList(String string) {
        this.setCachedValue(this.getPropertyNames().FOLDER_EXCLUDE_SPEC, (Object)string);
    }

    public String getFilePath(String string) {
        return this.getPath() + this.getServer().getClientContext().getFilePathDelimiter() + string;
    }

    public String getFolderHierarchy() {
        this.verifyNotDisembodied();
        StringBuffer stringBuffer = new StringBuffer();
        Folder folder = this;
        String string = this.getServer().getClientContext().getFilePathDelimiter();
        while (folder != null) {
            stringBuffer.insert(0, string);
            stringBuffer.insert(0, folder.getName());
            folder = folder.getParentFolder();
        }
        return stringBuffer.toString();
    }

    public boolean isExcluded(String string) {
        String string2 = this.resolveExcludeList();
        java.io.File file = new java.io.File(string);
        String string3 = file.getName();
        return FileUtils.matchPatternList(string3, string2, this.getServer().getClientContext().getCaseSensitiveFileNames());
    }

    public String resolveExcludeList() {
        this.verifyNotDisembodied();
        switch (this.getExcludeFlags()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return this.getExcludeList();
            }
            case 2: {
                if (this.getParentFolder() != null) {
                    String string = this.getParentFolder().resolveExcludeList();
                    String string2 = this.getExcludeList();
                    String string3 = EMPTY;
                    if (string.length() != 0 && string2.length() != 0) {
                        string3 = ";";
                    }
                    return string2 + string3 + string;
                }
                return this.getExcludeList();
            }
        }
        Assert.internalError("Folder.resolveExcludeList(), getExcludeFlags()=" + this.getExcludeFlags());
        return EMPTY;
    }

    public String getName() {
        return (String)this.getCachedValue(this.getPropertyNames().FOLDER_NAME);
    }

    public void setName(String string) {
        this.setCachedValue(this.getPropertyNames().FOLDER_NAME, (Object)string);
    }

    public Folder getParentFolder() {
        this.verifyNotDisembodied();
        if (!this.isNew() && !this.m_parentFolderCached) {
            CmdGetParentFolders cmdGetParentFolders = new CmdGetParentFolders(this);
            cmdGetParentFolders.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getServer().getComponentID(ServerComponentInfo.PROJECT));
            this.setParentFolder(cmdGetParentFolders.getFolder());
        }
        return this.getParentFolderWithoutRetrieval();
    }

    public boolean hasParentFolder() {
        this.verifyNotDisembodied();
        return this.getParentFolder() != null;
    }

    void setParentFolder(Folder folder) {
        super.setParentFolder(folder);
        this.m_parentFolderCached = true;
    }

    void setChildren(Folder[] folderArray) {
        if (folderArray == null) {
            Assert.internalError("Folder.setChildren(), folders=null");
        }
        this.m_subFolders = folderArray;
        int n = 0;
        while (n < folderArray.length) {
            folderArray[n].setParentFolder(this);
            ++n;
        }
    }

    public Enumeration enumerateItems(String string) {
        if (string.equals(this.getServer().getTypeNames().FOLDER)) {
            Vector<Folder> vector = new Vector<Folder>();
            int n = 0;
            while (n < this.m_subFolders.length) {
                vector.addElement(this.m_subFolders[n]);
                ++n;
            }
            return vector.elements();
        }
        Item_CacheRefCollection item_CacheRefCollection = this.getItemCollection(string);
        item_CacheRefCollection.populateItems();
        return item_CacheRefCollection.getRefs().elements();
    }

    public String getFileEOL() {
        this.verifyNotDisembodied();
        if (this.m_eol != null) {
            return this.m_eol;
        }
        Folder folder = this.getParentFolder();
        if (folder != null) {
            return folder.getFileEOL();
        }
        return Platform.getEOL();
    }

    void setFileEOL(String string) {
        this.m_eol = string;
    }

    public boolean getCaseSensitiveFileNames() {
        this.verifyNotDisembodied();
        if (this.m_caseSensitive != null) {
            return this.m_caseSensitive;
        }
        Folder folder = this.getParentFolder();
        if (folder != null) {
            return folder.getCaseSensitiveFileNames();
        }
        return Platform.caseSensitiveFileNames();
    }

    void setCaseSensitiveFileNames(Boolean bl) {
        this.m_caseSensitive = bl;
    }

    public File[] getNotInViewFiles() throws IOException {
        Object object;
        Vector vector = new Vector();
        java.io.File file = new java.io.File(this.getPath());
        if (file.exists() && file.isDirectory()) {
            object = new Hashtable(50);
            this.collectCanonicalNames(file, (Hashtable)object);
            this.collectNivFiles(file, (Hashtable)object, vector);
        }
        object = new File[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void collectCanonicalNames(java.io.File file, Hashtable hashtable) throws IOException {
        Item[] itemArray = this.getItems(this.getServer().getTypeNames().FILE);
        int n = 0;
        while (n < itemArray.length) {
            String string = itemArray[n].getString(this.getServer().getPropertyNames().FILE_NAME);
            java.io.File file2 = new java.io.File(file, string);
            if (file2.exists()) {
                java.io.File file3 = new java.io.File(file2.getCanonicalPath());
                String string2 = file3.getName();
                hashtable.put(string2, string2);
            }
            ++n;
        }
    }

    private void collectNivFiles(java.io.File file, Hashtable hashtable, Vector vector) throws IOException {
        Object object;
        String string;
        String[] stringArray = file.list();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            object = new java.io.File(file, string);
            if (!((java.io.File)object).isDirectory() && !this.isExcluded(string) && hashtable.get(string) == null) {
                vector2.addElement(string);
            }
            ++n;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = new File(this);
            ((File)object).setName(string);
            vector.addElement(object);
        }
    }

    public Item[] getHistory() {
        Item[] itemArray = super.getHistory();
        if (itemArray != null) {
            String string = this.getOriginalPathFragment();
            int n = 0;
            while (n < itemArray.length) {
                Folder folder = (Folder)itemArray[n];
                folder.setOriginalPathFragment(string);
                ++n;
            }
        }
        return itemArray;
    }

    public void remove() {
        Vector<Folder> vector = new Vector<Folder>();
        vector.addElement(this);
        this.getServer().deleteItems(vector);
        if (!this.isDisembodied()) {
            this.getParentFolder().deleteSubFolder(this);
            this.getView().unmapItem(this);
        }
    }

    private boolean fromSameServer(Item item, Item item2) {
        return item.getServer() == item2.getServer();
    }

    private Folder findFolderWithID(Folder folder, int n) {
        if (folder.getItemID() == n) {
            return folder;
        }
        Folder[] folderArray = folder.getSubFolders();
        int n2 = 0;
        while (n2 < folderArray.length) {
            Folder folder2 = this.findFolderWithID(folderArray[n2], n);
            if (folder2 != null) {
                return folder2;
            }
            ++n2;
        }
        return null;
    }

    private Folder retrieveFolderTreeByID(Server server, View view, int n) {
        Folder folder = View_Cmd_GetFolders.execute(server, view, null);
        Folder folder2 = this.findFolderWithID(folder, n);
        if (folder2 == null) {
            throw new RuntimeException(Res.getString(ResIDs.FOLDER_MISSING));
        }
        folder2.relocate(server, view);
        return folder2;
    }

    private void relocateItems(Server server, View view) {
        Type[] typeArray = server.getTypes();
        int n = 0;
        while (n < typeArray.length) {
            String string = typeArray[n].getName();
            Item_CacheRefCollection item_CacheRefCollection = this.getItemCollection(string);
            if (item_CacheRefCollection != null) {
                Enumeration enumeration = item_CacheRefCollection.getRefs().elements();
                while (enumeration.hasMoreElements()) {
                    Item item = (Item)enumeration.nextElement();
                    item.relocate(server, view);
                }
            }
            ++n;
        }
    }

    private void moveCachedInfoAndSubFolders(Server server, View view) {
        this.relocate(server, view);
        Folder[] folderArray = this.getSubFolders();
        int n = 0;
        while (n < folderArray.length) {
            folderArray[n].moveCachedInfoAndSubFolders(server, view);
            ++n;
        }
        this.relocateItems(server, view);
    }

    public Item add(Item item) {
        this.verifyNotDisembodied();
        if (item instanceof Folder) {
            if (!this.fromSameServer(this, item)) {
                throw new IllegalArgumentException(Res.getString(ResIDs.SHARE_FOLDERS_WITHIN_SAME_SERVER));
            }
            CmdShareFolder cmdShareFolder = new CmdShareFolder((Folder)item, this);
            cmdShareFolder.execute();
            Folder folder = this.retrieveFolderTreeByID(this.getServer(), this.getView(), cmdShareFolder.getSharedID());
            this.addSubFolder(folder);
            return folder;
        }
        if (!this.fromSameServer(this, item)) {
            throw new IllegalArgumentException(Res.getString(ResIDs.SHARE_ITEMS_WITHIN_SAME_SERVER));
        }
        Item item2 = this.getServer().addItemToFolder(this, item);
        this.addItem(item2);
        return item2;
    }

    public void move(Folder folder) {
        this.verifyNotDisembodied();
        if (!this.fromSameServer(this, folder)) {
            throw new IllegalArgumentException(Res.getString(ResIDs.MOVE_FOLDERS_WITHIN_SAME_SERVER));
        }
        CmdMoveFolder cmdMoveFolder = new CmdMoveFolder(this, folder);
        cmdMoveFolder.execute();
        this.getParentFolder().deleteSubFolder(this);
        this.setParentFolder(folder);
        this.moveCachedInfoAndSubFolders(folder.getServer(), folder.getView());
        folder.addSubFolder(this);
    }

    void addItem(Item item) {
        String string = item.getType().getName();
        Item_CacheRefCollection item_CacheRefCollection = this.getItemCollection(string);
        if (item_CacheRefCollection != null) {
            Vector vector = item_CacheRefCollection.getRefs();
            vector.addElement(item);
        }
        item.getView().mapItem(item);
    }

    void removeItem(Item item) {
        String string = item.getType().getName();
        Item_CacheRefCollection item_CacheRefCollection = this.getItemCollection(string);
        if (item_CacheRefCollection != null) {
            Vector vector = item_CacheRefCollection.getRefs();
            vector.removeElement(item);
        }
        item.getView().unmapItem(item);
    }

    public ItemList getList(String string) {
        ItemList itemList = new ItemList();
        if (string.equals(this.getServer().getTypeNames().FOLDER)) {
            Folder[] folderArray = this.getSubFolders();
            int n = 0;
            while (n < folderArray.length) {
                itemList.addItem(folderArray[n]);
                ++n;
            }
        } else {
            Item_CacheRefCollection item_CacheRefCollection = this.getItemCollection(string);
            item_CacheRefCollection.populateItems();
            Enumeration enumeration = item_CacheRefCollection.getRefs().elements();
            while (enumeration.hasMoreElements()) {
                Item item = (Item)enumeration.nextElement();
                itemList.addItem(item);
            }
        }
        return itemList;
    }

    public Item[] getItems(String string) {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        Type type = server.typeForName(string);
        return type.getItems(this);
    }

    public void populateNow(String string, String[] stringArray, int n) {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        Type type = server.typeForName(string);
        type.populate(this, stringArray, n);
    }

    public void populateAsNeeded(String string, String[] stringArray, int n) {
        this.populateNow(string, stringArray, 0);
    }

    public void populateInBackground(String string, String[] stringArray, int n) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        Folder folder = this;
        if (folder == null) {
            throw null;
        }
        Thread thread = new Thread(new Runnable(folder, string2, stringArray2){
            private final /* synthetic */ Folder this$0;
            private final /* synthetic */ String val$myTypeName;
            private final /* synthetic */ String[] val$myPropertyNames;

            public void run() {
                this.this$0.populateNow(this.val$myTypeName, this.val$myPropertyNames, 0);
            }
            {
                this.val$myTypeName = string;
                this.val$myPropertyNames = stringArray;
                this.this$0 = folder;
                this.constructor$0(folder);
            }

            private final void constructor$0(Folder folder) {
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public boolean isRefreshItemsRequired(String string, String[] stringArray, int n) {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        Type type = server.typeForName(string);
        return type.isRefreshRequired(this, stringArray, n);
    }

    boolean isRefreshFoldersRequired() {
        return this.isRefreshItemsRequired(this.getType().getName(), null, -1);
    }

    public void refreshItems(String string, String[] stringArray, int n) {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        Type type = server.typeForName(string);
        type.refresh(this, stringArray, n);
    }

    public void discardItems(String string, int n) {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        Type type = server.typeForName(string);
        type.discard(this, n);
    }

    void discardItems(String string) {
        Item_CacheRefCollection item_CacheRefCollection = this.disconnectItemCollection(string);
        if (item_CacheRefCollection != null) {
            item_CacheRefCollection.discard();
        }
    }

    protected Item_Cache getCache() {
        if (this.isDisembodied()) {
            Assert.internalError("Folder.getCache(), isDisembodied()=true");
        }
        return this.getView().getFolderCache();
    }

    void resetItemCollections() {
        Enumeration enumeration = this.m_itemCollections.elements();
        while (enumeration.hasMoreElements()) {
            Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
            item_CacheRefCollection.setRepopulateRequired();
        }
    }

    Item_CacheRefCollection getItemCollection(String string) {
        this.verifyNotDisembodied();
        return this.getItemCollection(string, true);
    }

    private Item_CacheRefCollection getItemCollection(String string, boolean bl) {
        Item_CacheRefCollection item_CacheRefCollection = null;
        Hashtable hashtable = this.m_itemCollections;
        synchronized (hashtable) {
            item_CacheRefCollection = (Item_CacheRefCollection)this.m_itemCollections.get(string);
            if (item_CacheRefCollection == null && bl) {
                Type type = this.getServer().typeForName(string);
                item_CacheRefCollection = new Item_CacheRefCollection(this, type);
                this.m_itemCollections.put(string, item_CacheRefCollection);
            }
        }
        return item_CacheRefCollection;
    }

    private Item_CacheRefCollection disconnectItemCollection(String string) {
        Item_CacheRefCollection item_CacheRefCollection = null;
        Hashtable hashtable = this.m_itemCollections;
        synchronized (hashtable) {
            item_CacheRefCollection = (Item_CacheRefCollection)this.m_itemCollections.get(string);
            if (item_CacheRefCollection != null) {
                this.m_itemCollections.remove(string);
            }
        }
        return item_CacheRefCollection;
    }

    boolean hasItemCollection(String string) {
        return this.getItemCollection(string, false) != null;
    }

    Vector getItemCollections(String string, int n) {
        Vector vector = new Vector();
        Folder.gatherItemCollections(this, string, n, false, vector);
        return vector;
    }

    Vector getPopulatedItemCollections(String string, int n) {
        Vector vector = new Vector();
        Folder.gatherItemCollections(this, string, n, true, vector);
        return vector;
    }

    private static void gatherItemCollections(Folder folder, String string, int n, boolean bl, Vector vector) {
        Item_CacheRefCollection item_CacheRefCollection = folder.getItemCollection(string, !bl);
        if (bl && item_CacheRefCollection != null && !item_CacheRefCollection.isPopulated()) {
            item_CacheRefCollection = null;
        }
        if (item_CacheRefCollection != null) {
            vector.addElement(item_CacheRefCollection);
        }
        if (n != 0) {
            if (n > 0) {
                --n;
            }
            Folder[] folderArray = folder.getSubFolders();
            int n2 = 0;
            while (n2 < folderArray.length) {
                Folder.gatherItemCollections(folderArray[n2], string, n, bl, vector);
                ++n2;
            }
        }
    }

    static void flattenFolderTree(Folder folder, Vector vector, int n) {
        if (folder != null) {
            vector.addElement(folder);
            if (n != 0) {
                Folder[] folderArray = folder.getSubFolders();
                int n2 = 0;
                while (n2 < folderArray.length) {
                    Folder.flattenFolderTree(folderArray[n2], vector, n > 0 ? n - 1 : n);
                    ++n2;
                }
            }
        }
    }

    private void addSubFolder(Folder folder) {
        folder.setParentFolder(this);
        if (this.m_subFolders == null) {
            this.m_subFolders = new Folder[0];
        }
        int n = this.m_subFolders.length;
        Folder[] folderArray = new Folder[n + 1];
        int n2 = 0;
        while (n2 < n) {
            folderArray[n2] = this.m_subFolders[n2];
            ++n2;
        }
        folderArray[n] = folder;
        this.m_subFolders = folderArray;
    }

    private void deleteSubFolder(Folder folder) {
        int n = this.m_subFolders.length;
        if (n <= 0) {
            Assert.internalError("Folder.deleteSubFolder(), size=" + n);
        }
        Folder[] folderArray = new Folder[n - 1];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (this.m_subFolders[n2] != folder) {
                folderArray[n3] = this.m_subFolders[n2];
                ++n3;
            }
            ++n2;
        }
        if (folderArray.length != this.m_subFolders.length - 1) {
            Assert.internalError("Folder.deleteSubFolder(), newsub.length=" + folderArray.length + ", m_subFolders.length" + this.m_subFolders.length);
        }
        this.m_subFolders = folderArray;
    }

    void refreshSyncInfo(String string) {
        if (!this.getServer().isSyncStoredLocally() && string.equals(this.getTypeNames().FILE) && !this.m_syncAvailable) {
            this.refreshSyncInfoNow();
        }
    }

    void refreshSyncInfoNow() {
        String[] stringArray = new String[]{this.getPropertyNames().FILE_NAME};
        this.populateNow(this.getTypeNames().FILE, stringArray, 0);
    }

    void setSyncAvailable(boolean bl) {
        this.m_syncAvailable = bl;
    }

    public boolean hasPermission(int n, String string) {
        return SecurityAccess.containerAccessTest(this.getServer(), this.getView(), 0, this.getItemID(), string, n);
    }

    public AclEntry[] getACL() {
        this.verifyNotDisembodied();
        return SecurityAccess.getContainerACL(this.getServer(), this.getView(), 0, this.getItemID());
    }

    public void setACL(AclEntry[] aclEntryArray) {
        this.verifyNotDisembodied();
        SecurityAccess.setContainerACL(this.getServer(), this.getView(), 0, this.getItemID(), aclEntryArray);
    }

    public AclEntry[] getContainerLevelACL(String string) {
        this.verifyNotDisembodied();
        return SecurityAccess.getContainerLevelACL(this.getServer(), this.getView(), 0, this.getItemID(), string);
    }

    public void setContainerLevelACL(AclEntry[] aclEntryArray, String string) {
        this.verifyNotDisembodied();
        SecurityAccess.setContainerLevelACL(this.getServer(), this.getView(), 0, this.getItemID(), string, aclEntryArray);
    }

    public void update() {
        boolean bl = this.isNew();
        if (bl) {
            this.verifyNotDisembodied();
        }
        String string = null;
        boolean bl2 = this.isDirty(this.getServer().getPropertyNames().COMMENT);
        if (bl2) {
            string = this.unsetDirtyComment();
        }
        this.getCachedObject().setDirty(true);
        Vector<Folder> vector = new Vector<Folder>();
        vector.addElement(this);
        if (this.isDirty()) {
            try {
                this.getServer().putItems(vector);
            }
            catch (ServerException serverException) {
                if (bl) {
                    this.getParentFolder().deleteSubFolder(this);
                }
                throw serverException;
            }
        }
        if (!this.m_unsavedNewProperties.isEmpty()) {
            Enumeration enumeration = this.m_unsavedNewProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                super.put(string2, this.m_unsavedNewProperties.get(string2));
            }
            this.getServer().putItems(vector);
            this.m_unsavedNewProperties.clear();
        }
        if (bl) {
            this.getParentFolder().addItem(this);
        }
        this.discard();
        this.retrieveReplicatedData();
        if (bl2) {
            this.updateRevisionComment(string);
        }
    }

    protected String unsetDirtyComment() {
        String string = this.getServer().getPropertyNames().COMMENT;
        if (this.m_unsavedNewProperties.containsKey(string)) {
            this.m_unsavedNewProperties.remove(string);
        }
        return super.unsetDirtyComment();
    }

    private boolean isSetOnCreate(String string) {
        PropertyNames propertyNames = this.getPropertyNames();
        return string.equalsIgnoreCase(propertyNames.FOLDER_NAME) || string.equalsIgnoreCase(propertyNames.FOLDER_DESCRIPTION) || string.equalsIgnoreCase(propertyNames.FOLDER_WORKING_FOLDER);
    }

    static Folder read(Command command, Server server, View view, Hashtable hashtable) throws IOException {
        Folder folder = null;
        int n = command.readInt();
        if (hashtable == null) {
            folder = new Folder(server, view);
        } else {
            Folder folder2 = (Folder)hashtable.get(new Integer(n));
            if (folder2 != null) {
                folder = folder2;
                folder.setCachedObject(new Item_Data(folder.getItemID(), folder.getType().getData()));
            } else {
                folder = new Folder(server, view);
            }
        }
        folder.setItemID(n);
        folder.readGuts(command);
        return folder;
    }

    private void readGuts(Command command) throws IOException {
        this.initializeReplicaValue(this.getPropertyNames().FOLDER_NAME, (Object)command.readString());
        String string = command.readString();
        this.initializeReplicaValue(this.getPropertyNames().FOLDER_WORKING_FOLDER, (Object)string);
        this.setOriginalPathFragment(string);
        int n = command.readInt();
        this.initializeReplicaValue(this.getPropertyNames().FOLDER_EXCLUDE_FLAGS, (Object)new Integer(n));
        this.initializeReplicaValue(this.getPropertyNames().FOLDER_EXCLUDE_SPEC, (Object)command.readString());
    }

    public String toString() {
        return this.getName();
    }

    public boolean getUserVisible() {
        return this.m_userVisible;
    }

    public void setUserVisible(boolean bl) {
        this.m_userVisible = bl;
    }

    public boolean resolveUserVisible() {
        Folder folder = this;
        while (folder != null) {
            if (!folder.getUserVisible()) {
                return false;
            }
            folder = folder.getParentFolder();
        }
        return true;
    }

    public Item copy() {
        try {
            this.populate();
        }
        catch (ServerException serverException) {
            // empty catch block
        }
        Folder folder = new Folder(this.getServer(), this.getView());
        this.copyInto(folder);
        return folder;
    }

    protected void copyInto(Folder folder) {
        Object v;
        Object k;
        super.copyInto(folder);
        folder.setParentFolder(this.getParentFolder());
        folder.m_parentFolderCached = true;
        int n = this.m_subFolders.length;
        Folder[] folderArray = new Folder[n];
        int n2 = 0;
        while (n2 < n) {
            folderArray[n2] = this.m_subFolders[n2];
            ++n2;
        }
        folder.m_subFolders = folderArray;
        folder.m_alternatePathFragment = this.m_alternatePathFragment;
        folder.m_caseSensitive = this.m_caseSensitive;
        folder.m_eol = this.m_eol;
        folder.m_originalPathFragment = this.m_originalPathFragment;
        folder.m_syncAvailable = this.m_syncAvailable;
        folder.m_timestampIDs = this.m_timestampIDs;
        folder.m_timestampProperties = this.m_timestampProperties;
        folder.m_userVisible = this.m_userVisible;
        if (this.m_unsavedNewProperties != null) {
            folder.m_unsavedNewProperties = new Hashtable();
            Enumeration enumeration = this.m_unsavedNewProperties.keys();
            while (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                v = this.m_unsavedNewProperties.get(k);
                folder.m_unsavedNewProperties.put(k, v);
            }
        }
        if (this.m_itemCollections != null) {
            folder.m_itemCollections = new Hashtable();
            Enumeration enumeration = this.m_itemCollections.keys();
            while (enumeration.hasMoreElements()) {
                k = enumeration.nextElement();
                v = this.m_itemCollections.get(k);
                folder.m_itemCollections.put(k, v);
            }
        }
    }

    public boolean isEqualTo(Item item) {
        return super.isEqualTo(item);
    }

    public void addFolderListener(IFolderListener iFolderListener, int n) {
        this.verifyNotDisembodied();
        Folder folder = this;
        if (folder == null) {
            throw null;
        }
        MyFolderScope myFolderScope = new MyFolderScope(folder, n);
        this.getView().addFolderListener(iFolderListener, myFolderScope);
    }

    public void removeFolderListener(IFolderListener iFolderListener, int n) {
        Folder folder = this;
        if (folder == null) {
            throw null;
        }
        MyFolderScope myFolderScope = new MyFolderScope(folder, n);
        this.getView().removeFolderListener(iFolderListener, myFolderScope);
    }

    public void addItemListener(IItemListener iItemListener, Type type, int n) {
        this.verifyNotDisembodied();
        Folder folder = this;
        if (folder == null) {
            throw null;
        }
        MyItemScope myItemScope = folder.new MyItemScope(n);
        this.getView().addItemListener(iItemListener, type, myItemScope);
    }

    public void addItemListener(IItemListener iItemListener, Type type, String[] stringArray, int n) {
        this.verifyNotDisembodied();
        Folder folder = this;
        if (folder == null) {
            throw null;
        }
        MyItemScope myItemScope = folder.new MyItemScope(n);
        this.getView().addItemListener(iItemListener, type, stringArray, myItemScope);
    }

    public void removeItemListener(IItemListener iItemListener, Type type, int n) {
        Folder folder = this;
        if (folder == null) {
            throw null;
        }
        MyItemScope myItemScope = folder.new MyItemScope(n);
        this.getView().removeItemListener(iItemListener, type, myItemScope);
    }

    protected String getDisembodiedMessage() {
        return Res.getString(ResIDs.DISEMBODIED_FOLDER_OPERATION);
    }

    public ISecurableContainer getParentContainer() {
        return this.hasParentFolder() ? this.getParentFolder() : this.getView();
    }

    public Folder(Server server) {
        super(server.getTypeNames().FOLDER, server, null);
    }

    public Folder(Folder folder) {
        this(folder, EMPTY, EMPTY);
    }

    public Folder(Folder folder, String string, String string2) {
        super(folder.getTypeNames().FOLDER, folder.getServer(), folder.getView());
        this.setName(string);
        this.setDefaultPathFragment(string2);
        folder.addSubFolder(this);
    }

    Folder(Server server, View view) {
        super(server.getTypeNames().FOLDER, server, view);
    }

    private class MyFolderScope
    implements FolderEventScope {
        private Folder m_parent;
        private int m_depth;
        private final /* synthetic */ Folder this$0;

        public boolean isMyEvent(Folder folder) {
            return this.isMyEvent(folder, this.m_depth);
        }

        private boolean isMyEvent(Folder folder, int n) {
            if (folder == null) {
                return false;
            }
            if (folder.getItemID() == this.this$0.getItemID()) {
                return true;
            }
            if (n == 0) {
                return false;
            }
            if (n > 0) {
                --n;
            }
            return this.isMyEvent(folder.getParentFolder(), n);
        }

        public boolean isEqualTo(FolderEventScope folderEventScope) {
            if (folderEventScope != null && folderEventScope instanceof MyFolderScope) {
                MyFolderScope myFolderScope = (MyFolderScope)folderEventScope;
                return this.m_parent == myFolderScope.m_parent && this.m_depth == myFolderScope.m_depth;
            }
            return false;
        }

        MyFolderScope(Folder folder, int n) {
            this.m_parent = this.this$0 = folder;
            this.m_depth = -1;
            this.m_depth = n;
        }
    }

    private class MyItemScope
    implements ItemEventScope {
        private FolderEventScope m_scope = null;

        public boolean isMyEvent(Folder folder, Item item) {
            return folder != null && this.m_scope.isMyEvent(folder);
        }

        public boolean isEqualTo(ItemEventScope itemEventScope) {
            if (itemEventScope != null && itemEventScope instanceof MyItemScope) {
                return this.m_scope.isEqualTo(((MyItemScope)itemEventScope).m_scope);
            }
            return false;
        }

        MyItemScope(int n) {
            Folder folder2 = Folder.this;
            if (folder2 == null) {
                throw null;
            }
            this.m_scope = new MyFolderScope(folder2, n);
        }
    }
}

