/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.GroupAccount;
import com.starbase.starteam.Group_Data;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerException;
import com.starbase.util.QuickSort;

public class Group
extends CacheRef {
    private Server m_server;
    private boolean m_bUserIDsMadePublic = false;

    private Group_Data getData() {
        return (Group_Data)this.getCachedObject();
    }

    public Group copy() {
        return new Group(this.m_server, (Group_Data)this.getData().copy());
    }

    public boolean isEqualTo(Group group) {
        if (group == null) {
            return false;
        }
        if (this.getData().isEqualTo(group.getData())) {
            int[] nArray;
            int[] nArray2 = this.fetchMemberUserIDs(false);
            if (nArray2.length != (nArray = group.fetchMemberUserIDs(false)).length) {
                return false;
            }
            boolean bl = false;
            int n = nArray2.length;
            int n2 = 0;
            while (n2 < n) {
                if (nArray2[n2] != nArray[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) {
                QuickSort.sortInts(nArray2);
                QuickSort.sortInts(nArray);
                n2 = 0;
                while (n2 < n) {
                    if (nArray2[n2] != nArray[n2]) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public Server getServer() {
        return this.m_server;
    }

    public int getID() {
        return this.getData().getID();
    }

    private GroupAccount getGroupAccount() {
        return this.m_server.getAdministration().findGroupAccount(this.getID());
    }

    public int[] fetchMemberUserIDs(boolean bl) {
        if (this.isDeleted()) {
            return new int[0];
        }
        GroupAccount groupAccount = this.getGroupAccount();
        if (groupAccount == null || groupAccount.isDeleted()) {
            return new int[0];
        }
        try {
            if (this.m_bUserIDsMadePublic) {
                return groupAccount.fetchMemberUserIDs(bl);
            }
            return groupAccount.getUserIDsFromAccounts(bl);
        }
        catch (ServerException serverException) {
            if (this.isUserGroupNotFoundException(serverException)) {
                this.m_server.getAdministration().refreshAccounts();
                return this.fetchMemberUserIDs(bl);
            }
            throw serverException;
        }
    }

    private boolean isUserGroupNotFoundException(ServerException serverException) {
        String string = serverException.getClassName();
        int n = serverException.getErrorCode();
        return string.equals("CStSecurityException") && n == 7;
    }

    public boolean isMember(int n) {
        return this.getGroupAccount().isMember(n);
    }

    public String getName() {
        return this.getData().getName();
    }

    public boolean isDeleted() {
        return this.getData().isDeleted();
    }

    public String toString() {
        return this.getName();
    }

    String toDebugString() {
        return "Group: " + this.getName() + " (id: 0x" + Integer.toHexString(this.getID()) + (this.isDeleted() ? " deleted)" : ")");
    }

    Group(Server server, Group_Data group_Data) {
        super(group_Data);
        this.m_server = server;
        this.m_bUserIDsMadePublic = this.m_server.getSupportedFeatures().hasGroupMembers();
    }
}

