/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Cacheable;
import com.starbase.starteam.vts.comm.Command;
import java.io.IOException;

class GroupAccount_Data
extends Cacheable {
    private int m_id = -1;
    private int m_rights = 0;
    private String m_name = "";
    private String m_description = "";
    private int m_parentID = -1;
    private boolean m_active = true;

    boolean isNew() {
        return this.m_id == -1;
    }

    boolean isDeleted() {
        return !this.m_active;
    }

    void setDeleted(boolean bl) {
        this.m_active = !bl;
    }

    int getID() {
        return this.m_id;
    }

    void setID(int n) {
        this.m_id = n;
    }

    String getName() {
        return this.m_name;
    }

    void setName(String string) {
        this.m_name = string;
    }

    String getDescription() {
        return this.m_description;
    }

    void setDescription(String string) {
        this.m_description = string;
    }

    int getParentID() {
        return this.m_parentID;
    }

    void setParentID(int n) {
        this.m_parentID = n;
    }

    int getPermissionsFlags() {
        return this.m_rights;
    }

    boolean hasPermission(int n) {
        return (this.m_rights & n) != 0;
    }

    void addPermission(int n) {
        this.m_rights |= n;
    }

    void removePermission(int n) {
        this.m_rights &= ~n;
    }

    boolean isBuiltin() {
        int n = this.m_id & Integer.MAX_VALUE;
        return n == 0 || n == 1 || n == 2;
    }

    void read(Command command) throws IOException {
        this.m_id = command.readInt();
        this.m_parentID = command.readInt();
        this.m_rights = command.readInt();
        this.m_name = command.readString();
        this.m_description = command.readString();
    }

    void write(Command command) throws IOException {
        command.writeInt(this.m_id);
        command.writeInt(this.m_parentID);
        command.writeInt(this.m_rights);
        command.writeString(this.m_name);
        command.writeString(this.m_description);
    }

    public boolean isEqualTo(Cacheable cacheable) {
        if (cacheable != null && cacheable instanceof GroupAccount_Data) {
            GroupAccount_Data groupAccount_Data = (GroupAccount_Data)cacheable;
            return this.getID() == groupAccount_Data.getID() && this.getParentID() == groupAccount_Data.getParentID() && this.getPermissionsFlags() == groupAccount_Data.getPermissionsFlags() && this.getName().equals(groupAccount_Data.getName()) && this.getDescription().equals(groupAccount_Data.getDescription());
        }
        return false;
    }

    GroupAccount_Data() {
    }
}

