/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.util.Assert;

public class GroupNode {
    private GroupNode[] m_children = new GroupNode[0];
    private boolean m_bExpanded = false;
    private int m_start = -1;
    private int m_length = -1;
    private String m_name = null;
    private GroupNode m_parent = null;

    public String getName() {
        return this.m_name;
    }

    public int getDepth() {
        if (this.m_parent == null) {
            return 0;
        }
        return 1 + this.m_parent.getDepth();
    }

    public boolean isExpanded() {
        return this.m_bExpanded;
    }

    public void setExpanded(boolean bl) {
        this.m_bExpanded = bl;
        if (bl) {
            if (this.m_parent != null) {
                this.m_parent.setExpanded(bl);
            }
        } else {
            int n = 0;
            while (n < this.m_children.length) {
                this.m_children[n].setExpanded(bl);
                ++n;
            }
        }
    }

    public int getNumChildren() {
        return this.m_children.length;
    }

    public GroupNode[] getChildren() {
        return this.m_children;
    }

    public boolean isLeafNode() {
        return this.m_children.length == 0;
    }

    public GroupNode getParent() {
        return this.m_parent;
    }

    public void addChild(GroupNode groupNode) {
        int n = this.m_children.length;
        GroupNode[] groupNodeArray = new GroupNode[n + 1];
        System.arraycopy(this.m_children, 0, groupNodeArray, 0, n);
        groupNodeArray[n] = groupNode;
        this.m_children = groupNodeArray;
        groupNode.m_parent = this;
    }

    public int getNumVisibleLines() {
        if (this.m_bExpanded) {
            if (!this.isLeafNode()) {
                int n = 1;
                int n2 = 0;
                while (n2 < this.m_children.length) {
                    n += this.m_children[n2].getNumVisibleLines();
                    ++n2;
                }
                return n;
            }
            return this.m_length + 1;
        }
        return 1;
    }

    public int getStart() {
        return this.m_start;
    }

    public int getLength() {
        return this.m_length;
    }

    void increment() {
        ++this.m_length;
        if (this.m_parent != null) {
            this.m_parent.increment();
        }
    }

    public void toDebugString() {
        CharSequence charSequence;
        boolean bl = this.m_parent != null;
        boolean bl2 = !this.isLeafNode();
        String string = bl ? this.m_parent.getName() : "";
        String string2 = "";
        if (bl2) {
            charSequence = new StringBuffer();
            int n = 0;
            while (n < this.m_children.length) {
                if (n > 0) {
                    ((StringBuffer)charSequence).append(", ");
                }
                ((StringBuffer)charSequence).append(this.m_children[n].getName());
                ++n;
            }
            string2 = ((StringBuffer)charSequence).toString();
        }
        charSequence = "";
        if (this.m_parent == null) {
            charSequence = "**ROOT** ";
        }
        if (this.isLeafNode()) {
            charSequence = (String)charSequence + "--LEAF-- ";
        }
        if (((String)charSequence).equals("")) {
            charSequence = "\t\t\t\t\t";
        }
        System.out.println(this.m_start + ", " + this.m_length + (this.m_bExpanded ? ", expanded" : ", collapsed") + ", >>>" + this.m_name + "<<<" + (bl ? ", parent[" + string + "]" : "") + (bl2 ? ", children[" + string2 + "]" : ""));
    }

    public GroupNode(String string, int n, int n2) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        } else {
            if (string.equals("")) {
                throw new IllegalArgumentException(Res.formatKey(ResIDs.GROUPNODE_REQUIRES_A_VALID_NAME_FMT, new Object[]{string}));
            }
            if (n < 0) {
                throw new IllegalArgumentException(Res.formatKey(ResIDs.GROUPNODE_STARTING_INDEX_FMT, new Object[]{new Integer(n)}));
            }
            if (n2 < 0) {
                throw new IllegalArgumentException(Res.formatKey(ResIDs.GROUPNODE_LENGTH_LESS_THAN_ZERO_FMT, new Object[]{new Integer(n2)}));
            }
        }
        this.m_name = string;
        this.m_start = n;
        this.m_length = n2;
    }
}

