/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.StringTokenizer;

public class IPRange {
    private int m_min;
    private int m_max;
    private EncryptionAlgorithm m_alg;

    public String getMinIP() {
        return IPRange.getAddress(this.m_min);
    }

    public void setMinIP(String string) {
        this.m_min = IPRange.parseIP(string);
    }

    public String getMaxIP() {
        return IPRange.getAddress(this.m_max);
    }

    public void setMaxIP(String string) {
        this.m_max = IPRange.parseIP(string);
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.m_alg;
    }

    public void setAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm == null) {
            Assert.nullArgument("EncryptionAlgorithm");
        }
        this.m_alg = encryptionAlgorithm;
    }

    static int parseIP(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_IP_ADDRESS_FMT, new Object[]{string}));
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            block5: {
                String string2 = stringTokenizer.nextToken();
                try {
                    int n3 = Integer.parseInt(string2);
                    if (n3 >= 0 && n3 <= 255) {
                        n += n3 << (3 - n2) * 8;
                        break block5;
                    }
                    throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_IP_ADDRESS_FMT, new Object[]{string}));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_IP_ADDRESS_FMT, new Object[]{string}));
                }
            }
            ++n2;
        }
        return n;
    }

    static String getAddress(int n) {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(n >> 24 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n >> 16 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n >> 8 & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(n & 0xFF);
        return stringBuffer.toString();
    }

    static IPRange read(Command command) throws IOException {
        IPRange iPRange = new IPRange();
        iPRange.readGuts(command);
        return iPRange;
    }

    void readGuts(Command command) throws IOException {
        command.readInt();
        this.m_min = command.readInt();
        this.m_max = command.readInt();
        this.m_alg = this.getAlg(command.readInt());
    }

    void writeGuts(Command command) throws IOException {
        command.writeInt(-1);
        command.writeInt(this.m_min);
        command.writeInt(this.m_max);
        command.writeInt(this.getAlgID(this.m_alg));
    }

    private EncryptionAlgorithm getAlg(int n) {
        switch (n) {
            case 0: {
                return EncryptionAlgorithm.NULL;
            }
            case 1: {
                return EncryptionAlgorithm.RC4;
            }
            case 2: {
                return EncryptionAlgorithm.RC2_ECB;
            }
            case 3: {
                return EncryptionAlgorithm.RC2_CBC;
            }
            case 4: {
                return EncryptionAlgorithm.RC2_CFB;
            }
        }
        Assert.internalError("IPRange.EncryptionAlgorithm(), id=" + n);
        return null;
    }

    private int getAlgID(EncryptionAlgorithm encryptionAlgorithm) {
        if (encryptionAlgorithm == EncryptionAlgorithm.NULL) {
            return 0;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC4) {
            return 1;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_ECB) {
            return 2;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CBC) {
            return 3;
        }
        if (encryptionAlgorithm == EncryptionAlgorithm.RC2_CFB) {
            return 4;
        }
        Assert.internalError("IPRange.getAlgID(), alg=" + encryptionAlgorithm);
        return -1;
    }

    public String toString() {
        return "[" + this.getMinIP() + " to " + this.getMaxIP() + " requires: " + this.m_alg + "]";
    }

    private IPRange() {
    }

    public IPRange(String string, String string2, EncryptionAlgorithm encryptionAlgorithm) {
        this.setAlgorithm(encryptionAlgorithm);
        this.setMinIP(string);
        this.setMaxIP(string2);
    }
}

