/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.Cacheable;
import com.starbase.starteam.Catalog;
import com.starbase.starteam.CmdCreateAttachment;
import com.starbase.starteam.CmdGetAttachment;
import com.starbase.starteam.CmdGetItemBehavior;
import com.starbase.starteam.CmdGetItemFromHistory;
import com.starbase.starteam.CmdGetItemReference;
import com.starbase.starteam.CmdGetItemReferences;
import com.starbase.starteam.CmdGetItemRevisions;
import com.starbase.starteam.CmdListSetRead;
import com.starbase.starteam.CmdLockItem;
import com.starbase.starteam.CmdMergeDelete;
import com.starbase.starteam.CmdMergeHistory;
import com.starbase.starteam.CmdMergeRecord;
import com.starbase.starteam.CmdMergeResolve;
import com.starbase.starteam.CmdMoveItems;
import com.starbase.starteam.CmdSetBookmark;
import com.starbase.starteam.CmdSetItemBehavior;
import com.starbase.starteam.CmdUpdateRevisionComment;
import com.starbase.starteam.DisembodiedItemException;
import com.starbase.starteam.Folder;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.ISecurableObject;
import com.starbase.starteam.ItemBehavior;
import com.starbase.starteam.ItemReference;
import com.starbase.starteam.ItemRevision;
import com.starbase.starteam.Item_Cache;
import com.starbase.starteam.Item_Data;
import com.starbase.starteam.Label;
import com.starbase.starteam.LabelMethods;
import com.starbase.starteam.MergePoint;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.NotWritableException;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Query;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.RevisionID;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.SimpleTypedResource;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypeNames;
import com.starbase.starteam.TypeNotFoundException;
import com.starbase.starteam.Type_Data;
import com.starbase.starteam.TypedResource_Data;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.NetMonitor;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.starteam.vts.pickle.ItemConfig;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Item
extends SimpleTypedResource
implements ISecurableObject {
    private static final String EMPTY_STRING = "";
    private int m_VMID;
    private View m_view;
    private Server m_server;
    private BitSet m_dirtyProperties;
    private boolean m_bIsNew = true;
    private Folder m_parentFolder;
    private boolean m_disembodied = false;

    OLEDate getSnapshotTime() {
        Item_Data item_Data = (Item_Data)this.getCachedObject();
        return item_Data.getSnapshotTime();
    }

    void setSnapshotTime(OLEDate oLEDate) {
        Item_Data item_Data = (Item_Data)this.getCachedObject();
        item_Data.setSnapshotTime(oLEDate);
    }

    public static Item createItem(String string, Folder folder) {
        if (folder == null) {
            Assert.nullArgument("Folder");
        }
        Server server = folder.getServer();
        Type type = folder.getServer().typeForName(string);
        Item item = server.newItem(type, folder.getView());
        item.setParentFolder(folder);
        return item;
    }

    public Item copy() {
        try {
            this.populate();
        }
        catch (ServerException serverException) {
            // empty catch block
        }
        Item item = Item.createItem(this.getType().getName(), this.m_parentFolder);
        this.copyInto(item);
        return item;
    }

    protected void copyInto(Item item) {
        super.copyInto(item);
        item.m_VMID = this.m_VMID;
        item.m_bIsNew = this.m_bIsNew;
        item.m_disembodied = this.m_disembodied;
        item.m_dirtyProperties = (BitSet)this.m_dirtyProperties.clone();
    }

    public boolean isEqualTo(Item item) {
        if (item == null || item.m_VMID != this.m_VMID || item.m_view.getID() != this.m_view.getID() || item.m_bIsNew != this.m_bIsNew || item.m_disembodied != this.m_disembodied || item.m_parentFolder == null != (this.m_parentFolder == null)) {
            return false;
        }
        if (this.m_parentFolder != null && item.m_parentFolder.getItemID() != this.m_parentFolder.getItemID()) {
            return false;
        }
        this.populate();
        item.populate();
        return super.isEqualTo(item);
    }

    protected void initializeCachedProperty(Property property, Object object) {
        this.initializeReplicaValue(property, object);
    }

    protected int getRefID() {
        return this.getItemID();
    }

    Cacheable getCachedObject() {
        Cacheable cacheable = super.getCachedObject();
        if (cacheable == null) {
            cacheable = new Item_Data(this.getItemID(), this.getType().getData());
            this.setCachedObject(cacheable);
        }
        return cacheable;
    }

    void setParentFolder(Folder folder) {
        this.m_parentFolder = folder;
    }

    public Folder getParentFolder() {
        this.verifyNotDisembodied();
        if (this.m_parentFolder == null) {
            this.m_parentFolder = this.getServer().getParentFolder(this);
        }
        return this.m_parentFolder;
    }

    Folder getParentFolderWithoutRetrieval() {
        return this.m_parentFolder;
    }

    public void move(Folder folder) {
        this.verifyNotDisembodied();
        Vector<Item> vector = new Vector<Item>();
        vector.addElement(this);
        CmdMoveItems cmdMoveItems = new CmdMoveItems(vector, folder);
        cmdMoveItems.execute(folder.getServer().useConnection(), folder.getServer().getSession().getID(), folder.getServer().getViewSession(folder.getView()).getID(), this.getServer().getClassID(this.getType().getName()));
        this.getParentFolder().removeItem(this);
        this.setParentFolder(folder);
        this.relocate(folder.getServer(), folder.getView());
        folder.addItem(this);
    }

    public void remove() {
        Vector<Item> vector = new Vector<Item>();
        vector.addElement(this);
        this.getServer().deleteItems(vector);
        if (!this.isDisembodied()) {
            this.getParentFolder().removeItem(this);
        }
    }

    public ItemReference[] getReferences() {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        CmdGetItemReferences cmdGetItemReferences = new CmdGetItemReferences(server.typeForName(this.getTypeNames().ITEM_REFERENCE), this.getItemID(), this.getObjectID(), this.getRevisionNumber());
        cmdGetItemReferences.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(this.getView()).getID(), server.getComponentID(ServerComponentInfo.PROJECT));
        Vector vector = cmdGetItemReferences.getReferences();
        Object[] objectArray = new ItemReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ItemReference getReference(ViewConfiguration viewConfiguration) {
        this.verifyNotDisembodied();
        Server server = this.getServer();
        CmdGetItemReference cmdGetItemReference = new CmdGetItemReference(server.typeForName(this.getTypeNames().ITEM_REFERENCE), this.getItemID(), viewConfiguration);
        cmdGetItemReference.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(this.getView()).getID(), server.getComponentID(ServerComponentInfo.PROJECT));
        return cmdGetItemReference.getItemReference();
    }

    public ItemRevision[] getItemRevisions() {
        this.verifyNotDisembodied();
        return CmdGetItemRevisions.getItemRevisions(this);
    }

    private void initialize(String string, View view, Server server) {
        Type type = server.typeForName(string);
        this.initialize(type, view, server);
    }

    private void initialize(Type type, View view, Server server) {
        if (!server.isTypeSupported(type.getName())) {
            throw new TypeNotFoundException(type.getName(), server);
        }
        this.setItemID(-1);
        this.setServer(server);
        this.setView(view);
        this.markClean();
    }

    void relocate(Server server, View view) {
        this.setServer(server);
        this.setView(view);
    }

    public int getItemID() {
        return this.m_VMID;
    }

    void setItemID(int n) {
        if (n != -1) {
            this.setNew(false);
        }
        this.m_VMID = n;
        ((Item_Data)this.getCachedObject()).setItemID(n);
    }

    public int getObjectID() {
        return (Integer)this.getCachedValue(this.getPropertyNames().OBJECT_ID);
    }

    public boolean isBranchable() {
        return this.getType().hasPropertyForName(this.getPropertyNames().ROOT_OBJECT_ID);
    }

    public int getRootObjectID() {
        if (this.isBranchable()) {
            return (Integer)this.getCachedValue(this.getPropertyNames().ROOT_OBJECT_ID);
        }
        return this.getObjectID();
    }

    public int getRevisionNumber() {
        return (Integer)this.getCachedValue(this.getPropertyNames().REVISION_NUMBER);
    }

    public int getParentRevision() {
        if (this.isBranchable()) {
            return (Integer)this.getCachedValue(this.getPropertyNames().PATH_REVISION);
        }
        return 0;
    }

    public int getLocker() {
        return (Integer)this.getCachedValue(this.getPropertyNames().EXCLUSIVE_LOCKER);
    }

    public String getComment() {
        return (String)this.getCachedValue(this.getPropertyNames().COMMENT);
    }

    public void setComment(String string) {
        this.setCachedValue(this.getPropertyNames().COMMENT, (Object)string);
    }

    public OLEDate getModifiedTime() {
        return (OLEDate)this.getCachedValue(this.getPropertyNames().MODIFIED_TIME);
    }

    public int getModifiedBy() {
        return (Integer)this.getCachedValue(this.getPropertyNames().MODIFIED_USER_ID);
    }

    public OLEDate getCreatedTime() {
        return (OLEDate)this.getCachedValue(this.getPropertyNames().CREATED_TIME);
    }

    public int getCreatedBy() {
        return (Integer)this.getCachedValue(this.getPropertyNames().CREATED_USER_ID);
    }

    public String getDotNotation() {
        return (String)this.getCachedValue(this.getPropertyNames().DOTNOTATION);
    }

    public int getViewVersion() {
        int n = this.getParentRevision();
        int n2 = this.getRevisionNumber();
        return n + n2 + 1;
    }

    public static int getViewVersionFromDotNotation(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2);
            n += 1 + n2;
        }
        return n;
    }

    public static int getBranchRevisionFromDotNotation(String string) {
        int n = string.lastIndexOf(".");
        int n2 = string.length();
        if (n == -1 || n == n2 - 1) {
            throw new IllegalArgumentException(ResIDs.INVALID_DOT_NOTATION);
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    public Server getServer() {
        return this.m_server;
    }

    protected void setServer(Server server) {
        this.m_server = server;
    }

    public View getView() {
        return this.m_view;
    }

    void setView(View view) {
        this.m_view = view;
    }

    public void lock() {
        this.putLock(1, false);
    }

    public void unlock() {
        this.putLock(0, false);
    }

    public void putLock(int n, boolean bl) {
        CmdLockItem cmdLockItem = new CmdLockItem(this.getItemID(), n, bl);
        cmdLockItem.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getType().getClassID());
        int n2 = cmdLockItem.getExclusiveID();
        this.initializeReplicaValue(this.getPropertyNames().EXCLUSIVE_LOCKER, (Object)new Integer(n2));
        this.initializeReplicaValue(this.getPropertyNames().NON_EXCLUSIVE_LOCKERS, (Object)this.getNonExclusiveLockers(cmdLockItem.getNonExclusiveIDs()));
    }

    private String getNonExclusiveLockers(int[] nArray) {
        Catalog catalog = this.getServer().typeForName(this.getServer().getTypeNames().USER).getCatalog();
        String string = EMPTY_STRING;
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            Object object = catalog.getPrimaryDescriptor(n2);
            if (object == null) {
                catalog.refresh();
            }
            if (!string.equals(EMPTY_STRING)) {
                string = string + ", ";
            }
            string = string + catalog.getPrimaryDescriptor(n2).toString();
            ++n;
        }
        return string;
    }

    public Item[] getHistory() {
        if (this.isDisembodied()) {
            return this.getView().getHistoryForItemID(this.getItemID(), this.getType());
        }
        Query query = Query.newQueryVersionsOf(this);
        Vector vector = this.getServer().getItems(query);
        int n = vector.size();
        Object[] objectArray = new Item[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Item getFromHistory(ItemConfig itemConfig, String[] stringArray) {
        Item item = null;
        Server server = this.getServer();
        item = server.newItem(this.getType(), this.getView());
        item.setItemID(this.getItemID());
        item.setParentFolder(this.getParentFolder());
        CmdGetItemFromHistory cmdGetItemFromHistory = new CmdGetItemFromHistory(item, stringArray, itemConfig);
        try {
            cmdGetItemFromHistory.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(this.getView()).getID(), server.getClassID(this.getType().getName()));
        }
        catch (ServerException serverException) {
            return null;
        }
        return item;
    }

    public Item getFromHistoryByVersion(int n) {
        Item item = this;
        synchronized (item) {
            Item item2 = null;
            Item[] itemArray = this.getHistory();
            int n2 = 0;
            while (n2 < itemArray.length) {
                Item item3 = itemArray[n2];
                if (item3.getViewVersion() == n) {
                    item2 = item3;
                    break;
                }
                ++n2;
            }
            Item item4 = item2;
            Object var3_8 = null;
            return item4;
        }
    }

    public Item getFromHistoryByLabelID(int n) {
        ItemConfig itemConfig = new ItemConfig();
        itemConfig.setLabel(n);
        return this.getFromHistory(itemConfig, null);
    }

    public Item getFromHistoryByDate(OLEDate oLEDate) {
        ItemConfig itemConfig = new ItemConfig();
        itemConfig.setTime(oLEDate.getDoubleValue());
        return this.getFromHistory(itemConfig, null);
    }

    public Label[] getAttachedLabels() {
        this.verifyNotDisembodied();
        Item item = this;
        synchronized (item) {
            Label[] labelArray = new LabelMethods(this.getView()).getLabelsOld(this.getItemID(), true, true, false);
            Object var2_3 = null;
            return labelArray;
        }
    }

    public Label[] getAllLabels() {
        this.verifyNotDisembodied();
        Item item = this;
        synchronized (item) {
            Label[] labelArray = new LabelMethods(this.getView()).getLabelsOld(this.getItemID(), true, true, true);
            Object var2_3 = null;
            return labelArray;
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof Item) {
            bl = this.getItemID() == ((Item)object).getItemID();
        }
        return bl;
    }

    public int hashCode() {
        return this.getItemID();
    }

    public String toString() {
        return String.valueOf(this.getItemID());
    }

    public void update() {
        boolean bl = this.isNew();
        if (bl) {
            this.verifyNotDisembodied();
        }
        if (!this.isDirty()) {
            return;
        }
        this.getCachedObject().setDirty(true);
        Vector<Item> vector = new Vector<Item>();
        vector.addElement(this);
        this.getServer().putItems(vector);
        if (bl) {
            this.getParentFolder().addItem(this);
        }
        this.markClean();
        if (!SystemRevisionNumbers.isClientManagedStatus(this.getServer().getRevisionLevel())) {
            this.setCachedObject(null);
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = System.getProperty("line.separator");
        stringBuffer.append(this.getType());
        stringBuffer.append(" item" + string);
        Property[] propertyArray = this.getType().getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            String string2 = propertyArray[n].getName();
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            if (this.hasValue(this.indexForName(string2))) {
                stringBuffer.append(this.get(string2));
            } else {
                stringBuffer.append("[not cached]");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean hasPermission(int n) {
        this.verifyNotDisembodied();
        return SecurityAccess.itemAccessTest(this.getServer(), this.getView(), this.getItemID(), n);
    }

    public AclEntry[] getACL() {
        this.verifyNotDisembodied();
        return SecurityAccess.getItemACL(this.getServer(), this.getView(), this.getItemID());
    }

    public void setACL(AclEntry[] aclEntryArray) {
        this.verifyNotDisembodied();
        SecurityAccess.setItemACL(this.getServer(), this.getView(), this.getItemID(), aclEntryArray);
    }

    public void getAttachment(int n, OutputStream outputStream) throws IOException {
        CmdGetAttachment cmdGetAttachment = new CmdGetAttachment(n, outputStream);
        cmdGetAttachment.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), 0, this.getServer().getClassID(this.getType().getName()));
    }

    public int createAttachment(String string, InputStream inputStream) throws IOException {
        CmdCreateAttachment cmdCreateAttachment = new CmdCreateAttachment(string, inputStream);
        cmdCreateAttachment.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), 0, this.getServer().getClassID(this.getType().getName()));
        return cmdCreateAttachment.getAttachmentID();
    }

    public void getAttachmentToFile(int n, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        try {
            this.getAttachment(n, bufferedOutputStream);
        }
        finally {
            Object var6_5 = null;
            bufferedOutputStream.close();
        }
    }

    public int createAttachmentFromFile(String string, File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        int n = -1;
        try {
            n = this.createAttachment(string, bufferedInputStream);
            return n;
        }
        finally {
            ((FilterInputStream)bufferedInputStream).close();
            return n;
        }
    }

    public int[] getAttachmentIDs() {
        return this.getIntArray(this.getPropertyNames().ATTACHMENT_COUNT, this.getPropertyNames().ATTACHMENT_IDS);
    }

    public String[] getAttachmentNames() {
        return this.getStringArray(this.getPropertyNames().ATTACHMENT_COUNT, this.getPropertyNames().ATTACHMENT_NAMES, "\n", false);
    }

    public void addAttachment(String string, int n) {
        if (string.indexOf("\n") != -1) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ATTACHMENT_NAME_CONTAIN_NEWLINE));
        }
        this.addToIntArray(this.getPropertyNames().ATTACHMENT_COUNT, this.getPropertyNames().ATTACHMENT_IDS, n);
        Object object = this.get(this.getPropertyNames().ATTACHMENT_NAMES);
        String string2 = object != null ? (String)object : EMPTY_STRING;
        string2 = string2.length() == 0 ? string : string2 + "\n" + string;
        this.setCachedValue(this.getPropertyNames().ATTACHMENT_NAMES, (Object)string2);
    }

    protected void removeCachedServerCalculatedProperty(Property property) {
        int n;
        if (!property.isServerCalculated()) {
            Assert.internalError("Item.removeCachedServerCalculatedProperty(), !prop.isServerCalculated()");
        }
        if (this.isDirty(n = property.getCacheIndex())) {
            Assert.internalError("Item.removeCachedServerCalculatedProperty(), isDirty( index )");
        }
        this.discardCachedValue(n);
        if (this.m_newData != null) {
            this.getNewData().remove(n);
        }
        this.setDirty(n, false);
    }

    public void removeAttachment(int n) {
        int[] nArray = this.getAttachmentIDs();
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ATTACHMENT_ID_MISSING));
        }
        String string = EMPTY_STRING;
        int n4 = 0;
        String[] stringArray = this.getAttachmentNames();
        if (n2 >= stringArray.length) {
            Assert.internalError("Item.removeAttachment()");
        }
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (n5 != n2) {
                string = n4++ == 0 ? stringArray[n5] : string + "\n" + stringArray[n5];
            }
            ++n5;
        }
        this.removeFromIntArray(this.getPropertyNames().ATTACHMENT_COUNT, this.getPropertyNames().ATTACHMENT_IDS, n);
        this.setCachedValue(this.getPropertyNames().ATTACHMENT_NAMES, (Object)string);
    }

    public int getInt(String string) throws NoSuchPropertyException, ClassCastException {
        return super.getInt(string);
    }

    public String getString(String string) throws NoSuchPropertyException, ClassCastException {
        return super.getString(string);
    }

    public OLEDate getOLEDate(String string) throws NoSuchPropertyException, ClassCastException {
        return super.getOLEDate(string);
    }

    public double getDouble(String string) throws NoSuchPropertyException, ClassCastException {
        return super.getDouble(string);
    }

    public byte[] getByteArray(String string) throws NoSuchPropertyException, ClassCastException {
        return super.getByteArray(string);
    }

    public int[] getIntArray(String string) throws NoSuchPropertyException, ClassCastException {
        return super.getIntArray(string);
    }

    public PropertyNames getPropertyNames() {
        return super.getPropertyNames();
    }

    public TypeNames getTypeNames() {
        return super.getTypeNames();
    }

    public int[] getPossibleValues(String string) {
        return super.getPossibleValues(string);
    }

    public String getEnumDisplayName(String string, int n) {
        return super.getEnumDisplayName(string, n);
    }

    public MergePoint resolveMergePoint(Item item) {
        this.checkForMergeService(this.getServer());
        this.verifySameTypeAndServer(item);
        RevisionID revisionID = new RevisionID(item.getObjectID(), item.getRevisionNumber());
        RevisionID revisionID2 = new RevisionID(this.getObjectID(), this.getRevisionNumber());
        CmdMergeResolve cmdMergeResolve = new CmdMergeResolve(this.getType().getClassID(), revisionID, revisionID2);
        try {
            cmdMergeResolve.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), 0, 65535);
            return cmdMergeResolve.getMergePoint();
        }
        catch (ServerException serverException) {
            this.checkForMergeService(serverException);
            throw serverException;
        }
    }

    public void recordMergePoint(Item item) {
        this.checkForMergeService(this.getServer());
        this.verifySameTypeAndServer(item);
        MergePoint mergePoint = new MergePoint(new RevisionID(item.getObjectID(), item.getRevisionNumber()), new RevisionID(this.getObjectID(), this.getRevisionNumber()));
        CmdMergeRecord cmdMergeRecord = new CmdMergeRecord(this.getType().getClassID(), mergePoint);
        try {
            cmdMergeRecord.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), 0, 65535);
        }
        catch (ServerException serverException) {
            this.checkForMergeService(serverException);
            throw serverException;
        }
    }

    public void deleteMergePoint(MergePoint mergePoint) {
        this.checkForMergeService(this.getServer());
        CmdMergeDelete cmdMergeDelete = new CmdMergeDelete(this.getType().getClassID(), mergePoint);
        try {
            cmdMergeDelete.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), 0, 65535);
        }
        catch (ServerException serverException) {
            this.checkForMergeService(serverException);
            throw serverException;
        }
    }

    public MergePoint[] getMergeHistory() {
        this.checkForMergeService(this.getServer());
        return CmdMergeHistory.getMergeHistory(this);
    }

    private void verifySameTypeAndServer(Item item) {
        if (item == null) {
            Assert.nullArgument("Item");
        }
        if (!this.getServer().getRepositoryID().equals(item.getServer().getRepositoryID())) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ITEMS_FROM_DIFFERENT_SERVERS));
        }
        if (!this.getType().getName().equals(item.getType().getName())) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ITEMS_DIFFERENT_TYPES));
        }
    }

    private void checkForMergeService(Server server) {
        server.getSupportedFeatures().verifyHasMergeService();
    }

    private void checkForMergeService(ServerException serverException) {
        if (serverException.getClassName().equals("Unknown") && serverException.getErrorCode() == -1) {
            this.getServer().getSupportedFeatures().throwUnsupportedException(ResIDs.SERVER_NO_MERGE_SERVICE);
        }
    }

    public String getParentFolderName() {
        if (this.isDisembodied()) {
            return EMPTY_STRING;
        }
        return this.getParentFolder().getName();
    }

    public String getParentFolderPath() {
        if (this.isDisembodied()) {
            return EMPTY_STRING;
        }
        return this.getParentFolder().getPath();
    }

    public String getParentFolderHierarchy() {
        if (this.isDisembodied()) {
            return EMPTY_STRING;
        }
        return this.getParentFolder().getFolderHierarchy();
    }

    public String getDisplayValue(Property property) {
        Object object = this.getByProperty(property);
        return property.getDisplayValue(object);
    }

    public int getReadStatus() {
        if (this.getServer().getRevisionLevel() >= 72) {
            Object object = this.get(this.getPropertyNames().READ_STATUS_USER_LIST);
            int[] nArray = (int[])object;
            int n = this.getServer().getSession().getUserID();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == n) {
                    return this.getServer().getPropertyEnums().READ_STATUS_UNREAD;
                }
                ++n2;
            }
            return this.getServer().getPropertyEnums().READ_STATUS_READ;
        }
        return this.getInt(this.getPropertyNames().READ_STATUS);
    }

    public void modifyReadStatusForUser(boolean bl) {
        int n = this.getItemID();
        CmdListSetRead cmdListSetRead = new CmdListSetRead(n, bl);
        cmdListSetRead.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getType().getClassID());
    }

    public int[] getPossibleReadStatus() {
        return this.getPossibleValues(this.getPropertyNames().READ_STATUS);
    }

    public String getReadStatusDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().READ_STATUS, n);
    }

    public int getFlag() {
        if (this.getServer().getRevisionLevel() >= 72) {
            Object object = this.get(this.getPropertyNames().FLAG_USER_LIST);
            int[] nArray = (int[])object;
            int n = this.getServer().getSession().getUserID();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == n) {
                    return this.getServer().getPropertyEnums().FLAG_YES;
                }
                ++n2;
            }
            return this.getServer().getPropertyEnums().FLAG_NO;
        }
        return this.getInt(this.getPropertyNames().FLAG);
    }

    public void modifyFlagForUser(boolean bl) {
        int n = this.getItemID();
        CmdSetBookmark cmdSetBookmark = new CmdSetBookmark(n, bl);
        cmdSetBookmark.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getType().getClassID());
    }

    public int[] getPossibleFlag() {
        return this.getPossibleValues(this.getPropertyNames().FLAG);
    }

    public String getFlagDisplayName(int n) {
        return this.getEnumDisplayName(this.getPropertyNames().FLAG, n);
    }

    public String getNewRevisionComment() {
        return EMPTY_STRING;
    }

    public int getMyLock() {
        int n;
        int n2 = this.getInt(this.getPropertyNames().EXCLUSIVE_LOCKER);
        if (n2 == (n = this.getServer().getSession().getUserID())) {
            return 1;
        }
        String string = this.getMyUserName(n);
        String string2 = this.getString(this.getPropertyNames().NON_EXCLUSIVE_LOCKERS);
        if (string2.indexOf(string) != -1) {
            return 2;
        }
        return 0;
    }

    private String getMyUserName(int n) {
        Catalog catalog = this.getServer().typeForName(this.getServer().getTypeNames().USER).getCatalog();
        Object object = catalog.getPrimaryDescriptor(n);
        if (object == null) {
            catalog.refresh();
        }
        return catalog.getPrimaryDescriptor(n).toString();
    }

    private void executeCommand(CommandMacro commandMacro) {
        commandMacro.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getServer().getComponentID(ServerComponentInfo.PROJECT));
    }

    public ItemBehavior getBehavior() {
        this.verifyNotDisembodied();
        CmdGetItemBehavior cmdGetItemBehavior = new CmdGetItemBehavior(this.getItemID());
        this.executeCommand(cmdGetItemBehavior);
        return cmdGetItemBehavior.getItemBehavior();
    }

    public void setFloatingConfig() {
        this.verifyNotDisembodied();
        CmdSetItemBehavior cmdSetItemBehavior = new CmdSetItemBehavior(this.getItemID(), null);
        this.executeCommand(cmdSetItemBehavior);
    }

    public void setFixedConfig(ViewConfiguration viewConfiguration) {
        this.verifyNotDisembodied();
        CmdSetItemBehavior cmdSetItemBehavior = new CmdSetItemBehavior(this.getItemID(), viewConfiguration);
        this.executeCommand(cmdSetItemBehavior);
    }

    public void setBranchOnChange(boolean bl) {
        this.verifyNotDisembodied();
        CmdSetItemBehavior cmdSetItemBehavior = new CmdSetItemBehavior(this.getItemID(), bl);
        this.executeCommand(cmdSetItemBehavior);
    }

    public void updateRevisionComment(String string) {
        int n;
        if (string == null) {
            Assert.nullArgument("String");
        }
        if ((n = this.getItemID()) == -1) {
            throw new IllegalStateException(Res.getString(ResIDs.NEW_ITEM_UPDATE_REVISION_COMMENT));
        }
        int n2 = this.getObjectID();
        int n3 = this.getRevisionNumber();
        CmdUpdateRevisionComment cmdUpdateRevisionComment = new CmdUpdateRevisionComment(n, n2, n3, string);
        cmdUpdateRevisionComment.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this.getView()).getID(), this.getServer().getClassID(this.getType().getName()));
        this.removeCachedServerCalculatedProperty(this.getType().propertyForName(this.getPropertyNames().COMMENT));
    }

    void setDisembodied(boolean bl) {
        this.m_disembodied = bl;
    }

    protected String unsetDirtyComment() {
        String string = EMPTY_STRING;
        try {
            String string2 = this.getServer().getPropertyNames().COMMENT;
            if (this.isDirty(string2)) {
                string = this.getString(string2);
                if (string == null) {
                    string = EMPTY_STRING;
                }
                this.setDirty(string2, false);
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            string = EMPTY_STRING;
        }
        return string;
    }

    public boolean isDisembodied() {
        return this.m_disembodied;
    }

    protected void verifyNotDisembodied() {
        if (this.isDisembodied()) {
            throw new DisembodiedItemException(this.getDisembodiedMessage(), this);
        }
    }

    protected String getDisembodiedMessage() {
        return Res.getString(ResIDs.DISEMBODIED_ITEM_OPERATION);
    }

    void makeEmbodied(Folder folder) {
        this.setParentFolder(folder);
        if (folder != null) {
            this.m_disembodied = false;
        }
    }

    public Type getType() {
        return super.getType();
    }

    public Object get(String string) throws NoSuchPropertyException {
        Property property = this.getType().propertyForName(string);
        return property.isClientCalculated() ? property.calculate(this) : this.getCachedValue(property);
    }

    public Object getByPropertyID(int n) throws NoSuchPropertyException {
        Property property = this.getType().propertyForPID(n);
        return property.isClientCalculated() ? property.calculate(this) : this.getCachedValue(property);
    }

    public Object getByProperty(Property property) throws NoSuchPropertyException {
        return property.isClientCalculated() ? property.calculate(this) : this.getCachedValue(property);
    }

    public Object put(String string, Object object) throws ClassCastException, NoSuchPropertyException {
        Property property = this.getType().propertyForName(string);
        this.validateForPut(string, property);
        Object object2 = this.adjustDateOnlyValue(property, object);
        return this.setCachedValue(property, object2);
    }

    private Object adjustDateOnlyValue(Property property, Object object) {
        if (property.getTypeCode() == 7 && property.isTimeTruncated() && !OLEDate.CURRENT_SERVER_TIME.equals(object)) {
            return ((OLEDate)property.coerce(object)).getUTCNoon();
        }
        return object;
    }

    public boolean hasValues(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this.hasAllValues();
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2 = this.getType().propertyForName(stringArray[n]).getCacheIndex();
            if (n2 >= 0 && !this.hasValue(n2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isDirty() {
        if (this.isNew()) {
            return true;
        }
        int n = this.getType().getCacheablePropertyCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.isDirty(n2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isNew() {
        return this.m_bIsNew;
    }

    public void discard() {
        if (!this.isDisembodied()) {
            this.getCache().discard(this.getItemID());
        }
        this.setCachedObject(null);
        this.markClean();
    }

    public void populate() {
        Vector<Item> vector = new Vector<Item>();
        vector.addElement(this);
        String[] stringArray = null;
        if (!this.isDisembodied()) {
            this.getCache().populate(this.getView(), vector, stringArray);
        } else {
            this.getServer().populateValues(vector, stringArray);
        }
    }

    public boolean isRefreshRequired() {
        if (!this.isDisembodied()) {
            Vector<Item> vector = new Vector<Item>();
            vector.addElement(this);
            return this.getCache().isRefreshRequired((Vector)vector, (String[])null);
        }
        return true;
    }

    public void refresh() {
        if (this.isRefreshRequired()) {
            if (!this.isDisembodied()) {
                Vector<Item> vector = new Vector<Item>();
                vector.addElement(this);
                this.getCache().refresh(this.getView(), (Vector)vector, (String[])null);
            } else {
                this.discard();
                this.populate();
            }
        }
    }

    public Item getCommonAncestor(Item item) {
        if (this.getType().getClassID() != item.getType().getClassID()) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ITEMS_DIFFERENT_TYPES));
        }
        if (!this.isBranchable()) {
            throw new IllegalArgumentException(Res.getString(ResIDs.ITEM_NOT_BRANCHABLE));
        }
        Item item2 = this;
        synchronized (item2) {
            Vector vector = Item.getTruncatedHistory(this);
            Vector vector2 = Item.getTruncatedHistory(item);
            Enumeration enumeration = vector.elements();
            Enumeration enumeration2 = vector2.elements();
            Item item3 = null;
            while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
                Item item4;
                Item item5 = (Item)enumeration.nextElement();
                if (!Item.sameRevisions(item5, item4 = (Item)enumeration2.nextElement())) break;
                item3 = item5;
            }
            Item item6 = item3;
            Object var3_11 = null;
            return item6;
        }
    }

    private static Vector getTruncatedHistory(Item item) {
        Item item2 = item;
        synchronized (item2) {
            Item[] itemArray = item.getHistory();
            Vector<Item> vector = new Vector<Item>();
            boolean bl = false;
            int n = 0;
            while (n < itemArray.length) {
                Item item3 = itemArray[n];
                if (!bl && Item.sameRevisions(item, item3)) {
                    bl = true;
                }
                if (bl) {
                    vector.insertElementAt(item3, 0);
                }
                ++n;
            }
            Vector<Item> vector2 = vector;
            Object var2_8 = null;
            return vector2;
        }
    }

    private static boolean sameRevisions(Item item, Item item2) {
        return item.getObjectID() == item2.getObjectID() && item.getViewVersion() == item2.getViewVersion();
    }

    protected Item_Cache getCache() {
        if (this.isDisembodied()) {
            Assert.internalError("Item.getCache(), isDisembodied()=true");
        }
        if (this.m_parentFolder == null) {
            Assert.internalError("Item.getCache(), m_parentFolder=null");
        }
        return this.m_parentFolder.getItemCollection((String)this.getType().getName()).m_mgr.getItemCache();
    }

    private String[] getCachedPropertyNames() {
        Enumeration enumeration = this.m_type.getCachedPropertyNames();
        String[] stringArray = new String[this.m_type.getCacheablePropertyCount()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    protected void setNewData(TypedResource_Data typedResource_Data) {
        this.m_newData = typedResource_Data;
    }

    protected void markClean() {
        this.setNewData(null);
        this.m_dirtyProperties = new BitSet(this.getType().getCacheablePropertyCount());
    }

    protected TypedResource_Data getNewData() {
        if (this.m_newData == null) {
            this.m_newData = new TypedResource_Data(this.m_type.getData());
        }
        return this.m_newData;
    }

    protected TypedResource_Data getReplica() {
        Type_Data type_Data = this.getType().getData();
        TypedResource_Data typedResource_Data = this.getCacheData();
        if (!typedResource_Data.m_typeData.sameTimestamp(type_Data)) {
            typedResource_Data.replaceTypeData(type_Data);
        }
        if (this.m_newData != null) {
            TypedResource_Data typedResource_Data2 = this.getNewData();
            if (!typedResource_Data2.m_typeData.sameTimestamp(type_Data)) {
                typedResource_Data2.replaceTypeData(type_Data);
            }
        }
        return typedResource_Data;
    }

    void initializeReplicaValue(String string, Object object) {
        int n = this.indexForName(string);
        this.getReplica().put(n, object);
        this.setNew(false);
    }

    void initializeReplicaValue(Property property, Object object) {
        int n = property.getCacheIndex();
        this.getReplica().put(n, object);
        this.setNew(false);
    }

    protected void validateForPut(String string, Property property) throws ClassCastException, NoSuchPropertyException {
        if (property.isClientCalculated()) {
            throw new NotWritableException(Res.formatKey(ResIDs.CANNOT_MODIFY_CLIENT_CALCULATED_PROPERTY_FMT, new Object[]{string, property.getDisplayName()}));
        }
        if (property.isServerCalculated() && !string.equalsIgnoreCase(this.getPropertyNames().COMMENT)) {
            throw new NotWritableException(Res.formatKey(ResIDs.CANNOT_MODIFY_SERVER_CALCULATED_PROPERTY_FMT, new Object[]{string, property.getDisplayName()}));
        }
    }

    protected boolean hasValue(int n) {
        boolean bl = false;
        bl = this.isNew() ? true : (n < 0 ? false : this.hasReplicatedValue(n) || this.hasNewValue(n));
        return bl;
    }

    protected boolean hasNewValue(int n) {
        return this.m_newData == null ? false : this.getNewData().hasValue(n);
    }

    protected boolean hasReplicatedValue(int n) {
        return this.getCachedObject() == null ? false : this.getReplica().hasValue(n);
    }

    boolean isDirty(String string) {
        return this.isDirty(this.indexForName(string));
    }

    protected boolean isDirty(int n) {
        return this.m_dirtyProperties.get(n);
    }

    protected void setDirty(String string, boolean bl) {
        this.setDirty(this.indexForName(string), bl);
    }

    protected void setDirty(int n, boolean bl) {
        if (bl) {
            this.m_dirtyProperties.set(n);
        } else {
            this.m_dirtyProperties.clear(n);
        }
    }

    protected void setNew(boolean bl) {
        this.m_bIsNew = bl;
    }

    int indexForName(String string) throws NoSuchPropertyException {
        return this.getType().propertyForName(string).getCacheIndex();
    }

    protected void discardCachedValue(int n) {
        if (this.getCachedObject() != null) {
            this.getReplica().remove(n);
        }
    }

    protected Object getCachedValue(String string) throws NoSuchPropertyException {
        return this.getCachedValue(this.getType().propertyForName(string));
    }

    protected Object getReplicaValue(Property property) {
        int n = property.getCacheIndex();
        if (!this.getReplica().hasValue(n)) {
            if (this.isNew()) {
                this.getReplica().put(n, property.getDefaultValue());
            } else {
                String string = this.getType().getName() + ".get(\"" + property.getName() + "\")";
                NetMonitor.println(Res.formatKey(ResIDs.FETCH_TRIGGERED_NET_MONITOR_MSG_FMT, new Object[]{string}));
                this.retrieveReplicatedData();
            }
        }
        return this.getReplica().get(n);
    }

    protected Object getCachedValue(Property property) {
        int n = property.getCacheIndex();
        return this.hasNewValue(n) ? this.getNewData().get(n) : this.getReplicaValue(property);
    }

    Property[] getDirtyProperties() {
        Property[] propertyArray = this.getType().getProperties();
        int n = propertyArray.length;
        Vector<Property> vector = new Vector<Property>();
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (!property.isClientCalculated() && !property.isServerCalculated() && this.isDirty(property.getCacheIndex())) {
                vector.addElement(property);
            }
            ++n2;
        }
        Object[] objectArray = new Property[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void retrieveReplicatedData() {
        Vector<Item> vector = new Vector<Item>();
        vector.addElement(this);
        this.getServer().populateValues(vector, null);
    }

    protected Object setCachedValue(String string, Object object) {
        return this.setCachedValue(this.getType().propertyForName(string), object);
    }

    protected Object setCachedValue(Property property, Object object) {
        Object object2 = this.getReplicaValue(property);
        Object object3 = property.coerce(object);
        if (object3 == null) {
            Assert.nullArgument("Object");
        }
        int n = property.getCacheIndex();
        Object object4 = this.getNewData().put(n, object3);
        this.setDirty(n, !Property.areValuesEqual(object3, object2));
        return object4;
    }

    private boolean hasAllValues() {
        int n = 0;
        while (n < this.getType().getCacheablePropertyCount()) {
            if (!this.hasValue(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getOwner() {
        return SecurityAccess.getItemOwner(this.m_server, this.getView(), this.getItemID());
    }

    public void acquireOwnership() {
        SecurityAccess.acquireItemOwnership(this.m_server, this.getView(), this.getItemID());
    }

    public ISecurableContainer getParentContainer() {
        return this.getParentFolder();
    }

    Item(String string, Server server, View view) {
        super(server.typeForName(string));
        this.initialize(string, view, server);
    }

    Item(String string, Server server, View view, int n) {
        super(server.typeForName(string));
        this.initialize(string, view, server);
        this.setItemID(n);
        this.setNew(false);
    }

    Item(Type type, Server server, View view) {
        super(type);
        this.initialize(type, view, server);
    }

    Item(Type type, Server server, View view, int n) {
        super(type);
        this.initialize(type, view, server);
        this.setItemID(n);
        this.setNew(false);
    }

    public static interface LockType {
        public static final int UNLOCKED = 0;
        public static final int EXCLUSIVE = 1;
        public static final int NONEXCLUSIVE = 2;
        public static final int UNCHANGED = 3;
        public static final int BREAK_FLAG = 16;
    }
}

