/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.CacheRef;
import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.LabelMethods;
import com.starbase.starteam.Label_Data;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Server;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.OLEDate;
import java.io.IOException;

public class Label
extends CacheRef {
    public static final int SCOPE_ITEM_ONLY = 0;
    public static final int SCOPE_ITEM_AND_CONTENTS = 1;
    public static final int SCOPE_ITEM_TREE = 2;
    public static final int NEXT_BUILD_ID = -2;
    private View m_view = null;
    private int m_owningProjectID = -1;
    private int m_owningViewID = -1;
    private int m_cloneID = -1;
    private LabelMethods m_labelMethods = null;
    private Label_Data m_newData = null;

    private Label_Data getData() {
        return this.m_newData == null ? (Label_Data)this.getCachedObject() : this.m_newData;
    }

    private Label_Data getNewData() {
        if (this.m_newData == null) {
            this.m_newData = (Label_Data)this.getData().copy();
        }
        return this.m_newData;
    }

    public Label copy() {
        Label label = new Label(this.m_view, (Label_Data)this.getData().copy());
        label.setOwningProjectID(this.getOwningProjectID());
        label.setOwningViewID(this.getOwningViewID());
        label.m_cloneID = this.m_cloneID;
        label.m_labelMethods = this.m_labelMethods;
        return label;
    }

    public boolean isEqualTo(Label label) {
        if (label == null) {
            return false;
        }
        if (!this.getData().isEqualTo(label.getData())) {
            return false;
        }
        if (this.getOwningProjectID() != label.getOwningProjectID()) {
            return false;
        }
        if (this.getOwningViewID() != label.getOwningViewID()) {
            return false;
        }
        return this.m_cloneID == label.m_cloneID;
    }

    public View getView() {
        return this.m_view;
    }

    public int getID() {
        return this.getData().getID();
    }

    public int getOwningProjectID() {
        return this.m_owningProjectID;
    }

    public int getOwningViewID() {
        return this.m_owningViewID;
    }

    public boolean isModified() {
        return this.getData().isModified();
    }

    public boolean isNew() {
        return this.getData().isNew();
    }

    public String getName() {
        return this.getData().getName();
    }

    public void setName(String string) {
        this.getNewData().setName(string);
    }

    public String getDescription() {
        return this.getData().getDescription();
    }

    public void setDescription(String string) {
        this.getNewData().setDescription(string);
    }

    public boolean isBuildLabel() {
        return this.getData().isBuildLabel();
    }

    public OLEDate getTime() {
        return this.getData().getTime();
    }

    public void setTime(OLEDate oLEDate) {
        this.getNewData().setTime(oLEDate);
    }

    public OLEDate getRevisionTime() {
        return this.getData().getRevisionTime();
    }

    public boolean isViewLabel() {
        return !this.isRevisionLabel();
    }

    public boolean isRevisionLabel() {
        return this.getData().isRevisionLabel();
    }

    public boolean isDeleted() {
        return this.getData().isDeleted();
    }

    public boolean isLocked() {
        return this.getData().isLocked();
    }

    public void setLocked(boolean bl) {
        this.m_view.getServer().getSupportedFeatures().verifyHasLabelLocking();
        this.getNewData().setLocked(bl);
    }

    public void attachItem(Item item, int n, OLEDate oLEDate, boolean bl) {
        if (n != item.getObjectID()) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.MISMATCH_OBJECT_IDS_FMT, new Object[]{new Integer(n), new Integer(item.getObjectID())}));
        }
        if (oLEDate.getDoubleValue() != item.getModifiedTime().getDoubleValue()) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.MISMATCH_REVISION_TIME_FMT, new Object[]{oLEDate, item.getModifiedTime()}));
        }
        this.createIfNeeded();
        if (item instanceof Folder) {
            this.attachToFolderRevision((Folder)item, n, oLEDate, bl ? 2 : 0);
        } else {
            this.attachToItemRevision(item, n, oLEDate);
        }
    }

    public void attachItem(Item item, boolean bl) {
        this.createIfNeeded();
        int n = bl ? 2 : 0;
        this.getLabelMethods().attachLabel(this.getID(), item.getItemID(), item.getObjectID(), item.getModifiedTime(), n);
    }

    public void attachToItem(Item item) {
        this.createIfNeeded();
        this.getLabelMethods().attachLabel(this.getID(), item.getItemID(), item.getObjectID(), item.getModifiedTime(), 0);
    }

    public void attachToItems(int[] nArray, ViewConfiguration viewConfiguration) {
        this.createIfNeeded();
        this.getLabelMethods().attachToItems(this.getID(), nArray, viewConfiguration);
    }

    public void detachFromItems(int[] nArray) {
        this.getLabelMethods().detachFromItems(this.getID(), nArray);
    }

    public void attachToFolder(Folder folder, int n) {
        this.createIfNeeded();
        if (this.m_view.getServer().getRevisionLevel() < 53) {
            this.getLabelMethods().attachLabelOld(this.getID(), folder.getItemID(), folder.getObjectID(), folder.getModifiedTime(), n != 0);
        } else {
            this.getLabelMethods().attachLabel(this.getID(), folder.getItemID(), folder.getObjectID(), folder.getModifiedTime(), n);
        }
    }

    private void attachToFolderRevision(Folder folder, int n, OLEDate oLEDate, int n2) {
        this.createIfNeeded();
        if (this.m_view.getServer().getRevisionLevel() < 53) {
            this.getLabelMethods().attachLabelOld(this.getID(), folder.getItemID(), n, oLEDate, n2 != 0);
        } else {
            this.getLabelMethods().attachLabel(this.getID(), folder.getItemID(), n, oLEDate, n2);
        }
    }

    private void attachToItemRevision(Item item, int n, OLEDate oLEDate) {
        this.createIfNeeded();
        if (this.m_view.getServer().getRevisionLevel() < 53) {
            this.getLabelMethods().attachLabelOld(this.getID(), item.getItemID(), n, oLEDate, false);
        } else {
            this.getLabelMethods().attachLabel(this.getID(), item.getItemID(), n, oLEDate, 0);
        }
    }

    public void moveItem(Item item, int n, OLEDate oLEDate) {
        this.createIfNeeded();
        if (this.m_view.getServer().getRevisionLevel() < 53) {
            this.getLabelMethods().moveLabelOld(this.getID(), item.getItemID(), n, oLEDate);
        } else {
            this.getLabelMethods().attachLabel(this.getID(), item.getItemID(), n, oLEDate, 0);
        }
    }

    public void moveItem(Item item) {
        this.createIfNeeded();
        if (this.m_view.getServer().getRevisionLevel() < 53) {
            this.getLabelMethods().moveLabelOld(this.getID(), item.getItemID(), item.getObjectID(), item.getModifiedTime());
        } else {
            this.getLabelMethods().attachLabel(this.getID(), item.getItemID(), item.getObjectID(), item.getModifiedTime(), 0);
        }
    }

    public void detachItem(Item item) {
        if (this.m_view.getServer().getRevisionLevel() < 53) {
            this.getLabelMethods().detachLabelOld(this.getID(), item.getItemID(), false);
        } else {
            this.getLabelMethods().detachLabel(this.getID(), item.getItemID(), 0);
        }
    }

    public void detachFromFolder(Folder folder, int n) {
        if (this.m_view.getServer().getRevisionLevel() < 53) {
            this.getLabelMethods().detachLabelOld(this.getID(), folder.getItemID(), n != 0);
        } else {
            this.getLabelMethods().detachLabel(this.getID(), folder.getItemID(), n);
        }
    }

    public int[] getLabeledItemIDs(int[] nArray) {
        this.createIfNeeded();
        return this.getLabelMethods().getLabeledItems(this.getID(), nArray);
    }

    public void update() {
        LabelMethods labelMethods = this.getLabelMethods();
        if (this.isNew()) {
            Label_Data label_Data = this.getData();
            int n = labelMethods.createLabel(this.m_cloneID, label_Data.getName(), label_Data.getDescription(), label_Data.isBuildLabel(), label_Data.getTime().getDoubleValue(), label_Data.isRevisionLabel(), label_Data.isLocked());
            this.m_newData = null;
            this.m_cloneID = -1;
            this.getData().setID(n);
            this.m_view.registerLabel(this);
        } else if (this.isModified()) {
            labelMethods.modifyLabel(this);
            int n = this.getID();
            this.m_newData = null;
            this.setID(n);
        }
        labelMethods.getLabelInfo(this);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Label: ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" id: ");
        stringBuffer.append(this.getID());
        stringBuffer.append(string + "Desc: ");
        stringBuffer.append(this.getDescription());
        stringBuffer.append(string + "Workflow: ");
        stringBuffer.append(this.isBuildLabel());
        stringBuffer.append(string + "Revision Label: ");
        stringBuffer.append(this.isRevisionLabel());
        stringBuffer.append(string + "Time: ");
        OLEDate oLEDate = new OLEDate(this.getTime());
        stringBuffer.append(oLEDate.localString(1, 1));
        stringBuffer.append(string + "Revision Time: ");
        oLEDate = new OLEDate(this.getRevisionTime());
        stringBuffer.append(oLEDate.localString(1, 1));
        stringBuffer.append(string + "Locked: " + this.isLocked());
        stringBuffer.append(string + "Owning ProjectID: " + this.m_owningProjectID);
        stringBuffer.append(string + "Owning ViewID   : " + this.m_owningViewID);
        stringBuffer.append(string + "View Context ID: " + this.m_view.getID());
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Label) {
            Label label = (Label)object;
            return this.getView().getServer() == label.getView().getServer() && this.getID() == label.getID();
        }
        return false;
    }

    public int hashCode() {
        return this.getID();
    }

    public void remove() {
        this.getLabelMethods().deleteLabel(this.getID());
        this.setDeleted(true);
    }

    private void createIfNeeded() {
        if (this.isNew()) {
            this.update();
        }
    }

    void setDeleted(boolean bl) {
        this.getNewData().setDeleted(bl);
    }

    void setID(int n) {
        this.getNewData().setID(n);
    }

    void setOwningProjectID(int n) {
        this.m_owningProjectID = n;
    }

    void setOwningViewID(int n) {
        this.m_owningViewID = n;
    }

    void setBuildLabel(boolean bl) {
        this.getNewData().setBuildLabel(bl);
    }

    void setRevisionLabel(boolean bl) {
        this.getNewData().setRevisionLabel(bl);
    }

    void readGuts(Command command) throws IOException {
        this.getData().readGuts(command);
    }

    void writeGuts(Command command) throws IOException {
        this.getData().writeGuts(command);
    }

    private LabelMethods getLabelMethods() {
        if (this.m_labelMethods == null) {
            this.m_labelMethods = new LabelMethods(this.m_view);
        }
        return this.m_labelMethods;
    }

    Label(View view, Label_Data label_Data) {
        super(label_Data);
        this.m_view = view;
        this.setOwningProjectID(view.getProject().getID());
        this.setOwningViewID(view.getID());
    }

    Label(View view, String string, String string2, OLEDate oLEDate, boolean bl, boolean bl2) {
        this(view, new Label_Data());
        this.setName(string);
        this.setDescription(string2);
        this.setTime(oLEDate);
        this.setBuildLabel(bl);
        this.setRevisionLabel(bl2);
    }

    public Label(View view, String string, String string2, OLEDate oLEDate, boolean bl) {
        this(view, string, string2, oLEDate, bl, false);
    }

    public Label(View view, String string, String string2, boolean bl) {
        this(view, string, string2, new OLEDate(0.0), bl);
    }

    public Label(View view, String string, String string2) {
        this(view, string, string2, new OLEDate(0.0), false, true);
    }

    public Label(View view, String string, String string2, Label label) {
        this(view, string, string2, new OLEDate(0.0), label.isBuildLabel(), label.isRevisionLabel());
        Server server = view.getServer();
        server.getSupportedFeatures().verifyHasLabelCopy();
        this.m_cloneID = label.getID();
    }

    Label(View view) {
        this(view, new Label_Data());
    }
}

