/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.borland.starteam.xml.XMLDocument;
import com.borland.starteam.xml.XMLElement;
import com.borland.starteam.xml.XMLException;
import com.starbase.starteam.MPXException;
import com.starbase.starteam.vts.pickle.IntegerFactory;
import com.starbase.util.Assert;
import com.starbase.util.Base64;
import com.starbase.util.ByteOrder;
import com.starbase.util.OLEDate;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

abstract class MPXEvent {
    public static final String VERB_ADDED = "New";
    public static final String VERB_CHANGED = "Modify";
    public static final String VERB_DELETED = "Delete";
    protected static final String EMPTY_STRING = "";
    private static final IntegerFactory m_Integers = new IntegerFactory(512, -1);
    private static final Double ZERO_DOUBLE = new Double(0.0);
    private static final OLEDate ZERO_DATE = new OLEDate(0.0);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final boolean DEBUG = false;
    private static final boolean LOG = false;
    private static final String EOL = System.getProperty("line.separator");
    private static final String LOG_FOLDER_NAME = "MPX Event Log";
    private static Writer m_logwriter = null;
    private static long m_logtime = 0L;
    private XMLDocument m_xml = null;
    protected XMLElement m_eventHeader = null;
    protected XMLElement m_eventData = null;
    protected String m_strType = null;
    protected String m_strSubtype = null;
    protected String m_strVerb = null;
    protected int m_nRevision = 0;

    public String getEventType() {
        return this.m_strType;
    }

    public String getEventSubtype() {
        return this.m_strSubtype;
    }

    public String getEventVerb() {
        return this.m_strVerb;
    }

    public int getEventRevision() {
        return this.m_nRevision;
    }

    protected static XMLElement getElement(XMLElement xMLElement, String string) throws MPXException {
        XMLElement[] xMLElementArray = xMLElement.getChildren(string);
        XMLElement xMLElement2 = null;
        int n = xMLElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement3 = xMLElementArray[n2];
            if (xMLElement2 != null) {
                MPXEvent.throwParseException("MPXEvent.getElement(), name=" + string);
            }
            xMLElement2 = xMLElement3;
            ++n2;
        }
        return xMLElement2;
    }

    protected static XMLElement getRequiredElement(XMLDocument xMLDocument, String string) throws MPXException {
        XMLElement xMLElement = xMLDocument.getRootElement();
        if (xMLElement == null || !xMLElement.getName().equals(string)) {
            MPXEvent.throwParseException("MPXEvent.getRequiredElement(), name=" + string);
        }
        return xMLElement;
    }

    protected static XMLElement getRequiredElement(XMLElement xMLElement, String string) throws MPXException {
        XMLElement xMLElement2 = MPXEvent.getElement(xMLElement, string);
        if (xMLElement2 == null) {
            MPXEvent.throwParseException("MPXEvent.getRequiredElement(), name=" + string);
        }
        return xMLElement2;
    }

    protected static String getRequiredStringAttribute(XMLElement xMLElement, String string) throws MPXException {
        String string2 = MPXEvent.getAttributeValue(xMLElement, string);
        if (string2 != null) {
            return string2;
        }
        MPXEvent.throwParseException("MPXEvent.getRequiredStringAttribute(), node=" + xMLElement.getName() + ", =" + string);
        return EMPTY_STRING;
    }

    protected static int getRequiredIntAttribute(XMLElement xMLElement, String string) throws MPXException {
        String string2 = MPXEvent.getRequiredStringAttribute(xMLElement, string);
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            MPXEvent.throwParseException("MPXEvent.getRequiredIntAttribute(), node=" + xMLElement.getName() + "; name=" + string + ", value=\"" + string2 + "\"");
            return 0;
        }
    }

    public static String getAttributeValue(XMLElement xMLElement, String string) {
        return xMLElement.getAttributeValue(string);
    }

    protected static void throwParseException(String string) throws MPXException {
        MPXException.internalError(string);
    }

    protected static void throwParseException(Throwable throwable) throws MPXException {
        MPXException.internalError(throwable.getLocalizedMessage());
    }

    protected static String getRequiredString(XMLElement xMLElement, String string) throws MPXException {
        XMLElement xMLElement2 = MPXEvent.getRequiredElement(xMLElement, string);
        return MPXEvent.getStringValue(xMLElement2);
    }

    protected static String getStringValue(XMLElement xMLElement) {
        return xMLElement.getText();
    }

    protected static int getRequiredInteger(XMLElement xMLElement, String string) throws MPXException {
        XMLElement xMLElement2 = MPXEvent.getRequiredElement(xMLElement, string);
        return MPXEvent.getIntValue(xMLElement2);
    }

    protected static int getIntValue(XMLElement xMLElement) throws MPXException {
        String string = MPXEvent.getStringValue(xMLElement);
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            MPXEvent.throwParseException("MPXEvent.getIntValue(), node=" + xMLElement.getName() + "; s=\"" + string + "\"");
            return 0;
        }
    }

    protected static Integer getIntegerValue(XMLElement xMLElement) throws MPXException {
        int n = MPXEvent.getIntValue(xMLElement);
        return m_Integers.get(n);
    }

    protected static long getLongValue(XMLElement xMLElement) throws MPXException {
        String string = MPXEvent.getStringValue(xMLElement);
        try {
            long l = Long.parseLong(string);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            MPXEvent.throwParseException("MPXEvent.getLongValue(), node=" + xMLElement.getName() + "; s=\"" + string + "\"");
            return 0L;
        }
    }

    protected static double getFloatValue(XMLElement xMLElement) {
        byte[] byArray = MPXEvent.getBinaryValue(xMLElement);
        return ByteOrder.readDouble(byArray);
    }

    protected static Double getDoubleValue(XMLElement xMLElement) {
        double d = MPXEvent.getFloatValue(xMLElement);
        if (d == 0.0) {
            return ZERO_DOUBLE;
        }
        return new Double(d);
    }

    protected static OLEDate getRequiredTime(XMLElement xMLElement, String string) throws MPXException {
        OLEDate oLEDate = ZERO_DATE;
        XMLElement xMLElement2 = MPXEvent.getRequiredElement(xMLElement, string);
        String string2 = MPXEvent.getRequiredStringAttribute(xMLElement2, "Type");
        if (string2.equals("sttime")) {
            oLEDate = MPXEvent.getOLEDateValue(xMLElement2);
        } else {
            MPXEvent.throwParseException("MPXEvent.getRequiredTime(), type=" + string2);
        }
        return oLEDate;
    }

    protected static OLEDate getOLEDateValue(XMLElement xMLElement) {
        double d = MPXEvent.getFloatValue(xMLElement);
        if (d == 0.0) {
            return ZERO_DATE;
        }
        return new OLEDate(d);
    }

    protected static byte[] getBinaryValue(XMLElement xMLElement) {
        String string = MPXEvent.getStringValue(xMLElement);
        if (string.length() == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = Base64.decode(string);
        if (byArray.length == 0) {
            return EMPTY_BYTES;
        }
        return byArray;
    }

    protected static int[] getIDArrayValue(XMLElement xMLElement) throws MPXException {
        return MPXEvent.getIntArray(xMLElement);
    }

    public static int[] getRequiredIntArray(XMLElement xMLElement, String string) throws MPXException {
        return MPXEvent.getIntArray(MPXEvent.getRequiredElement(xMLElement, string));
    }

    public static int[] getRequiredIntArray(XMLElement xMLElement, String string, String string2) throws MPXException {
        return MPXEvent.getIntArray(MPXEvent.getRequiredElement(xMLElement, string), string2);
    }

    public static int[] getIntArray(XMLElement xMLElement) throws MPXException {
        return MPXEvent.getIntArray(xMLElement, "RawID");
    }

    public static int[] getIntArray(XMLElement xMLElement, String string) throws MPXException {
        Object object;
        Vector<Integer> vector = new Vector<Integer>();
        XMLElement[] xMLElementArray = xMLElement.getChildren();
        int n = xMLElementArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            XMLElement xMLElement2 = xMLElementArray[n3];
            object = xMLElement2.getName();
            if (n2 < 0) {
                if (((String)object).equals("Size")) {
                    n2 = MPXEvent.getIntValue(xMLElement2);
                    if (n2 < 0) {
                        Assert.internalError("MPXEvent.getIntArray(), nSize=" + n2);
                    }
                } else {
                    MPXEvent.throwParseException("MPXEvent.getIntArray(), name=\"" + (String)object + "\", expected=Size");
                }
            } else if (((String)object).equals(string)) {
                Integer n4 = MPXEvent.getIntegerValue(xMLElement2);
                vector.addElement(n4);
            } else {
                MPXEvent.throwParseException("MPXEvent.getIntArray(), name=\"" + (String)object + "\", expected=\"" + string + "\"");
            }
            ++n3;
        }
        if (n2 != vector.size()) {
            Assert.internalError("MPXEvent.getIntArray(), nSize=" + n2 + ", v.size()=" + vector.size());
        }
        if (n2 == 0) {
            return EMPTY_INTS;
        }
        int[] nArray = new int[n2];
        int n5 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            nArray[n5++] = (Integer)object.nextElement();
        }
        return nArray;
    }

    public String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMyClassName());
        stringBuffer.append(": ");
        stringBuffer.append(this.getEventType());
        String string = this.getEventSubtype();
        if (string.length() != 0) {
            stringBuffer.append('/');
            stringBuffer.append(string);
            String string2 = this.getEventVerb();
            if (string2.length() != 0) {
                stringBuffer.append('/');
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    protected String getMyClassName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void dump() {
    }

    private void logEvent() {
    }

    private static Writer getLogFile() {
        if (m_logwriter == null) {
            try {
                File file = new File(LOG_FOLDER_NAME);
                if (!file.exists()) {
                    file.mkdir();
                }
                File file2 = new File(file, "Events.html");
                m_logwriter = new BufferedWriter(new FileWriter(file2.getPath(), true));
                m_logwriter.write("<hr>" + EOL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return m_logwriter;
    }

    private String getEventLogFilename() {
        long l = System.currentTimeMillis();
        if (l <= m_logtime) {
            l = m_logtime + 1L;
        }
        m_logtime = l;
        return EMPTY_STRING + l + ".txt";
    }

    private void saveXML(File file) {
    }

    MPXEvent(String string) throws MPXException {
        this(string.getBytes());
    }

    MPXEvent(byte[] byArray) throws MPXException {
        try {
            this.m_xml = XMLDocument.build(byArray);
            XMLElement xMLElement = MPXEvent.getRequiredElement(this.m_xml, "STEvent");
            this.m_eventHeader = MPXEvent.getRequiredElement(xMLElement, "EventHeader");
            this.m_eventData = MPXEvent.getRequiredElement(xMLElement, "EventData");
            this.m_strType = MPXEvent.getRequiredString(this.m_eventHeader, "EventType");
            this.m_strSubtype = MPXEvent.getRequiredString(this.m_eventHeader, "EventSubtype");
            this.m_strVerb = MPXEvent.getRequiredString(this.m_eventHeader, "EventVerb");
            this.m_nRevision = MPXEvent.getRequiredInteger(this.m_eventHeader, "Revision");
        }
        catch (IOException iOException) {
            MPXEvent.throwParseException(iOException);
        }
        catch (XMLException xMLException) {
            MPXEvent.throwParseException(xMLException);
        }
    }

    MPXEvent(String string, String string2, String string3) {
        this.m_strType = string;
        this.m_strSubtype = string2;
        this.m_strVerb = string3;
    }
}

