/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Project;
import com.starbase.starteam.ReferenceFactoryCache;
import com.starbase.starteam.Server;
import com.starbase.starteam.View;
import com.starbase.starteam.View_CacheRefCollection;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.starteam.vts.comm.CommandRoute;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Vector;

class Project_Cmd_GetViews
extends CommandMacro {
    private static final String DELIMITER = "/";
    private static final CommandRoute m_routePublic = new CommandRoute(0x10000000, 0, 1002, "SRVR_CMD_GET_PROJECT_VIEWS");
    private static final CommandRoute m_routeSecure = new CommandRoute(0x40000000, 0, 1002, "SRVR_CMD_GET_PROJECT_VIEWS");
    private boolean m_bUseSecureCommand;
    private Project m_project = null;
    private View_CacheRefCollection m_views = null;
    private boolean m_bUpdateCache = false;
    private int[] m_ids = null;
    private String[] m_names = null;
    private String[] m_descriptions = null;
    private int[] m_childCounts = null;
    private String[] m_fullnames;
    private int m_index;

    public static void execute(Server server, Project project, View_CacheRefCollection view_CacheRefCollection, boolean bl) {
        boolean bl2 = server.getRevisionLevel() >= 66;
        Project_Cmd_GetViews project_Cmd_GetViews = new Project_Cmd_GetViews(project, bl2, view_CacheRefCollection, bl);
        project_Cmd_GetViews.execute(server.useConnection(), bl2 ? server.getSession().getID() : null, 0, 0);
    }

    public int[] getIDs() {
        return this.m_ids;
    }

    public String[] getNames() {
        return this.m_names;
    }

    public String[] getDescriptions() {
        return this.m_descriptions;
    }

    public int[] getChildCounts() {
        return this.m_childCounts;
    }

    public String[] getFullNames() {
        return this.m_fullnames;
    }

    protected CommandRoute getCommandRoute() {
        return this.m_bUseSecureCommand ? m_routeSecure : m_routePublic;
    }

    protected boolean isRetrySupported() {
        return true;
    }

    protected void push(Command command) throws IOException {
        if (this.m_bUseSecureCommand) {
            command.writeInt(this.m_project.getID());
        } else {
            command.writeString(this.m_project.getName());
        }
    }

    protected void pop(Command command) throws IOException {
        block4: {
            int n;
            this.m_ids = command.readIntArray();
            this.m_names = command.readStringArray();
            this.m_descriptions = command.readStringArray();
            this.m_childCounts = command.readIntArray();
            if (this.m_names.length <= 0) {
                Assert.internalError("Project_Cmd_GetViews.pop(), m_names.length=" + this.m_names.length);
            }
            this.m_fullnames = new String[this.m_names.length];
            this.m_fullnames[0] = this.m_names[0];
            this.m_index = 1;
            this.buildFullNames(this.m_fullnames[0], this.m_childCounts[0]);
            Vector vector = this.m_views.getRefs();
            if (this.m_bUpdateCache) {
                ReferenceFactoryCache.resolveReferencesToIDs(vector, this.m_ids, null);
                n = 0;
                while (n < vector.size()) {
                    this.m_views.updateView(this.m_ids[n], this.m_names[n], this.m_descriptions[n]);
                    ++n;
                }
            }
            n = vector.size();
            while (n < this.m_ids.length) {
                this.m_views.addView(this.m_ids[n], this.m_names[n], this.m_descriptions[n], this.m_fullnames[n], this.m_bUpdateCache);
                ++n;
            }
            if (!this.m_bUpdateCache) break block4;
            View[] viewArray = this.m_views.toArray();
            this.buildViewHierarchy(0, viewArray, this.m_childCounts);
        }
    }

    private void buildFullNames(String string, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.m_fullnames[this.m_index] = string + DELIMITER + this.m_names[this.m_index];
            String string2 = this.m_fullnames[this.m_index];
            int n3 = this.m_childCounts[this.m_index];
            ++this.m_index;
            this.buildFullNames(string2, n3);
            ++n2;
        }
    }

    private int buildViewHierarchy(int n, View[] viewArray, int[] nArray) {
        View view = viewArray[n];
        int n2 = nArray[n];
        View[] viewArray2 = new View[n2];
        int n3 = n + 1;
        int n4 = 0;
        while (n4 < n2) {
            View view2 = viewArray[n3];
            view2.setParentView(view);
            viewArray2[n4] = view2;
            n3 = this.buildViewHierarchy(n3, viewArray, nArray);
            ++n4;
        }
        view.setDerivedViews(viewArray2);
        return n3;
    }

    public Project_Cmd_GetViews(Project project, boolean bl, View_CacheRefCollection view_CacheRefCollection, boolean bl2) {
        this.m_project = project;
        this.m_bUseSecureCommand = bl;
        this.m_views = view_CacheRefCollection;
        this.m_bUpdateCache = bl2;
    }
}

