/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.pickle.Variant;
import com.starbase.util.Assert;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

class PropertyValues {
    Hashtable m_keyedValueTable = new Hashtable();

    public String[] getPropertyNames() {
        if (this.m_keyedValueTable == null) {
            Assert.internalError("PropertyValues.getPropertyNames(), m_keyedValueTable=null");
        }
        String[] stringArray = new String[this.m_keyedValueTable.size()];
        int n = 0;
        Enumeration enumeration = this.m_keyedValueTable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    Object get(String string) {
        Variant variant = (Variant)this.m_keyedValueTable.get(string);
        return variant == null ? null : variant.getData();
    }

    Object put(String string, Object object) {
        Variant variant = this.m_keyedValueTable.put(string, Variant.createVariant(object));
        return variant == null ? null : variant.getData();
    }

    Object remove(String string) {
        Variant variant = (Variant)this.m_keyedValueTable.remove(string);
        return variant == null ? null : variant.getData();
    }

    void readGuts(Command command) throws IOException {
        this.m_keyedValueTable.clear();
        int n = command.readInt();
        int n2 = 0;
        while (n2 < n) {
            String string = command.readString();
            this.m_keyedValueTable.put(string, Variant.read(command));
            ++n2;
        }
    }

    void writeGuts(Command command) throws IOException {
        int n = this.m_keyedValueTable.size();
        command.writeInt(n);
        Enumeration enumeration = this.m_keyedValueTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            command.writeString(string);
            Variant variant = (Variant)this.m_keyedValueTable.get(string);
            variant.writeGuts(command);
        }
    }

    PropertyValues copy() {
        PropertyValues propertyValues = new PropertyValues();
        this.copyInto(propertyValues);
        return propertyValues;
    }

    void copyInto(PropertyValues propertyValues) {
        Enumeration enumeration = this.m_keyedValueTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.m_keyedValueTable.get(string);
            propertyValues.put(string, v);
        }
    }

    boolean isEqualTo(PropertyValues propertyValues) {
        if (propertyValues != null && this.m_keyedValueTable.size() == propertyValues.m_keyedValueTable.size()) {
            Object v;
            Object object;
            Object object2;
            Enumeration enumeration = this.m_keyedValueTable.keys();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                object = this.m_keyedValueTable.get(object2);
                v = propertyValues.m_keyedValueTable.get(object2);
                if (!(object != null ? !object.equals(v) : v != null)) continue;
                return false;
            }
            object2 = propertyValues.m_keyedValueTable.keys();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                v = this.m_keyedValueTable.get(object);
                Object v2 = propertyValues.m_keyedValueTable.get(object);
                if (!(v != null ? !v.equals(v2) : v2 != null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.m_keyedValueTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + "\n Key: \"" + string2 + "\"";
            string = string + ", Value: " + this.m_keyedValueTable.get(string2).toString();
        }
        return string;
    }

    PropertyValues() {
    }
}

