/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.CmdQueryAdd;
import com.starbase.starteam.CmdQueryDelete;
import com.starbase.starteam.CmdQueryModify;
import com.starbase.starteam.ISecurable;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.Item;
import com.starbase.starteam.NamedCacheRef;
import com.starbase.starteam.QueryInfo_Cache;
import com.starbase.starteam.QueryInfo_Data;
import com.starbase.starteam.QueryNode;
import com.starbase.starteam.QueryPart;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.Server;
import com.starbase.starteam.SupportedFeatures;
import com.starbase.starteam.Type;
import com.starbase.util.Assert;
import java.util.Enumeration;
import java.util.Hashtable;

public class QueryInfo
extends NamedCacheRef
implements ISecurable {
    private Type m_type;
    private boolean m_deleted = false;
    private boolean m_bDirty = false;
    private QueryInfo_Data m_newData = null;

    private QueryInfo_Data getData() {
        return this.m_newData == null ? (QueryInfo_Data)this.getCachedObject() : this.m_newData;
    }

    protected void clearNewData() {
        if (this.m_newData != null) {
            this.m_newData = null;
            this.m_bDirty = false;
        }
    }

    private QueryInfo_Cache getCache() {
        if (this.m_type == null) {
            Assert.internalError("QueryInfo.getCache(), type=null");
        }
        return this.m_type.getQueryInfoCache();
    }

    private QueryInfo_Data getNewData() {
        if (this.m_newData == null) {
            this.m_newData = (QueryInfo_Data)this.getData().copy();
        }
        return this.m_newData;
    }

    protected String getRefName() {
        return this.getName();
    }

    public QueryInfo copy() {
        QueryInfo queryInfo = new QueryInfo(this.m_type, (QueryInfo_Data)this.getCachedObject());
        queryInfo.m_newData = this.m_newData != null ? (QueryInfo_Data)this.m_newData.copy() : null;
        queryInfo.m_deleted = this.m_deleted;
        return queryInfo;
    }

    public boolean isEqualTo(QueryInfo queryInfo) {
        if (queryInfo == null) {
            return false;
        }
        return this.getData().isEqualTo(queryInfo.getData()) && this.isDeleted() == queryInfo.isDeleted() && this.m_type.getClassID() == queryInfo.m_type.getClassID();
    }

    public boolean isDirty() {
        return this.m_bDirty;
    }

    public boolean isPublic() {
        return this.getData().isPublic();
    }

    public int getID() {
        return this.getData().getID();
    }

    public int getUserID() {
        return this.getData().getUserID();
    }

    public Type getType() {
        return this.m_type;
    }

    public void makePublic() {
        if (!this.isPublic()) {
            this.getNewData().makePublic();
            this.m_bDirty = true;
        }
    }

    public String getName() {
        return this.getData().getName();
    }

    public void setName(String string) {
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if (!this.getName().equals(string)) {
            this.getNewData().setName(string);
            this.m_bDirty = true;
        }
    }

    public QueryNode getQueryNode() {
        this.getNewData();
        return this.getData().getQueryNode();
    }

    public void setQueryNode(QueryNode queryNode) {
        if (queryNode == null) {
            Assert.nullArgument("QueryNode");
        }
        this.verifyNOTOperator(queryNode);
        this.getNewData().setQueryNode(queryNode);
        this.m_bDirty = true;
    }

    public int[] getPropertyIDs() {
        Hashtable hashtable = new Hashtable();
        this.collectPropIDs(this.getQueryNode(), hashtable);
        int n = hashtable.size();
        int[] nArray = new int[n];
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n2++] = (Integer)enumeration.nextElement();
        }
        return nArray;
    }

    private void collectPropIDs(QueryNode queryNode, Hashtable hashtable) {
        QueryPart[] queryPartArray = queryNode.getQueryParts();
        int n = 0;
        while (n < queryPartArray.length) {
            Integer n2 = new Integer(queryPartArray[n].getPropertyID());
            hashtable.put(n2, n2);
            ++n;
        }
        QueryNode[] queryNodeArray = queryNode.getQueryNodes();
        int n3 = 0;
        while (n3 < queryNodeArray.length) {
            this.collectPropIDs(queryNodeArray[n3], hashtable);
            ++n3;
        }
    }

    public boolean isNew() {
        return this.getData().isNew();
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public void update() {
        if (this.isDeleted()) {
            throw new IllegalStateException(Res.getString(ResIDs.QUERY_HAS_BEEN_DELETED));
        }
        this.verifyNOTOperator(this.getData().getQueryNode());
        Server server = this.m_type.getServer();
        if (this.isNew()) {
            this.getCache().setIDsModified();
            CmdQueryAdd cmdQueryAdd = new CmdQueryAdd(server, this.m_type.getClassID(), this.getData());
            cmdQueryAdd.execute();
        } else {
            this.getCache().setObjectDirty(this.getID());
            CmdQueryModify cmdQueryModify = new CmdQueryModify(server, this.m_type.getClassID(), this.getData());
            cmdQueryModify.execute();
        }
        this.m_bDirty = false;
    }

    public void delete() {
        if (!this.isDeleted()) {
            this.getCache().setObjectDirty(this.getID());
            this.getCache().setIDsModified();
            CmdQueryDelete cmdQueryDelete = new CmdQueryDelete(this.m_type.getServer(), this.m_type.getClassID(), this.getData());
            cmdQueryDelete.execute();
            this.markDeleted();
        }
    }

    public AclEntry[] getACL() {
        return SecurityAccess.getComponentObjectACL(this.m_type, this.m_type.getQueryClassID(), this.getID());
    }

    public void setACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setComponentObjectACL(this.m_type, this.m_type.getQueryClassID(), this.getID(), true, aclEntryArray);
    }

    public boolean hasPermission(int n) {
        return SecurityAccess.componentObjectAccessTest(this.m_type, this.m_type.getQueryClassID(), this.getID(), n);
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(super.toString() + string);
        stringBuffer.append(" Type: " + this.m_type.getName() + string);
        stringBuffer.append(" Deleted: " + this.m_deleted + string);
        stringBuffer.append(" Data: " + this.getData().toDebugString() + string);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public boolean evaluate(Item item) {
        return this.getQueryNode().evaluate(item);
    }

    void markDeleted() {
        this.m_deleted = true;
    }

    void setID(int n) {
        this.getNewData().setID(n);
    }

    private void verifyNOTOperator(QueryNode queryNode) {
        SupportedFeatures supportedFeatures;
        if (this.m_type != null && !(supportedFeatures = this.m_type.getServer().getSupportedFeatures()).hasNOTQueryOperator() && this.hasNOT(queryNode)) {
            supportedFeatures.verifyHasNOTQueryOperator();
        }
    }

    private boolean hasNOT(QueryNode queryNode) {
        if (queryNode == null) {
            return false;
        }
        if (queryNode.getOperator() == 2) {
            return true;
        }
        QueryNode[] queryNodeArray = queryNode.getQueryNodes();
        if (queryNodeArray != null) {
            int n = 0;
            while (n < queryNodeArray.length) {
                if (this.hasNOT(queryNodeArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public ISecurableContainer getParentContainer() {
        return this.getType();
    }

    public QueryInfo(Type type, boolean bl, String string, QueryNode queryNode) {
        super(null);
        if (string == null) {
            Assert.nullArgument("String", "name");
        }
        if (queryNode == null) {
            Assert.nullArgument("QueryNode");
        }
        if (type == null) {
            Assert.nullArgument("Type");
        }
        this.setCachedObject(new QueryInfo_Data(string, queryNode, bl ? -1 : type.getServer().getLoggedInUserID()));
        this.m_type = type;
        this.verifyNOTOperator(queryNode);
    }

    QueryInfo(Type type, QueryInfo_Data queryInfo_Data) {
        super(queryInfo_Data);
        this.m_type = type;
    }
}

