/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Item;
import com.starbase.starteam.Property;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.starteam.vts.pickle.Variant;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.io.IOException;

public class QueryPart {
    public static final int REL_LESSTHAN = 1;
    public static final int REL_LESSOREQUAL = 2;
    public static final int REL_EQUAL = 3;
    public static final int REL_GREATEROREQUAL = 4;
    public static final int REL_GREATERTHAN = 5;
    public static final int REL_NOTEQUAL = 6;
    public static final int REL_LASTDAYS = 9;
    public static final int REL_LASTWEEKS = 10;
    public static final int REL_OLDERDAYS = 11;
    public static final int REL_OLDERWEEKS = 12;
    public static final int REL_TEXTSEARCH = 65536;
    public static final int REL_STARTTEXT = 131072;
    public static final int REL_ENDTEXT = 196608;
    private static final int FLAG_IgnoreCase = 0x100000;
    private static final int FLAG_IgnoreTimePart = 0x1000000;
    private static final Class LONG_CLASS = new Integer(0).getClass();
    private static final Class DOUBLE_CLASS = new Double(0.0).getClass();
    private static final Class TIME_CLASS = new OLEDate().getClass();
    private static final Class TEXT_CLASS = new String("").getClass();
    private static final Class BINARY_CLASS = new byte[0].getClass();
    private static final Class IDARRAY_CLASS = new int[0].getClass();
    private int m_ID = -1;
    private int m_relation = 0;
    private boolean m_ignoreCase = false;
    private boolean m_ignoreTime = false;
    private int m_propertyID = 0;
    private Variant m_value = null;

    public QueryPart copyQueryPart() {
        QueryPart queryPart = new QueryPart();
        queryPart.m_ID = -1;
        queryPart.m_relation = this.m_relation;
        queryPart.m_ignoreCase = this.m_ignoreCase;
        queryPart.m_ignoreTime = this.m_ignoreTime;
        queryPart.m_propertyID = this.m_propertyID;
        queryPart.m_value = null;
        if (this.m_value != null) {
            queryPart.m_value = new Variant(this.m_value);
        }
        queryPart.validate(false);
        return queryPart;
    }

    public String toString() {
        return this.toDebugString();
    }

    public String toDebugString() {
        return "[ propID=0x" + Integer.toHexString(this.m_propertyID) + " \"" + this.relationString(this.m_relation) + "\" " + this.m_value.toString() + (this.m_ignoreCase ? ", ignore case" : "") + (this.m_ignoreTime ? ", ignore time" : "") + "]";
    }

    public boolean evaluate(Item item) {
        Property property = item.getType().propertyForPID(this.m_propertyID);
        Object object = item.get(property.getName());
        return QueryPart.query(object, this.m_value.getData(), this.m_relation, this.m_ignoreCase, this.m_ignoreTime);
    }

    public boolean evaluateAgainst(Object object) {
        return QueryPart.query(object, this.m_value.getData(), this.m_relation, this.m_ignoreCase, this.m_ignoreTime);
    }

    public int getRelation() {
        return this.m_relation;
    }

    public void setRelation(int n) {
        this.m_relation = n;
        this.validate(true);
    }

    private void validate(boolean bl) {
        if (this.m_value == null) {
            Assert.internalError("QueryPart.validate(), m_value=null");
        }
        QueryPart.validate(this.m_value.getData(), this.m_relation, bl);
    }

    private static void validate(Object object, int n, boolean bl) {
        if (object == null) {
            Assert.internalError("QueryPart.validate(), value=null");
        }
        Class<?> clazz = object.getClass();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (clazz != TIME_CLASS && clazz != DOUBLE_CLASS) {
                    if (!bl) break;
                    String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"REL_LASTDAYS", "REL_LASTWEEKS"});
                    string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "REL_OLDERDAYS"});
                    string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "REL_OLDERWEEKS"});
                    throw new IllegalArgumentException(Res.formatKey(ResIDs.QUERY_VALUE_INVALID_FOR_DATETIME_RELATION_FMT, new Object[]{string, clazz.getName()}));
                }
                return;
            }
            case 65536: 
            case 131072: 
            case 196608: {
                if (clazz != TEXT_CLASS) {
                    if (!bl) break;
                    String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"REL_TEXTSEARCH", "REL_STARTTEXT"});
                    string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "REL_ENDTEXT"});
                    throw new IllegalArgumentException(Res.formatKey(ResIDs.QUERY_VALUE_INVALID_FOR_TEXT_RELATION_FMT, new Object[]{string, clazz.getName()}));
                }
                return;
            }
            default: {
                if (!bl) break;
                String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"REL_LESSTHAN", "REL_EQUAL"});
                string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "REL_GREATERTHAN"});
                throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_QUERY_RELATION_FMT, new Object[]{new Integer(n), string}));
            }
        }
        Assert.internalError("QueryPart.validate(), relation=" + n + "; class=" + clazz.getName());
    }

    public boolean isIgnoreCase() {
        return this.m_ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.m_ignoreCase = bl;
    }

    public boolean isIgnoreTime() {
        return this.m_ignoreTime;
    }

    public void setIgnoreTime(boolean bl) {
        this.m_ignoreTime = bl;
    }

    public int getPropertyID() {
        return this.m_propertyID;
    }

    public void setPropertyID(int n) {
        this.m_propertyID = n;
    }

    public Object getValue() {
        return this.m_value.getData();
    }

    private void init(int n, int n2, Variant variant) {
        this.m_value = variant;
        this.m_propertyID = n;
        this.m_relation = n2;
        this.validate(true);
    }

    int getOpMask() {
        return this.m_relation | (this.m_ignoreCase ? 0x100000 : 0) | (this.m_ignoreTime ? 0x1000000 : 0);
    }

    static QueryPart read(Command command) throws IOException {
        QueryPart queryPart = new QueryPart();
        queryPart.readGuts(command);
        return queryPart;
    }

    private void readGuts(Command command) throws IOException {
        this.m_ID = command.readInt();
        this.m_propertyID = command.readInt();
        int n = command.readInt();
        this.m_ignoreCase = (n & 0x100000) != 0;
        this.m_ignoreTime = (n & 0x1000000) != 0;
        this.m_relation = n & 0xFFFFF;
        this.m_value = Variant.read(command);
        this.validate(false);
    }

    void writeGuts(Command command) throws IOException {
        this.validate(false);
        command.writeInt(this.m_ID);
        command.writeInt(this.m_propertyID);
        command.writeInt(this.getOpMask());
        this.m_value.writeGuts(command);
    }

    private String relationString(int n) {
        switch (n) {
            case 1: {
                return "<";
            }
            case 2: {
                return "<=";
            }
            case 3: {
                return "==";
            }
            case 5: {
                return ">";
            }
            case 4: {
                return ">=";
            }
            case 6: {
                return "!=";
            }
            case 9: {
                return "last-n-days";
            }
            case 10: {
                return "last-n-weeks";
            }
            case 11: {
                return "older-n-days";
            }
            case 12: {
                return "older-n-weeks";
            }
            case 65536: {
                return "contains";
            }
            case 131072: {
                return "starts-with";
            }
            case 196608: {
                return "ends-with";
            }
        }
        return "0x" + Integer.toHexString(n);
    }

    private static boolean query(Object object, Object object2, int n, boolean bl, boolean bl2) {
        Class<?> clazz;
        QueryPart.validate(object2, n, false);
        if (object.getClass() == TIME_CLASS) {
            clazz = object2.getClass();
            if (clazz != TIME_CLASS && clazz != DOUBLE_CLASS) {
                QueryPart.throwIncompatibleTypesException(object, object2);
            }
        } else if (object2.getClass() != object.getClass()) {
            QueryPart.throwIncompatibleTypesException(object, object2);
        }
        clazz = object.getClass();
        if (clazz == LONG_CLASS) {
            return QueryPart.queryLong((Integer)object, (Integer)object2, n);
        }
        if (clazz == DOUBLE_CLASS) {
            return QueryPart.queryDouble((Double)object, (Double)object2, n);
        }
        if (clazz == TIME_CLASS) {
            double d = object2.getClass() == DOUBLE_CLASS ? ((Double)object2).doubleValue() : ((OLEDate)object2).getDoubleValue();
            return QueryPart.queryTime(((OLEDate)object).getDoubleValue(), d, n, bl2);
        }
        if (clazz == TEXT_CLASS) {
            return QueryPart.queryString((String)object, (String)object2, n, bl);
        }
        if (clazz == BINARY_CLASS) {
            return QueryPart.queryBinary((byte[])object, (byte[])object2, n);
        }
        if (clazz == IDARRAY_CLASS) {
            return QueryPart.queryIDArray((int[])object, (int[])object2, n);
        }
        Assert.internalError("QueryPart.query(), class=" + clazz.getName());
        return false;
    }

    private static void throwIncompatibleTypesException(Object object, Object object2) {
        String string = object.getClass().getName();
        String string2 = object2.getClass().getName();
        throw new IllegalArgumentException(Res.formatKey(ResIDs.QUERY_INCOMPATIBLE_TYPES_FMT, new Object[]{string, string2}));
    }

    private static boolean queryBinary(byte[] byArray, byte[] byArray2, int n) {
        int n2 = Variant.compare(byArray, byArray2, false, false);
        switch (n) {
            case 1: {
                return n2 < 0;
            }
            case 2: {
                return n2 <= 0;
            }
            case 3: {
                return n2 == 0;
            }
            case 4: {
                return n2 >= 0;
            }
            case 5: {
                return n2 > 0;
            }
            case 6: {
                return n2 != 0;
            }
        }
        Assert.internalError("QueryPart.queryBinary(), relation=" + n);
        return false;
    }

    private static boolean queryIDArray(int[] nArray, int[] nArray2, int n) {
        int n2 = Variant.compare(nArray, nArray2, false, false);
        switch (n) {
            case 1: {
                return n2 < 0;
            }
            case 2: {
                return n2 <= 0;
            }
            case 3: {
                return n2 == 0;
            }
            case 4: {
                return n2 >= 0;
            }
            case 5: {
                return n2 > 0;
            }
            case 6: {
                return n2 != 0;
            }
        }
        Assert.internalError("QueryPart.queryIDArray(), relation=" + n);
        return false;
    }

    private static boolean queryString(String string, String string2, int n, boolean bl) {
        String string3 = bl ? string.toLowerCase() : string;
        String string4 = bl ? string2.toLowerCase() : string2;
        switch (n) {
            case 65536: {
                return string3.indexOf(string4) != -1;
            }
            case 131072: {
                return string3.startsWith(string4);
            }
            case 196608: {
                return string3.endsWith(string4);
            }
        }
        int n2 = string3.compareTo(string4);
        switch (n) {
            case 1: {
                return n2 < 0;
            }
            case 2: {
                return n2 <= 0;
            }
            case 3: {
                return n2 == 0;
            }
            case 4: {
                return n2 >= 0;
            }
            case 5: {
                return n2 > 0;
            }
            case 6: {
                return n2 != 0;
            }
        }
        Assert.internalError("QueryPart.queryString(), relation=" + n);
        return false;
    }

    private static boolean queryTime(double d, double d2, int n, boolean bl) {
        double d3 = d;
        double d4 = d2;
        if (bl) {
            d3 = (long)d;
            d4 = (long)d2;
        }
        switch (n) {
            case 1: {
                return d3 < d4;
            }
            case 2: {
                return d3 <= d4;
            }
            case 3: {
                return d3 == d4;
            }
            case 4: {
                return d3 >= d4;
            }
            case 5: {
                return d3 > d4;
            }
            case 6: {
                return d3 != d4;
            }
        }
        double d5 = new OLEDate(System.currentTimeMillis()).getDoubleValue();
        switch (n) {
            case 9: {
                return d5 - d3 <= d4;
            }
            case 10: {
                return d5 - d3 <= d4 * 7.0;
            }
            case 11: {
                return d5 - d3 > d4;
            }
            case 12: {
                return d5 - d3 > d4 * 7.0;
            }
        }
        Assert.internalError("QueryPart.queryTime(), relation=" + n);
        return false;
    }

    private static boolean queryDouble(double d, double d2, int n) {
        switch (n) {
            case 1: {
                return d < d2;
            }
            case 2: {
                return d <= d2;
            }
            case 3: {
                return d == d2;
            }
            case 4: {
                return d >= d2;
            }
            case 5: {
                return d > d2;
            }
            case 6: {
                return d != d2;
            }
        }
        Assert.internalError("QueryPart.queryDouble(), relation=" + n);
        return false;
    }

    private static boolean queryLong(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return n < n2;
            }
            case 2: {
                return n <= n2;
            }
            case 3: {
                return n == n2;
            }
            case 4: {
                return n >= n2;
            }
            case 5: {
                return n > n2;
            }
            case 6: {
                return n != n2;
            }
        }
        Assert.internalError("QueryPart.queryLong(), relation=" + n3);
        return false;
    }

    boolean isEqualTo(QueryPart queryPart) {
        if (queryPart != null) {
            return this.m_ID == queryPart.m_ID && this.getRelation() == queryPart.getRelation() && this.isIgnoreCase() == queryPart.isIgnoreCase() && this.isIgnoreTime() == queryPart.isIgnoreTime() && this.getPropertyID() == queryPart.getPropertyID() && this.getValue().equals(queryPart.getValue());
        }
        return false;
    }

    public QueryPart(int n, int n2, int n3) {
        this.init(n, n2, new Variant(n3));
    }

    public QueryPart(int n, int n2, double d) {
        this.init(n, n2, new Variant(d));
    }

    public QueryPart(int n, int n2, double d, boolean bl) {
        this.init(n, n2, new Variant(d));
        this.m_ignoreTime = bl;
    }

    public QueryPart(int n, int n2, OLEDate oLEDate, boolean bl) {
        if (oLEDate == null) {
            Assert.nullArgument("OLEDate");
        }
        this.init(n, n2, new Variant(oLEDate));
        this.m_ignoreTime = bl;
    }

    public QueryPart(int n, int n2, String string, boolean bl) {
        if (string == null) {
            Assert.nullArgument("String", "value");
        }
        this.init(n, n2, new Variant(string));
        this.m_ignoreCase = !bl;
    }

    public QueryPart(int n, int n2, byte[] byArray) {
        if (byArray == null) {
            Assert.nullArgument("byte[]");
        }
        this.init(n, n2, new Variant(byArray));
    }

    public QueryPart(int n, int n2, int[] nArray) {
        if (nArray == null) {
            Assert.nullArgument("int[]");
        }
        this.init(n, n2, new Variant(nArray));
    }

    private QueryPart() {
    }
}

