/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.CmdAccessTest;
import com.starbase.starteam.CmdAcquireItemOwnership;
import com.starbase.starteam.CmdAcquireObjectOwnership;
import com.starbase.starteam.CmdContainerAccessTest;
import com.starbase.starteam.CmdDropServerACL;
import com.starbase.starteam.CmdGetComponentACL;
import com.starbase.starteam.CmdGetComponentLevelACL;
import com.starbase.starteam.CmdGetComponentObjectACL;
import com.starbase.starteam.CmdGetContainerACL;
import com.starbase.starteam.CmdGetContainerLevelACL;
import com.starbase.starteam.CmdGetItemACL;
import com.starbase.starteam.CmdGetItemOwner;
import com.starbase.starteam.CmdGetObjectACL;
import com.starbase.starteam.CmdGetObjectOwner;
import com.starbase.starteam.CmdGetServerACL;
import com.starbase.starteam.CmdItemAccessTest;
import com.starbase.starteam.CmdObjectAccessTest;
import com.starbase.starteam.CmdSetComponentACL;
import com.starbase.starteam.CmdSetComponentLevelACL;
import com.starbase.starteam.CmdSetComponentObjectACL;
import com.starbase.starteam.CmdSetContainerACL;
import com.starbase.starteam.CmdSetContainerLevelACL;
import com.starbase.starteam.CmdSetItemACL;
import com.starbase.starteam.CmdSetObjectACL;
import com.starbase.starteam.CmdSetServerACL;
import com.starbase.starteam.CmdTestComponentLevelAccess;
import com.starbase.starteam.CmdTestComponentObjectAccess;
import com.starbase.starteam.Server;
import com.starbase.starteam.Type;
import com.starbase.starteam.View;
import com.starbase.starteam.vts.comm.CommandMacro;
import com.starbase.util.Assert;
import com.starbase.util.GUID;

class SecurityAccess {
    static boolean accessTest(Server server, int n) {
        CmdAccessTest cmdAccessTest = new CmdAccessTest(n);
        cmdAccessTest.execute(server.useConnection(), server.getSession().getID(), 0, 0);
        return cmdAccessTest.m_granted;
    }

    static boolean containerAccessTest(Server server, View view, int n, int n2, String string, int n3) {
        int n4 = server.typeForName(string).getClassID();
        CmdContainerAccessTest cmdContainerAccessTest = new CmdContainerAccessTest(n, n2, n4, n3);
        cmdContainerAccessTest.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
        return cmdContainerAccessTest.m_granted;
    }

    static boolean itemAccessTest(Server server, View view, int n, int n2) {
        CmdItemAccessTest cmdItemAccessTest = new CmdItemAccessTest(n, n2);
        cmdItemAccessTest.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
        return cmdItemAccessTest.m_granted;
    }

    static boolean objectAccessTest(Server server, View view, int n, int n2, int n3) {
        CmdObjectAccessTest cmdObjectAccessTest = new CmdObjectAccessTest(server, view, n, n2, n3);
        cmdObjectAccessTest.execute();
        return cmdObjectAccessTest.m_granted;
    }

    static AclEntry[] getServerACL(Server server) {
        CmdGetServerACL cmdGetServerACL = new CmdGetServerACL();
        cmdGetServerACL.execute(server.useConnection(), server.getSession().getID(), 0, 0);
        if (cmdGetServerACL.m_exists) {
            return AclEntry.fromRaw(cmdGetServerACL.m_acl);
        }
        return null;
    }

    static void setServerACL(Server server, AclEntry[] aclEntryArray) {
        if (aclEntryArray == null) {
            CmdDropServerACL cmdDropServerACL = new CmdDropServerACL();
            cmdDropServerACL.execute(server.useConnection(), server.getSession().getID(), 0, 0);
        } else {
            CmdSetServerACL cmdSetServerACL = new CmdSetServerACL(AclEntry.toRaw(aclEntryArray));
            cmdSetServerACL.execute(server.useConnection(), server.getSession().getID(), 0, 0);
        }
    }

    static AclEntry[] getObjectACL(Server server, View view, int n, int n2) {
        CmdGetObjectACL cmdGetObjectACL = new CmdGetObjectACL(n, n2);
        cmdGetObjectACL.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
        if (cmdGetObjectACL.m_exists) {
            return AclEntry.fromRaw(cmdGetObjectACL.m_acl);
        }
        return null;
    }

    static void setObjectACL(Server server, View view, int n, int n2, AclEntry[] aclEntryArray) {
        CmdSetObjectACL cmdSetObjectACL = new CmdSetObjectACL(n, n2, AclEntry.toRaw(aclEntryArray));
        cmdSetObjectACL.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
    }

    static AclEntry[] getItemACL(Server server, View view, int n) {
        CmdGetItemACL cmdGetItemACL = new CmdGetItemACL(n);
        cmdGetItemACL.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
        if (cmdGetItemACL.m_exists) {
            return AclEntry.fromRaw(cmdGetItemACL.m_acl);
        }
        return null;
    }

    static void setItemACL(Server server, View view, int n, AclEntry[] aclEntryArray) {
        CmdSetItemACL cmdSetItemACL = new CmdSetItemACL(n, AclEntry.toRaw(aclEntryArray));
        cmdSetItemACL.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
    }

    static AclEntry[] getContainerACL(Server server, View view, int n, int n2) {
        CmdGetContainerACL cmdGetContainerACL = new CmdGetContainerACL(n, n2);
        cmdGetContainerACL.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
        if (cmdGetContainerACL.m_exists) {
            return AclEntry.fromRaw(cmdGetContainerACL.m_acl);
        }
        return null;
    }

    static void setContainerACL(Server server, View view, int n, int n2, AclEntry[] aclEntryArray) {
        CmdSetContainerACL cmdSetContainerACL = new CmdSetContainerACL(n, n2, AclEntry.toRaw(aclEntryArray));
        cmdSetContainerACL.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
    }

    static AclEntry[] getContainerLevelACL(Server server, View view, int n, int n2, String string) {
        Object object;
        int n3 = -1;
        if (string.equalsIgnoreCase(server.getTypeNames().FOLDER)) {
            n3 = -4;
        } else if (string.equalsIgnoreCase(server.getTypeNames().VIEW)) {
            n3 = -3;
        } else {
            object = server.typeForName(string);
            n3 = ((Type)object).getClassID();
        }
        object = new CmdGetContainerLevelACL(n, n2, n3);
        ((CommandMacro)object).execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
        if (((CmdGetContainerLevelACL)object).m_exists) {
            return AclEntry.fromRaw(((CmdGetContainerLevelACL)object).m_acl);
        }
        return null;
    }

    static void setContainerLevelACL(Server server, View view, int n, int n2, String string, AclEntry[] aclEntryArray) {
        Object object;
        int n3 = -1;
        if (string.equalsIgnoreCase(server.getTypeNames().FOLDER)) {
            n3 = -4;
        } else if (string.equalsIgnoreCase(server.getTypeNames().VIEW)) {
            n3 = -3;
        } else {
            object = server.typeForName(string);
            n3 = ((Type)object).getClassID();
        }
        object = new CmdSetContainerLevelACL(n, n2, n3, AclEntry.toRaw(aclEntryArray));
        ((CommandMacro)object).execute(server.useConnection(), server.getSession().getID(), server.getViewSession(view).getID(), 0);
    }

    static AclEntry[] getComponentACL(Type type) {
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdGetComponentACL cmdGetComponentACL = new CmdGetComponentACL(server, gUID);
        cmdGetComponentACL.execute();
        return cmdGetComponentACL.m_exists ? AclEntry.fromRaw(cmdGetComponentACL.m_acl) : null;
    }

    static void setComponentACL(Type type, boolean bl, AclEntry[] aclEntryArray) {
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdSetComponentACL cmdSetComponentACL = new CmdSetComponentACL(server, gUID, bl, AclEntry.toRaw(aclEntryArray));
        cmdSetComponentACL.execute();
    }

    static AclEntry[] getComponentLevelACL(Type type, int n) {
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdGetComponentLevelACL cmdGetComponentLevelACL = new CmdGetComponentLevelACL(server, gUID, n);
        cmdGetComponentLevelACL.execute();
        return cmdGetComponentLevelACL.m_exists ? AclEntry.fromRaw(cmdGetComponentLevelACL.m_acl) : null;
    }

    static void setComponentLevelACL(Type type, int n, boolean bl, AclEntry[] aclEntryArray) {
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdSetComponentLevelACL cmdSetComponentLevelACL = new CmdSetComponentLevelACL(server, gUID, n, bl, AclEntry.toRaw(aclEntryArray));
        cmdSetComponentLevelACL.execute();
    }

    static AclEntry[] getComponentObjectACL(Type type, int n, int n2) {
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdGetComponentObjectACL cmdGetComponentObjectACL = new CmdGetComponentObjectACL(server, gUID, n, n2);
        cmdGetComponentObjectACL.execute();
        return cmdGetComponentObjectACL.m_exists ? AclEntry.fromRaw(cmdGetComponentObjectACL.m_acl) : null;
    }

    static void setComponentObjectACL(Type type, int n, int n2, boolean bl, AclEntry[] aclEntryArray) {
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdSetComponentObjectACL cmdSetComponentObjectACL = new CmdSetComponentObjectACL(server, gUID, n, n2, bl, AclEntry.toRaw(aclEntryArray));
        cmdSetComponentObjectACL.execute();
    }

    static boolean componentObjectAccessTest(Type type, int n, int n2, int n3) {
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdTestComponentObjectAccess cmdTestComponentObjectAccess = new CmdTestComponentObjectAccess(server, gUID, n, n2, n3);
        cmdTestComponentObjectAccess.execute();
        return cmdTestComponentObjectAccess.m_granted;
    }

    static boolean componentLevelAccessTest(Type type, int n) {
        if (!type.isItemType()) {
            Assert.internalError("SecurityAccess.componentLevelAccessTest(), type=\"" + type.getName() + "\"");
        }
        Server server = type.getServer();
        GUID gUID = server.getComponentGUID(type);
        CmdTestComponentLevelAccess cmdTestComponentLevelAccess = new CmdTestComponentLevelAccess(server, gUID, n);
        cmdTestComponentLevelAccess.execute();
        return cmdTestComponentLevelAccess.m_granted;
    }

    static int getItemOwner(Server server, View view, int n) {
        CmdGetItemOwner cmdGetItemOwner = new CmdGetItemOwner(server, view, n);
        cmdGetItemOwner.execute();
        return cmdGetItemOwner.getOwnerID();
    }

    static void acquireItemOwnership(Server server, View view, int n) {
        CmdAcquireItemOwnership cmdAcquireItemOwnership = new CmdAcquireItemOwnership(server, view, n);
        cmdAcquireItemOwnership.execute();
    }

    static int getObjectOwner(Server server, View view, int n, int n2) {
        CmdGetObjectOwner cmdGetObjectOwner = new CmdGetObjectOwner(server, view, n, n2);
        cmdGetObjectOwner.execute();
        return cmdGetObjectOwner.getOwnerID();
    }

    static void acquireObjectOwnership(Server server, View view, int n, int n2) {
        CmdAcquireObjectOwnership cmdAcquireObjectOwnership = new CmdAcquireObjectOwnership(server, view, n, n2);
        cmdAcquireObjectOwnership.execute();
    }

    SecurityAccess() {
    }
}

