/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AccessCheckSecLogID;
import com.starbase.starteam.ContainerACLSecLogID;
import com.starbase.starteam.ObjectACLSecLogID;
import com.starbase.starteam.Server;
import com.starbase.starteam.User;
import com.starbase.starteam.UserGroupSecLogID;
import com.starbase.starteam.Workstation;
import com.starbase.starteam.vts.comm.Command;
import com.starbase.util.OLEDate;
import java.io.IOException;
import java.util.Vector;

public class SecurityLogEntry {
    private Server m_server = null;
    private int m_eSecEventType = 0;
    private int m_userID = -1;
    private int m_workstationID = -1;
    private OLEDate m_timestamp;
    private boolean m_bFailure = false;
    private String m_objectDisplayText = "";
    Workstation m_workstation = null;
    private AccessCheckSecLogID m_accessCheckSecLogID = null;
    private ContainerACLSecLogID m_containerACLSecLogID = null;
    private ObjectACLSecLogID m_objectACLSecLogID = null;
    private UserGroupSecLogID m_userGroupSecLogID = null;

    public int getUserID() {
        return this.m_userID;
    }

    public User getUser() {
        return this.m_server.getUser(this.m_userID);
    }

    public int getWorkstationID() {
        return this.m_workstationID;
    }

    public Workstation getWorkstation() {
        return this.m_workstation;
    }

    public OLEDate getTimestamp() {
        return this.m_timestamp;
    }

    public boolean isFailure() {
        return this.m_bFailure;
    }

    public String getObjectDisplayText() {
        return this.m_objectDisplayText;
    }

    public UserGroupSecLogID getUserGroupSecLogID() {
        return this.m_userGroupSecLogID;
    }

    public ContainerACLSecLogID getContainerACLSecLogID() {
        return this.m_containerACLSecLogID;
    }

    public ObjectACLSecLogID getObjectACLSecLogID() {
        return this.m_objectACLSecLogID;
    }

    public AccessCheckSecLogID getAccessCheckSecLogID() {
        return this.m_accessCheckSecLogID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t");
        stringBuffer.append("User: " + this.getUser().toString());
        Workstation workstation = this.getWorkstation();
        if (workstation == null) {
            stringBuffer.append(" Workstation: null");
        } else {
            stringBuffer.append(" Workstation: " + workstation.toString());
        }
        stringBuffer.append(" Timestamp: " + this.m_timestamp.toISO8601String());
        stringBuffer.append(" Failure: " + this.m_bFailure);
        stringBuffer.append(" Display: " + this.m_objectDisplayText);
        if (this.m_userGroupSecLogID != null) {
            stringBuffer.append(" UserGroupSecLogID: >>>" + this.m_userGroupSecLogID.toString() + "<<< ");
        }
        if (this.m_containerACLSecLogID != null) {
            stringBuffer.append(" ContainerACLSecLogID: >>>" + this.m_containerACLSecLogID.toString() + "<<< ");
        }
        if (this.m_objectACLSecLogID != null) {
            stringBuffer.append(" ObjectACLSecLogID: >>>" + this.m_objectACLSecLogID.toString() + "<<< ");
        }
        if (this.m_accessCheckSecLogID != null) {
            stringBuffer.append(" AccessCheckSecLogID: >>>" + this.m_accessCheckSecLogID.toString() + "<<< ");
        }
        return stringBuffer.toString();
    }

    static void readEntry(Command command, Vector vector, Server server) throws IOException {
        int n = command.readInt();
        int n2 = command.readInt();
        int n3 = command.readInt();
        int n4 = command.readInt();
        OLEDate oLEDate = new OLEDate(command.readTime());
        boolean bl = command.readBoolean();
        String string = command.readString();
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        SecurityLogEntry securityLogEntry = null;
        switch (n2) {
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: {
                n5 = command.readInt();
                UserGroupSecLogID userGroupSecLogID = new UserGroupSecLogID(n5);
                securityLogEntry = new SecurityLogEntry(server, n2, n3, n4, oLEDate, bl, string, userGroupSecLogID, null, null, null);
                break;
            }
            case 65536: 
            case 65537: {
                n6 = command.readInt();
                n7 = command.readInt();
                n8 = command.readInt();
                ContainerACLSecLogID containerACLSecLogID = new ContainerACLSecLogID(n6, n7, n8);
                securityLogEntry = new SecurityLogEntry(server, n2, n3, n4, oLEDate, bl, string, null, containerACLSecLogID, null, null);
                break;
            }
            case 4096: 
            case 4097: 
            case 4098: 
            case 4099: 
            case 4100: {
                n7 = command.readInt();
                n8 = command.readInt();
                ObjectACLSecLogID objectACLSecLogID = new ObjectACLSecLogID(n7, n8);
                securityLogEntry = new SecurityLogEntry(server, n2, n3, n4, oLEDate, bl, string, null, null, objectACLSecLogID, null);
                break;
            }
            case 0x100000: {
                n7 = command.readInt();
                n8 = command.readInt();
                AccessCheckSecLogID accessCheckSecLogID = new AccessCheckSecLogID(n7, n8);
                securityLogEntry = new SecurityLogEntry(server, n2, n3, n4, oLEDate, bl, string, null, null, null, accessCheckSecLogID);
                break;
            }
            default: {
                securityLogEntry = new SecurityLogEntry(server, n2, n3, n4, oLEDate, bl, string, null, null, null, null);
            }
        }
        vector.addElement(securityLogEntry);
    }

    private SecurityLogEntry() {
    }

    SecurityLogEntry(Server server, int n, int n2, int n3, OLEDate oLEDate, boolean bl, String string, UserGroupSecLogID userGroupSecLogID, ContainerACLSecLogID containerACLSecLogID, ObjectACLSecLogID objectACLSecLogID, AccessCheckSecLogID accessCheckSecLogID) {
        this.m_server = server;
        this.m_eSecEventType = n;
        this.m_userID = n2;
        this.m_workstationID = n3;
        this.m_timestamp = oLEDate;
        this.m_bFailure = bl;
        this.m_objectDisplayText = string;
        this.m_userGroupSecLogID = userGroupSecLogID;
        this.m_containerACLSecLogID = containerACLSecLogID;
        this.m_objectACLSecLogID = objectACLSecLogID;
        this.m_accessCheckSecLogID = accessCheckSecLogID;
    }

    public static interface SecurityEventType {
        public static final int eUnknownEvent = 0;
        public static final int eLogon = 1;
        public static final int eLogout = 2;
        public static final int eSuspendedAccount = 3;
        public static final int eAccessTimeRestricted = 4;
        public static final int eNoSuchLoginName = 5;
        public static final int eLoginFailure = 6;
        public static final int ePasswordExpired = 7;
        public static final int eLockout = 8;
        public static final int ePolicyChange = 16;
        public static final int eUserGroupAdd = 256;
        public static final int eUserGroupDrop = 257;
        public static final int eUserGroupEdit = 258;
        public static final int eUserGroupStatusChange = 259;
        public static final int eUserGroupForceLogout = 260;
        public static final int eUserChange = 261;
        public static final int eObjectACLAddEdit = 4096;
        public static final int eObjectACLDelete = 4097;
        public static final int eObjectACLAddOwner = 4098;
        public static final int eObjectACLDropOwner = 4099;
        public static final int eObjectACLAcquireOwnership = 4100;
        public static final int eContainerACLAddEdit = 65536;
        public static final int eContainerACLDelete = 65537;
        public static final int eObjectAccessCheck = 0x100000;
    }
}

