/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import System.Exception;
import com.starbase.starteam.CacheRefCollection;
import com.starbase.starteam.ClientContext;
import com.starbase.starteam.CmdBeginLogin;
import com.starbase.starteam.CmdFolderToItemLink;
import com.starbase.starteam.CmdGetComponentList;
import com.starbase.starteam.CmdGetEventHandlerNames;
import com.starbase.starteam.CmdGetMailAvailability;
import com.starbase.starteam.CmdGetMailUsers;
import com.starbase.starteam.CmdGetParentFolders;
import com.starbase.starteam.CmdGetUserInfo;
import com.starbase.starteam.CmdNewServerLogin;
import com.starbase.starteam.CmdPingServer;
import com.starbase.starteam.CmdRequiredEncryption;
import com.starbase.starteam.CmdSendMail;
import com.starbase.starteam.CmdServerLogOff;
import com.starbase.starteam.CmdServerLogin;
import com.starbase.starteam.DeleteMethods;
import com.starbase.starteam.EmailAttachment;
import com.starbase.starteam.EventHandlerInfo;
import com.starbase.starteam.EventHandlerProfile;
import com.starbase.starteam.FileBasedStatusManager;
import com.starbase.starteam.FileSyncCache;
import com.starbase.starteam.FileSyncInfo;
import com.starbase.starteam.Filter;
import com.starbase.starteam.Folder;
import com.starbase.starteam.GetMethods;
import com.starbase.starteam.Group;
import com.starbase.starteam.Implementations;
import com.starbase.starteam.Item;
import com.starbase.starteam.Link;
import com.starbase.starteam.MPXEventQueue;
import com.starbase.starteam.MPXException;
import com.starbase.starteam.MPXStatusListener;
import com.starbase.starteam.MPXStatus_Marshaler;
import com.starbase.starteam.MyUserAccount;
import com.starbase.starteam.NamedCacheRefCollection;
import com.starbase.starteam.PopulateMethods;
import com.starbase.starteam.Project;
import com.starbase.starteam.ProjectEvent_Marshaler;
import com.starbase.starteam.ProjectListener;
import com.starbase.starteam.Project_CacheRefCollection;
import com.starbase.starteam.PropertyEnums;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.PutMethods;
import com.starbase.starteam.Query;
import com.starbase.starteam.QueryInfo;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SDKRuntimeException;
import com.starbase.starteam.ServerAdministration;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.ServerConfiguration;
import com.starbase.starteam.ServerControlEvent_Marshaler;
import com.starbase.starteam.ServerControlListener;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.ServerSession;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.Server_CacheManagerCollection;
import com.starbase.starteam.Server_PseudoConstants;
import com.starbase.starteam.StatusDataImpl;
import com.starbase.starteam.StatusMethod;
import com.starbase.starteam.SupportedFeatures;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypeEvent_Marshaler;
import com.starbase.starteam.TypeListener;
import com.starbase.starteam.TypeNames;
import com.starbase.starteam.TypeNotFoundException;
import com.starbase.starteam.User;
import com.starbase.starteam.UserAccountMarshaller;
import com.starbase.starteam.UserAccount_Data;
import com.starbase.starteam.UserEvent_Marshaler;
import com.starbase.starteam.UserListener;
import com.starbase.starteam.View;
import com.starbase.starteam.ViewSession;
import com.starbase.starteam.vts.comm.Connection;
import com.starbase.starteam.vts.comm.EncryptionAlgorithm;
import com.starbase.starteam.vts.comm.SystemRevisionNumbers;
import com.starbase.starteam.vts.comm.TcpIpConnection;
import com.starbase.starteam.vts.pickle.LoginInfo;
import com.starbase.util.Assert;
import com.starbase.util.GUID;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Server {
    private static final String EMPTY = "";
    private static final String DOT = ".";
    private static final String SPACE = " ";
    private static final int m_defaultProtocol = 6;
    private GUID m_repositoryID;
    private String m_address;
    private int m_port;
    private Connection m_connection = null;
    private String m_ConnectMPXProfile = null;
    private boolean m_componentInfo_Retrieved = false;
    private Hashtable m_componentInfo = new Hashtable();
    private Project_CacheRefCollection m_projects = null;
    private NamedCacheRefCollection m_types = null;
    private TypeNames m_typeNames = null;
    private Hashtable m_destIDCache = new Hashtable();
    private SupportedFeatures m_features = null;
    private CacheRefCollection m_users = null;
    private CacheRefCollection m_groups = null;
    private short m_revisionLevel = (short)-1;
    private String m_commandAPIRevision = "1.0";
    private PropertyNames m_propertyNames = null;
    private PropertyEnums m_propertyEnums = null;
    private Implementations m_impl = null;
    private String m_endpoint;
    private boolean m_groupInfo_Retrieved = false;
    private boolean m_loggedOn = false;
    private LoginInfo m_loginInfo = null;
    private int m_compressionLevel = 0;
    private EncryptionAlgorithm m_algorithmID = null;
    private FileSyncCache m_syncCache = null;
    private ServerAdministration m_admin = new ServerAdministration(this);
    private Boolean m_mailAvailable = null;
    private int m_protocol = 6;
    private boolean m_isConnected = false;
    private Session m_session;
    private Hashtable m_viewSessions;
    private boolean m_importMode = false;
    private ClientContext m_clientContext = new ClientContext();
    private int m_userID = -1;
    private Hashtable m_eventHandlerInfos = null;
    private int[] m_productCodes = new int[0];
    private Server_CacheManager m_serverCacheManager = null;
    private Hashtable m_sessions = new Hashtable(2, 0.5f);
    private Hashtable m_userToViewSessionTable = new Hashtable(2, 0.5f);
    private Thread m_handleEventsThread = null;
    private boolean m_bHandleEvents = false;
    private MPXEventQueue m_eventQueue = null;
    private MPXStatus_Marshaler m_MPXStatusMarshaler = null;
    private ServerControlEvent_Marshaler m_serverControlEventMarshaler = null;
    private TypeEvent_Marshaler m_typeEventMarshaler = null;
    private UserEvent_Marshaler m_userEventMarshaler = null;
    private ProjectEvent_Marshaler m_projectEventMarshaler = null;
    private Thread m_keepAliveThread = null;
    private int m_nKeepAliveMinutes = 0;

    Server_CacheManager getServerCacheManager() {
        if (this.m_serverCacheManager == null) {
            this.m_serverCacheManager = Server_CacheManagerCollection.get(this);
            Server_CacheManagerCollection.addRef(this.m_serverCacheManager);
        }
        Server_CacheManagerCollection.touch(this.m_serverCacheManager);
        return this.m_serverCacheManager;
    }

    private Project_CacheRefCollection getProjectCollection() {
        if (this.m_projects == null) {
            this.m_projects = new Project_CacheRefCollection(this);
        }
        return this.m_projects;
    }

    void cacheNewProject(Project project) {
        this.getProjectCollection().addProject(project);
    }

    private NamedCacheRefCollection getTypeCacheRefCollection() {
        if (this.m_types == null) {
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        return this.m_types;
    }

    private CacheRefCollection getUserCacheRefCollection() {
        if (this.m_users == null) {
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        return this.m_users;
    }

    private CacheRefCollection getGroupCacheRefCollection() {
        if (this.m_groups == null) {
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        return this.m_groups;
    }

    public ServerAdministration getAdministration() {
        return this.m_admin;
    }

    public Link[] findLinks(Item item) {
        Vector vector = null;
        Query query = Query.newQueryContainedBy(this.getTypeNames().LINK, item);
        vector = this.getItems(query);
        Object[] objectArray = new Link[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isRefreshTypesRequired() {
        return this.isRefreshTypesRequired(false);
    }

    boolean isRefreshTypesRequired(boolean bl) {
        if (this.getTypeCacheRefCollection().isRefreshRequired()) {
            return true;
        }
        if (bl) {
            Vector vector = this.getTypeCacheRefCollection().getRefs();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Type type = (Type)enumeration.nextElement();
                if (!type.isRefreshMembersRequired()) continue;
                return true;
            }
        }
        return false;
    }

    public void refreshTypes() {
        this.refreshTypes(false);
    }

    void refreshTypes(boolean bl) {
        Vector vector = this.getTypeCacheRefCollection().getRefs();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            if (bl) {
                type.refreshMembers();
                continue;
            }
            type.clearMembers();
        }
        this.getTypeCacheRefCollection().refresh();
    }

    public void refreshTypesInPlace() {
        this.refreshTypes();
    }

    public void discardTypes() {
        this.getTypeCacheRefCollection().discard();
    }

    private void initTypes() {
        this.m_types = new NamedCacheRefCollection(this.getServerCacheManager().getTypeCache(), this);
        this.m_types.populate();
        if (!this.m_componentInfo_Retrieved) {
            this.initComponentInfo();
        }
        Enumeration enumeration = this.m_types.getRefs().elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            this.m_impl.addClientProperties(type);
        }
    }

    public MyUserAccount getMyUserAccount() {
        CmdGetUserInfo cmdGetUserInfo = new CmdGetUserInfo(new UserAccountMarshaller(this));
        cmdGetUserInfo.execute(this.useConnection(), this.getSession().getID(), 0, 0);
        MyUserAccount myUserAccount = cmdGetUserInfo.getMyUserAccount();
        if (myUserAccount == null) {
            Assert.internalError("Server.getMyUserAccount(), account=null");
        }
        return myUserAccount;
    }

    void setCommandTime(double d) {
        this.useConnection().setCommandTime(d);
    }

    void setCommandUserID(int n) {
        this.useConnection().setCommandUserID(n);
    }

    void enableImportMode() {
        this.m_importMode = true;
    }

    void switchUserContext(int n) {
        if (!this.m_importMode) {
            throw new IllegalStateException(Res.getString(ResIDs.IMPORT_MODE_REQUIRED));
        }
        Session session = (Session)this.m_sessions.get(new Integer(n));
        this.setSession(session);
        this.setViewSessionTable(n);
        if (!this.ping()) {
            this.setSession(null);
            this.m_sessions.remove(new Integer(n));
            this.removeViewSessionTable(n);
            throw new RuntimeException(Res.getString(ResIDs.STARTEAM_SERVER_NOT_RESPONDING));
        }
    }

    public ServerSession getSession() {
        return this.m_session;
    }

    void setSession(Session session) {
        this.m_session = session;
    }

    ViewSession getViewSession(View view) {
        String string = "|Project" + view.getProject().getID() + "|View" + view.getViewID() + "|" + view.getConfiguration() + "|";
        ViewSession viewSession = (ViewSession)this.m_viewSessions.get(string);
        if (viewSession != null && !viewSession.isAlive()) {
            this.m_viewSessions.remove(string);
            viewSession = null;
        }
        if (viewSession == null) {
            viewSession = new ViewSession(this, view);
            this.m_viewSessions.put(string, viewSession);
        }
        return viewSession;
    }

    private void setViewSessionTable(int n) {
        Hashtable hashtable = (Hashtable)this.m_userToViewSessionTable.get(new Integer(n));
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.m_userToViewSessionTable.put(new Integer(n), hashtable);
        }
        this.m_viewSessions = hashtable;
    }

    private void removeViewSessionTable(int n) {
        this.m_userToViewSessionTable.remove(new Integer(n));
    }

    Hashtable getDestIDCache() {
        if (this.isSyncStoredLocally()) {
            Assert.internalError("Server.getDestIDCache()");
        }
        return this.m_destIDCache;
    }

    void populateValues(Vector vector, String[] stringArray) {
        PopulateMethods.populate(this, vector, stringArray);
    }

    Vector getItems(Query query) {
        return GetMethods.get(this, query);
    }

    void putItems(Vector vector) {
        PutMethods.put(this, vector);
    }

    void deleteItems(Vector vector) {
        DeleteMethods.delete(this, vector);
    }

    Folder getParentFolder(Item item) {
        CmdGetParentFolders cmdGetParentFolders = new CmdGetParentFolders(item);
        cmdGetParentFolders.execute(this.useConnection(), this.getSession().getID(), this.getViewSession(item.getView()).getID(), this.getComponentID(ServerComponentInfo.PROJECT));
        return cmdGetParentFolders.getFolder();
    }

    Item newItem(Type type, View view) {
        return this.newItem(type, view, false);
    }

    Item newItem(Type type, View view, boolean bl) {
        if (this.m_impl == null) {
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        Item item = this.m_impl.createItem(type, view);
        item.setDisembodied(bl);
        return item;
    }

    private void setProtocol(int n) {
        if (n != 6) {
            if (n == 7) {
                throw new IllegalArgumentException(Res.getString(ResIDs.XML_PROTOCOL_IS_OBSOLETE));
            }
            if (ServerConfiguration.isValidProtocol(n)) {
                throw new IllegalArgumentException(Res.formatKey(ResIDs.PROTOCOL_NOT_SUPPORTED_FMT, new Object[]{new Integer(n)}));
            }
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_PROTOCOL_FMT, new Object[]{new Integer(n)}));
        }
        this.m_protocol = n;
    }

    private void initialize(String string, int n, EncryptionAlgorithm encryptionAlgorithm, boolean bl, int n2) {
        this.setProtocol(n2);
        this.m_address = string;
        this.m_port = n;
        this.m_algorithmID = encryptionAlgorithm;
        this.m_compressionLevel = bl ? 6 : 0;
        this.m_syncCache = new FileSyncCache(this);
    }

    private void initComponentInfo() {
        this.getTypeCacheRefCollection().populate();
        CmdGetComponentList cmdGetComponentList = new CmdGetComponentList();
        cmdGetComponentList.execute(this.useConnection(), this.getSession().getID(), 0, 0);
        GUID[] gUIDArray = cmdGetComponentList.getComponentGuids();
        int[] nArray = cmdGetComponentList.getPrimaryClassIDs();
        Vector<ServerComponentInfo> vector = new Vector<ServerComponentInfo>();
        Type type = this.typeForName(this.getTypeNames().PROJECT);
        ServerComponentInfo serverComponentInfo = new ServerComponentInfo(ServerComponentInfo.PROJECT, 0, type);
        vector.addElement(serverComponentInfo);
        int n = 0;
        while (n < gUIDArray.length) {
            Type type2 = this.typeForClassID(nArray[n]);
            ServerComponentInfo serverComponentInfo2 = new ServerComponentInfo(gUIDArray[n], n + 1, type2);
            vector.addElement(serverComponentInfo2);
            ++n;
        }
        this.setComponentInfo(vector);
    }

    public User[] fetchEmailUsers() {
        CmdGetMailUsers cmdGetMailUsers = new CmdGetMailUsers(this);
        cmdGetMailUsers.execute(this.useConnection(), this.getSession().getID(), 0, 0);
        return cmdGetMailUsers.getEmailUsers();
    }

    public boolean isRefreshUsersRequired() {
        return this.getUserCacheRefCollection().isRefreshRequired();
    }

    public void refreshUsers() {
        this.getUserCacheRefCollection().refresh();
    }

    public void discardUsers() {
        this.getUserCacheRefCollection().discard();
    }

    public void refreshAccounts() {
        this.refreshUsers();
        this.refreshGroups();
    }

    public void discardAccounts() {
        this.discardUsers();
        this.discardGroups();
    }

    public boolean isRefreshAccountsRequired() {
        return this.isRefreshGroupsRequired() || this.isRefreshUsersRequired();
    }

    public boolean isRefreshGroupsRequired() {
        return this.getGroupCacheRefCollection().isRefreshRequired();
    }

    public void discardGroups() {
        this.getGroupCacheRefCollection().discard();
    }

    public void refreshGroups() {
        this.getGroupCacheRefCollection().refresh();
    }

    private void initUserInfo() {
        this.refreshUsers();
    }

    public String getAddress() {
        if (this.m_address == null) {
            Assert.internalError("Server.getAddress(), address=null");
        }
        return this.m_address;
    }

    public int getPort() {
        return this.m_port;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.m_algorithmID;
    }

    public boolean isCompressed() {
        return this.m_compressionLevel > 0;
    }

    public int getProtocol() {
        return this.m_protocol;
    }

    public GUID getRepositoryID() {
        if (this.m_repositoryID == null) {
            if (this.m_revisionLevel >= 100) {
                throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
            }
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        return this.m_repositoryID;
    }

    public EncryptionAlgorithm getRequiredEncryptionLevel() {
        EncryptionAlgorithm encryptionAlgorithm = null;
        CmdRequiredEncryption cmdRequiredEncryption = new CmdRequiredEncryption();
        cmdRequiredEncryption.execute(this.useConnection(), null, 0, 0);
        encryptionAlgorithm = cmdRequiredEncryption.getEncryptionAlgorithm();
        if (encryptionAlgorithm == null) {
            Assert.internalError("Server.getRequiredEncryptionLevel(), id=null");
        }
        return encryptionAlgorithm;
    }

    public boolean isConnected() {
        return this.m_isConnected;
    }

    public Connection useConnection() {
        return this.m_connection;
    }

    public ClientContext getClientContext() {
        return this.m_clientContext;
    }

    public Project[] getProjects() {
        Project_CacheRefCollection project_CacheRefCollection = this.getProjectCollection();
        project_CacheRefCollection.refreshProjects();
        Vector vector = project_CacheRefCollection.getRefs();
        Project[] projectArray = new Project[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Project project = (Project)enumeration.nextElement();
            projectArray[n++] = project.copy(1);
        }
        return projectArray;
    }

    Project getProject(int n) {
        boolean bl = false;
        Project project = null;
        Project[] projectArray = this.getProjectCollection().toArray();
        int n2 = 0;
        while (n2 < projectArray.length) {
            Project project2 = projectArray[n2];
            if (project2.getID() == n) {
                if (bl) {
                    Assert.internalError("Server.getProject(), bFoundOne=true, id=" + n);
                }
                bl = true;
                project = project2;
            }
            ++n2;
        }
        if (project == null) {
            Assert.internalError("Server.getProject(), result=null, id=" + n);
        }
        return project;
    }

    private Vector getComponentInfo() {
        Vector vector = null;
        if (!this.m_componentInfo_Retrieved) {
            this.initComponentInfo();
        }
        vector = new Vector(this.m_componentInfo.size());
        Enumeration enumeration = this.m_componentInfo.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (vector == null) {
            Assert.internalError("Server.getComponentInfo(), info=null");
        }
        return vector;
    }

    private void setComponentInfo(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ServerComponentInfo serverComponentInfo = (ServerComponentInfo)vector.elementAt(n);
            this.m_componentInfo.put(serverComponentInfo.getID(), serverComponentInfo);
            ++n;
        }
        this.m_componentInfo_Retrieved = true;
    }

    ServerComponentInfo componentForID(GUID gUID) {
        ServerComponentInfo serverComponentInfo;
        if (gUID == null) {
            Assert.internalError("Server.componentForID(), guid=null");
        }
        if (!this.m_componentInfo_Retrieved) {
            this.initComponentInfo();
        }
        if ((serverComponentInfo = (ServerComponentInfo)this.m_componentInfo.get(gUID)) == null) {
            Assert.internalError("Server.componentForID(), info=null, guid=" + gUID);
        }
        return serverComponentInfo;
    }

    public boolean isTypeSupported(String string) {
        return this.getTypeForName(string) != null;
    }

    public Type[] getTypes() {
        this.getTypeCacheRefCollection().populate();
        Type[] typeArray = new Type[this.getTypeCacheRefCollection().getRefs().size()];
        Enumeration enumeration = this.getTypeCacheRefCollection().getRefs().elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            typeArray[n++] = (Type)enumeration.nextElement();
        }
        if (typeArray == null) {
            Assert.internalError("Server.getTypes(), types=null");
        }
        return typeArray;
    }

    public Type typeForName(String string) throws IllegalArgumentException, TypeNotFoundException {
        Type type = this.getTypeForName(string);
        if (type == null) {
            throw new TypeNotFoundException(string, this);
        }
        return type;
    }

    private Type getTypeForName(String string) throws IllegalArgumentException {
        if (string == null) {
            Assert.nullArgument("String", "typeName");
        }
        this.getTypeCacheRefCollection().populate();
        return (Type)this.getTypeCacheRefCollection().getByName(string);
    }

    protected Vector getItemTypes() {
        Vector<Type> vector = new Vector<Type>();
        Type[] typeArray = this.getTypes();
        int n = 0;
        while (n < typeArray.length) {
            Type type = typeArray[n];
            if (type.isItemType()) {
                vector.addElement(type);
            }
            ++n;
        }
        return vector;
    }

    int typeNumberForName(String string) throws IllegalArgumentException, TypeNotFoundException {
        return this.typeForName(string).getClassID();
    }

    String typeNameForNumber(int n) throws IllegalArgumentException, TypeNotFoundException {
        return this.typeForClassID(n).getName();
    }

    public Type typeForClassID(int n) throws TypeNotFoundException {
        this.getTypeCacheRefCollection().populate();
        Type type = (Type)this.getTypeCacheRefCollection().getByID(n);
        if (type == null) {
            throw new TypeNotFoundException(n, this);
        }
        return type;
    }

    public User[] getActiveUsers() {
        Object object;
        this.getUserCacheRefCollection().populate();
        Vector vector = this.getUserCacheRefCollection().getRefs();
        int n = vector.size();
        if (n == 0) {
            Assert.internalError("Server.getActiveUsers(), size=0");
        }
        Vector<Object> vector2 = new Vector<Object>(n);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (User)enumeration.nextElement();
            if (((User)object).isDeleted()) continue;
            vector2.addElement(object);
        }
        object = new User[vector2.size()];
        enumeration = vector2.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object[n2++] = (User)enumeration.nextElement();
        }
        return object;
    }

    public User[] getUsers() {
        this.getUserCacheRefCollection().populate();
        Vector vector = this.getUserCacheRefCollection().getRefs();
        int n = vector.size();
        if (n == 0) {
            Assert.internalError("Server.getUsers(), size=0");
        }
        User[] userArray = new User[n];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            userArray[n2++] = (User)enumeration.nextElement();
        }
        return userArray;
    }

    public Group[] getActiveGroups() {
        Object object;
        this.getGroupCacheRefCollection().populate();
        Vector vector = this.getGroupCacheRefCollection().getRefs();
        int n = vector.size();
        if (n == 0) {
            Assert.internalError("Server.getActiveGroups(), size=0");
        }
        Vector<Object> vector2 = new Vector<Object>(n);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Group)enumeration.nextElement();
            if (((Group)object).isDeleted()) continue;
            vector2.addElement(object);
        }
        object = new Group[vector2.size()];
        enumeration = vector2.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            object[n2++] = (Group)enumeration.nextElement();
        }
        return object;
    }

    public Group[] getGroups() {
        this.getGroupCacheRefCollection().populate();
        Vector vector = this.getGroupCacheRefCollection().getRefs();
        int n = vector.size();
        if (n == 0) {
            Assert.internalError("Server.getGroups(), size=0");
        }
        Group[] groupArray = new Group[n];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            groupArray[n2++] = (Group)enumeration.nextElement();
        }
        return groupArray;
    }

    public User getUser(int n) {
        this.getUserCacheRefCollection().populate();
        return (User)this.getUserCacheRefCollection().getByID(n);
    }

    public Group getGroup(int n) {
        this.getGroupCacheRefCollection().populate();
        return (Group)this.getGroupCacheRefCollection().getByID(n);
    }

    public SupportedFeatures getSupportedFeatures() {
        if (this.m_features == null) {
            throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
        }
        return this.m_features;
    }

    public boolean hasProductCodeInformation() {
        return this.getRevisionLevel() >= 46;
    }

    public int[] getProductCodes() {
        return this.m_productCodes;
    }

    public boolean hasProductCode(int n) {
        int[] nArray = this.getProductCodes();
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n == nArray[n2]) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    boolean supports(short s, String string) {
        return SystemRevisionNumbers.equalOrGreater(this.getRevisionLevel(), this.getCommandAPIRevisionLevel(), s, string);
    }

    public short getRevisionLevel() {
        return this.m_revisionLevel;
    }

    public String getCommandAPIRevisionLevel() {
        return this.m_commandAPIRevision;
    }

    public String getServerBuild() {
        int n;
        if (this.m_connection == null) {
            return EMPTY;
        }
        String string = this.m_connection.getServerBuild();
        if ((string == null || string.length() == 0) && (string = SystemRevisionNumbers.getRevisionName(this.getRevisionLevel())) != null && (n = string.indexOf(DOT, 0)) >= 0) {
            int n2 = string.indexOf(DOT, n + 1);
            if (n2 > n) {
                string = string.substring(0, n2);
            }
            if ((n2 = string.indexOf(SPACE, n + 1)) > n) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    public String getServerBuildDescription() {
        if (this.m_connection == null) {
            return EMPTY;
        }
        String string = this.m_connection.getServerBuildDescription();
        if (string == null || string.length() == 0) {
            string = this.getServerBuild();
        }
        return string;
    }

    public PropertyNames getPropertyNames() {
        if (this.m_propertyNames == null) {
            throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
        }
        return this.m_propertyNames;
    }

    public PropertyEnums getPropertyEnums() {
        if (this.m_propertyEnums == null) {
            throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
        }
        return this.m_propertyEnums;
    }

    public TypeNames getTypeNames() {
        if (this.m_typeNames == null) {
            throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
        }
        return this.m_typeNames;
    }

    public int getCommandCount() {
        if (this.m_connection == null) {
            return 0;
        }
        return this.m_connection.getCommandCount();
    }

    public int getMPXMessageCount() {
        return this.m_serverCacheManager == null ? 0 : this.m_serverCacheManager.getMPXMessageCount();
    }

    public void connect() {
        block7: {
            this.m_connection = new TcpIpConnection(this.getAddress(), this.getPort(), this.m_protocol, this);
            try {
                if (this.m_connection.open(this.m_clientContext.getWorkStationID(), this.m_clientContext.getHostName())) {
                    this.m_isConnected = true;
                    this.m_connection.setCompressionLevel(this.m_compressionLevel);
                    this.m_revisionLevel = this.m_connection.getRevisionLevel();
                    this.m_commandAPIRevision = this.m_connection.getCommandAPIRevisionLevel();
                    Server_PseudoConstants server_PseudoConstants = Server_PseudoConstants.get(this.m_revisionLevel);
                    this.m_typeNames = server_PseudoConstants.getTypeNames();
                    this.m_propertyNames = server_PseudoConstants.getPropertyNames();
                    this.m_propertyEnums = server_PseudoConstants.getPropertyEnums();
                    this.m_features = new SupportedFeatures(this.m_revisionLevel, this.m_commandAPIRevision, this.getServerBuildDescription());
                    this.m_impl = new Implementations(this);
                    if (this.m_revisionLevel >= 100) {
                        this.m_repositoryID = this.m_connection.getServerGUID();
                        if (this.m_ConnectMPXProfile != null) {
                            try {
                                this.enableMPX(this.m_ConnectMPXProfile);
                            }
                            catch (MPXException mPXException) {}
                        }
                    }
                    break block7;
                }
                this.m_isConnected = false;
                throw new RuntimeException(this.getProblemOpeningConnectionMessage());
            }
            catch (IOException iOException) {
                throw new SDKRuntimeException(this.getProblemOpeningConnectionMessage(), iOException);
            }
        }
    }

    private String getProblemOpeningConnectionMessage() {
        String string = this.getAddress() + ":" + this.getPort();
        return Res.formatKey(ResIDs.PROBLEM_OPENING_CONNECTION_FMT, new Object[]{string});
    }

    /*
     * Loose catch block
     */
    public void disconnect() {
        block17: {
            if (this.isConnected()) {
                try {
                    try {
                        this.terminate();
                        if (this.m_importMode) {
                            Enumeration enumeration = this.m_sessions.elements();
                            while (enumeration.hasMoreElements()) {
                                Session session = (Session)enumeration.nextElement();
                                CmdServerLogOff cmdServerLogOff = new CmdServerLogOff();
                                cmdServerLogOff.execute(this.useConnection(), session.getID(), 0, 0);
                            }
                        } else if (this.m_loggedOn) {
                            CmdServerLogOff cmdServerLogOff = new CmdServerLogOff();
                            cmdServerLogOff.execute(this.useConnection(), this.getSession().getID(), 0, 0);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    Object var2_7 = null;
                    this.m_connection.disconnect();
                    this.m_isConnected = false;
                    this.m_loggedOn = false;
                    this.m_propertyNames = null;
                    this.m_propertyEnums = null;
                }
                catch (Throwable throwable) {
                    Object var2_9 = null;
                    this.m_connection.disconnect();
                    this.m_isConnected = false;
                    this.m_loggedOn = false;
                    this.m_propertyNames = null;
                    this.m_propertyEnums = null;
                    this.m_revisionLevel = (short)-1;
                    this.m_commandAPIRevision = null;
                    this.m_mailAvailable = null;
                    this.m_features = null;
                    throw throwable;
                }
                this.m_revisionLevel = (short)-1;
                this.m_commandAPIRevision = null;
                this.m_mailAvailable = null;
                this.m_features = null;
                {
                    break block17;
                    catch (Exception exception) {
                        Object var2_8 = null;
                        this.m_connection.disconnect();
                        this.m_isConnected = false;
                        this.m_loggedOn = false;
                        this.m_propertyNames = null;
                        this.m_propertyEnums = null;
                        this.m_revisionLevel = (short)-1;
                        this.m_commandAPIRevision = null;
                        this.m_mailAvailable = null;
                        this.m_features = null;
                    }
                }
            }
        }
        if (this.m_types != null) {
            this.m_types.clear();
            this.m_types = null;
        }
        if (this.m_users != null) {
            this.m_users.clear();
            this.m_users = null;
        }
        if (this.m_groups != null) {
            this.m_groups.clear();
            this.m_groups = null;
        }
        if (this.m_projects != null) {
            this.m_projects.clear();
            this.m_projects = null;
        }
        this.m_componentInfo = new Hashtable();
        this.m_componentInfo_Retrieved = false;
        this.m_revisionLevel = (short)-1;
        this.m_commandAPIRevision = null;
        this.m_features = null;
        this.m_propertyNames = null;
        this.m_propertyEnums = null;
        this.m_typeNames = null;
        this.m_impl = null;
        if (this.m_eventQueue != null) {
            this.m_eventQueue.kill();
            this.m_eventQueue = null;
        }
        this.m_projectEventMarshaler = null;
        this.m_userEventMarshaler = null;
        this.m_typeEventMarshaler = null;
        this.m_serverControlEventMarshaler = null;
        this.m_MPXStatusMarshaler = null;
        if (this.m_serverCacheManager != null) {
            Server_CacheManagerCollection.release(this.m_serverCacheManager);
            this.m_serverCacheManager = null;
        }
    }

    public int logOn(String string, String string2) {
        this.m_clientContext = new ClientContext();
        return this.logOnImpl(string, string2);
    }

    public int logOnForWorkstation(String string, String string2, GUID gUID) {
        if (string == null) {
            Assert.nullArgument("String", "logOnName");
        }
        if (string2 == null) {
            Assert.nullArgument("String", "password");
        }
        if (this.m_importMode) {
            throw new IllegalStateException(Res.getString(ResIDs.NOT_SUPPORTED_IN_IMPORT_MODE));
        }
        this.m_clientContext = gUID == null ? new ClientContext() : new ClientContext(gUID);
        int n = this.logOnImpl(string, string2);
        return n;
    }

    public int logOnWithClientContext(String string, String string2, ClientContext clientContext) {
        if (string == null) {
            Assert.nullArgument("String", "logOnName");
        }
        if (string2 == null) {
            Assert.nullArgument("String", "password");
        }
        if (clientContext == null) {
            Assert.nullArgument("ClientContext");
        }
        if (this.m_importMode) {
            throw new IllegalStateException(Res.getString(ResIDs.NOT_SUPPORTED_IN_IMPORT_MODE));
        }
        this.m_clientContext = clientContext;
        int n = this.logOnImpl(string, string2);
        return n;
    }

    public void reconnect() {
        this.reconnect(null);
    }

    public void reconnect(String string) {
        ServerSession serverSession;
        if (!this.isLoggedOn()) {
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        this.getSupportedFeatures().verifyHasReconnect();
        Connection connection = this.useConnection();
        if (connection == null) {
            Assert.internalError("Server.reconnect(), connection=null");
        }
        if ((serverSession = this.getSession()) == null) {
            Assert.internalError("Server.reconnect(), session=null");
        }
        GUID gUID = serverSession.getID();
        if (string != null) {
            connection.saveSessionInfo(gUID, null, UserAccount_Data.manglePassword(string));
        }
        connection.reconnect(gUID);
    }

    public boolean isAutoReconnectEnabled() {
        Connection connection = this.useConnection();
        if (connection != null) {
            return connection.isAutoReconnectEnabled();
        }
        return false;
    }

    public void setAutoReconnectEnabled(boolean bl) {
        Connection connection = this.useConnection();
        if (connection == null) {
            throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
        }
        connection.setAutoReconnectEnabled(bl);
    }

    public int getAutoReconnectAttempts() {
        Connection connection = this.useConnection();
        if (connection != null) {
            return connection.getAutoReconnectAttempts();
        }
        return 0;
    }

    public void setAutoReconnectAttempts(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        Connection connection = this.useConnection();
        if (connection == null) {
            throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
        }
        connection.setAutoReconnectAttempts(n);
    }

    public int getAutoReconnectWait() {
        Connection connection = this.useConnection();
        if (connection != null) {
            return connection.getAutoReconnectWait();
        }
        return 0;
    }

    public void setAutoReconnectWait(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Connection connection = this.useConnection();
        if (connection == null) {
            throw new IllegalStateException(Res.getString(ResIDs.CONNECT_REQUIRED));
        }
        connection.setAutoReconnectWait(n);
    }

    public boolean ping() {
        boolean bl = false;
        try {
            try {
                if (this.isConnected()) {
                    CmdPingServer cmdPingServer = new CmdPingServer();
                    GUID gUID = this.getSession() == null ? new GUID() : this.getSession().getID();
                    cmdPingServer.execute(this.useConnection(), gUID, 0, 0);
                    bl = true;
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("Server: ");
        stringBuffer.append(this.m_repositoryID);
        stringBuffer.append(", ");
        stringBuffer.append(this.getAddress());
        stringBuffer.append(", ");
        stringBuffer.append(this.getPort());
        return stringBuffer.toString();
    }

    Item addItemToFolder(Folder folder, Item item) {
        Type type = item.getType();
        CmdFolderToItemLink cmdFolderToItemLink = new CmdFolderToItemLink(folder, item);
        cmdFolderToItemLink.execute(this.useConnection(), this.getSession().getID(), this.getViewSession(folder.getView()).getID(), type.getClassID());
        Item item2 = this.newItem(type, folder.getView());
        item2.setItemID(cmdFolderToItemLink.getItemID());
        item2.setParentFolder(folder);
        return item2;
    }

    private void terminate() {
        Enumeration enumeration = this.m_userToViewSessionTable.elements();
        Enumeration enumeration2 = null;
        while (enumeration.hasMoreElements()) {
            enumeration2 = ((Hashtable)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                try {
                    try {
                        ((ViewSession)enumeration2.nextElement()).terminate();
                    }
                    catch (RuntimeException runtimeException) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    int getComponentID(GUID gUID) {
        ServerComponentInfo serverComponentInfo = this.componentForID(gUID);
        return serverComponentInfo.getRoutingOrdinal();
    }

    GUID getComponentGUID(Type type) {
        Enumeration enumeration = this.m_componentInfo.elements();
        while (enumeration.hasMoreElements()) {
            ServerComponentInfo serverComponentInfo = (ServerComponentInfo)enumeration.nextElement();
            if (serverComponentInfo.getPrimaryType().getClassID() != type.getClassID()) continue;
            return serverComponentInfo.getID();
        }
        return null;
    }

    int getClassID(String string) {
        return this.typeNumberForName(string);
    }

    private int logOnImpl(String string, String string2) {
        boolean bl = true;
        if (!this.isConnected()) {
            bl = false;
            this.connect();
        }
        if (this.m_loggedOn && !this.m_importMode) {
            throw new IllegalStateException(Res.getString(ResIDs.ALREADY_LOGGED_ON));
        }
        int n = -1;
        GUID gUID = this.m_connection.getClientGUID();
        if (this.getRevisionLevel() >= 100 && (this.m_importMode || bl)) {
            gUID = this.useConnection().startNewClientSession(this.m_clientContext);
        }
        CmdBeginLogin cmdBeginLogin = new CmdBeginLogin(this);
        cmdBeginLogin.execute(this.useConnection(), gUID, 0, 0);
        int n2 = cmdBeginLogin.getLoginID();
        EncryptionAlgorithm encryptionAlgorithm = this.getRequiredEncryptionLevel();
        EncryptionAlgorithm encryptionAlgorithm2 = EncryptionAlgorithm.maxSecurity(encryptionAlgorithm, this.m_algorithmID);
        if (encryptionAlgorithm2 != null && encryptionAlgorithm2 != EncryptionAlgorithm.NULL) {
            this.useConnection().enableEncryption(n2, encryptionAlgorithm2, 40);
        }
        byte[] byArray = UserAccount_Data.manglePassword(string2);
        if (this.getRevisionLevel() >= 100) {
            CmdNewServerLogin cmdNewServerLogin = new CmdNewServerLogin(n2, string, byArray);
            cmdNewServerLogin.execute(this.useConnection(), gUID, 0, 0);
            this.m_productCodes = cmdNewServerLogin.getProductCodes();
            n = cmdNewServerLogin.getUserID();
            Server server = this;
            if (server == null) {
                throw null;
            }
            Session session = server.new Session(gUID, n);
            this.setSession(session);
            if (this.m_importMode) {
                this.m_sessions.put(new Integer(n), session);
            }
            this.setViewSessionTable(n);
            this.useConnection().saveSessionInfo(gUID, string, byArray);
            this.m_loggedOn = true;
            this.m_loginInfo = cmdNewServerLogin.getLoginInfo();
        } else {
            CmdServerLogin cmdServerLogin = new CmdServerLogin(n2, this.m_clientContext.getWorkStationID(), this.m_clientContext.getHostName(), string, byArray);
            cmdServerLogin.execute(this.useConnection(), null, 0, 0);
            this.m_repositoryID = cmdServerLogin.getServerGuid();
            this.m_productCodes = cmdServerLogin.getProductCodes();
            n = cmdServerLogin.getUserID();
            gUID = cmdServerLogin.getClientID();
            Server server = this;
            if (server == null) {
                throw null;
            }
            Session session = server.new Session(gUID, n);
            this.setSession(session);
            if (this.m_importMode) {
                this.m_sessions.put(new Integer(n), session);
            }
            this.setViewSessionTable(n);
            this.useConnection().saveSessionInfo(gUID, string, byArray);
            this.m_loggedOn = true;
            this.m_loginInfo = cmdServerLogin.getLoginInfo();
            if (this.m_ConnectMPXProfile != null) {
                try {
                    this.enableMPX(this.m_ConnectMPXProfile);
                }
                catch (MPXException mPXException) {
                    // empty catch block
                }
            }
        }
        this.initTypes();
        this.m_groups = new CacheRefCollection(this.getServerCacheManager().getGroupCache(), this);
        this.m_users = new CacheRefCollection(this.getServerCacheManager().getUserCache(), this);
        this.m_userID = n;
        return n;
    }

    public boolean isLoggedOn() {
        return this.m_loggedOn;
    }

    LoginInfo getLoginInfo() {
        return this.m_loginInfo;
    }

    int getLoggedInUserID() {
        return this.m_userID;
    }

    public void sendMailFromView(View view, int[] nArray, int[] nArray2, int[] nArray3, String string, String string2) {
        this.sendMailWithAttachments(view, nArray, nArray2, nArray3, string, string2, null);
    }

    public void sendMailWithAttachments(View view, int[] nArray, int[] nArray2, int[] nArray3, String string, String string2, EmailAttachment[] emailAttachmentArray) {
        String[] stringArray = new String[]{this.getTypeNames().CHANGEREQUEST, this.getTypeNames().TOPIC, this.getTypeNames().TASK, this.getTypeNames().AUDIT};
        CmdSendMail cmdSendMail = new CmdSendMail(nArray, nArray2, nArray3, string, string2, emailAttachmentArray);
        int n = 0;
        while (n < stringArray.length) {
            try {
                int n2 = this.typeForName(stringArray[n]).getClassID();
                cmdSendMail.execute(this.useConnection(), this.getSession().getID(), this.getViewSession(view).getID(), n2);
                break;
            }
            catch (TypeNotFoundException typeNotFoundException) {
                ++n;
            }
        }
    }

    public Filter[] getFilterList(Type type, boolean bl) {
        Vector<Filter> vector = new Vector<Filter>();
        Filter[] filterArray = type.getFilters();
        int n = 0;
        while (n < filterArray.length) {
            if (filterArray[n].isPublic() == bl) {
                vector.addElement(filterArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new Filter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public QueryInfo[] getQueryList(Type type, boolean bl) {
        Vector<QueryInfo> vector = new Vector<QueryInfo>();
        QueryInfo[] queryInfoArray = type.getQueries();
        int n = 0;
        while (n < queryInfoArray.length) {
            if (queryInfoArray[n].isPublic() == bl) {
                vector.addElement(queryInfoArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new QueryInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    boolean isSyncStoredLocally() {
        return SystemRevisionNumbers.isClientManagedStatus(this.getRevisionLevel());
    }

    FileBasedStatusManager getFileBasedStatusManager(View view) {
        return StatusMethod.getStatusManagerForView(view);
    }

    FileSyncCache getFileSyncCache() {
        return this.m_syncCache;
    }

    private boolean getCaseSens() {
        return this.getClientContext().getCaseSensitiveFileNames();
    }

    void cacheStatusData(Folder folder, String string, StatusDataImpl statusDataImpl) {
        if (this.isSyncStoredLocally()) {
            try {
                this.getFileBasedStatusManager(folder.getView()).setFileSyncInfo(new File(string), statusDataImpl, this.getCaseSens());
            }
            catch (IOException iOException) {
                throw new SDKRuntimeException(Res.getString(ResIDs.STATUS_UPDATE_PROBLEM), iOException);
            }
        } else {
            this.m_syncCache.cacheStatusData(folder, string, statusDataImpl);
        }
    }

    void deleteFileSyncInfo(Folder folder, String string, View view) {
        if (this.isSyncStoredLocally()) {
            try {
                this.getFileBasedStatusManager(view).deleteFileSyncInfo(new File(string), this.getCaseSens());
            }
            catch (IOException iOException) {
                throw new SDKRuntimeException(Res.getString(ResIDs.STATUS_UPDATE_PROBLEM), iOException);
            }
        } else {
            this.m_syncCache.deleteFileSyncInfo(folder, string, view);
        }
    }

    FileSyncInfo getFileSyncInfo(Folder folder, String string) {
        if (this.isSyncStoredLocally()) {
            try {
                return this.getFileBasedStatusManager(folder.getView()).getFileSyncInfo(new File(string), this.getCaseSens());
            }
            catch (IOException iOException) {
                throw new SDKRuntimeException(Res.getString(ResIDs.STATUS_READ_PROBLEM), iOException);
            }
        }
        return this.m_syncCache.getFileSyncInfo(folder, string);
    }

    void refreshFolders(Vector vector) {
        if (!this.isSyncStoredLocally()) {
            this.m_syncCache.refreshFolders(vector);
        }
    }

    public void setForeignPassword(Project project) {
        this.setForeignPasswordExplicit(project.getConfigSource1(), project.getProjectType(), null);
    }

    public void setForeignPasswordExplicit(String string, int n, String string2) {
        ServerSession serverSession = this.getSession();
        if (serverSession == null) {
            throw new IllegalStateException(Res.getString(ResIDs.LOGON_REQUIRED));
        }
        byte[] byArray = null;
        if (string2 != null) {
            byArray = UserAccount_Data.manglePassword(string2);
        }
        this.useConnection().setForeignPassword(serverSession.getID(), string, n, byArray);
    }

    public boolean isMailAvailable() {
        if (this.m_mailAvailable == null) {
            CmdGetMailAvailability cmdGetMailAvailability = new CmdGetMailAvailability();
            cmdGetMailAvailability.execute(this.useConnection(), this.getSession().getID(), 0, 0);
            this.m_mailAvailable = new Boolean(cmdGetMailAvailability.getMailAvailable());
        }
        return this.m_mailAvailable;
    }

    public String[] getEventHandlerInfoNames() {
        CmdGetEventHandlerNames cmdGetEventHandlerNames = new CmdGetEventHandlerNames(this);
        cmdGetEventHandlerNames.execute();
        this.m_eventHandlerInfos = new Hashtable();
        String[] stringArray = cmdGetEventHandlerNames.getNames();
        String[] stringArray2 = cmdGetEventHandlerNames.getDescriptions();
        int n = 0;
        while (n < stringArray.length) {
            EventHandlerInfo eventHandlerInfo = new EventHandlerInfo(this, stringArray[n], stringArray2[n]);
            this.m_eventHandlerInfos.put(stringArray[n], eventHandlerInfo);
            ++n;
        }
        return stringArray;
    }

    public EventHandlerInfo getEventHandlerInfo(String string) {
        if (this.m_eventHandlerInfos == null) {
            this.getEventHandlerInfoNames();
        }
        return (EventHandlerInfo)this.m_eventHandlerInfos.get(string);
    }

    public boolean isMPXAvailable() {
        if (this.m_revisionLevel >= 80) {
            EventHandlerInfo eventHandlerInfo = this.getEventHandlerInfo("StarbaseMPX Transmitter");
            return eventHandlerInfo != null;
        }
        return false;
    }

    public void enableMPX() throws MPXException {
        if (this.m_revisionLevel >= 80) {
            EventHandlerInfo eventHandlerInfo = this.getEventHandlerInfo("StarbaseMPX Transmitter");
            if (eventHandlerInfo != null) {
                String string = (String)eventHandlerInfo.getProperty("ClientDefault");
                if (string != null) {
                    this.enableMPX(string);
                } else {
                    MPXException.throwNoDefaultClientProfileException();
                }
            } else {
                MPXException.throwNotInstalledException();
            }
        } else {
            MPXException.throwNotSupportedException();
        }
    }

    public void enableMPX(String string) throws MPXException {
        if (this.m_revisionLevel >= 80) {
            EventHandlerInfo eventHandlerInfo = this.getEventHandlerInfo("StarbaseMPX Transmitter");
            if (eventHandlerInfo != null) {
                EventHandlerProfile eventHandlerProfile = eventHandlerInfo.getProfile(string);
                if (eventHandlerProfile != null) {
                    this.enableMPX(eventHandlerProfile);
                } else {
                    MPXException.throwNoSuchProfileException(string);
                }
            } else {
                MPXException.throwNotInstalledException();
            }
        } else {
            MPXException.throwNotSupportedException();
        }
    }

    public void enableMPX(EventHandlerProfile eventHandlerProfile) throws MPXException {
        if (this.m_revisionLevel >= 80) {
            this.getServerCacheManager().enableMPX(this, eventHandlerProfile);
        } else {
            MPXException.throwNotSupportedException();
        }
    }

    public boolean isMPXEnabled() {
        return this.getServerCacheManager().isMPXEnabled();
    }

    public boolean isMPXResponding() {
        boolean bl = false;
        try {
            this.pingMPXServer();
            bl = true;
        }
        catch (MPXException mPXException) {
            // empty catch block
        }
        return bl;
    }

    public void pingMPXServer() throws MPXException {
        this.getServerCacheManager().pingMPXServer();
    }

    public void disableMPX() {
        this.getServerCacheManager().disableMPX();
    }

    /*
     * Unable to fully structure code
     */
    public void handleEvents() {
        var1_1 = Thread.currentThread();
        var2_2 = 0L;
        var4_3 = this;
        synchronized (var4_3) {
            if (this.m_handleEventsThread != null) {
                throw new IllegalStateException(Res.getString(ResIDs.HANDLE_EVENTS_ALREADY_CALLED));
            }
            if (!this.isMPXEnabled()) {
                throw new IllegalStateException(Res.getString(ResIDs.ENABLE_MPX_REQUIRED));
            }
            if (this.m_eventQueue == null) {
                throw new IllegalStateException(Res.getString(ResIDs.EVANT_HANDLERS_REQUIRED));
            }
            var6_4 = 5;
            try {
                var7_6 = this.getAdministration().getConfiguration().getInactivityTimeout();
                if (var7_6 > 0) {
                    var6_4 = (var7_6 + 1) / 2;
                    if (var6_4 < 1) {
                        var6_4 = 1;
                    }
                    if (var6_4 > 10) {
                        var6_4 = 10;
                    }
                }
            }
            catch (ServerException var7_7) {
                // empty catch block
            }
            var2_2 = var6_4 * 60 * 1000;
            this.m_handleEventsThread = var1_1;
            this.m_bHandleEvents = true;
            // MONITOREXIT @DISABLED, blocks:[0, 4] lbl29 : MonitorExitStatement: MONITOREXIT : var4_3
            if (true) ** GOTO lbl39
        }
        do {
            this.ping();
            try {
                Thread.sleep(var2_2);
            }
            catch (InterruptedException var6_5) {
                // empty catch block
            }
lbl39:
            // 3 sources

        } while (this.m_bHandleEvents);
        var4_3 = this;
        synchronized (var4_3) {
            if (this.m_handleEventsThread == var1_1) {
                this.m_handleEventsThread = null;
                this.m_bHandleEvents = false;
            }
        }
    }

    public void interruptHandleEvents() {
        Server server = this;
        synchronized (server) {
            if (this.m_bHandleEvents && this.m_handleEventsThread != null) {
                this.m_bHandleEvents = false;
                this.m_handleEventsThread.interrupt();
            }
        }
    }

    MPXEventQueue getEventQueue() {
        if (this.m_eventQueue == null) {
            Server server = this;
            synchronized (server) {
                if (this.m_eventQueue == null) {
                    Server_CacheManager server_CacheManager = this.getServerCacheManager();
                    server_CacheManager.getProjectCache(this);
                    server_CacheManager.getViewCache(this);
                    this.m_eventQueue = new MPXEventQueue(this.getServerCacheManager());
                }
            }
        }
        return this.m_eventQueue;
    }

    public void addMPXStatusListener(MPXStatusListener mPXStatusListener) {
        this.getMPXStatusMarshaler().addListener(mPXStatusListener);
    }

    public void removeMPXStatusListener(MPXStatusListener mPXStatusListener) {
        this.getMPXStatusMarshaler().removeListener(mPXStatusListener);
    }

    MPXStatus_Marshaler getMPXStatusMarshaler() {
        if (this.m_MPXStatusMarshaler == null) {
            Server server = this;
            synchronized (server) {
                if (this.m_MPXStatusMarshaler == null) {
                    this.m_MPXStatusMarshaler = new MPXStatus_Marshaler(this);
                }
            }
        }
        return this.m_MPXStatusMarshaler;
    }

    public void addServerControlListener(ServerControlListener serverControlListener) {
        this.getServerControlEventMarshaler().addListener(serverControlListener);
    }

    public void removeServerControlListener(ServerControlListener serverControlListener) {
        this.getServerControlEventMarshaler().removeListener(serverControlListener);
    }

    ServerControlEvent_Marshaler getServerControlEventMarshaler() {
        if (this.m_serverControlEventMarshaler == null) {
            Server server = this;
            synchronized (server) {
                if (this.m_serverControlEventMarshaler == null) {
                    this.m_serverControlEventMarshaler = new ServerControlEvent_Marshaler(this);
                }
            }
        }
        return this.m_serverControlEventMarshaler;
    }

    public void addTypeListener(TypeListener typeListener) {
        this.getTypeEventMarshaler().addListener(typeListener, null);
    }

    public void removeTypeListener(TypeListener typeListener) {
        this.getTypeEventMarshaler().removeListener(typeListener, null);
    }

    TypeEvent_Marshaler getTypeEventMarshaler() {
        if (this.m_typeEventMarshaler == null) {
            Server server = this;
            synchronized (server) {
                if (this.m_typeEventMarshaler == null) {
                    this.m_typeEventMarshaler = new TypeEvent_Marshaler(this);
                }
            }
        }
        return this.m_typeEventMarshaler;
    }

    public void addUserListener(UserListener userListener) {
        this.getUserEventMarshaler().addListener(userListener);
    }

    public void removeUserListener(UserListener userListener) {
        this.getUserEventMarshaler().removeListener(userListener);
    }

    UserEvent_Marshaler getUserEventMarshaler() {
        if (this.m_userEventMarshaler == null) {
            Server server = this;
            synchronized (server) {
                if (this.m_userEventMarshaler == null) {
                    this.m_userEventMarshaler = new UserEvent_Marshaler(this);
                }
            }
        }
        return this.m_userEventMarshaler;
    }

    public void addProjectListener(ProjectListener projectListener) {
        this.getProjectEventMarshaler().addListener(projectListener, null);
    }

    public void removeProjectListener(ProjectListener projectListener) {
        this.getProjectEventMarshaler().removeListener(projectListener, null);
    }

    ProjectEvent_Marshaler getProjectEventMarshaler() {
        if (this.m_projectEventMarshaler == null) {
            Server server = this;
            synchronized (server) {
                if (this.m_projectEventMarshaler == null) {
                    this.m_projectEventMarshaler = new ProjectEvent_Marshaler(this);
                }
            }
        }
        return this.m_projectEventMarshaler;
    }

    public int getKeepAliveInterval() {
        int n = this.m_nKeepAliveMinutes;
        if (n < 1) {
            n = 5;
            try {
                int n2 = this.getAdministration().getConfiguration().getInactivityTimeout();
                if (n2 > 0) {
                    n = (n2 + 1) / 2;
                    if (n < 1) {
                        n = 1;
                    }
                    if (n > 10) {
                        n = 10;
                    }
                }
            }
            catch (ServerException serverException) {
                // empty catch block
            }
        }
        return n;
    }

    public void setKeepAliveInterval(int n) {
        this.m_nKeepAliveMinutes = n;
        if (this.isKeepAlive()) {
            Server server = this;
            synchronized (server) {
                if (this.m_keepAliveThread != null) {
                    this.setKeepAlive(false);
                    this.setKeepAlive(true);
                }
            }
        }
    }

    public boolean isKeepAlive() {
        return this.m_keepAliveThread != null;
    }

    public synchronized void setKeepAlive(boolean bl) {
        if (bl) {
            if (this.m_keepAliveThread == null) {
                Server server = this;
                if (server == null) {
                    throw null;
                }
                this.m_keepAliveThread = new Thread(new Runnable(server){
                    private final /* synthetic */ Server this$0;

                    public void run() {
                        Thread thread = Thread.currentThread();
                        int n = this.this$0.getKeepAliveInterval();
                        int n2 = n * 60 * 1000;
                        while (thread == Server.access$0(this.this$0)) {
                            this.this$0.ping();
                            try {
                                Thread thread2 = thread;
                                synchronized (thread2) {
                                    Thread.sleep(n2);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    {
                        this.this$0 = server;
                        this.constructor$0(server);
                    }

                    private final void constructor$0(Server server) {
                    }
                });
                this.m_keepAliveThread.setDaemon(true);
                this.m_keepAliveThread.start();
            }
        } else if (this.m_keepAliveThread != null) {
            Thread thread = this.m_keepAliveThread;
            synchronized (thread) {
                this.m_keepAliveThread.notifyAll();
                this.m_keepAliveThread = null;
            }
        }
    }

    static /* synthetic */ Thread access$0(Server server) {
        return server.m_keepAliveThread;
    }

    public Server(String string, int n) {
        if (string == null) {
            Assert.nullArgument("String", "address");
        }
        this.initialize(string, n, EncryptionAlgorithm.NULL, false, 6);
    }

    public Server(String string, int n, EncryptionAlgorithm encryptionAlgorithm, boolean bl) {
        if (string == null) {
            Assert.nullArgument("String", "address");
        }
        this.initialize(string, n, encryptionAlgorithm, bl, 6);
    }

    public Server(String string, int n, EncryptionAlgorithm encryptionAlgorithm, boolean bl, int n2) {
        if (string == null) {
            Assert.nullArgument("String", "address");
        }
        this.initialize(string, n, encryptionAlgorithm, bl, n2);
    }

    public Server(ServerInfo serverInfo) {
        int n = serverInfo.getConnectionType();
        this.setProtocol(n);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(serverInfo.getEndpoint());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.INVALID_PORT_FMT, new Object[]{serverInfo.getEndpoint()}));
        }
        this.initialize(serverInfo.getHost(), n2, serverInfo.getEncryption(), serverInfo.isCompression(), n);
        this.m_ConnectMPXProfile = serverInfo.getMPXProfileName();
    }

    class Session
    implements ServerSession {
        private GUID m_clientID;
        private int m_userID;

        public GUID getID() {
            return this.m_clientID;
        }

        public int getUserID() {
            return this.m_userID;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("Server session: ID=");
            stringBuffer.append(this.getID());
            stringBuffer.append(", UserID=");
            stringBuffer.append(this.getUserID());
            return stringBuffer.toString();
        }

        Session(GUID gUID, int n) {
            this.m_clientID = gUID;
            this.m_userID = n;
        }
    }
}

