/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.CacheRefCollection;
import com.starbase.starteam.CmdAddCustomField;
import com.starbase.starteam.CmdGetLicenseInfo;
import com.starbase.starteam.CmdGetLicenseUsage;
import com.starbase.starteam.CmdGetLog;
import com.starbase.starteam.CmdGetServerCommandStats;
import com.starbase.starteam.CmdGetServerConfig;
import com.starbase.starteam.CmdGetServerLock;
import com.starbase.starteam.CmdGetServerLog;
import com.starbase.starteam.CmdGetSystemPolicy;
import com.starbase.starteam.CmdModifyField;
import com.starbase.starteam.CmdRestartServer;
import com.starbase.starteam.CmdSetServerConfig;
import com.starbase.starteam.CmdSetServerLock;
import com.starbase.starteam.CmdSetSystemPolicy;
import com.starbase.starteam.CmdShutdownServer;
import com.starbase.starteam.CmdTestLDAP;
import com.starbase.starteam.CmdUpdateServerInfo;
import com.starbase.starteam.Cmd_ServerCfgNamedOptionsGet;
import com.starbase.starteam.Cmd_ServerCfgNamedOptionsSet;
import com.starbase.starteam.EnumeratedValue;
import com.starbase.starteam.GroupAccount;
import com.starbase.starteam.HiveManager;
import com.starbase.starteam.LicenseUsage;
import com.starbase.starteam.Property;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.SecurityLog;
import com.starbase.starteam.SecurityLogEntry;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerConfiguration;
import com.starbase.starteam.ServerException;
import com.starbase.starteam.ServerInfo;
import com.starbase.starteam.ServerLicenseInfo;
import com.starbase.starteam.SystemPolicy;
import com.starbase.starteam.Translations;
import com.starbase.starteam.Type;
import com.starbase.starteam.UserAccount;
import com.starbase.starteam.vts.pickle.Enum;
import com.starbase.starteam.vts.pickle.PropertyInfo2;
import com.starbase.starteam.vts.pickle.TranslationCache;
import com.starbase.starteam.vts.pickle.Variant;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class ServerAdministration {
    public static final int UNKNOWN = -1;
    public static final int SERVER_LOCKED = 1;
    public static final int SERVER_UNLOCKED = 2;
    public static final int SERVER_LOCKED_EXCLUSIVELY = 3;
    public static final int LOG_TYPE_SERVER = 0;
    public static final int LOG_MODE_ERRORS = 1;
    public static final int LOG_MODE_ALL = 0;
    public static final int LOG_ALL = 65535;
    public static final int LOG_MESSAGES = 4097;
    public static final int LOG_WARNINGS = 4098;
    public static final int LOG_EXCEPTIONS = 4100;
    public static final int LOG_ASSERTIONS = 4104;
    private Server m_server = null;
    private HiveManager m_hiveManager = null;
    private CacheRefCollection m_userAccountCollection = null;
    private CacheRefCollection m_groupAccountCollection = null;
    private GroupAccount[] m_groups = new GroupAccount[0];
    private boolean m_cachedAccounts = false;
    private ServerException m_userAccountException = null;

    Server getServer() {
        return this.m_server;
    }

    private boolean isGroupInfoPublic() {
        return this.m_server.getRevisionLevel() >= 69;
    }

    void addUserAccount(UserAccount userAccount) {
        this.getUserAccountCacheRefCollection().add(userAccount);
    }

    private CacheRefCollection getUserAccountCacheRefCollection() {
        if (this.m_userAccountCollection == null) {
            this.m_userAccountCollection = new CacheRefCollection(this.m_server.getServerCacheManager().getUserAccountCache(), this);
        }
        return this.m_userAccountCollection;
    }

    void addGroupAccount(GroupAccount groupAccount) {
        this.getGroupAccountCacheRefCollection().add(groupAccount);
    }

    private CacheRefCollection getGroupAccountCacheRefCollection() {
        if (this.m_groupAccountCollection == null) {
            this.m_groupAccountCollection = new CacheRefCollection(this.m_server.getServerCacheManager().getGroupAccountCache(), this);
        }
        return this.m_groupAccountCollection;
    }

    public void addTextField(Type type, String string, String string2, int n) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 8, 0, new Variant(n), null);
        cmdAddCustomField.execute();
    }

    public void addTextFieldEx(Type type, String string, Translations translations, int n) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 8, 0, new Variant(n), null);
        cmdAddCustomField.execute();
    }

    public void addRequiredTextField(Type type, String string, String string2, int n) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 8, 256, new Variant(n), null);
        cmdAddCustomField.execute();
    }

    public void addRequiredTextFieldEx(Type type, String string, Translations translations, int n) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 8, 256, new Variant(n), null);
        cmdAddCustomField.execute();
    }

    public void addTimeField(Type type, String string, String string2, OLEDate oLEDate) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 7, 0, new Variant(oLEDate), null);
        cmdAddCustomField.execute();
    }

    public void addTimeFieldEx(Type type, String string, Translations translations, OLEDate oLEDate) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 7, 0, new Variant(oLEDate), null);
        cmdAddCustomField.execute();
    }

    public void addIntegerField(Type type, String string, String string2, int n) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 1, 0, new Variant(n), null);
        cmdAddCustomField.execute();
    }

    public void addIntegerFieldEx(Type type, String string, Translations translations, int n) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 1, 0, new Variant(n), null);
        cmdAddCustomField.execute();
    }

    public void addDoubleField(Type type, String string, String string2, double d) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 6, 0, new Variant(d), null);
        cmdAddCustomField.execute();
    }

    public void addDoubleFieldEx(Type type, String string, Translations translations, double d) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 6, 0, new Variant(d), null);
        cmdAddCustomField.execute();
    }

    public void addUserField(Type type, String string, String string2) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 3, 0, new Variant(0), null);
        cmdAddCustomField.execute();
    }

    public void addUserFieldEx(Type type, String string, Translations translations) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 3, 0, new Variant(0), null);
        cmdAddCustomField.execute();
    }

    public void addRequiredUserField(Type type, String string, String string2) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 3, 256, new Variant(0), null);
        cmdAddCustomField.execute();
    }

    public void addRequiredUserFieldEx(Type type, String string, Translations translations) {
        type.setDirty();
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 3, 256, new Variant(0), null);
        cmdAddCustomField.execute();
    }

    public void addEnumeratedField(Type type, String string, String string2, EnumeratedValue[] enumeratedValueArray, int n) {
        type.setDirty();
        Enum[] enumArray = this.makeNewEnums(enumeratedValueArray);
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(string2), 2, 0, new Variant(n), enumArray);
        cmdAddCustomField.execute();
    }

    public void addEnumeratedFieldEx(Type type, String string, Translations translations, EnumeratedValue[] enumeratedValueArray, int n) {
        type.setDirty();
        Enum[] enumArray = this.makeNewEnums(enumeratedValueArray);
        CmdAddCustomField cmdAddCustomField = new CmdAddCustomField(this.m_server, type.getClassID(), string, new TranslationCache(translations), 2, 0, new Variant(n), enumArray);
        cmdAddCustomField.execute();
    }

    public void modifyTextField(Type type, Property property, boolean bl, String string) {
        this.modifyField(type, property, bl, string, new Variant(255), null);
    }

    public void modifyTextFieldEx(Type type, Property property, boolean bl, Translations translations) {
        this.modifyField(type, property, bl, translations, new Variant(255), null);
    }

    public void modifyIntegerField(Type type, Property property, boolean bl, String string, int n) {
        this.modifyField(type, property, bl, string, new Variant(n), null);
    }

    public void modifyIntegerFieldEx(Type type, Property property, boolean bl, Translations translations, int n) {
        this.modifyField(type, property, bl, translations, new Variant(n), null);
    }

    public void modifyDoubleField(Type type, Property property, boolean bl, String string, double d) {
        this.modifyField(type, property, bl, string, new Variant(d), null);
    }

    public void modifyDoubleFieldEx(Type type, Property property, boolean bl, Translations translations, double d) {
        this.modifyField(type, property, bl, translations, new Variant(d), null);
    }

    public void modifyTimeField(Type type, Property property, boolean bl, String string, OLEDate oLEDate) {
        this.modifyField(type, property, bl, string, new Variant(oLEDate), null);
    }

    public void modifyTimeFieldEx(Type type, Property property, boolean bl, Translations translations, OLEDate oLEDate) {
        this.modifyField(type, property, bl, translations, new Variant(oLEDate), null);
    }

    public void modifyUserField(Type type, Property property, boolean bl, String string) {
        this.modifyField(type, property, bl, string, new Variant(-1), null);
    }

    public void modifyUserFieldEx(Type type, Property property, boolean bl, Translations translations) {
        this.modifyField(type, property, bl, translations, new Variant(-1), null);
    }

    public void modifyEnumeratedField(Type type, Property property, boolean bl, String string, EnumeratedValue[] enumeratedValueArray, int n) {
        this.modifyField(type, property, bl, string, new Variant(n), enumeratedValueArray);
    }

    public void modifyEnumeratedFieldEx(Type type, Property property, boolean bl, Translations translations, EnumeratedValue[] enumeratedValueArray, int n) {
        this.modifyField(type, property, bl, translations, new Variant(n), enumeratedValueArray);
    }

    public void setFieldRequired(Property property, boolean bl) {
        Type type = property.getType();
        PropertyInfo2 propertyInfo2 = property.getRawImplementation();
        PropertyInfo2 propertyInfo22 = propertyInfo2.copy();
        propertyInfo22.m_flags = bl ? (propertyInfo22.m_flags |= 0x100) : (propertyInfo22.m_flags &= 0xFFFFFEFF);
        type.setDirty();
        CmdModifyField cmdModifyField = new CmdModifyField(this.m_server, type.getClassID(), propertyInfo22, propertyInfo2);
        cmdModifyField.execute();
    }

    public void enableProperty(Property property, boolean bl) {
        PropertyInfo2 propertyInfo2 = property.getRawImplementation();
        PropertyInfo2 propertyInfo22 = propertyInfo2.copy();
        propertyInfo22.m_flags = bl ? (propertyInfo22.m_flags &= 0xDFFFFFFF) : (propertyInfo22.m_flags |= 0x20000000);
        property.getType().setDirty();
        CmdModifyField cmdModifyField = new CmdModifyField(this.m_server, property.getType().getClassID(), propertyInfo22, propertyInfo2);
        cmdModifyField.execute();
    }

    private void modifyField(Type type, Property property, boolean bl, String string, Variant variant, EnumeratedValue[] enumeratedValueArray) {
        type.cacheTranslationsIfNeeded(property);
        PropertyInfo2 propertyInfo2 = property.getRawImplementation();
        TranslationCache translationCache = propertyInfo2.getTranslationCache().copyForModify(Locale.getDefault(), string);
        this.modifyField(type, property, bl, translationCache, variant, enumeratedValueArray);
    }

    private void modifyField(Type type, Property property, boolean bl, Translations translations, Variant variant, EnumeratedValue[] enumeratedValueArray) {
        type.cacheTranslationsIfNeeded(property);
        TranslationCache translationCache = new TranslationCache(translations);
        this.modifyField(type, property, bl, translationCache, variant, enumeratedValueArray);
    }

    private void modifyField(Type type, Property property, boolean bl, TranslationCache translationCache, Variant variant, EnumeratedValue[] enumeratedValueArray) {
        type.cacheTranslationsIfNeeded(property);
        PropertyInfo2 propertyInfo2 = property.getRawImplementation();
        PropertyInfo2 propertyInfo22 = propertyInfo2.copy();
        propertyInfo22.setTranslationCache(translationCache);
        propertyInfo22.m_default = variant;
        propertyInfo22.m_flags = bl ? (propertyInfo22.m_flags &= 0xDFFFFFFF) : (propertyInfo22.m_flags |= 0x20000000);
        if (propertyInfo22.m_eType == 2) {
            propertyInfo22.m_rawEnums = this.makeEnums(propertyInfo22.m_rawEnums, enumeratedValueArray);
        }
        type.setDirty();
        CmdModifyField cmdModifyField = new CmdModifyField(this.m_server, type.getClassID(), propertyInfo22, propertyInfo2);
        cmdModifyField.execute();
    }

    private Enum[] makeNewEnums(EnumeratedValue[] enumeratedValueArray) {
        int n = enumeratedValueArray.length;
        Enum[] enumArray = new Enum[n];
        int n2 = 0;
        while (n2 < n) {
            EnumeratedValue enumeratedValue = enumeratedValueArray[n2];
            if (!enumeratedValue.getEnabled()) {
                throw new IllegalArgumentException(ResIDs.ENUMERATED_VALUE_DISABLED);
            }
            Translations translations = enumeratedValue.getTranslations();
            if (translations == null) {
                translations = new Translations(enumeratedValue.getDescription());
            }
            enumArray[n2] = new Enum(0, enumeratedValue.getCode(), new TranslationCache(translations), 0);
            ++n2;
        }
        return enumArray;
    }

    private Enum[] makeEnums(Enum[] enumArray, EnumeratedValue[] enumeratedValueArray) {
        Object object;
        Object object2;
        Object object3;
        Vector<Object> vector = new Vector<Object>();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            object3 = enumArray[n2];
            object2 = this.find(((Enum)object3).m_code, enumeratedValueArray);
            object = null;
            if (object2 != null) {
                TranslationCache translationCache = null;
                translationCache = ((EnumeratedValue)object2).isOldStyle() ? ((Enum)object3).getTranslationCache().copyForModify(Locale.getDefault(), ((EnumeratedValue)object2).getDescription()) : new TranslationCache(((EnumeratedValue)object2).getTranslations());
                object = ((EnumeratedValue)object2).getEnabled() ? new Enum(((Enum)object3).m_id, ((Enum)object3).m_code, translationCache, ((Enum)object3).m_flags & 0xFFFEFFFF) : new Enum(((Enum)object3).m_id, ((Enum)object3).m_code, translationCache, ((Enum)object3).m_flags | 0x10000);
            } else {
                object = new Enum(((Enum)object3).m_id, ((Enum)object3).m_code, ((Enum)object3).getTranslationCache(), ((Enum)object3).m_flags | 0x10000);
            }
            vector.addElement(object);
            ++n2;
        }
        n = enumeratedValueArray.length;
        n2 = 0;
        while (n2 < n) {
            object3 = enumeratedValueArray[n2];
            object2 = this.find(((EnumeratedValue)object3).getCode(), enumArray);
            if (object2 == null) {
                if (!((EnumeratedValue)object3).getEnabled()) {
                    throw new IllegalArgumentException(ResIDs.ENUMERATED_VALUE_DISABLED);
                }
                object = ((EnumeratedValue)object3).getTranslations();
                if (object == null) {
                    object = new Translations(((EnumeratedValue)object3).getDescription());
                }
                vector.addElement(new Enum(-1, ((EnumeratedValue)object3).getCode(), new TranslationCache((Translations)object), 0));
            }
            ++n2;
        }
        Object[] objectArray = new Enum[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private EnumeratedValue find(int n, EnumeratedValue[] enumeratedValueArray) {
        int n2 = enumeratedValueArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (enumeratedValueArray[n3].getCode() == n) {
                return enumeratedValueArray[n3];
            }
            ++n3;
        }
        return null;
    }

    private Enum find(int n, Enum[] enumArray) {
        int n2 = enumArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (enumArray[n3].m_code == n) {
                return enumArray[n3];
            }
            ++n3;
        }
        return null;
    }

    public String getLog() {
        CmdGetServerLog cmdGetServerLog = new CmdGetServerLog();
        cmdGetServerLog.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
        return cmdGetServerLog.getLog();
    }

    public void writeLogFile(File file, int n, int n2) throws IOException {
        File file2;
        if (file == null) {
            Assert.nullArgument("File");
        }
        if ((file2 = file).getParent() == null) {
            throw new IOException(Res.formatKey(ResIDs.CANNOT_WRITE_TO_FILE_FMT, new Object[]{file2.getPath()}));
        }
        File file3 = new File(file2.getParent());
        if (!file3.exists()) {
            file3.mkdirs();
        }
        if (file2.exists() && !Platform.getFileWritable(file2)) {
            Platform.setFileWritable(file2, true);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        CmdGetLog cmdGetLog = new CmdGetLog(this.m_server, n, 0, n2, fileOutputStream);
        cmdGetLog.execute();
        fileOutputStream.close();
    }

    public SecurityLogEntry[] getSecurityLog(int n) {
        return SecurityLog.getSecurityLog(this.m_server, n);
    }

    public ServerLicenseInfo getLicenseInformation() {
        CmdGetLicenseInfo cmdGetLicenseInfo = new CmdGetLicenseInfo();
        cmdGetLicenseInfo.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
        return cmdGetLicenseInfo.getInfo();
    }

    public HiveManager getHiveManager() {
        if (this.m_hiveManager == null) {
            this.m_hiveManager = new HiveManager(this.getServer());
        }
        return this.m_hiveManager;
    }

    public boolean testDirectoryServiceSettings(String string, int n, boolean bl) {
        if (this.m_server.getSupportedFeatures().hasSecureDirectoryService()) {
            CmdTestLDAP cmdTestLDAP = new CmdTestLDAP(this.getServer(), string, n, bl);
            cmdTestLDAP.execute();
            return cmdTestLDAP.getSuccess();
        }
        return false;
    }

    public ServerConfiguration getConfiguration() {
        CmdGetServerConfig cmdGetServerConfig = new CmdGetServerConfig();
        cmdGetServerConfig.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
        ServerConfiguration serverConfiguration = cmdGetServerConfig.getConfig();
        serverConfiguration.m_serverAdmin = this;
        serverConfiguration.m_supportsNamedOptions = this.m_server.supports((short)100, "1.12");
        return serverConfiguration;
    }

    public void setConfiguration(ServerConfiguration serverConfiguration) {
        CmdSetServerConfig cmdSetServerConfig = new CmdSetServerConfig(serverConfiguration);
        cmdSetServerConfig.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
        if (this.m_server.supports((short)100, "1.12") && serverConfiguration.m_bNamedOptionsModified) {
            Hashtable hashtable = serverConfiguration.m_namedOptions;
            this.setNamedConfigOptions(hashtable);
            serverConfiguration.m_bNamedOptionsModified = false;
        }
    }

    public SystemPolicy getPolicy() {
        CmdGetSystemPolicy cmdGetSystemPolicy = new CmdGetSystemPolicy();
        cmdGetSystemPolicy.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
        return cmdGetSystemPolicy.getPolicy();
    }

    public void setPolicy(SystemPolicy systemPolicy) {
        CmdSetSystemPolicy cmdSetSystemPolicy = new CmdSetSystemPolicy(systemPolicy);
        cmdSetSystemPolicy.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public void getServerCommandStats(OutputStream outputStream) throws IOException {
        this.getServer().getSupportedFeatures().verifyHasServerCommandStats();
        CmdGetServerCommandStats cmdGetServerCommandStats = new CmdGetServerCommandStats(outputStream);
        cmdGetServerCommandStats.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public void writeServerCommandStats(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.getServerCommandStats(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
        }
        finally {
            Object var4_3 = null;
            if (bufferedOutputStream != null) {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
    }

    public int getServerLockStatus() {
        this.getServer().getSupportedFeatures().verifyHasServerLockStatus();
        CmdGetServerLock cmdGetServerLock = new CmdGetServerLock();
        cmdGetServerLock.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
        return cmdGetServerLock.getLockStatus();
    }

    public void lockServer() {
        CmdSetServerLock cmdSetServerLock = new CmdSetServerLock(1);
        cmdSetServerLock.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public void lockServerExclusively() {
        this.getServer().getSupportedFeatures().verifyHasServerExclusiveLock();
        CmdSetServerLock cmdSetServerLock = new CmdSetServerLock(3);
        cmdSetServerLock.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public void unlockServer() {
        CmdSetServerLock cmdSetServerLock = new CmdSetServerLock(2);
        cmdSetServerLock.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public void shutdownServer() {
        this.getServer().getSupportedFeatures().verifyHasServerShutdown();
        CmdShutdownServer cmdShutdownServer = new CmdShutdownServer();
        cmdShutdownServer.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public void restartServer() {
        this.getServer().getSupportedFeatures().verifyHasServerShutdown();
        CmdRestartServer cmdRestartServer = new CmdRestartServer();
        cmdRestartServer.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public boolean hasPermission(int n) {
        return SecurityAccess.accessTest(this.m_server, n);
    }

    public AclEntry[] getACL() {
        return SecurityAccess.getServerACL(this.m_server);
    }

    public void setACL(AclEntry[] aclEntryArray) {
        SecurityAccess.setServerACL(this.m_server, aclEntryArray);
    }

    public void discardAccounts() {
        this.getUserAccountCacheRefCollection().discard();
        this.getGroupAccountCacheRefCollection().discard();
        this.m_groups = new GroupAccount[0];
        this.m_cachedAccounts = false;
    }

    public boolean isRefreshAccountsRequired() {
        return this.getUserAccountCacheRefCollection().isRefreshRequired() || this.getGroupAccountCacheRefCollection().isRefreshRequired();
    }

    public void populateAccounts() {
        this.populateAccounts(false);
    }

    void populateAccounts(boolean bl) {
        if (!this.m_cachedAccounts) {
            block9: {
                if (!this.isGroupInfoPublic()) {
                    bl = false;
                }
                try {
                    this.getUserAccountCacheRefCollection().populate();
                }
                catch (ServerException serverException) {
                    if (bl) {
                        this.m_userAccountException = serverException;
                    }
                    throw serverException;
                }
                try {
                    this.getGroupAccountCacheRefCollection().populate();
                }
                catch (ServerException serverException) {
                    if (this.isGroupInfoPublic()) break block9;
                    throw serverException;
                }
            }
            this.rebuildAccounts();
            this.m_cachedAccounts = true;
        } else if (!bl && this.m_userAccountException != null) {
            throw this.m_userAccountException;
        }
    }

    private void rebuildAccounts() {
        GroupAccount groupAccount;
        Vector vector = this.getGroupAccountCacheRefCollection().getRefs();
        Hashtable<Integer, GroupAccount> hashtable = new Hashtable<Integer, GroupAccount>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            groupAccount = (GroupAccount)vector.elementAt(n2);
            hashtable.put(new Integer(groupAccount.getID()), groupAccount);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            groupAccount = (GroupAccount)vector.elementAt(n2);
            int n3 = groupAccount.getParentID();
            GroupAccount groupAccount2 = (GroupAccount)hashtable.get(new Integer(n3));
            if (groupAccount2 == null && n3 != -1) {
                hashtable.remove(new Integer(groupAccount.getID()));
            } else {
                groupAccount.setParent(groupAccount2);
            }
            ++n2;
        }
        UserAccount[] userAccountArray = this._getUserAccounts();
        if (userAccountArray != null) {
            int n4 = 0;
            while (n4 < userAccountArray.length) {
                UserAccount userAccount = userAccountArray[n4];
                userAccount.fixGroupList(hashtable);
                ++n4;
            }
        }
        this.m_groups = new GroupAccount[hashtable.size()];
        int n5 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this.m_groups[n5++] = (GroupAccount)enumeration.nextElement();
        }
    }

    public void refreshAccounts() {
        if (this.isRefreshAccountsRequired()) {
            this.getUserAccountCacheRefCollection().refresh();
            this.getGroupAccountCacheRefCollection().refresh();
            this.rebuildAccounts();
        }
    }

    private UserAccount[] _getUserAccounts() {
        Vector vector = this.getUserAccountCacheRefCollection().getRefs();
        UserAccount[] userAccountArray = new UserAccount[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            userAccountArray[n++] = (UserAccount)enumeration.nextElement();
        }
        return userAccountArray;
    }

    public UserAccount[] getUserAccounts() {
        this.populateAccounts();
        UserAccount[] userAccountArray = this._getUserAccounts();
        if (userAccountArray.length == 0) {
            Assert.internalError("ServerAdministration.getUserAccounts(), length=0");
        }
        return userAccountArray;
    }

    public GroupAccount[] getGroupAccounts() {
        this.populateAccounts(true);
        return this.m_groups;
    }

    public UserAccount findUserAccount(int n) {
        this.populateAccounts();
        return (UserAccount)this.getUserAccountCacheRefCollection().getByID(n);
    }

    public GroupAccount findGroupAccount(int n) {
        GroupAccount[] groupAccountArray = this.getGroupAccounts();
        int n2 = groupAccountArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n == groupAccountArray[n3].getID()) {
                return groupAccountArray[n3];
            }
            ++n3;
        }
        return null;
    }

    public LicenseUsage getLicenseUsage() {
        CmdGetLicenseUsage cmdGetLicenseUsage = new CmdGetLicenseUsage();
        cmdGetLicenseUsage.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
        return new LicenseUsage(cmdGetLicenseUsage.getFormattedInfo(), cmdGetLicenseUsage.getEncrytpedInfo());
    }

    public void updateLicenseUsage(String string, ServerInfo[] serverInfoArray) {
        CmdUpdateServerInfo cmdUpdateServerInfo = new CmdUpdateServerInfo(string, serverInfoArray);
        cmdUpdateServerInfo.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), 0, 0);
    }

    public String[] getNamedConfigOptions(String[] stringArray) {
        if (this.m_server.supports((short)100, "1.12")) {
            Cmd_ServerCfgNamedOptionsGet cmd_ServerCfgNamedOptionsGet = new Cmd_ServerCfgNamedOptionsGet(this.m_server, stringArray);
            cmd_ServerCfgNamedOptionsGet.execute();
            Hashtable hashtable = cmd_ServerCfgNamedOptionsGet.getOptions();
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < hashtable.size()) {
                stringArray2[n] = (String)hashtable.get(stringArray[n]);
                ++n;
            }
            return stringArray2;
        }
        return new String[0];
    }

    public void setNamedConfigOptions(String[] stringArray, String[] stringArray2) {
        if (this.m_server.supports((short)100, "1.12")) {
            if (stringArray.length != stringArray2.length) {
                throw new IllegalArgumentException(ResIDs.ARGUMENT_ARRAYS_MUST_BE_SAME_LENGTH);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(stringArray[n], stringArray2[n]);
                ++n;
            }
            this.setNamedConfigOptions(hashtable);
        }
    }

    public void setNamedConfigOptions(Hashtable hashtable) {
        Cmd_ServerCfgNamedOptionsSet cmd_ServerCfgNamedOptionsSet = new Cmd_ServerCfgNamedOptionsSet(this.m_server, hashtable);
        cmd_ServerCfgNamedOptionsSet.execute();
    }

    ServerAdministration(Server server) {
        this.m_server = server;
    }
}

