/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Keyword;
import com.starbase.util.Assert;
import com.starbase.util.XMLUtils;
import java.io.UnsupportedEncodingException;

public class SimpleKeyword
implements Keyword {
    private String m_name;
    private String m_value;

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean stopExpanding() {
        return false;
    }

    public boolean multiLine() {
        return false;
    }

    public boolean matches(String string, int n, int[] nArray) {
        String string2 = this.getName();
        int n2 = string.length() - n;
        int n3 = string2.length();
        if (n3 + 2 > n2) {
            return false;
        }
        if (!string.regionMatches(n + 1, string2, 0, n3)) {
            return false;
        }
        int n4 = n + n3 + 1;
        if (string.charAt(n4) == '$') {
            nArray[0] = n4;
            return true;
        }
        if (string.charAt(n4) == ':') {
            int n5;
            nArray[0] = n5 = string.indexOf(36, n4);
            return n5 != -1 || this.multiLine();
        }
        return false;
    }

    public String expand(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.m_name.length() + this.m_value.length() + 3);
        stringBuffer.append(this.m_name);
        if (bl) {
            stringBuffer.append(": ");
            stringBuffer.append(this.m_value);
        }
        stringBuffer.append('$');
        return stringBuffer.toString();
    }

    protected static String encodeForPlatform(String string, int n) {
        try {
            return new String(string.getBytes(), "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.internalError("SimpleKeyword.encodeForPlatform()");
            return null;
        }
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<keyword ");
        stringBuffer.append("name=\"");
        XMLUtils.writeEscaped(this.getName(), stringBuffer);
        stringBuffer.append("\"");
        stringBuffer.append(" value=\"");
        XMLUtils.writeEscaped(this.getValue(), stringBuffer);
        stringBuffer.append("\"");
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public SimpleKeyword(String string, String string2) {
        this.m_name = string;
        this.m_value = string2;
    }
}

