/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.File;
import com.starbase.starteam.FileDigest;
import com.starbase.starteam.FileSyncInfo;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.RevisionIdentifier;
import com.starbase.starteam.vts.pickle.FileRevisionID;
import com.starbase.starteam.vts.pickle.StStatusData;
import com.starbase.util.FileUtils;
import com.starbase.util.GUID;
import com.starbase.util.MD5;
import com.starbase.util.OLEDate;
import com.starbase.util.Platform;
import java.io.IOException;
import java.io.PrintStream;

class StatusDataImpl
implements FileSyncInfo,
FileDigest,
RevisionIdentifier {
    private StStatusData m_data = null;

    public void setData(StStatusData stStatusData) {
        this.m_data = stStatusData;
    }

    public StStatusData getData() {
        return this.m_data;
    }

    public FileDigest getFileDigest() {
        return this;
    }

    public long getFileSize() {
        return this.m_data.m_syncSize;
    }

    public void setFileSize(long l) {
        long l2 = Integer.MAX_VALUE;
        if (l > l2) {
            throw new IllegalArgumentException(Res.formatKey(ResIDs.FILE_TOO_LARGE_FMT, new Object[]{new Long(l)}));
        }
        this.m_data.m_syncSize = (int)l;
    }

    public double getFileTime() {
        return this.m_data.m_syncTime;
    }

    public void setFileTime(double d) {
        this.m_data.m_syncTime = d;
    }

    public MD5 getFileMD5() {
        return this.m_data.m_syncMD5;
    }

    public void setFileMD5(MD5 mD5) {
        this.m_data.m_syncMD5 = mD5;
    }

    public RevisionIdentifier getRevisionIdentifier() {
        return this;
    }

    public String getRepositoryID() {
        return this.m_data.serverID.canonicalFormat();
    }

    public int getRootObjectID() {
        return this.m_data.m_rootObjectID;
    }

    public void setRootObjectID(int n) {
        this.m_data.m_rootObjectID = n;
    }

    public int getContentRevision() {
        return this.m_data.m_contentRevision;
    }

    public void setContentRevision(int n) {
        this.m_data.m_contentRevision = n;
    }

    public String getDotNotation() {
        return this.m_data.m_dotNotation;
    }

    public void setDotNotation(String string) {
        this.m_data.m_dotNotation = string;
    }

    public void setRecordID(int n) {
        this.m_data.m_recordID = n;
    }

    public int getRecordID() {
        return this.m_data.m_recordID;
    }

    public double getRecordTime() {
        return this.m_data.m_recordTime;
    }

    public void setObjectID(int n) {
        this.m_data.m_objectID = n;
    }

    public int getObjectID() {
        return this.m_data.m_objectID;
    }

    public void setRevisionNumber(int n) {
        this.m_data.m_version = n;
    }

    public int getRevisionNumber() {
        return this.m_data.m_version;
    }

    void setFromFileSyncInfo(FileSyncInfo fileSyncInfo) {
        this.setRecordID(-1);
        RevisionIdentifier revisionIdentifier = fileSyncInfo.getRevisionIdentifier();
        this.setRootObjectID(revisionIdentifier.getRootObjectID());
        this.setObjectID(revisionIdentifier.getObjectID());
        this.setRevisionNumber(revisionIdentifier.getRevisionNumber());
        this.setDotNotation(revisionIdentifier.getDotNotation());
        this.setContentRevision(revisionIdentifier.getContentRevision());
        FileDigest fileDigest = fileSyncInfo.getFileDigest();
        this.setFileTime(fileDigest.getFileTime());
        this.setFileSize(fileDigest.getFileSize());
        this.setFileMD5(fileDigest.getFileMD5());
    }

    public void initFromFileRevisionID(FileRevisionID fileRevisionID) {
        this.setRecordID(-1);
        this.setRootObjectID(fileRevisionID.getRootObjectID());
        this.setObjectID(fileRevisionID.getObjectID());
        this.setRevisionNumber(fileRevisionID.getObjectVersion());
        this.setDotNotation(fileRevisionID.getDotNotation());
        this.setContentRevision(fileRevisionID.getContentVersion());
    }

    public void initFromFile(File file) {
        this.setRecordID(-1);
        this.setRootObjectID(file.getRootObjectID());
        this.setObjectID(file.getObjectID());
        this.setRevisionNumber(file.getRevisionNumber());
        this.setDotNotation(file.getDotNotation());
        this.setContentRevision(file.getContentVersion());
    }

    public void setLocalFileInfo(java.io.File file) throws IOException {
        this.setFileTime(Platform.getFileLastModified(file));
        this.setFileSize(FileUtils.getFileLength(file));
        MD5 mD5 = new MD5();
        mD5.computeFileMD5(file);
        this.setFileMD5(mD5);
    }

    public boolean isValid() {
        return this.getRootObjectID() != -1;
    }

    public void dump(PrintStream printStream) {
        printStream.println("===== StatusData =====");
        printStream.println("RecordID " + this.getRecordID());
        printStream.println("RootObjectID: " + this.getRootObjectID());
        printStream.println("ObjectID: " + this.getObjectID());
        printStream.println("Version: " + this.getRevisionNumber());
        printStream.println("DotNotation: " + this.getDotNotation());
        printStream.println("ContentRev: " + this.getContentRevision());
        printStream.println("SyncTime: " + new OLEDate(this.getFileTime()));
        printStream.println("SyncSize: " + this.getFileSize());
        printStream.println("SyncMD5: " + this.getFileMD5());
        printStream.println("Record time: " + new OLEDate(this.getRecordTime()));
        printStream.println("===== End StatusData =====");
    }

    private StatusDataImpl() {
    }

    public StatusDataImpl(GUID gUID) {
        this.m_data = new StStatusData(gUID);
    }

    public StatusDataImpl(StStatusData stStatusData) {
        this.m_data = stStatusData;
    }
}

