/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.GroupSortInfo;
import com.starbase.starteam.ItemList;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertySortCollection;
import com.starbase.util.OLEDate;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

class TimeCollection
extends PropertySortCollection {
    private double[] m_dest;
    private double[] m_scratchpad;
    private double m_tz = 0.0;
    private DateFormat m_format = DateFormat.getDateInstance(3);

    public boolean sameForGrouping(int n) {
        double d = this.m_tz + this.m_dest[n];
        double d2 = this.m_tz + this.m_dest[n - 1];
        return (int)d == (int)d2;
    }

    public void swap(int n, int n2) {
        double d = this.m_dest[n];
        this.m_dest[n] = this.m_dest[n2];
        this.m_dest[n2] = d;
    }

    public void copySequence(int n, int n2) {
        System.arraycopy(this.m_scratchpad, n, this.m_dest, n, n2);
    }

    public void setFromScratchpad(int n, int n2) {
        this.m_dest[n2] = this.m_scratchpad[n];
    }

    public void saveToScratchpad(int n, int n2) {
        this.m_scratchpad[n2] = this.m_dest[n];
    }

    public int compareScratchpad(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_scratchpad[n], this.m_scratchpad[n2]);
        }
        return this.comp(this.m_scratchpad[n2], this.m_scratchpad[n]);
    }

    public int compare(int n, int n2) {
        if (this.m_bAscending) {
            return this.comp(this.m_dest[n], this.m_dest[n2]);
        }
        return this.comp(this.m_dest[n2], this.m_dest[n]);
    }

    private void setTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        long l = timeZone.getRawOffset();
        this.m_tz = (double)l / 8.64E7;
    }

    protected String getValueDisplay(int n) {
        OLEDate oLEDate = new OLEDate(this.m_dest[n]);
        return this.m_format.format(new Date(oLEDate.getLongValue()));
    }

    private int comp(double d, double d2) {
        if (d > d2) {
            return 1;
        }
        if (d < d2) {
            return -1;
        }
        return 0;
    }

    public TimeCollection(ItemList itemList, GroupSortInfo groupSortInfo, Property property) {
        super(itemList, groupSortInfo, property);
        this.m_bAscending = groupSortInfo.isAscending();
        int n = itemList.size();
        this.m_dest = new double[n];
        this.m_scratchpad = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            Object object = itemList.getAt(n2).getByProperty(property);
            this.m_dest[n2] = d = ((OLEDate)object).getDoubleValue();
            this.m_scratchpad[n2] = d;
            ++n2;
        }
        this.setTimeZone();
    }
}

