/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Cacheable;
import com.starbase.starteam.NamedCacheable;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Property;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.Type_Data;
import com.starbase.starteam.vts.pickle.Variant;
import com.starbase.util.Assert;
import java.util.BitSet;
import java.util.Enumeration;

class TypedResource_Data
extends NamedCacheable {
    private static final String ID = "ID";
    protected Type_Data m_typeData = null;
    private Object[] m_values = null;
    private BitSet m_storedValueMap = null;
    private int m_nSize = -1;
    private int m_nPrimaryDescriptorIndex = -1;

    private void initialize() {
        this.m_nSize = this.m_typeData.getCacheablePropertyCount();
        this.m_values = new Object[this.m_nSize];
        this.m_storedValueMap = new BitSet(this.m_nSize);
        this.setDirty(true);
    }

    Object copy() {
        TypedResource_Data typedResource_Data = new TypedResource_Data(this.m_typeData);
        this.copyMembersTo(typedResource_Data);
        return typedResource_Data;
    }

    protected void copyMembersTo(TypedResource_Data typedResource_Data) {
        typedResource_Data.m_storedValueMap = (BitSet)this.m_storedValueMap.clone();
        typedResource_Data.m_nSize = this.m_nSize;
        typedResource_Data.m_nPrimaryDescriptorIndex = this.m_nPrimaryDescriptorIndex;
        if (this.m_values != null) {
            int n = this.m_values.length;
            typedResource_Data.m_values = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                Variant variant = Variant.createVariant(this.m_values[n2]);
                typedResource_Data.m_values[n2] = variant.getData();
                ++n2;
            }
        }
    }

    public boolean isEqualTo(Cacheable cacheable) {
        if (cacheable != null && cacheable instanceof TypedResource_Data) {
            TypedResource_Data typedResource_Data = (TypedResource_Data)cacheable;
            if (this == typedResource_Data) {
                return true;
            }
            int n = this.m_storedValueMap.size();
            if (this.m_storedValueMap.equals(typedResource_Data.m_storedValueMap) && n == typedResource_Data.m_storedValueMap.size()) {
                int n2 = 0;
                while (n2 < n) {
                    if (this.hasValue(n2) && !Property.areValuesEqual(this.get(n2), typedResource_Data.get(n2))) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    int getID() {
        return (Integer)this.getByName(ID);
    }

    void setID(int n) {
        this.putByName(ID, new Integer(n));
    }

    public String getName() {
        if (this.m_nPrimaryDescriptorIndex == -1) {
            throw new NoSuchPropertyException(Res.formatKey(ResIDs.TYPE_HAS_NO_PRIMARY_DESCRIPTOR_FMT, new Object[]{this.m_typeData.getName()}));
        }
        return (String)this.get(this.m_nPrimaryDescriptorIndex);
    }

    public void remove(int n) {
        this.m_values[n] = null;
        this.m_storedValueMap.clear(n);
    }

    public void discard() {
        int n = this.getID();
        this.initialize();
        this.setID(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string = "";
        stringBuffer.append(string + this.m_storedValueMap.toString());
        Enumeration enumeration = this.m_typeData.getCachedPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = this.m_typeData.indexForName(string2);
            Object object = n > -1 ? this.get(n) : null;
            stringBuffer.append(string + string2 + ": " + (object == null ? "null" : object));
            string = ", ";
        }
        return stringBuffer.toString();
    }

    private void validateIndex(int n) {
        if (n >= this.m_values.length) {
            Assert.internalError("TypedResource_Data.validateIndex(), i=" + n + ", n=" + this.m_values.length);
        }
    }

    void replaceTypeData(Type_Data type_Data) {
        if (type_Data.getID() != this.m_typeData.getID()) {
            Assert.internalError("TypedResource_Data.replaceTypeData(), typeData.getID()=" + type_Data.getID() + ", m_typeData.getID()=" + this.m_typeData.getID());
        }
        this.m_typeData = type_Data;
        this.m_nPrimaryDescriptorIndex = type_Data.getPrimaryDescriptorIndex();
        int n = this.m_typeData.getCacheablePropertyCount();
        if (this.m_nSize != n) {
            int n2;
            Object object;
            int n3 = this.m_nSize;
            this.m_nSize = n;
            if (this.m_values != null) {
                object = new Object[this.m_nSize];
                n2 = 0;
                while (n2 < n3) {
                    Variant variant = Variant.createVariant(this.m_values[n2]);
                    object[n2] = variant.getData();
                    ++n2;
                }
                this.m_values = object;
            }
            object = new BitSet(this.m_nSize);
            n2 = 0;
            while (n2 < n3) {
                if (this.m_storedValueMap.get(n2)) {
                    ((BitSet)object).set(n2);
                }
                ++n2;
            }
            this.m_storedValueMap = object;
        }
    }

    int indexForName(String string) {
        int n = this.m_typeData.indexForName(string);
        if (n == -1) {
            throw new NoSuchPropertyException(this.m_typeData.getName(), string);
        }
        return n;
    }

    int indexForPid(int n) {
        int n2 = this.m_typeData.indexForPid(n);
        if (n2 == -1) {
            throw new NoSuchPropertyException(this.m_typeData.getName(), n);
        }
        return n2;
    }

    int size() {
        return this.m_nSize;
    }

    boolean hasValue(int n) {
        return this.m_storedValueMap.size() > n ? this.m_storedValueMap.get(n) : false;
    }

    boolean hasValueForName(String string) {
        return this.hasValue(this.indexForName(string));
    }

    boolean hasValueForPid(int n) {
        return this.hasValue(this.indexForPid(n));
    }

    boolean hasValues(BitSet bitSet) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (bitSet.get(n2) && !this.hasValue(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean hasValuesForNames(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!this.hasValueForName(stringArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    Object get(int n) {
        this.validateIndex(n);
        return this.m_values[n];
    }

    Object getByName(String string) {
        return this.get(this.indexForName(string));
    }

    Object getByPid(int n) {
        return this.get(this.indexForPid(n));
    }

    Object put(int n, Object object) {
        this.validateIndex(n);
        Object object2 = this.m_values[n];
        this.m_values[n] = object;
        this.m_storedValueMap.set(n);
        return object2;
    }

    Object putByName(String string, Object object) {
        return this.put(this.indexForName(string), object);
    }

    Object putByPid(int n, Object object) {
        return this.put(this.indexForPid(n), object);
    }

    TypedResource_Data(Type_Data type_Data) {
        this.m_typeData = type_Data;
        this.m_nPrimaryDescriptorIndex = type_Data.getPrimaryDescriptorIndex();
        this.initialize();
    }
}

