/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.AclEntry;
import com.starbase.starteam.CmdGetHistory;
import com.starbase.starteam.CmdListSetRead;
import com.starbase.starteam.CmdSetBookmark;
import com.starbase.starteam.FileBasedStatusManager;
import com.starbase.starteam.Folder;
import com.starbase.starteam.FolderEventScope;
import com.starbase.starteam.FolderEvent_Marshaler;
import com.starbase.starteam.FolderListener;
import com.starbase.starteam.FolderTreeEvent_Marshaler;
import com.starbase.starteam.FolderTreeListener;
import com.starbase.starteam.Folder_Cache;
import com.starbase.starteam.IFolderListener;
import com.starbase.starteam.IItemListener;
import com.starbase.starteam.ISecurableContainer;
import com.starbase.starteam.ISecurableObject;
import com.starbase.starteam.Item;
import com.starbase.starteam.ItemEventScope;
import com.starbase.starteam.ItemEvent_Marshaler;
import com.starbase.starteam.ItemIDEvent_Marshaler;
import com.starbase.starteam.ItemIDListener;
import com.starbase.starteam.ItemListEvent_Marshaler;
import com.starbase.starteam.ItemListListener;
import com.starbase.starteam.ItemListener;
import com.starbase.starteam.ItemType_CacheManager;
import com.starbase.starteam.Item_CacheRefCollection;
import com.starbase.starteam.Label;
import com.starbase.starteam.LabelEvent_Marshaler;
import com.starbase.starteam.LabelListener;
import com.starbase.starteam.LabelMethods;
import com.starbase.starteam.Label_CacheRefCollection;
import com.starbase.starteam.Label_Repository;
import com.starbase.starteam.LinkEndpoint;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.NotificationEvent_Marshaler;
import com.starbase.starteam.NotificationItem;
import com.starbase.starteam.NotificationListener;
import com.starbase.starteam.NotifyMethods;
import com.starbase.starteam.Project;
import com.starbase.starteam.PromotionModel;
import com.starbase.starteam.Property;
import com.starbase.starteam.PropertyNames;
import com.starbase.starteam.Query;
import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;
import com.starbase.starteam.SecurityAccess;
import com.starbase.starteam.Server;
import com.starbase.starteam.ServerComponentInfo;
import com.starbase.starteam.Server_CacheManager;
import com.starbase.starteam.SimpleTypedResource;
import com.starbase.starteam.StatusMethod;
import com.starbase.starteam.Type;
import com.starbase.starteam.TypedResource_Data;
import com.starbase.starteam.ViewConfiguration;
import com.starbase.starteam.ViewConfiguration_CacheManager;
import com.starbase.starteam.ViewEvent_Marshaler;
import com.starbase.starteam.ViewListener;
import com.starbase.starteam.View_Cache;
import com.starbase.starteam.View_CacheManager;
import com.starbase.starteam.View_Cmd_Create;
import com.starbase.starteam.View_Cmd_Delete;
import com.starbase.starteam.View_Cmd_SetProperties;
import com.starbase.starteam.vts.pickle.ItemRevision;
import com.starbase.util.Assert;
import com.starbase.util.OLEDate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class View
extends SimpleTypedResource
implements ISecurableObject,
ISecurableContainer {
    private static final String EMPTY = "";
    static final int SCOPE_SELF = 1;
    static final int SCOPE_ALLPROPERTIES = 2;
    static final int SCOPE_DEFAULT = 3;
    private LabelEvent_Marshaler m_labelEventMarshaler = null;
    private FolderTreeEvent_Marshaler m_folderTreeEventMarshaler = null;
    private FolderEvent_Marshaler m_folderEventMarshaler = null;
    private Hashtable m_itemListEventMarshalers = new Hashtable();
    private Hashtable m_itemIDEventMarshalers = new Hashtable();
    private Hashtable m_itemEventMarshalers = new Hashtable();
    private Hashtable m_notificationEventMarshalers = new Hashtable();
    private boolean m_isNew = false;
    private boolean m_isDeleted = false;
    private int m_nViewID;
    private View[] m_derivedViews = new View[0];
    private Project m_project;
    private Server m_server;
    private String m_fullName = "";
    private String m_sRootDir = "";
    private String m_sOverrideRootDir = null;
    private Folder m_rootFolder = null;
    private boolean m_bPopulated = false;
    private boolean m_bDiscarded = false;
    private boolean m_bRootNeedsRefresh = true;
    private ViewConfiguration m_config;
    private PromotionModel m_promotionModel = null;
    private Hashtable m_ItemIDsByType = new Hashtable();
    private View_CacheManager m_viewCacheManager = null;
    private ViewConfiguration_CacheManager m_viewConfigCacheManager = null;
    private Label_CacheRefCollection m_labels = null;
    private Label_CacheRefCollection m_activeLabels = null;
    private View m_parentView;
    private String m_name = "";
    private String m_description = "";
    private ViewConfiguration m_configForCreate = null;
    private boolean m_bIsVariantView = false;
    private boolean m_bIsROView = false;
    private int m_nRootFolderID;
    private String m_defaultWorkingFolder = "";
    private boolean m_bIsBranched;
    private StatusMethod m_viewStatusMethod = StatusMethod.DEFAULT;
    private Hashtable m_unsavedNewProperties = new Hashtable();
    private boolean m_bRetrievingProperties = false;

    private void init(Server server, Project project, int n, String string, String string2, ViewConfiguration viewConfiguration, View view, View[] viewArray) {
        this.setServer(server);
        this.setProject(project);
        this.setViewID(n);
        this.setInitialName(string);
        this.setInitialDescription(string2);
        this.setConfiguration(viewConfiguration);
        this.setParentView(view);
        this.setDerivedViews(viewArray);
    }

    public Object get(String string) throws NoSuchPropertyException {
        if (!this.hasValue(string) || this.m_bDiscarded) {
            this.retrieveProperties();
        }
        return super.get(string);
    }

    public Object put(String string, Object object) throws NoSuchPropertyException, ClassCastException {
        if (this.m_isNew && !this.isSetOnViewCreate(string)) {
            this.m_unsavedNewProperties.put(string, object);
        }
        return super.put(string, object);
    }

    public Object putByPropertyID(int n, Object object) throws NoSuchPropertyException, ClassCastException {
        Property property = this.getType().propertyForPID(n);
        if (property == null) {
            throw new NoSuchPropertyException(this.getType().getName(), n);
        }
        return this.put(property.getName(), object);
    }

    public void populate() {
        if (!this.m_bPopulated) {
            this.retrieveProperties();
        }
    }

    public boolean isRefreshRequired() {
        if (this.isNew() || !this.m_bPopulated) {
            return true;
        }
        Vector<View> vector = new Vector<View>();
        vector.addElement(this);
        return this.getCache().isRefreshRequired(vector);
    }

    public void refresh() {
        if (this.isRefreshRequired()) {
            this.refreshCache();
        }
    }

    private boolean isRefreshAllRequired() {
        if (!this.m_server.isMPXEnabled()) {
            return true;
        }
        return this.m_project.isRefreshRequired() || this.m_server.isRefreshAccountsRequired() || this.m_server.isRefreshTypesRequired(true) || this.isRefreshViewMembersRequired();
    }

    private boolean isRefreshViewMembersRequired() {
        if (!this.m_server.isMPXEnabled()) {
            return true;
        }
        if (this.isRefreshLabelsRequired() || this.isRefreshFoldersRequired()) {
            return true;
        }
        Vector vector = this.m_server.getItemTypes();
        int n = 0;
        while (n < vector.size()) {
            Type type = (Type)vector.elementAt(n);
            if (Item_CacheRefCollection.isRefreshRequired(this.m_rootFolder.getPopulatedItemCollections(type.getName(), -1), null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void refreshAll() {
        if (this.isRefreshAllRequired()) {
            this.m_project.refresh();
            this.m_server.refreshAccounts();
            this.m_server.refreshTypes(true);
            this.refreshLabels();
            this.m_bRootNeedsRefresh = true;
            this.getRootFolder();
            Vector vector = this.m_server.getItemTypes();
            int n = 0;
            while (n < vector.size()) {
                Type type = (Type)vector.elementAt(n);
                Item_CacheRefCollection.refresh(this.m_rootFolder.getPopulatedItemCollections(type.getName(), -1), null);
                ++n;
            }
        }
    }

    public View copy() {
        return this.copy(3);
    }

    View copy(int n) {
        if ((n & 2) != 0) {
            this.populate();
        }
        View view = new View(this.m_server, this.m_project, null);
        super.copyInto(view);
        view.m_isNew = this.m_isNew;
        view.m_nViewID = this.m_nViewID;
        view.m_derivedViews = this.m_derivedViews;
        view.m_fullName = this.m_fullName;
        view.m_sRootDir = this.m_sRootDir;
        view.m_sOverrideRootDir = this.m_sOverrideRootDir;
        view.m_rootFolder = this.m_rootFolder == null ? null : (Folder)this.m_rootFolder.copy();
        view.m_parentView = this.m_parentView;
        view.m_bDiscarded = this.m_bDiscarded;
        view.m_config = this.m_config;
        view.m_promotionModel = this.m_promotionModel;
        view.m_ItemIDsByType = this.m_ItemIDsByType;
        view.m_viewCacheManager = this.m_viewCacheManager;
        view.m_viewConfigCacheManager = this.m_viewConfigCacheManager;
        view.m_labels = this.m_labels;
        view.m_activeLabels = this.m_activeLabels;
        view.m_bPopulated = this.m_bPopulated;
        if (this.m_unsavedNewProperties != null) {
            view.m_unsavedNewProperties = new Hashtable();
            Enumeration enumeration = this.m_unsavedNewProperties.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.m_unsavedNewProperties.get(k);
                view.m_unsavedNewProperties.put(k, v);
            }
        }
        return view;
    }

    public boolean isEqualTo(View view) {
        if (view == null) {
            return false;
        }
        this.populate();
        view.populate();
        return this.getData().isEqualTo(view.getData());
    }

    public boolean isReference() {
        this.verifyAccessRights();
        return (this.getInt(this.getPropertyNames().VIEW_FLAGS) & 1) == 1;
    }

    public boolean isReadOnly() {
        this.verifyAccessRights();
        return (this.getInt(this.getPropertyNames().VIEW_FLAGS) & 0x10000000) == 0x10000000;
    }

    public boolean isRoot() {
        this.verifyAccessRights();
        return this.getParentView() == null && (this.getInt(this.getPropertyNames().VIEW_FLAGS) & 2) == 2;
    }

    public boolean isBranch() {
        this.verifyAccessRights();
        return (this.getInt(this.getPropertyNames().VIEW_FLAGS) & 4) == 4;
    }

    public boolean isNonDerived() {
        this.verifyAccessRights();
        return (this.getInt(this.getPropertyNames().VIEW_FLAGS) & 8) == 8;
    }

    public boolean isBranchAll() {
        this.verifyAccessRights();
        return (this.getInt(this.getPropertyNames().VIEW_FLAGS) & 0x10000) == 65536;
    }

    public boolean isBranchNone() {
        this.verifyAccessRights();
        return (this.getInt(this.getPropertyNames().VIEW_FLAGS) & 0x20000) == 131072;
    }

    public boolean isBranchOnShare() {
        this.verifyAccessRights();
        try {
            return (this.getInt(this.getPropertyNames().VIEW_SHARE_FLAGS) & 1) == 1;
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            return false;
        }
    }

    public void setBranchOnShare(boolean bl) throws NoSuchPropertyException {
        this.verifyAccessRights();
        String string = this.getPropertyNames().VIEW_SHARE_FLAGS;
        int n = this.m_isNew ? 0 : this.getInt(string);
        n = bl ? n | 1 : n ^ 1;
        this.put(string, new Integer(n));
    }

    public boolean getHaveAccessRights() {
        return this.m_isNew ? true : this.m_nViewID != -1;
    }

    public int getViewID() {
        this.verifyAccessRights();
        return this.getID();
    }

    public int getID() {
        return (Integer)this.get(this.m_server.getPropertyNames().OBJECT_ID);
    }

    public Label[] getLabels() {
        this.verifyAccessRights();
        this.getLabelCacheRefCollection().populate();
        Vector vector = this.getLabelCacheRefCollection().getRefs();
        Object[] objectArray = new Label[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Label[] getActiveLabels() {
        this.verifyAccessRights();
        this.getActiveLabelCacheRefCollection().populate();
        Vector vector = this.getActiveLabelCacheRefCollection().getRefs();
        Object[] objectArray = new Label[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void discardActiveLabels() {
        this.getActiveLabelCacheRefCollection().discard();
    }

    public boolean isRefreshActiveLabelsRequired() {
        return this.getActiveLabelCacheRefCollection().isRefreshRequired();
    }

    public void refreshActiveLabels() {
        this.verifyAccessRights();
        this.getActiveLabelCacheRefCollection().refresh();
    }

    public Label[] fetchAllLabels() {
        Label_CacheRefCollection label_CacheRefCollection = new Label_CacheRefCollection(this.getViewCacheManager().getLabelCache(), new Label_Repository(this, false));
        label_CacheRefCollection.populate();
        Vector vector = label_CacheRefCollection.getRefs();
        Enumeration enumeration = vector.elements();
        Label[] labelArray = new Label[vector.size()];
        enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            labelArray[n++] = (Label)enumeration.nextElement();
        }
        return labelArray;
    }

    public Label[] fetchAllLabelsFromView(int n, int n2) {
        if (n == this.getProject().getID() && n2 == this.getID()) {
            return this.fetchAllLabels();
        }
        return new LabelMethods(this).getLabels(n, n2, -1, true, true, false);
    }

    public Label createViewLabel(String string, String string2, OLEDate oLEDate, boolean bl, boolean bl2) {
        LabelMethods labelMethods = new LabelMethods(this);
        int n = -1;
        n = this.getServer().getRevisionLevel() < 53 ? labelMethods.createLabelOld(string, string2, bl, oLEDate.getDoubleValue(), false) : labelMethods.createLabel(-1, string, string2, bl, oLEDate.getDoubleValue(), false, bl2);
        Label label = new Label(this);
        label.setID(n);
        labelMethods.getLabelInfo(label);
        this.registerLabel(label);
        return label;
    }

    public Label createRevisionLabel(String string, String string2, boolean bl) {
        LabelMethods labelMethods = new LabelMethods(this);
        int n = -1;
        n = this.getServer().getRevisionLevel() < 53 ? labelMethods.createLabelOld(string, string2, false, 0.0, true) : labelMethods.createLabel(-1, string, string2, false, 0.0, true, bl);
        Label label = new Label(this);
        label.setID(n);
        labelMethods.getLabelInfo(label);
        this.registerLabel(label);
        return label;
    }

    public Label cloneViewLabel(Label label, String string, String string2, boolean bl, boolean bl2) {
        this.getServer().getSupportedFeatures().verifyHasLabelCopy();
        LabelMethods labelMethods = new LabelMethods(this);
        int n = labelMethods.createLabel(label.getID(), string, string2, bl, 0.0, false, bl2);
        Label label2 = new Label(this);
        label2.setID(n);
        labelMethods.getLabelInfo(label2);
        this.registerLabel(label2);
        return label2;
    }

    public Label cloneRevisionLabel(Label label, String string, String string2, boolean bl) {
        this.getServer().getSupportedFeatures().verifyHasLabelCopy();
        LabelMethods labelMethods = new LabelMethods(this);
        int n = labelMethods.createLabel(label.getID(), string, string2, false, 0.0, true, bl);
        Label label2 = new Label(this);
        label2.setID(n);
        labelMethods.getLabelInfo(label2);
        this.registerLabel(label2);
        return label2;
    }

    public PromotionModel getPromotionModel() {
        this.verifyAccessRights();
        if (this.m_promotionModel == null) {
            Query query = Query.newQueryContainedBy(this.getServer().getTypeNames().PROMOTIONMODEL, this);
            this.m_promotionModel = (PromotionModel)this.getServer().getItems(query).elementAt(0);
        }
        return this.m_promotionModel;
    }

    public String getDefaultPath() {
        return this.getRootFolder().getDefaultPathFragment();
    }

    public void setDefaultPath(String string) {
        this.getRootFolder().setDefaultPathFragment(string);
        this.put(this.getPropertyNames().VIEW_WORKING_FOLDER, string);
    }

    public String getAlternatePath() {
        return this.getRootFolder().getAlternatePathFragment();
    }

    public void setAlternatePath(String string) {
        this.getRootFolder().setAlternatePathFragment(string);
    }

    public void setStatusMethodOverride(StatusMethod statusMethod) {
        if (statusMethod == null) {
            Assert.nullArgument("StatusMethod");
        }
        this.m_viewStatusMethod = statusMethod;
    }

    public StatusMethod getStatusMethodOverride() {
        return this.m_viewStatusMethod;
    }

    public FileBasedStatusManager getFileStatusManager() {
        return StatusMethod.getStatusManagerForView(this);
    }

    public String getPath() {
        return this.getAlternatePath() != null ? this.getAlternatePath() : this.getDefaultPath();
    }

    public Folder getRootFolder() {
        this.verifyAccessRights();
        if (this.m_bRootNeedsRefresh) {
            this.m_labels = null;
            this.m_activeLabels = null;
            this.m_promotionModel = null;
            Folder_Cache folder_Cache = this.getFolderCache();
            Vector vector = this.getFolderList();
            folder_Cache.refreshItems(this, vector);
            this.m_rootFolder = (Folder)vector.elementAt(0);
            this.m_bRootNeedsRefresh = false;
            String string = this.getServer().getTypeNames().FOLDER;
            this.initializeItemsForType(string);
        }
        return this.m_rootFolder;
    }

    public ViewConfiguration getConfiguration() {
        this.verifyAccessRights();
        if (this.m_config == null) {
            this.m_config = ViewConfiguration.createTip();
        }
        return this.m_config;
    }

    public ViewConfiguration getBaseConfiguration() {
        this.verifyAccessRights();
        PropertyNames propertyNames = this.getPropertyNames();
        int n = this.getInt(propertyNames.VIEW_BASECONFIG_TYPE);
        double d = this.getOLEDate(propertyNames.VIEW_BASECONFIG_DATA).getDoubleValue();
        switch (n) {
            case 0: {
                return ViewConfiguration.createTip();
            }
            case 1: {
                return ViewConfiguration.createFromLabel((int)d);
            }
            case 2: {
                return ViewConfiguration.createFromTime(new OLEDate(d));
            }
            case 3: {
                return ViewConfiguration.createFromPromotionState((int)d);
            }
        }
        Assert.internalError("View.getBaseConfiguration(), nType=" + n);
        return null;
    }

    public OLEDate getCreatedTime() {
        this.verifyAccessRights();
        return this.getOLEDate(this.getPropertyNames().CREATED_TIME);
    }

    public int getCreatedBy() {
        this.verifyAccessRights();
        return this.getInt(this.getPropertyNames().CREATED_USER_ID);
    }

    public String getDescription() {
        this.verifyAccessRights();
        return this.getString(this.getPropertyNames().VIEW_DESCRIPTION);
    }

    public void setDescription(String string) {
        this.verifyAccessRights();
        this.put(this.getPropertyNames().VIEW_DESCRIPTION, string);
    }

    public String getFullName() {
        return this.m_fullName;
    }

    public Server getServer() {
        return this.m_server;
    }

    public String getName() {
        return this.getString(this.getPropertyNames().VIEW_NAME);
    }

    public void setName(String string) {
        this.put(this.getPropertyNames().VIEW_NAME, string);
    }

    public Project getProject() {
        return this.m_project;
    }

    public View getParentView() {
        return this.m_parentView;
    }

    public View[] getDerivedViews() {
        return this.m_derivedViews;
    }

    public boolean hasPermission(int n) {
        return SecurityAccess.objectAccessTest(this.getServer(), this, this.getType().getClassID(), this.getID(), n);
    }

    public boolean hasPermission(int n, String string) {
        return SecurityAccess.containerAccessTest(this.getServer(), this, 1, -1, string, n);
    }

    public AclEntry[] getACL() {
        this.verifyAccessRights();
        return SecurityAccess.getContainerACL(this.getServer(), this, 1, -1);
    }

    public void setACL(AclEntry[] aclEntryArray) {
        this.verifyAccessRights();
        SecurityAccess.setContainerACL(this.getServer(), this, 1, -1, aclEntryArray);
    }

    public AclEntry[] getContainerLevelACL(String string) {
        this.verifyAccessRights();
        return SecurityAccess.getContainerLevelACL(this.getServer(), this, 1, -1, string);
    }

    public void setContainerLevelACL(AclEntry[] aclEntryArray, String string) {
        this.verifyAccessRights();
        SecurityAccess.setContainerLevelACL(this.getServer(), this, 1, -1, string, aclEntryArray);
    }

    public Folder findFolder(int n) {
        return (Folder)this.findItem(this.m_server.typeForName(this.m_server.getTypeNames().FOLDER), n);
    }

    public Item findItem(Type type, int n) {
        Hashtable hashtable = this.m_ItemIDsByType;
        synchronized (hashtable) {
            this.verifyAccessRights();
            String string = type.getName();
            if (!this.m_ItemIDsByType.containsKey(string)) {
                this.initializeItemsForType(string);
            }
            Hashtable hashtable2 = (Hashtable)this.m_ItemIDsByType.get(string);
            Item item = (Item)hashtable2.get(new Integer(n));
            Object var4_7 = null;
            return item;
        }
    }

    public void remove() {
        View_Cmd_Delete.execute(this.getServer(), this);
        this.markDeleted();
        this.m_derivedViews = null;
        this.m_ItemIDsByType = null;
        this.getCache().setIDsModified();
    }

    void markDeleted() {
        this.m_isDeleted = true;
    }

    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    public void discard() {
        int n = this.getViewID();
        String string = this.getName();
        this.m_bPopulated = false;
        this.m_bDiscarded = true;
        this.m_newData = null;
        this.getCache().discard(n);
        this.setCachedObject(null);
        this.setViewID(n);
        this.setInitialName(string);
        this.m_unsavedNewProperties.clear();
    }

    public void update() {
        if (this.isNew()) {
            this.createView();
            if (!this.m_unsavedNewProperties.isEmpty()) {
                Enumeration enumeration = this.m_unsavedNewProperties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.put(string, this.m_unsavedNewProperties.get(string));
                }
                this.updateView();
                this.m_unsavedNewProperties.clear();
            }
        } else {
            this.updateView();
        }
        this.setCachedObject(this.getData());
        this.m_newData = null;
        this.m_isNew = false;
    }

    public void discardLabels() {
        this.getLabelCacheRefCollection().discard();
    }

    public boolean isRefreshLabelsRequired() {
        return this.getLabelCacheRefCollection().isRefreshRequired();
    }

    public void refreshLabels() {
        this.verifyAccessRights();
        this.getLabelCacheRefCollection().refresh();
    }

    public void refreshPromotionModel() {
        this.verifyAccessRights();
        this.m_promotionModel = null;
        this.getPromotionModel();
    }

    public void refreshFolders() {
        this.verifyAccessRights();
        Vector vector = this.getFolderList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Folder folder = (Folder)enumeration.nextElement();
            folder.resetItemCollections();
        }
        if (this.isRefreshFoldersRequired(vector)) {
            this.m_bRootNeedsRefresh = true;
            this.getRootFolder();
        }
    }

    public boolean isRefreshFoldersRequired() {
        this.verifyAccessRights();
        return this.isRefreshFoldersRequired(this.getFolderList());
    }

    private boolean isRefreshFoldersRequired(Vector vector) {
        Folder_Cache folder_Cache = this.getFolderCache();
        return folder_Cache.isRefreshFoldersRequired(vector);
    }

    public void discardFolders() {
        this.verifyAccessRights();
        if (this.m_rootFolder != null) {
            this.m_rootFolder.getType().discard(this.m_rootFolder, -1);
            this.m_bRootNeedsRefresh = true;
            this.m_rootFolder = null;
        }
    }

    public Item resolveLinkEndpoint(LinkEndpoint linkEndpoint) {
        if (linkEndpoint == null) {
            Assert.nullArgument("LinkEndpoint");
            return null;
        }
        this.verifyAccessRights();
        Item item = this.findItem(linkEndpoint.getType(), linkEndpoint.getItemID());
        if (item != null) {
            return this.resolveLinkEndpointToItem(linkEndpoint, item);
        }
        return null;
    }

    public void modifyItemsReadStatusForUser(int[] nArray, Type type, boolean bl) {
        CmdListSetRead cmdListSetRead = new CmdListSetRead(nArray, bl);
        cmdListSetRead.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this).getID(), type.getClassID());
    }

    public void modifyItemsFlagForUser(int[] nArray, Type type, boolean bl) {
        CmdSetBookmark cmdSetBookmark = new CmdSetBookmark(nArray, bl);
        cmdSetBookmark.execute(this.getServer().useConnection(), this.getServer().getSession().getID(), this.getServer().getViewSession(this).getID(), type.getClassID());
    }

    public Item getDisembodiedItem(int n, Type type) {
        Server server = this.getServer();
        Item item = server.newItem(type, this, true);
        item.setItemID(n);
        return item;
    }

    public Item[] getHistoryForItemID(int n, Type type) {
        return this.getHistoryForItemIDSince(n, type, new OLEDate(0.0));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof View) {
            View view = (View)object;
            return this.getProject().equals(view.getProject()) && this.getID() == view.getID();
        }
        return false;
    }

    public int hashCode() {
        return this.getProject().hashCode() * 37 + this.getID();
    }

    public boolean hasNewNotificationItems(String string) {
        Type type = this.getServer().typeForName(string);
        if (View.supportsNotifications(type)) {
            NotifyMethods notifyMethods = new NotifyMethods(this);
            return notifyMethods.listAnyNewItems(type);
        }
        return false;
    }

    public NotificationItem[] getNewNotificationItems(String string) {
        Type type = this.getServer().typeForName(string);
        if (View.supportsNotifications(type)) {
            NotifyMethods notifyMethods = new NotifyMethods(this);
            return notifyMethods.listGetNewItems(type);
        }
        return new NotificationItem[0];
    }

    private static boolean supportsNotifications(Type type) {
        if (type.getComponentGUID() == null) {
            return false;
        }
        if (type.getName().equals(type.getServer().getTypeNames().PROJECT)) {
            return false;
        }
        if (type.getName().equals(type.getServer().getTypeNames().FILE)) {
            return false;
        }
        return !type.getName().equals(type.getServer().getTypeNames().AUDIT);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        String string = System.getProperty("line.separator");
        stringBuffer.append(super.toString() + string);
        stringBuffer.append(" Name: " + this.getName() + string);
        if (this.getHaveAccessRights()) {
            stringBuffer.append(" ID: " + this.getViewID() + string);
        }
        stringBuffer.append(" Project: " + this.getProject().getName() + string);
        stringBuffer.append(" Description: " + this.getDescription() + string);
        String string2 = EMPTY;
        string2 = this.isReference() ? (this.isReadOnly() ? "Read-only Reference" : "Reference") : (this.isRoot() ? "Root" : (this.isBranch() ? "Branch" : (this.isNonDerived() ? "Non-Derived" : "Unknown. Either Branch or Non-Derived.")));
        stringBuffer.append(" View Type: " + string2 + string);
        String string3 = EMPTY;
        string3 = this.isBranchAll() ? "All" : (this.isBranchNone() ? "None" : "Unknown.");
        stringBuffer.append(" Original Branching Default: " + string3 + string);
        return stringBuffer.toString();
    }

    public void addViewListener(ViewListener viewListener) {
        this.verifyAccessRights();
        this.getViewEventMarshaler().addListener(viewListener, this);
    }

    public void removeViewListener(ViewListener viewListener) {
        this.getViewEventMarshaler().removeListener(viewListener, this);
    }

    ViewEvent_Marshaler getViewEventMarshaler() {
        return this.getProject().getViewEventMarshaler();
    }

    public void addLabelListener(LabelListener labelListener) {
        this.verifyAccessRights();
        this.getLabelEventMarshaler().addListener(labelListener);
    }

    public void removeLabelListener(LabelListener labelListener) {
        this.getLabelEventMarshaler().removeListener(labelListener);
    }

    LabelEvent_Marshaler getLabelEventMarshaler() {
        if (this.m_labelEventMarshaler == null) {
            View view = this;
            synchronized (view) {
                if (this.m_labelEventMarshaler == null) {
                    this.m_labelEventMarshaler = new LabelEvent_Marshaler(this);
                }
            }
        }
        return this.m_labelEventMarshaler;
    }

    public void addFolderListener(IFolderListener iFolderListener) {
        this.verifyAccessRights();
        this.addFolderListener(iFolderListener, null);
    }

    void addFolderListener(IFolderListener iFolderListener, FolderEventScope folderEventScope) {
        boolean bl = false;
        if (iFolderListener instanceof FolderTreeListener) {
            this.getFolderTreeEventMarshaler().addListener((FolderTreeListener)iFolderListener, folderEventScope);
            bl = true;
        }
        if (iFolderListener instanceof FolderListener) {
            this.getFolderEventMarshaler().addListener((FolderListener)iFolderListener, folderEventScope);
            bl = true;
        }
        if (!bl) {
            String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"FolderListener", "FolderTreeListener"});
            throw new IllegalArgumentException(Res.formatKey(ResIDs.UNRECOGNIZED_LISTENER_FMT, new Object[]{string}));
        }
    }

    public void removeFolderListener(IFolderListener iFolderListener) {
        this.removeFolderListener(iFolderListener, null);
    }

    void removeFolderListener(IFolderListener iFolderListener, FolderEventScope folderEventScope) {
        if (iFolderListener instanceof FolderTreeListener) {
            this.getFolderTreeEventMarshaler().removeListener((FolderTreeListener)iFolderListener, folderEventScope);
        }
        if (iFolderListener instanceof FolderListener) {
            this.getFolderEventMarshaler().removeListener((FolderListener)iFolderListener, folderEventScope);
        }
    }

    FolderTreeEvent_Marshaler getFolderTreeEventMarshaler() {
        if (this.m_folderTreeEventMarshaler == null) {
            View view = this;
            synchronized (view) {
                if (this.m_folderTreeEventMarshaler == null) {
                    this.m_folderTreeEventMarshaler = new FolderTreeEvent_Marshaler(this);
                }
            }
        }
        return this.m_folderTreeEventMarshaler;
    }

    FolderEvent_Marshaler getFolderEventMarshaler() {
        if (this.m_folderEventMarshaler == null) {
            View view = this;
            synchronized (view) {
                if (this.m_folderEventMarshaler == null) {
                    this.m_folderEventMarshaler = new FolderEvent_Marshaler(this);
                }
            }
        }
        return this.m_folderEventMarshaler;
    }

    public void addItemListener(IItemListener iItemListener, Type type) {
        this.verifyAccessRights();
        this.addItemListener(iItemListener, type, (ItemEventScope)null);
    }

    public void addItemListener(IItemListener iItemListener, Type type, String[] stringArray) {
        this.verifyAccessRights();
        this.addItemListener(iItemListener, type, stringArray, null);
    }

    void addItemListener(IItemListener iItemListener, Type type, ItemEventScope itemEventScope) {
        Property[] propertyArray;
        String[] stringArray = null;
        if (iItemListener instanceof ItemListener && (propertyArray = type.getDescriptors()).length > 0) {
            stringArray = new String[propertyArray.length];
            int n = 0;
            while (n < propertyArray.length) {
                stringArray[n] = propertyArray[n].getName();
                ++n;
            }
        }
        this.addItemListener(iItemListener, type, stringArray, itemEventScope);
    }

    void addItemListener(IItemListener iItemListener, Type type, String[] stringArray, ItemEventScope itemEventScope) {
        boolean bl = false;
        if (iItemListener instanceof ItemListListener) {
            this.getItemListEventMarshaler(type).addListener((ItemListListener)iItemListener, itemEventScope);
            bl = true;
        }
        if (iItemListener instanceof ItemIDListener) {
            this.getItemIDEventMarshaler(type).addListener((ItemIDListener)iItemListener, itemEventScope);
            bl = true;
        }
        if (iItemListener instanceof ItemListener) {
            this.getItemEventMarshaler(type).addListener((ItemListener)iItemListener, stringArray, itemEventScope);
            bl = true;
        }
        if (iItemListener instanceof NotificationListener) {
            if (View.supportsNotifications(type)) {
                this.getNotificationEventMarshaler(type).addListener((NotificationListener)iItemListener, itemEventScope);
            }
            bl = true;
        }
        if (!bl) {
            String string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{"ItemListener", "ItemIDListener"});
            string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "ItemListListener"});
            string = Res.formatKey(ResIDs.LIST_FMT, new Object[]{string, "NotificationListener"});
            throw new IllegalArgumentException(Res.formatKey(ResIDs.UNRECOGNIZED_LISTENER_FMT, new Object[]{string}));
        }
    }

    public void removeItemListener(IItemListener iItemListener, Type type) {
        this.removeItemListener(iItemListener, type, null);
    }

    void removeItemListener(IItemListener iItemListener, Type type, ItemEventScope itemEventScope) {
        if (iItemListener instanceof ItemListListener) {
            this.getItemListEventMarshaler(type).removeListener((ItemListListener)iItemListener, itemEventScope);
        }
        if (iItemListener instanceof ItemListener) {
            this.getItemEventMarshaler(type).removeListener((ItemListener)iItemListener, itemEventScope);
        }
        if (iItemListener instanceof NotificationListener) {
            this.getNotificationEventMarshaler(type).removeListener((NotificationListener)iItemListener, itemEventScope);
        }
    }

    ItemListEvent_Marshaler getItemListEventMarshaler(Type type) {
        Hashtable hashtable = this.m_itemListEventMarshalers;
        synchronized (hashtable) {
            Integer n = new Integer(type.getClassID());
            ItemListEvent_Marshaler itemListEvent_Marshaler = (ItemListEvent_Marshaler)this.m_itemListEventMarshalers.get(n);
            if (itemListEvent_Marshaler == null) {
                itemListEvent_Marshaler = new ItemListEvent_Marshaler(this, type);
                this.m_itemListEventMarshalers.put(n, itemListEvent_Marshaler);
            }
            ItemListEvent_Marshaler itemListEvent_Marshaler2 = itemListEvent_Marshaler;
            Object var3_6 = null;
            return itemListEvent_Marshaler2;
        }
    }

    ItemIDEvent_Marshaler getItemIDEventMarshaler(Type type) {
        Hashtable hashtable = this.m_itemIDEventMarshalers;
        synchronized (hashtable) {
            Integer n = new Integer(type.getClassID());
            ItemIDEvent_Marshaler itemIDEvent_Marshaler = (ItemIDEvent_Marshaler)this.m_itemIDEventMarshalers.get(n);
            if (itemIDEvent_Marshaler == null) {
                itemIDEvent_Marshaler = new ItemIDEvent_Marshaler(this, type);
                this.m_itemIDEventMarshalers.put(n, itemIDEvent_Marshaler);
            }
            ItemIDEvent_Marshaler itemIDEvent_Marshaler2 = itemIDEvent_Marshaler;
            Object var3_6 = null;
            return itemIDEvent_Marshaler2;
        }
    }

    ItemEvent_Marshaler getItemEventMarshaler(Type type) {
        Hashtable hashtable = this.m_itemEventMarshalers;
        synchronized (hashtable) {
            Integer n = new Integer(type.getClassID());
            ItemEvent_Marshaler itemEvent_Marshaler = (ItemEvent_Marshaler)this.m_itemEventMarshalers.get(n);
            if (itemEvent_Marshaler == null) {
                itemEvent_Marshaler = new ItemEvent_Marshaler(this, type);
                this.m_itemEventMarshalers.put(n, itemEvent_Marshaler);
            }
            ItemEvent_Marshaler itemEvent_Marshaler2 = itemEvent_Marshaler;
            Object var3_6 = null;
            return itemEvent_Marshaler2;
        }
    }

    NotificationEvent_Marshaler getNotificationEventMarshaler(Type type) {
        Hashtable hashtable = this.m_notificationEventMarshalers;
        synchronized (hashtable) {
            Integer n = new Integer(type.getClassID());
            NotificationEvent_Marshaler notificationEvent_Marshaler = (NotificationEvent_Marshaler)this.m_notificationEventMarshalers.get(n);
            if (notificationEvent_Marshaler == null) {
                notificationEvent_Marshaler = new NotificationEvent_Marshaler(this, type);
                this.m_notificationEventMarshalers.put(n, notificationEvent_Marshaler);
            }
            NotificationEvent_Marshaler notificationEvent_Marshaler2 = notificationEvent_Marshaler;
            Object var3_6 = null;
            return notificationEvent_Marshaler2;
        }
    }

    ViewConfiguration_CacheManager getViewConfigCacheManager() {
        if (this.m_viewConfigCacheManager == null) {
            View_CacheManager view_CacheManager = this.getViewCacheManager();
            ViewConfiguration viewConfiguration = this.getConfiguration();
            this.m_viewConfigCacheManager = view_CacheManager.getViewConfigCacheManager(viewConfiguration);
        }
        return this.m_viewConfigCacheManager;
    }

    void setRootFolder(Folder folder) {
        this.m_rootFolder = folder;
    }

    void setFullName(String string) {
        this.m_fullName = string;
    }

    void setParentView(View view) {
        this.m_parentView = view;
    }

    void setDerivedViews(View[] viewArray) {
        this.m_derivedViews = viewArray == null ? new View[0] : viewArray;
    }

    void mapItem(Item item) {
        Hashtable hashtable = this.m_ItemIDsByType;
        synchronized (hashtable) {
            String string = item.getType().getName();
            if (this.m_ItemIDsByType.containsKey(string)) {
                Hashtable hashtable2 = (Hashtable)this.m_ItemIDsByType.get(string);
                hashtable2.put(new Integer(item.getItemID()), item);
            }
        }
    }

    void unmapItem(Item item) {
        Hashtable hashtable = this.m_ItemIDsByType;
        synchronized (hashtable) {
            String string = item.getType().getName();
            if (this.m_ItemIDsByType.containsKey(string)) {
                Hashtable hashtable2 = (Hashtable)this.m_ItemIDsByType.get(string);
                hashtable2.remove(new Integer(item.getItemID()));
            }
        }
    }

    void clearItemsForType(String string) {
        Hashtable hashtable = this.m_ItemIDsByType;
        synchronized (hashtable) {
            this.m_ItemIDsByType.remove(string);
        }
    }

    void registerLabel(Label label) {
        Label_CacheRefCollection label_CacheRefCollection;
        Label_CacheRefCollection label_CacheRefCollection2 = this.getLabelCacheRefCollection();
        if (label_CacheRefCollection2.isPopulated() && label_CacheRefCollection2.getByID(label.getID()) == null) {
            label_CacheRefCollection2.add(label);
        }
        if ((label_CacheRefCollection = this.getActiveLabelCacheRefCollection()).isPopulated() && label_CacheRefCollection.getByID(label.getID()) == null) {
            label_CacheRefCollection.add(label);
        }
    }

    int getIdForAccessCheck() {
        return this.m_nViewID;
    }

    Folder_Cache getFolderCache() {
        String string = this.getServer().getTypeNames().FOLDER;
        Type type = this.getServer().typeForName(string);
        View_CacheManager view_CacheManager = this.getViewCacheManager();
        ViewConfiguration_CacheManager viewConfiguration_CacheManager = view_CacheManager.getViewConfigCacheManager(this.getConfiguration(), true);
        ItemType_CacheManager itemType_CacheManager = viewConfiguration_CacheManager.getItemTypeCacheManager(type, true);
        Folder_Cache folder_Cache = (Folder_Cache)itemType_CacheManager.getItemCache();
        return folder_Cache;
    }

    private Vector getFolderList() {
        Vector vector = new Vector();
        if (this.m_rootFolder != null) {
            Folder.flattenFolderTree(this.m_rootFolder, vector, -1);
        }
        return vector;
    }

    private Item resolveLinkEndpointToItem(LinkEndpoint linkEndpoint, Item item) {
        Item item2 = null;
        if (linkEndpoint.isPinned()) {
            int n = linkEndpoint.getObjectID();
            int n2 = linkEndpoint.getRevisionNumber();
            if (n == item.getObjectID() && n2 == item.getRevisionNumber()) {
                item2 = item;
            } else {
                Item[] itemArray = item.getHistory();
                int n3 = 0;
                while (n3 < itemArray.length) {
                    Item item3 = itemArray[n3];
                    if (n == item3.getObjectID() && n2 == item3.getRevisionNumber()) {
                        item2 = item3;
                        break;
                    }
                    ++n3;
                }
            }
        } else {
            item2 = item;
        }
        return item2;
    }

    private void setProject(Project project) {
        this.m_project = project;
    }

    private View_CacheManager getViewCacheManager() {
        if (this.m_viewCacheManager == null) {
            this.verifyAccessRights();
            if (!this.m_isNew) {
                Server_CacheManager server_CacheManager = this.m_server.getServerCacheManager();
                this.m_viewCacheManager = server_CacheManager.getViewCacheManager(this);
            } else {
                throw new IllegalStateException(Res.getString(ResIDs.VIEW_NOT_SAVED_YET));
            }
        }
        return this.m_viewCacheManager;
    }

    private void setInitialName(String string) {
        this.getCacheData().putByName(this.getPropertyNames().VIEW_NAME, string);
    }

    private void setInitialDescription(String string) {
        this.getCacheData().putByName(this.getPropertyNames().VIEW_DESCRIPTION, string);
    }

    private void setViewID(int n) {
        this.m_nViewID = n;
        this.getCacheData().putByName(this.m_server.getPropertyNames().OBJECT_ID, new Integer(n));
        if (n != -1) {
            this.m_isNew = false;
        }
        this.m_viewCacheManager = null;
        this.m_viewConfigCacheManager = null;
    }

    private Label_CacheRefCollection getLabelCacheRefCollection() {
        if (this.m_labels == null) {
            this.m_labels = new Label_CacheRefCollection(this.getViewCacheManager().getLabelCache(), new Label_Repository(this, true));
        }
        return this.m_labels;
    }

    private Label_CacheRefCollection getActiveLabelCacheRefCollection() {
        if (this.m_activeLabels == null) {
            this.m_activeLabels = new Label_CacheRefCollection(this.getViewCacheManager().getLabelCache(), new Label_Repository(this, false));
        }
        return this.m_activeLabels;
    }

    private boolean isNew() {
        return this.m_isNew;
    }

    private void setConfiguration(ViewConfiguration viewConfiguration) {
        this.m_config = viewConfiguration;
        this.setRootFolder(null);
        this.m_viewCacheManager = null;
        this.m_viewConfigCacheManager = null;
    }

    private void setServer(Server server) {
        this.m_server = server;
        this.m_viewCacheManager = null;
        this.m_viewConfigCacheManager = null;
    }

    private void initializeItemsForType(String string) {
        Hashtable hashtable = this.m_ItemIDsByType;
        synchronized (hashtable) {
            Folder folder;
            Hashtable<Integer, Item> hashtable2 = new Hashtable<Integer, Item>();
            Vector vector = new Vector();
            Folder folder2 = folder = this.m_rootFolder == null ? this.getRootFolder() : this.m_rootFolder;
            if (string.equals(this.m_server.getTypeNames().FOLDER)) {
                Folder.flattenFolderTree(folder, vector, -1);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Folder folder3 = (Folder)enumeration.nextElement();
                    hashtable2.put(new Integer(folder3.getItemID()), folder3);
                }
            } else {
                Vector vector2 = folder.getItemCollections(string, -1);
                Item_CacheRefCollection.populateItems(vector2);
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    Item_CacheRefCollection item_CacheRefCollection = (Item_CacheRefCollection)enumeration.nextElement();
                    Enumeration enumeration2 = item_CacheRefCollection.getRefs().elements();
                    while (enumeration2.hasMoreElements()) {
                        Item item = (Item)enumeration2.nextElement();
                        hashtable2.put(new Integer(item.getItemID()), item);
                    }
                }
            }
            this.m_ItemIDsByType.put(string, hashtable2);
        }
    }

    private boolean isSetOnViewCreate(String string) {
        return string.equalsIgnoreCase(this.getPropertyNames().VIEW_NAME) || string.equalsIgnoreCase(this.getPropertyNames().VIEW_DESCRIPTION) || string.equalsIgnoreCase(this.getPropertyNames().VIEW_FLAGS);
    }

    private void verifyAccessRights() {
        if (!this.getHaveAccessRights()) {
            throw new RuntimeException(Res.getString(ResIDs.NO_ACCESS_RIGHTS));
        }
    }

    private Item[] getHistoryForItemIDSince(int n, Type type, OLEDate oLEDate) {
        Server server = this.getServer();
        CmdGetHistory cmdGetHistory = new CmdGetHistory(n, oLEDate.getDoubleValue());
        cmdGetHistory.execute(server.useConnection(), server.getSession().getID(), server.getViewSession(this).getID(), server.getClassID(type.getName()));
        ItemRevision[] itemRevisionArray = cmdGetHistory.getHistory();
        PropertyNames propertyNames = type.getServer().getPropertyNames();
        boolean bl = type.hasPropertyForName(propertyNames.VIEW_ID);
        Item[] itemArray = new Item[itemRevisionArray.length];
        int n2 = 0;
        while (n2 < itemRevisionArray.length) {
            Item item = server.newItem(type, this, true);
            ItemRevision itemRevision = itemRevisionArray[n2];
            itemArray[n2] = item;
            item.setItemID(n);
            item.initializeReplicaValue(propertyNames.REVISION_NUMBER, (Object)new Integer(itemRevision.m_revisionID.getRevision()));
            item.initializeReplicaValue(propertyNames.OBJECT_ID, (Object)new Integer(itemRevision.m_revisionID.getObjectID()));
            item.initializeReplicaValue(propertyNames.MODIFIED_TIME, (Object)new OLEDate(itemRevision.m_time));
            item.initializeReplicaValue(propertyNames.DOTNOTATION, (Object)itemRevision.m_dotNotation);
            item.initializeReplicaValue(propertyNames.COMMENT, (Object)itemRevision.m_comment);
            item.initializeReplicaValue(propertyNames.MODIFIED_USER_ID, (Object)new Integer(itemRevision.m_userID));
            if (item.isBranchable()) {
                item.initializeReplicaValue(propertyNames.PATH_REVISION, (Object)new Integer(itemRevision.m_pathRevision - itemRevision.m_revisionID.getRevision() - 1));
            }
            if (bl) {
                item.initializeReplicaValue(propertyNames.VIEW_ID, (Object)new Integer(itemRevision.m_viewID));
            }
            ++n2;
        }
        return itemArray;
    }

    private View_Cache getCache() {
        return this.m_server.getServerCacheManager().getViewCache(this.m_server);
    }

    private void refreshCache() {
        Vector<View> vector = new Vector<View>();
        vector.addElement(this);
        this.getCache().refresh(this.m_project, vector);
        this.m_bPopulated = true;
    }

    private synchronized void retrieveProperties() {
        if (!this.m_bRetrievingProperties) {
            block3: {
                try {
                    this.m_bRetrievingProperties = true;
                    if (this.m_nViewID == -1 || this.m_isNew) break block3;
                    this.refreshCache();
                    this.m_bDiscarded = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.m_bRetrievingProperties = false;
                    throw throwable;
                }
            }
            Object var2_1 = null;
            this.m_bRetrievingProperties = false;
        }
    }

    private void updateView() {
        this.getCacheData().setDirty(true);
        this.getNewData().setDirty(true);
        View_Cmd_SetProperties.execute(this.m_server, this.m_project, this);
        this.completeUpdate();
    }

    private void createView() {
        boolean bl = !this.m_configForCreate.isTip();
        View_Cmd_Create view_Cmd_Create = new View_Cmd_Create(this.m_bIsVariantView, this.m_bIsROView, this.getName(), this.getDescription(), this.m_nRootFolderID, this.m_defaultWorkingFolder, this.m_configForCreate, bl, this.m_bIsBranched);
        view_Cmd_Create.execute(this.m_server.useConnection(), this.m_server.getSession().getID(), this.m_server.getViewSession(this.m_parentView).getID(), this.m_server.getComponentID(ServerComponentInfo.PROJECT));
        this.getCache().setIDsModified();
        int n = view_Cmd_Create.getID();
        this.setViewID(n);
        this.m_isNew = false;
        View[] viewArray = this.m_project.getViews();
        int n2 = 0;
        while (n2 < viewArray.length) {
            int n3 = viewArray[n2].getID();
            if (n3 == n) {
                this.setFullName(viewArray[n2].getFullName());
                break;
            }
            ++n2;
        }
    }

    private void completeUpdate() {
        this.setCachedObject(this.getNewData());
        this.m_newData = null;
    }

    public int getOwner() {
        return SecurityAccess.getObjectOwner(this.m_server, this, this.getType().getClassID(), this.getViewID());
    }

    public void acquireOwnership() {
        SecurityAccess.acquireObjectOwnership(this.m_server, this, this.getType().getClassID(), this.getViewID());
    }

    public ISecurableContainer getParentContainer() {
        return this.getProject();
    }

    View(Server server, Project project, TypedResource_Data typedResource_Data) {
        super(server.typeForName(server.getTypeNames().VIEW), typedResource_Data);
        this.setServer(server);
        this.setProject(project);
    }

    View(Server server, Project project, int n, String string, String string2) {
        this(server, project, n, string, string2, ViewConfiguration.createTip());
    }

    public View(View view, boolean bl, boolean bl2, String string, String string2, Folder folder, String string3, ViewConfiguration viewConfiguration, boolean bl3) {
        this(view.getServer(), view.getProject(), -1, string, string2, ViewConfiguration.createTip());
        this.m_isNew = true;
        this.m_configForCreate = viewConfiguration == null ? ViewConfiguration.createTip() : viewConfiguration;
        this.m_name = string;
        this.m_description = string2;
        this.m_parentView = view;
        this.m_bIsVariantView = bl;
        this.m_bIsROView = bl2;
        this.m_nRootFolderID = folder.getItemID();
        this.setRootFolder(null);
        this.m_defaultWorkingFolder = string3;
        this.m_bIsBranched = bl3;
    }

    public View(View view, String string, String string2, String string3) {
        this(view.getServer(), view.getProject(), -1, string, string2, ViewConfiguration.createTip());
        this.m_isNew = true;
        this.m_configForCreate = ViewConfiguration.createTip();
        this.m_name = string;
        this.m_description = string2;
        this.m_parentView = view;
        this.m_bIsVariantView = true;
        this.m_bIsROView = false;
        this.m_nRootFolderID = -1;
        this.setRootFolder(null);
        this.m_defaultWorkingFolder = string3;
        this.m_bIsBranched = true;
    }

    public View(View view, ViewConfiguration viewConfiguration) {
        super(view.getServer().typeForName(view.getServer().getTypeNames().VIEW), new TypedResource_Data(view.getServer().typeForName(view.getServer().getTypeNames().VIEW).getData()));
        this.init(view.getServer(), view.getProject(), view.getViewID(), view.getName(), view.getDescription(), viewConfiguration, view.getParentView(), view.getDerivedViews());
        this.setFullName(view.getFullName());
    }

    private View(Server server, Project project, int n, String string, String string2, ViewConfiguration viewConfiguration) {
        super(server.typeForName(server.getTypeNames().VIEW), new TypedResource_Data(server.typeForName(server.getTypeNames().VIEW).getData()));
        int n2 = 0;
        this.init(server, project, n2, string, string2, viewConfiguration, null, null);
        this.setViewID(n);
    }

    static interface ViewFlags {
        public static final int REFERENCE = 1;
        public static final int ROOT = 2;
        public static final int BRANCH = 4;
        public static final int NON_DERIVED = 8;
        public static final int BRANCH_ALL = 65536;
        public static final int BRANCH_NONE = 131072;
        public static final int READ_ONLY = 0x10000000;
    }

    static interface ViewShareFlags {
        public static final int BRANCH_ON_SHARE = 1;
    }
}

