/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam;

import com.starbase.starteam.Res;
import com.starbase.starteam.ResIDs;

class WinProfile {
    private static final String MODULENAME = "StWinProfile";
    private static boolean m_bLoaded = false;
    private static final int PROFILETYPE_COMMONAPPDATA = 0;
    private static final int PROFILETYPE_USERAPPDATA = 1;
    private static final int PROFILETYPE_USERDOCUMENTS = 2;
    private static final int PROFILETYPE_COMMONSTARBASEAPPDATA = 3;
    private static final int PROFILETYPE_USERSTARBASEAPPDATA = 4;
    private static final int PROFILETYPE_LOCALSTARBASEAPPDATA = 5;
    private static final int PROFILETYPE_LOCALAPPDATA = 6;
    private static final int FILETYPE_WORKSTATIONID = 0;
    private static final int FILETYPE_STARTEAMINI = 1;
    private static final int FILETYPE_SERVERLIST = 2;
    private static final int FILETYPE_STARTEAMLOG = 4;
    private static final int FILETYPE_LICENSE = 5;
    private static final int FILETYPE_STARTEAMXML = 6;

    public static String getWorkstationIDPath(boolean bl) {
        if (bl) {
            return WinProfile.getPath(0);
        }
        String string = WinProfile.getProfilePath(4);
        if (string.length() == 0 || string.charAt(string.length() - 1) != '\\') {
            string = string + "\\";
        }
        string = string + WinProfile.getFile(0);
        return string;
    }

    public static String getStarTeamIniPath() {
        return WinProfile.getPath(1);
    }

    public static String getServerListPath() {
        return WinProfile.getPath(2);
    }

    public static String getStarTeamLogPath() {
        return WinProfile.getPath(4);
    }

    public static String getLicensePath() {
        return WinProfile.getPath(5);
    }

    public static String getStarTeamXMLPath() {
        return WinProfile.getPath(6);
    }

    public static String getLocalStarbaseAppDataDir() {
        return WinProfile.getProfilePath(5);
    }

    private static void init() {
        if (!m_bLoaded) {
            try {
                System.loadLibrary(MODULENAME);
                m_bLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new RuntimeException(Res.formatKey(ResIDs.NATIVE_LIBRARY_NOT_FOUND_FMT, new Object[]{MODULENAME}));
            }
        }
    }

    private static String getPath(int n) {
        WinProfile.init();
        return WinProfile.getFilePath(n);
    }

    private static String getFile(int n) {
        WinProfile.init();
        return WinProfile.getFileName(n);
    }

    private static String getProfilePath(int n) {
        WinProfile.init();
        return WinProfile.getProfileDirectory(n);
    }

    private static native int getInterfaceVersion();

    private static native String getFilePath(int var0);

    private static native String getFileName(int var0);

    private static native String getProfileDirectory(int var0);

    private WinProfile() {
    }
}

